﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Documents;
using System.Diagnostics;
using System.IO;
using System.Windows;
using System.Windows.Media;
using System.Runtime.InteropServices;
using System.Windows.Interop;

namespace JoinNotes
{
    abstract internal class Util
    {

        #region † http://tomoemon.hateblo.jp/entry/20080430/p2
        // 外部プロセスのメイン・ウィンドウを起動するためのWin32 API
        [DllImport("user32.dll")]
        private static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);

        [DllImport("user32.dll")]
        private static extern bool IsIconic(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern uint GetWindowThreadProcessId(IntPtr hWnd, ref uint procId);

        // コールバックメソッドのデリゲート
        private delegate int EnumerateWindowsCallback(IntPtr hWnd, int lParam);

        [DllImport("user32", EntryPoint = "EnumWindows")]
        private static extern int EnumWindows(EnumerateWindowsCallback lpEnumFunc, int lParam);

        [return: MarshalAs(UnmanagedType.Bool)]
        [DllImport("user32.dll", SetLastError = true)]
        static public extern bool PostMessage(HandleRef hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern int GetWindowText(IntPtr hWnd, StringBuilder lpString, int nMaxCount);

        private static Process target_proc = null;
        private static IntPtr target_hwnd = IntPtr.Zero;

        // ウィンドウを列挙するためのコールバックメソッド
        public static int EnumerateWindows(IntPtr hWnd, int lParam)
        {
            uint procId = 0;
            uint result = GetWindowThreadProcessId(hWnd, ref procId);

            var proc = Process.GetProcessById((int)procId);
            Debug.WriteLine(new { proc.Id, proc.MainWindowHandle, proc.MainWindowTitle }, "EnumerateWindows");

            var sb = new StringBuilder(1024);
            GetWindowText(hWnd, sb, sb.Capacity);
            //Debug.WriteLine("*** id:" + procId + ", title:" + sb.ToString() + ":0x" + hWnd.ToString("X"));

            if (procId == target_proc.Id && sb.ToString() == App.NotifyContainerTitle)
            //if (proc.MainWindowTitle == App.mainWindow.Title)
            //if (procId == target_proc.Id)
            {
                // 同じIDで複数のウィンドウが見つかる場合がある
                // とりあえず最初のウィンドウが見つかった時点で終了する
                target_hwnd = hWnd;
                return 0;
            }

            // 列挙を継続するには0以外を返す必要がある
            return 1;
        }

        // 外部プロセスのウィンドウを最前面に表示する
        public static void WakeupWindow(Process target)
        {
            target_proc = target;
            EnumWindows(new EnumerateWindowsCallback(EnumerateWindows), 0);
            if (target_hwnd == IntPtr.Zero)
            {
                Debug.Fail("window not found");
                return;
            }

            //// メイン・ウィンドウが最小化されていれば元に戻す
            //if (IsIconic(target_hwnd))
            //{
            //    ShowWindowAsync(target_hwnd, Menu.SW_RESTORE);
            //}
            //// メイン・ウィンドウを最前面に表示する
            //SetForegroundWindow(target_hwnd);

            //UNDONE: 送信先ハンドルが違う。メインでないウィンドウを探す必要がある。
            //var ret = PostMessage(new HandleRef(App.Current.MainWindow, hWnd), Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
            var ret = PostMessage(new HandleRef(App.mainWindow, target_hwnd), Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
            Trace.Assert(ret);
            //MessageBox.Show("PostMessage Handle: 0x" + target_hwnd.ToString("X") + ", Message: 0x" + Menu.WM_APP_ACTIVATEAPP.ToString("X"));
        }
        #endregion

        //#region WakeupWindow: 同一アプリの別インスタンスをアクティブ化
        //// †: http://www.atmarkit.co.jp/fdotnet/dotnettips/151winshow/winshow.cs
        //public static void WakeupWindow(IntPtr hWnd)
        //{
        //    Debug.WriteLine(new { hWnd }, "WakeupWindow");
        //    Debug.Assert(hWnd != IntPtr.Zero, "window not found");

        //    //// メイン・ウィンドウが最小化されていれば元に戻す
        //    //if (IsIconic(hWnd))
        //    //{
        //    //    ShowWindowAsync(hWnd, SW_RESTORE);
        //    //}

        //    //// メイン・ウィンドウを最前面に表示する
        //    //SetForegroundWindow(hWnd);

        //    {
        //        //uint WM_QUIT = 0x12;

        //        //UNDONE: 送信できていない
        //        //var ret = PostMessage(new HandleRef(App.Current.MainWindow, hWnd), Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //        var ret = PostMessage(new HandleRef(App.mainWindow, hWnd), Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //        MessageBox.Show("PostMessage Handle: " + hWnd + ", Message: " + Menu.WM_APP_ACTIVATEAPP);
        //        Trace.Assert(ret);
        //    }

        //    //{
        //    //    var w = new Search();

        //    //    // new WindowInteropHelper(w).Handle;

        //    //    //FIXME: remove
        //    //    //SendMessage(hWnd, Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //    //    //UNDONE: 送信先プロセスのWndProcに到達していない
        //    //    var ret = PostMessage(new HandleRef(App.Instance.MainWindow, hWnd), Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //    //    //var ret = PostMessage(hWnd, Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //    //    Trace.Assert(ret);

        //    //    w.Close();
        //    //}

        //    //{
        //    //    uint nullProcessId = 0;

        //    //    // ターゲットとなるハンドルのスレッドIDを取得.
        //    //    uint targetThreadId = GetWindowThreadProcessId(hWnd, out nullProcessId);
        //    //    // 現在アクティブとなっているウィンドウのスレッドIDを取得.
        //    //    uint currentActiveThreadId = GetWindowThreadProcessId(new WindowInteropHelper(App.Instance.MainWindow).Handle, out nullProcessId);

        //    //    {
        //    //        var ret = AttachThreadInput(targetThreadId, currentActiveThreadId, true);
        //    //        Trace.Assert(ret);
        //    //    }

        //    //    {
        //    //        //FIXME: remove
        //    //        //SendMessage(hWnd, Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //    //        //UNDONE: 送信先プロセスのWndProcに到達していない
        //    //        var ret = PostMessage(new HandleRef(App.Instance.MainWindow, hWnd), Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //    //        //var ret = PostMessage(hWnd, Menu.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
        //    //        Trace.Assert(ret);
        //    //    }

        //    //    {
        //    //        var ret = AttachThreadInput(targetThreadId, currentActiveThreadId, false);
        //    //        Trace.Assert(ret);
        //    //    }

        //    //}
        //}

        //[DllImport("user32.dll")]
        //static extern IntPtr GetForegroundWindow();
        //[DllImport("user32.dll", SetLastError = true)]
        //static extern uint GetWindowThreadProcessId(IntPtr hWnd, out uint lpdwProcessId);
        //[DllImport("user32.dll")]
        //extern static bool AttachThreadInput(uint idAttach, uint idAttachTo, bool fAttach);

        //// 外部プロセスのメイン・ウィンドウを起動するためのWin32 API
        //[DllImport("user32.dll")]
        //private static extern bool SetForegroundWindow(IntPtr hWnd);
        //[DllImport("user32.dll")]
        //private static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);
        //[DllImport("user32.dll")]
        //private static extern bool IsIconic(IntPtr hWnd);
        //// ShowWindowAsync関数のパラメータに渡す定義値
        //private const int SW_RESTORE = 9;  // 画面を元の大きさに戻す
        //[return: MarshalAs(UnmanagedType.Bool)]
        //[DllImport("user32.dll", SetLastError = true)]
        //static public extern bool PostMessage(HandleRef hWnd, uint Msg, IntPtr wParam, IntPtr lParam);
        ////static public extern bool PostMessage(IntPtr hWnd, uint Msg, IntPtr wParam, IntPtr lParam);
        //[DllImport("user32.dll", CharSet = CharSet.Auto)]
        //static extern IntPtr SendMessage(IntPtr hWnd, UInt32 Msg, IntPtr wParam, IntPtr lParam);
        //#endregion

        static public IEnumerable<DependencyObject> GetVisualTreeChildrenByType(DependencyObject reference, Type type)
        {
            var ret = new List<DependencyObject> { };

            var count = VisualTreeHelper.GetChildrenCount(reference);
            for (var childIndex = 0; childIndex < count; childIndex++)
            {
                var child = VisualTreeHelper.GetChild(reference, childIndex);
                if (child.GetType() == type)
                    ret.Add(child);
                ret.AddRange(GetVisualTreeChildrenByType(child, type));
            }

            return ret;
        }

        static public IEnumerable<DependencyObject> GetLogicalTreeChildrenByType(DependencyObject reference, Type type)
        {
            var ret = new List<DependencyObject> { };

            var children = LogicalTreeHelper.GetChildren(reference);
            foreach (var child in children)
            {
                if (child is DependencyObject)
                {
                    if (child.GetType() == type)
                        ret.Add((DependencyObject)child);
                    ret.AddRange(GetLogicalTreeChildrenByType((DependencyObject)child, type));
                }
            }

            return ret;
        }

        static public string GetFileNameWithoutDocumentExtension(string path)
        {
            return Path.GetFileName(path).Replace(".join.rtf", "");
        }

        static public int GetIndexByTextPointer(TextPointer pointer, TextRange at)
        {
            Debug.Assert(pointer.IsInSameDocument(at.Start));

            // 変換元がTextPointerなので、at.Text[idx]のidxとして使える範囲より大きな値になることがある
            return Util.TextOf(new TextRange(at.Start, pointer)).Length;
        }

        //static public int TextLengthOf(TextRange range)
        //{
        //    var ret = 0;

        //    for (var pointer = range.Start; pointer != null && pointer.CompareTo(range.End) <= 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
        //    {
        //        if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text && pointer.GetTextInRun(LogicalDirection.Forward).Length > 0)
        //            ret++;
        //    }

        //    return ret;
        //}

        //// InsertionPositionごとにTextRange.Text使用。細切れにすることで存在しない文字が入らないように。
        //static public string TextOf(TextRange range)
        //{
        //    var ret = new StringBuilder();

        //    TextPointer pointer_ = null;
        //    //FIXME: range.Endでの処理は含めない。End以降を扱ってしまうので。
        //    for (var pointer = range.Start; pointer != null && pointer.CompareTo(range.End) <= 0; pointer = pointer.GetNextInsertionPosition(LogicalDirection.Forward))
        //    {
        //        if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text)
        //        {
        //            if (pointer_ != null)
        //            {
        //                ret.Append(new TextRange(pointer_, pointer).Text);
        //            }
        //            pointer_ = pointer;
        //        }
        //        else if (pointer_ != null)
        //        {
        //            ret.Append(new TextRange(pointer_, pointer).Text);
        //            pointer_ = null;
        //        }
        //    }

        //    return ret.ToString();
        //}

        /// <summary>
        /// TextRange.Textを使わずにテキスト化。
        /// </summary>
        static public string TextOf(TextRange range)
        {
            var text = new StringBuilder();
            // range.Endでの処理は含めない。End以降を扱ってしまうので。
            for (var pointer = range.Start; pointer != null && pointer.CompareTo(range.End) < 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text)
                {
                    var textInRun = pointer.GetTextInRun(LogicalDirection.Forward);
                    var textRunLength = pointer.GetTextRunLength(LogicalDirection.Forward);
                    if (range.End.CompareTo(pointer.GetPositionAtOffset(textRunLength)) <= 0)
                    {
                        text.Append(textInRun.Substring(0, pointer.GetOffsetToPosition(range.End)));
                        break;
                    }
                    else
                    {
                        text.Append(textInRun);
                    }
                }
            }

            return text.ToString();
        }

        static public TextRange ContentRangeOf(FlowDocument document)
        {
            return new TextRange(document.ContentStart, document.ContentEnd);
        }

        static public TextRange ContentRangeOf(TextElement element)
        {
            return new TextRange(element.ContentStart, element.ContentEnd);
        }

        static public TextRange ElementRangeOf(TextElement element)
        {
            return new TextRange(element.ElementStart, element.ElementEnd);
        }

        static public System.Windows.Forms.Keys InputModifierKeyToFormsKey(System.Windows.Input.ModifierKeys inputKey)
        {
            System.Windows.Forms.Keys ret = System.Windows.Forms.Keys.None;

            if (inputKey != System.Windows.Input.ModifierKeys.None)
            {
                //HACK: なぜかSystem.Windows.Input.ModifierKeysとSystem.Windows.Forms.Keysの対応が違うので、ここで変更。
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Alt))
                    ret |= System.Windows.Forms.Keys.Shift; // ModifierKeys.Alt -> Keys.Shift
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Control))
                    ret |= System.Windows.Forms.Keys.Control;
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Shift))
                    ret |= System.Windows.Forms.Keys.Alt;  // ModifierKeys.Shift -> Keys.Alt
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Windows))
                {
                    ret |= System.Windows.Forms.Keys.LWin;
                    ret |= System.Windows.Forms.Keys.RWin;
                }
            }

            Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputModifierKeyToFormsKey");

            return ret;
        }

        static public System.Windows.Forms.Keys InputKeyToFormsKey(System.Windows.Input.Key inputKey)
        {
            System.Windows.Forms.Keys ret = System.Windows.Forms.Keys.None;

            try
            {
                // System.Windows.Input.Key http://msdn.microsoft.com/ja-jp/library/vstudio/system.windows.input.hotKey.aspx
                // System.Windows.Forms.Keys http://msdn.microsoft.com/ja-jp/library/vstudio/system.windows.forms.keys.aspx
                ret = (System.Windows.Forms.Keys)Enum.Parse(typeof(System.Windows.Forms.Keys), inputKey.ToString());
            }
            catch (ArgumentException ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }

            if (inputKey.ToString() != ret.ToString())
                Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputKeyToFormsKey");

            Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputKeyToFormsKey");

            return ret;
        }

        static public bool Contain(TextRange range, TextPointer pointer)
        {
            return range.Start.CompareTo(pointer) <= 0 && pointer.CompareTo(range.End) <= 0;
        }

        #region GetTextPointerByIndex2
        /// <param name="indexInDocument">（左側にある文字数で指定。例えばatに3文字しか含まれていなくても3を指定していい。）</param>
        /// <param name="at"></param>
        /// <param name="sideOfBound"></param>
        /// <returns></returns>
        static public TextPointer GetTextPointerByIndex2(int indexInDocument, FlowDocument at, LogicalDirection sideOfBound)
        {
            var _sw = new Stopwatch();
            _sw.Start();

            Debug.Assert(0 <= indexInDocument && indexInDocument <= TextOf(new TextRange(at.ContentStart, at.ContentEnd)).Length);
            TextPointer ret = null;

            var loop = 0;

            // at.ContentEndでGetPointerContext(LogicalDirection.Forward)するのは範囲外を取得することになるので、ループ範囲にat.ContentEndを含めない。
            int lengthCount = 0;
            for (var pointer = at.ContentStart; pointer != null && pointer.CompareTo(at.ContentEnd) < 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text)
                {
                    Debug.Assert(pointer.GetPointerContext(LogicalDirection.Backward) == TextPointerContext.ElementStart && pointer.Parent is Run, "ElementStart - Text");
                    //Debug.WriteLine(new { lengthCount, runLength = pointer.GetTextRunLength(LogicalDirection.Forward), indexInDocument }, "c1-1.detail");
                    //Debug.WriteLine(lengthCount + pointer.GetTextRunLength(LogicalDirection.Forward) == indexInDocument, "c1-1\t");
                    //Debug.WriteLine(sideOfBound == LogicalDirection.Backward, "c1-2\t");
                    //Debug.WriteLine(lengthCount + pointer.GetTextRunLength(LogicalDirection.Forward) > indexInDocument, "c2\t\t");
                    if ((lengthCount + pointer.GetTextRunLength(LogicalDirection.Forward) == indexInDocument && sideOfBound == LogicalDirection.Backward)
                        || lengthCount + pointer.GetTextRunLength(LogicalDirection.Forward) > indexInDocument)
                    {
                        ret = pointer.GetPositionAtOffset(indexInDocument - lengthCount);
                        break;
                    }

                    lengthCount += pointer.GetTextRunLength(LogicalDirection.Forward);
                }
                loop++;
            }

            Debug.WriteLine(new { _sw.ElapsedMilliseconds, loop });
            //Debug.WriteLine(ret != null, "ret");
            Debug.Assert(ret == null || (at.ContentStart.CompareTo(ret) <= 0 && ret.CompareTo(at.ContentEnd) <= 0 && TextOf(new TextRange(at.ContentStart, ret)).Length == indexInDocument));
            return ret;
        }
        #endregion

        //#region GetTextPointerByIndex
        //// メモ化されたスキャン結果。
        //static internal HashSet<Tuple<TextPointer, int?>> getTextPointerByIndexMemo = new HashSet<Tuple<TextPointer, int?>> { };

        //static internal TextPointer GetTextPointerByIndex(int indexInRange, TextRange at, LogicalDirection sideOfBound)
        //{
        //    return GetTextPointerByIndex(indexInRange, at, sideOfBound, new Tuple<TextPointer, int?>[] { });
        //}
        //static internal TextPointer GetTextPointerByIndex(int indexInRange, TextRange at, LogicalDirection sideOfBound, IEnumerable<TextPointer> scanningOriginPointers)
        //{
        //    var scanningOrigins = new List<Tuple<TextPointer, int?>> { };
        //    foreach (var pointer in scanningOriginPointers)
        //    {
        //        var hintIndex = (pointer == null) ? (int?)null : Util.TextOf(new TextRange(at.Start, pointer)).Length;
        //        scanningOrigins.Add(new Tuple<TextPointer, int?>(pointer, hintIndex));
        //    }
        //    return GetTextPointerByIndex(indexInRange, at, sideOfBound, scanningOrigins.ToArray());
        //}
        //static internal TextPointer GetTextPointerByIndex(int indexInRange, TextRange at, LogicalDirection sideOfBound, IEnumerable<Tuple<TextPointer, int?>> scanningOrigins)
        //{
        //    var _sw = new Stopwatch();
        //    _sw.Start();

        //    // decide origin
        //    var origin = scanningOrigins
        //        .Concat(getTextPointerByIndexMemo)
        //        .Concat(new[] {
        //                new Tuple<TextPointer, int?>(at.Start, 0),
        //                new Tuple<TextPointer, int?>(at.End, Util.TextOf(new TextRange(at.Start, at.End)).Length - 1 + 1) })
        //        .OrderBy(_ => Math.Abs((_.Item2 ?? 0) - indexInRange))
        //        .First();

        //    {
        //        //HACK: 適当に進める。答えに近いoriginが無いときのための対策。
        //        var originPointer2 = at.Start.GetPositionAtOffset(origin.Item2.Value);
        //        var originIndex2 = Util.TextOf(new TextRange(at.Start, originPointer2)).Length;
        //        origin = new Tuple<TextPointer, int?>(originPointer2, originIndex2);
        //    }

        //    TextPointer ret = null;

        //    //Debug.WriteLine(new { indexInRange, originIndex = origin.Item2, at.Text.Replace("\r\n", ""), }, "GetTextPointerByIndex");
        //    Debug.Assert(origin.Item1 != null ? at.Start.CompareTo(origin.Item1) <= 0 : true);
        //    Debug.Assert(origin.Item1 != null ? origin.Item1.CompareTo(at.End) <= 0 : true);

        //    Debug.Assert(origin.Item1 != null && origin.Item2.HasValue
        //        ? Util.TextOf(new TextRange(at.Start, origin.Item1)).Length == origin.Item2.Value : true, "*****");

        //    var scanDirection = (origin.Item2 <= indexInRange) ? LogicalDirection.Forward : LogicalDirection.Backward;
        //    var reverseDirection = (scanDirection == LogicalDirection.Forward) ? LogicalDirection.Backward : LogicalDirection.Forward;
        //    var offset = (origin.Item2 <= indexInRange) ? 1 : -1;

        //    //Debug.WriteLine(new { originIndex = origin.Item2, indexInRange, scanDirection, offset, }, "param");
        //    Debug.Assert(scanDirection == LogicalDirection.Forward ? origin.Item2 <= indexInRange : indexInRange <= origin.Item2);
        //    Debug.Assert(scanDirection == LogicalDirection.Forward ? 0 < offset : offset < 0);

        //    var loop = 0;
        //    {
        //        int lengthCount = origin.Item2.Value;

        //        // ループの終了条件を飛び越さないようにスキャンを進める。でもTextPointerはシンボル単位で進み、1つのシンボルは2文字以上に変換されることがあるので、一度に2文字以上進むことがある。
        //        //for (var pointer = origin.Item1; pointer != null && at.Start.CompareTo(pointer) <= 0 && pointer.CompareTo(at.End) <= 0; pointer = pointer.GetPositionAtOffset(offset, scanDirection))
        //        for (var pointer = origin.Item1; pointer != null && at.Start.CompareTo(pointer) <= 0 && pointer.CompareTo(at.End) <= 0; pointer = pointer.GetNextInsertionPosition(scanDirection))
        //        //for (var pointer = origin.Item1; pointer != null && at.Start.CompareTo(pointer) <= 0 && pointer.CompareTo(at.End) <= 0; pointer = pointer.GetNextContextPosition(scanDirection))
        //        {
        //            lengthCount = origin.Item2.Value + Util.TextOf(new TextRange(origin.Item1, pointer)).Length * offset;
        //            if (scanDirection != sideOfBound && lengthCount == indexInRange)
        //            {
        //                getTextPointerByIndexMemo.Add(new Tuple<TextPointer, int?>(pointer, indexInRange));
        //                ret = pointer;
        //                Debug.WriteLine(new { pointer = Util.TextOf(new TextRange(at.Start, pointer)), ret = Util.TextOf(new TextRange(at.Start, ret)) }, "1");
        //                break;
        //            }
        //            else if (scanDirection == LogicalDirection.Forward && indexInRange < lengthCount)
        //            {
        //                getTextPointerByIndexMemo.Add(new Tuple<TextPointer, int?>(pointer, indexInRange));
        //                //ret = pointer;
        //                Debug.WriteLine(new { pointer = Util.TextOf(new TextRange(at.Start, pointer)), Util.TextOf(new TextRange(at.Start, pointer)).Length }, "2");
        //                pointer = pointer.GetNextInsertionPosition(reverseDirection);
        //                ret = pointer.GetInsertionPosition(sideOfBound);
        //                Debug.WriteLine(new { pointer = Util.TextOf(new TextRange(at.Start, pointer)), ret = Util.TextOf(new TextRange(at.Start, ret)) }, "2");
        //                break;
        //            }
        //            else if (scanDirection == LogicalDirection.Backward && lengthCount < indexInRange)
        //            {
        //                getTextPointerByIndexMemo.Add(new Tuple<TextPointer, int?>(pointer, indexInRange));
        //                //ret = pointer;                                
        //                Debug.WriteLine(new { pointer = Util.TextOf(new TextRange(at.Start, pointer)), Util.TextOf(new TextRange(at.Start, pointer)).Length }, "3");
        //                pointer = pointer.GetNextInsertionPosition(reverseDirection);
        //                ret = pointer.GetInsertionPosition(sideOfBound);
        //                Debug.WriteLine(new { pointer = Util.TextOf(new TextRange(at.Start, pointer)), ret = Util.TextOf(new TextRange(at.Start, ret)) }, "3");
        //                break;
        //            }

        //            Debug.Assert(Util.TextOf(new TextRange(at.Start, pointer)).Length == lengthCount);
        //            loop++;
        //        }
        //    }

        //    Debug.WriteLine(new { _sw.ElapsedMilliseconds, loop, score = (Math.Abs(indexInRange - (origin.Item2 ?? 0)) / (float)_sw.ElapsedMilliseconds), f = (origin.Item2 ?? 0).ToString() + "->" + indexInRange.ToString() }, "GetTextPointerByIndex\t");
        //    Debug.Assert(ret == null || (at.Contains(ret) && Util.TextOf(new TextRange(at.Start, ret)).Length == indexInRange));

        //    // retは条件に合う（つまりindexInRangeに対応する）TextPointerのうちいずれか（不定）。…に近いInsertionPosition
        //    return ret;
        //}
        //#endregion

        static public void p(string category)
        {
            Debug.WriteLine(category);
        }
        static public void p(object value)
        {
            Debug.WriteLine(value);
        }
        static public void p(object value, string category)
        {
            Debug.WriteLine(value, category);
        }

        static public void p(Exception ex)
        {
            Debug.WriteLine(ex.Message, ex.Source);
        }

    }
}
