﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using Forms = System.Windows.Forms;
using System.Diagnostics;
using System.Windows.Interop;
using System.Reflection;
using System.ComponentModel;

namespace JoinNotes
{
    /// <summary>
    /// NotifyTray.xaml の相互作用ロジック
    /// </summary>
    public partial class NotifyTray : Window
    {
        internal const int WM_HOTKEY = 0x312;
        internal const int WM_ACTIVATEAPP = 0x1C;
        internal const int WM_APP = 0x8000;
        internal const int WM_APP_ACTIVATEAPP = WM_APP + 1;
        internal const int SW_RESTORE = 9;
        public const int HotKey_ActivateHotKeyId = 0;
        public const int HotKey_OpenWindowHotKeyId = 1;
        static public HotKey HotKey_ActivateHotKey = null;
        static public HotKey HotKey_OpenWindowHotKey = null;

        Forms.NotifyIcon notifyIcon;
        Forms.ContextMenuStrip menuStrip;
        Forms.ToolStripMenuItem searchToolStripMenuItem;
        Forms.ToolStripMenuItem editorToolStripMenuItem;
        Forms.ToolStripMenuItem configToolStripMenuItem;
        Forms.ToolStripMenuItem exitToolStripMenuItem;
        Forms.ToolStripMenuItem aboutToolStripMenuItem;

        private static IntPtr WndProc(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, ref bool handled)
        {
            Debug.WriteLine(msg.ToString(), "NotifyTray:WndProc");

            if (msg == WM_APP_ACTIVATEAPP)
            {
                //MessageBox.Show("NotifyTray:WndProc, Message:0x" + msg.ToString("X") + ", MainWindowHandle: 0x" + new WindowInteropHelper(App.Instance.MainWindow).Handle.ToString("X"));
                App.ActivateWindows();
                handled = true;
            }

            //if (m.Msg == WM_ACTIVATEAPP)
            //    if (m.WParam.ToInt64() == 0)
            //    {
            //        App.InactivateWindows();
            //    }
            //    else
            //    {
            //        App.ActivateWindows();
            //    }

            //if (msg == WM_HOTKEY)
            //{
            //    var ret = Util.PostMessage(new HandleRef(App.Instance, this.Handle), WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
            //    Trace.Assert(ret);
            //}

            if (msg == WM_HOTKEY && lParam != null && HotKey_ActivateHotKey != null && lParam == HotKey_ActivateHotKey.LParam)
            {
                //App.SwitchApplicationVisibility();
                //var editor = new Editor();
                //editor.Show();

                App.SwitchApplicationVisibility();
            }
            else if (msg == WM_HOTKEY && lParam != null && HotKey_OpenWindowHotKey != null && lParam == HotKey_OpenWindowHotKey.LParam)
            {
                switch (Properties.Settings.Default.StartupWindowClassName)
                {
                    case "Editor":
                        {
                            var editor = new Editor();
                            ((App)App.Current).UntitledEditorWindows.Add(editor);
                            editor.Show();
                            editor.Activate();
                        }
                        break;

                    case "Search":
                        App.searchWindow.Show();
                        break;

                    case "Task":
                        //App.mainWindow.MainMenuStrip.Show();
                        ((NotifyTray)App.mainWindow).ShowNotifyTrayMenu();
                        break;

                    default:
                        break;
                }
                //App.SwitchApplicationVisibility();
                //var editor = new Editor();
                //editor.Show();

                App.SwitchApplicationVisibility();
            }

            return IntPtr.Zero;
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            {
                // † http://csfun.blog49.fc2.com/blog-entry-93.html
                HwndSource source = HwndSource.FromHwnd(new WindowInteropHelper(this).Handle);
                source.AddHook(new HwndSourceHook(WndProc));
            }
        }

        public NotifyTray()
        {
            InitializeComponent();
            this.Unloaded += new RoutedEventHandler(NotifyTray_Unloaded);
            this.Closed += new EventHandler(NotifyTray_Closed);
            this.AllowsTransparency = true;
            this.Background = Brushes.Transparent;
            this.WindowStyle = System.Windows.WindowStyle.None;
            this.ShowInTaskbar = false;
            this.Title = App.NotifyContainerTitle;

            var components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Menu));

            this.notifyIcon = new Forms.NotifyIcon(components);
            this.menuStrip = new Forms.ContextMenuStrip(components);
            this.searchToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.editorToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.configToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.exitToolStripMenuItem = new Forms.ToolStripMenuItem();
            this.aboutToolStripMenuItem = new Forms.ToolStripMenuItem();

            // 
            // notifyIcon1
            // 
            this.notifyIcon.BalloonTipText = "Active.";
            this.notifyIcon.BalloonTipTitle = "Join Notes";
            this.notifyIcon.ContextMenuStrip = this.menuStrip;
            this.notifyIcon.Icon = ((System.Drawing.Icon)(Properties.Resources.ResourceManager.GetObject("notifyIcon")));
            this.notifyIcon.Text = "notifyIcon1";
            this.notifyIcon.Visible = true;
            this.notifyIcon.MouseClick += new Forms.MouseEventHandler(notifyIcon_MouseClick);
            //this.notifyIcon.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler(this.notifyIcon_MouseDoubleClick);

            // 
            // searchToolStripMenuItem
            // 
            this.searchToolStripMenuItem.Name = "searchToolStripMenuItem";
            this.searchToolStripMenuItem.ShortcutKeyDisplayString = "";
            this.searchToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.E)));
            this.searchToolStripMenuItem.Size = new System.Drawing.Size(152, 22);
            this.searchToolStripMenuItem.Text = "&Find";
            this.searchToolStripMenuItem.Click += new EventHandler(searchToolStripMenuItem_Click);
            // 
            // editorToolStripMenuItem
            // 
            this.editorToolStripMenuItem.Name = "editorToolStripMenuItem";
            this.editorToolStripMenuItem.Size = new System.Drawing.Size(152, 22);
            this.editorToolStripMenuItem.Text = "&New Editor";
            this.editorToolStripMenuItem.Click += new EventHandler(editorToolStripMenuItem_Click);
            // 
            // configToolStripMenuItem
            // 
            this.configToolStripMenuItem.Name = "configToolStripMenuItem";
            this.configToolStripMenuItem.Size = new System.Drawing.Size(152, 22);
            this.configToolStripMenuItem.Text = "&Options";
            this.configToolStripMenuItem.Click += new EventHandler(this.configToolStripMenuItem_Click);
            // 
            // exitToolStripMenuItem
            // 
            this.exitToolStripMenuItem.Name = "exitToolStripMenuItem";
            this.exitToolStripMenuItem.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Alt | System.Windows.Forms.Keys.F4)));
            this.exitToolStripMenuItem.Size = new System.Drawing.Size(152, 22);
            this.exitToolStripMenuItem.Text = "&Exit";
            this.exitToolStripMenuItem.Click += new EventHandler(this.exitToolStripMenuItem_Click);
            // 
            // aboutToolStripMenuItem
            // 
            this.aboutToolStripMenuItem.Name = "aboutToolStripMenuItem";
            this.aboutToolStripMenuItem.Size = new System.Drawing.Size(152, 22);
            this.aboutToolStripMenuItem.Text = "&About";
            this.aboutToolStripMenuItem.Click += new System.EventHandler(this.aboutToolStripMenuItem_Click);

            // 
            // contextMenuStrip1
            // 
            this.menuStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
                this.searchToolStripMenuItem,
                this.editorToolStripMenuItem,
                this.configToolStripMenuItem,
                this.exitToolStripMenuItem,
                this.aboutToolStripMenuItem,
            });
            //this.editorToolStripMenuItem,
            //this.aboutToolStripMenuItem,
            //this.configToolStripMenuItem,
            //this.exitToolStripMenuItem,
            //this.toolStripMenuItem1});
            this.menuStrip.Name = "contextMenuStrip1";
            this.menuStrip.Size = new System.Drawing.Size(153, 142);
            //this.menuStrip.Opening += new System.ComponentModel.CancelEventHandler(this.menuStrip_Opening);
        }

        void NotifyTray_Closed(object sender, EventArgs e)
        {
            //FIXME: 適切なイベントハンドラーで実行
            this.notifyIcon.Dispose();
        }

        void NotifyTray_Unloaded(object sender, RoutedEventArgs e)
        {
            throw new NotImplementedException();
        }

        void searchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Search().Show();
        }

        void editorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Editor().Show();
        }

        void configToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Config().Show();
        }

        void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            App.Instance.Shutdown();
        }

        void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new AboutBox1().Show();
        }

        void notifyIcon_MouseClick(object sender, Forms.MouseEventArgs e)
        {
            if (e.Button == Forms.MouseButtons.Left)
            {
                new Config().Show();
                //App.configWindow.Show();

                //var w = App.Current.MainWindow;
                //if (w.IsVisible)
                //    w.Close();
                //else
                //    w.Show();
            }
            else if (e.Button == Forms.MouseButtons.Right)
            {
                ShowNotifyTrayMenu();
            }
        }

        public void ShowNotifyTrayMenu()
        {
            this.menuStrip.Show();
        }

        public void ShowNotifyTrayMenu(Point position)
        {
            this.menuStrip.Show((int)position.X, (int)position.Y);
        }

    }
}
