﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Effects;
using System.Windows.Media.Imaging;
using Shapes = System.Windows.Shapes;
using System.Diagnostics;
using System.IO;
using Microsoft.Windows.Controls.Ribbon;

namespace JoinNotes
{
    /// <summary>
    /// Editor.xaml の相互作用ロジック
    /// </summary>
    public partial class Editor : RibbonWindow
    {
        // メモ化されたスキャン結果。
        static HashSet<Tuple<TextPointer, int?>> getTextPointerByIndexMemo = new HashSet<Tuple<TextPointer, int?>> { };

        //private string basepath
        //{
        //    get { return App.DocumentPath.FullName; }
        //}
        internal Uri DocumentUri { get; private set; }
        Dictionary<string, string> linkTargets;
        internal TextRange CompletionRange;
        internal Popup CompletionRangePopup;
        internal Canvas CompletionRangeCanvas;

        private string _searchString = string.Empty;
        internal string SearchString
        {
            get { return this._searchString; }
            set { this._searchString = this.MigiueBox.Text = value; }
        }

        public Editor()
        {
            InitializeComponent();
            App.Instance.UntitledEditorWindows.Add(this);
            this.SearchString = "";
            //this.ShowActivated = true;
            this.Loaded += new RoutedEventHandler(Editor_Loaded);
            this.Closed += new EventHandler(Editor_Closed);
            this.KeyDown += new KeyEventHandler(Editor_KeyDown);
            this.StateChanged += new EventHandler(Editor_StateChanged);
            this.PreviewKeyDown += new KeyEventHandler(Editor_PreviewKeyDown);
            this.PreviewMouseMove += new MouseEventHandler(Editor_PreviewMouseMove);
            this.MouseUp += new MouseButtonEventHandler(Editor_MouseUp);
            this.MouseLeave += new MouseEventHandler(Editor_MouseLeave);
            //this.QueryContinueDrag += new QueryContinueDragEventHandler(Editor_QueryContinueDrag);
            //this.PreviewQueryContinueDrag += new QueryContinueDragEventHandler(Editor_PreviewQueryContinueDrag);

            this.CompletionRangeCanvas = new Canvas();
            {
                //FIXME: 効果なし
                this.CompletionRangeCanvas.HorizontalAlignment = System.Windows.HorizontalAlignment.Stretch;
                this.CompletionRangeCanvas.VerticalAlignment = System.Windows.VerticalAlignment.Stretch;

                //this.CompletionRangeCanvas.Opacity = 0.25;
                //this.CompletionRangeCanvas.Background = SystemColors.HighlightBrush;

                ////FIXME: Remove
                //this.CompletionRangeCanvas.Background = Brushes.White;
            }
            this.CompletionRangePopup = new Popup();
            {
                this.CompletionRangePopup.AllowsTransparency = true;
                this.CompletionRangePopup.Placement = PlacementMode.Relative;
                this.CompletionRangePopup.PlacementTarget = this.RichTextBox;
            }
            this.CompletionRangePopup.Child = this.CompletionRangeCanvas;

            this.MigiueBox.Loaded += new RoutedEventHandler(MigiueBox_Loaded);
            this.MigiueBox.TextChanged += new TextChangedEventHandler(MigiueBox_TextChanged);
            this.MigiueBox.PreviewKeyDown += new KeyEventHandler(MigiueBox_PreviewKeyDown);
            this.MigiueBox.KeyDown += new KeyEventHandler(MigiueBox_KeyDown);
            this.MigiueBox.GotKeyboardFocus += new KeyboardFocusChangedEventHandler(MigiueBox_GotKeyboardFocus);
            this.MigiueBox.LostKeyboardFocus += new KeyboardFocusChangedEventHandler(MigiueBox_LostKeyboardFocus);

            {
                TextCompositionManager.AddPreviewTextInputHandler(this.RichTextBox, OnPreviewTextInput);
                TextCompositionManager.AddPreviewTextInputStartHandler(this.RichTextBox, OnPreviewTextInputStart);
                TextCompositionManager.AddPreviewTextInputUpdateHandler(this.RichTextBox, OnPreviewTextInputUpdate);
            }

            #region RichTextBox
            this.RichTextBox.FontFamily = new FontFamily("Meiryo");
            this.RichTextBox.FontSize = 18;
            this.RichTextBox.Foreground = SystemColors.WindowTextBrush;
            this.RichTextBox.Background = null;
            this.RichTextBox.PreviewMouseDown += new MouseButtonEventHandler(RichTextBox_PreviewMouseDown);
            this.RichTextBox.SelectionChanged += new RoutedEventHandler(RichTextBox_SelectionChanged);
            this.RichTextBox.SizeChanged += new SizeChangedEventHandler(RichTextBox_SizeChanged);
            //this.RichTextBox.QueryContinueDrag += new QueryContinueDragEventHandler(RichTextBox_QueryContinueDrag);

            {
                var document = this.RichTextBox.Document;
                document.Foreground = this.RichTextBox.Foreground;
                document.Background = this.RichTextBox.Background;
                document.DragEnter += new DragEventHandler(FlowDocument_DragEnter);
                document.DragOver += new DragEventHandler(FlowDocument_DragOver);
                document.Drop += new DragEventHandler(FlowDocument_Drop);
                document.DragLeave += new DragEventHandler(FlowDocument_DragLeave);
                document.GiveFeedback += new GiveFeedbackEventHandler(FlowDocument_GiveFeedback);
                document.PreviewGiveFeedback += new GiveFeedbackEventHandler(FlowDocument_PreviewGiveFeedback);
                //document.MouseMove += new MouseEventHandler(FlowDocument_MouseMove);
                document.MouseUp += new MouseButtonEventHandler(FlowDocument_MouseUp);
                document.QueryContinueDrag += new QueryContinueDragEventHandler(FlowDocument_QueryContinueDrag);
                document.PreviewQueryContinueDrag += new QueryContinueDragEventHandler(FlowDocument_PreviewQueryContinueDrag);
            }
            this.RichTextBox.IsOnTextChangedEnabled = true;
            #endregion RichTextBox

            #region AutocompleteBox
            this.Popup.StaysOpen = false;
            this.Popup.AllowsTransparency = true;
            this.Popup.Opened += new EventHandler(Popup_Opened);
            this.Popup.PopupAnimation = PopupAnimation.Fade;
            var effect = new DropShadowEffect();
            {
                effect.BlurRadius = 0;
                effect.Color = Colors.Gray;
                effect.Opacity = 0.25;
                effect.ShadowDepth = 2.5;
                effect.Direction = 315;
            }
            //this.Popup.Effect = effect;
            Debug.WriteLine(new { this.Popup.HasDropShadow });

            {
                var listbox = (ListBox)this.Popup.Child;
                listbox.IsSynchronizedWithCurrentItem = true;
                listbox.IsTextSearchCaseSensitive = false;
                listbox.IsTextSearchEnabled = true;
                listbox.FocusVisualStyle = null;
                listbox.BorderBrush = Brushes.Gray;
                listbox.BorderThickness = new Thickness(1);
                listbox.Effect = effect;
                listbox.Margin = new Thickness(10); // for Effect
                listbox.Padding = new Thickness(5);
                listbox.Foreground = SystemColors.WindowTextBrush;
                listbox.Background = SystemColors.WindowBrush;
                listbox.Opacity = 0.95;
                //FIXME: MaxHeightは行の高さ単位で
                listbox.MaxHeight = 200;
                listbox.MaxWidth = 1000;
                //TODO: Widthは表示時に決定。最も長い項目が表示できる幅。
                //listbox.Width = ???;
                listbox.KeyDown += new KeyEventHandler(ListBox_KeyDown);
            }
            #endregion AutocompleteBox

            {
                linkTargets = new Dictionary<string, string> { };
                var dir = App.DocumentPath;
                this.ListBox.Items.Clear();
                foreach (var file in dir.GetFiles("*.join.rtf", SearchOption.TopDirectoryOnly))
                {
                    var withoutExtension = file.Name.Replace(".join.rtf", "");
                    linkTargets[withoutExtension] = file.Name;

                    // for AutoComplete
                    this.ListBox.Items.Add(new ListBoxItem() { Content = withoutExtension, HorizontalContentAlignment = HorizontalAlignment.Left, VerticalContentAlignment = VerticalAlignment.Center, });
                }
            }

            {
                var command = new CommandBinding(ApplicationCommands.Paste);
                command.Executed += new ExecutedRoutedEventHandler(pasteCommand_Executed);  //HACK: PreviewExecutedを発生させるため
                command.PreviewExecuted += new ExecutedRoutedEventHandler(pasteCommand_PreviewExecuted);
                this.RichTextBox.CommandBindings.Add(command);
            }

            t_Editor();
        }

        void Editor_PreviewQueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            Debug.WriteLine(new { e.Action, e.EscapePressed }, "Editor_PreviewQueryContinueDrag");
        }

        void Editor_QueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            Debug.WriteLine(new { e.Action, e.EscapePressed }, "Editor_QueryContinueDrag");
        }

        void RichTextBox_QueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            Debug.WriteLine(new { e.Action, e.EscapePressed }, "RichTextBox_QueryContinueDrag");
        }

        void FlowDocument_PreviewQueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            Debug.WriteLine(new { e.Action, e.EscapePressed }, "FlowDocument_PreviewQueryContinueDrag");

            //e.Action = DragAction.Cancel;
            //e.Handled = true;
        }

        void FlowDocument_GiveFeedback(object sender, GiveFeedbackEventArgs e)
        {
            Debug.WriteLine(new { e.Effects, e.UseDefaultCursors }, "FlowDocument_GiveFeedback");
        }

        void FlowDocument_PreviewGiveFeedback(object sender, GiveFeedbackEventArgs e)
        {
            Debug.WriteLine(new { e.Effects, e.UseDefaultCursors }, "FlowDocument_PreviewGiveFeedback");
        }

        void Editor_MouseLeave(object sender, MouseEventArgs e)
        {
            Debug.WriteLine("Editor_MouseLeave");
        }

        void Editor_MouseUp(object sender, MouseButtonEventArgs e)
        {
            Debug.WriteLine("Editor_MouseUp");
        }

        void FlowDocument_DragLeave(object sender, DragEventArgs e)
        {
            Debug.WriteLine("FlowDocument_DragLeave");
        }

        void FlowDocument_MouseUp(object sender, MouseButtonEventArgs e)
        {
            Debug.WriteLine("FlowDocument_MouseUp");

            //var sel = (FlowDocument)sender;
            //sel.ReleaseMouseCapture();
        }

        void FlowDocument_QueryContinueDrag(object sender, QueryContinueDragEventArgs e)
        {
            Debug.WriteLine(new { e.Action, e.EscapePressed }, "FlowDocument_QueryContinueDrag");
        }

        //void FlowDocument_MouseMove(object sender, MouseEventArgs e)
        //{
        //    //Debug.WriteLine("FlowDocument_MouseMove");

        //    var c = (FlowDocument)sender;

        //    if (e.LeftButton == MouseButtonState.Pressed)
        //    {
        //        //e.Handled = true;
        //        Uri uri;
        //        {
        //            IDataObject _clipboard = Clipboard.GetDataObject();
        //            Clipboard.Clear();

        //            //TODO: ドラッグ開始位置がイメージなら、前操作なしにイメージを選択、コピー可能にする
        //            this.RichTextBox.Copy();

        //            var dataObject = Clipboard.GetDataObject();
        //            var formats = dataObject.GetFormats(false);
        //            Debug.WriteLine(new { formats = string.Join(", ", formats) }, "Extract");

        //            if (formats.Contains(DataFormats.Bitmap))
        //            {
        //                string shorthash;
        //                {
        //                    var bitmap = Clipboard.GetImage();
        //                    var encoder = new PngBitmapEncoder();
        //                    encoder.Frames.Add(BitmapFrame.Create(bitmap));

        //                    byte[] hash;
        //                    using (var stream = new MemoryStream())
        //                    {
        //                        encoder.Save(stream);
        //                        hash = System.Security.Cryptography.MD5Cng
        //                            .Create()
        //                            .ComputeHash(stream.ToArray());
        //                    }

        //                    var num = new int[2];
        //                    for (var i = 0; i < hash.Length; i++)
        //                        num[i % num.Length] ^= hash[i];

        //                    shorthash = string.Join("", num.Select(_ => _.ToString()));
        //                }

        //                uri = new Uri(Path.Combine(Path.GetTempPath(), Util.GetFileNameWithoutDocumentExtension(this.DocumentUri.LocalPath) + "-" + shorthash + ".png"));
        //                Debug.WriteLine(new { tempFile = uri.LocalPath }, "Extract Image");

        //                {
        //                    Debug.Assert(dataObject.GetDataPresent(DataFormats.Bitmap, true), "Extract:Bitmap");
        //                    Debug.WriteLine("Extract:Bitmap");

        //                    var bitmap = Clipboard.GetImage();
        //                    var encoder = new PngBitmapEncoder();
        //                    encoder.Frames.Add(BitmapFrame.Create(bitmap));

        //                    using (var stream = new FileStream(uri.LocalPath, FileMode.Create))
        //                        encoder.Save(stream);
        //                }
        //            }
        //            else if (formats.Contains(DataFormats.Rtf))
        //            {
        //                Debug.Assert(dataObject.GetDataPresent(DataFormats.Rtf, true), "Extract:Rtf");
        //                Debug.WriteLine("Extract:Rtf");

        //                var paragraph = new Paragraph();
        //                var section = new Section(paragraph);
        //                var document = new FlowDocument(section);
        //                {
        //                    var range = Util.ContentRangeOf(section);
        //                    {
        //                        var richtext = (string)dataObject.GetData(DataFormats.Rtf, true);

        //                        //var formatter = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
        //                        using (var stream = new MemoryStream())
        //                        using (var writer = new BinaryWriter(stream))
        //                        {
        //                            writer.Write(richtext);

        //                            //formatter.Serialize(stream, richtext);
        //                            range.Load(stream, DataFormats.Rtf);
        //                        }
        //                    }
        //                }
        //                {
        //                    //uri = null;

        //                    var range = Util.ContentRangeOf(document);
        //                    uri = new Uri(Path.Combine(Path.GetTempPath(), CreateFilenameFrom(document, ".join.rtf")));

        //                    using (var stream = new FileStream(uri.LocalPath, FileMode.Create))
        //                        range.Save(stream, DataFormats.Rtf, true);
        //                }

        //                ////FIXME: remove
        //                ////var data = new DataObject(DataFormats.Rtf, dataObject.GetData(DataFormats.Rtf, true));
        //                //var data = new DataObject(DataFormats.FileDrop, new string[] { uri.LocalPath });
        //                //var effects = DragDrop.DoDragDrop(this, data, DragDropEffects.All);
        //            }
        //            else if (formats.Contains(DataFormats.UnicodeText))
        //            {
        //                Debug.Assert(dataObject.GetDataPresent(DataFormats.UnicodeText, true), "Extract:UnicodeText");
        //                Debug.WriteLine("Extract:UnicodeText");

        //                var text = (string)dataObject.GetData(DataFormats.UnicodeText, true);
        //                uri = new Uri(Path.Combine(Path.GetTempPath(), ValidateFilename(text + ".txt")));

        //                using (var writer = new StreamWriter(new FileStream(uri.LocalPath, FileMode.Create)))
        //                    writer.Write(text);
        //            }
        //            else if (formats.Length >= 1)
        //            {
        //                Debug.WriteLine("Extract:Other");

        //                var obj = dataObject.GetData(formats.First(), true);
        //                uri = new Uri(Path.Combine(Path.GetTempPath(), ValidateFilename(obj.GetHashCode().ToString())));

        //                var formatter = new System.Runtime.Serialization.Formatters.Binary.BinaryFormatter();
        //                using (var stream = new FileStream(uri.LocalPath, FileMode.Create))
        //                    formatter.Serialize(stream, obj);
        //            }
        //            else
        //            {
        //                Debug.WriteLine("Extract:NoData");
        //                uri = null;
        //            }

        //            Clipboard.Clear();
        //            Clipboard.SetDataObject(_clipboard);
        //        }

        //        //this.RichTextBox.Document.Dispatcher.BeginInvoke(new Action(() =>
        //        {
        //            if (uri != null)
        //            {
        //                try
        //                {
        //                    var data = new DataObject(DataFormats.FileDrop, new string[] { uri.LocalPath });
        //                    //HACK: this.RichTextBoxやthis.RichTextBox.Documentなどにドラッグ・ドロップを管理させたいが、ドラッグ・ドロップが終わってもEditor(Window)がドロップを待ち続けてしまうのでEditorで行なっている。
        //                    //FIXME: ドラッグ編集すると "エラー HRESULT E_FAIL が COM コンポーネントの呼び出しから返されました。"

        //                    //ドラッグ開始
        //                    //FIXME: 有効にすると通常のドラッグ編集や他アプリにドキュメントを渡すことができなくなる。
        //                    //FIXME: enable
        //                    //var effects = DragDrop.DoDragDrop(this, data, DragDropEffects.Copy);
        //                    Debug.WriteLine(new { tempFile = uri.LocalPath }, "Dropped(Outgoing)");

        //                    //lock (this.RichTextBox)
        //                    //{
        //                    //    if (effects.HasFlag(DragDropEffects.Move))
        //                    //        this.RichTextBox.Selection.Text = "";
        //                    //}

        //                    File.Delete(uri.LocalPath);
        //                }
        //                catch (Exception ex)
        //                {
        //                    Util.p(ex);
        //                    //FIXME: ドラッグ編集すると "System.Security.SecurityException はハンドルされませんでした。ソースが見つかりませんでした。一部またはすべてのイベント ログを検索できませんでした。ソースを作成するには、新しいソース名が一意であることを確認するために、すべてのイベント ログの読み取りアクセス許可が必要です。アクセスできないログ: Security。"
        //                    EventLog.WriteEntry(ex.Source, ex.Message);
        //                }
        //            }
        //        }
        //        //), null);
        //    }
        //}

        void Editor_DragLeave2(object sender, DragEventArgs e)
        {
            Debug.WriteLine("Editor_DragLeave2");
        }

        void Editor_GiveFeedback2(object sender, GiveFeedbackEventArgs e)
        {
            Debug.WriteLine("Editor_GiveFeedback2");
        }

        void Editor_Drop2(object sender, DragEventArgs e)
        {
            Debug.WriteLine("Editor_Drop2");

        }

        void RichTextBox_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            var c = (RichTextBoxEx)sender;

            this.CompletionRangePopup.PlacementRectangle = new Rect(0, 0, c.Width, c.Height);

            //HACK: HorizontalAlignment.Stretchなどの効果が無いので
            this.CompletionRangeCanvas.Width = c.ActualWidth;
            this.CompletionRangeCanvas.Height = c.ActualHeight;
        }

        void Editor_StateChanged(object sender, EventArgs e)
        {
            var c = (Editor)sender;

            // RibbonWindowでは無意味
            //switch (sel.WindowState)
            //{
            //    case WindowState.Maximized:
            //        sel.WindowStyle = WindowStyle.None;
            //        break;
            //
            //    case WindowState.Minimized:
            //        break;
            //
            //    case WindowState.Normal:
            //        sel.WindowStyle = WindowStyle.SingleBorderWindow;
            //        break;
            //
            //    default:
            //        break;
            //}
        }

        void Editor_Loaded(object sender, RoutedEventArgs e)
        {
            var ribbon = RibbonControlService.GetRibbon(this.Ribbon);
            ribbon.Background = SystemColors.WindowBrush;
            ribbon.CheckedBackground = SystemColors.WindowBrush;
            ((RibbonTab)ribbon.SelectedItem).Background = SystemColors.WindowBrush;
            //RibbonControlService.SetCheckedBackground(ribbon, SystemColors.WindowBrush);
            //RibbonControlService.SetFocusedBackground(ribbon, SystemColors.WindowBrush);
            //RibbonControlService.SetMouseOverBackground(ribbon, SystemColors.WindowBrush);
            //RibbonControlService.SetPressedBackground(ribbon, SystemColors.WindowBrush);
            //Debug.WriteLine(new { _204 = ribbon.Style.Resources["&#204;"] });

            //<!--=================================================================
            //        Ribbon
            //    ==================================================================-->
            //<SolidColorBrush x:Key="&#204;" Color="#60FFFFFF"/>
            //<SolidColorBrush x:Key="&#200;" Color="#DFE9F5" />
            //<SolidColorBrush x:Key="&#201;" Color="#B9C9DA" />
            //<LinearGradientBrush x:Key="&#205;" StartPoint="0.5,0.0" EndPoint="0.5,1.0" >
            //    <GradientStop Color="#EEFFFFFF" Offset="0.0"/>
            //    <GradientStop Color="#BBFFFFFF" Offset="0.1"/>
            //    <GradientStop Color="#05FFFFFF" Offset="0.5"/>
            //    <GradientStop Color="#20FFFFFF" Offset="1.0"/>
            //</LinearGradientBrush>

            // ...

            //<Canvas x:Name="BackgroundCanvas"
            //    Height="0"
            //    Width="0"
            //    HorizontalAlignment="Left"
            //    VerticalAlignment="Top"
            //    Margin="0,1,0,0">
            //<Rectangle x:Name="OpaqueRect"
            //            Height="{Binding ElementName=ScrollViewer,Path=ActualHeight}"
            //            Width="{Binding ElementName=ScrollViewer,Path=ActualWidth}"
            //            Fill="{Binding RelativeSource={RelativeSource Self},Path=(ribbon:RibbonControlService.Ribbon).Background}"/>
            //<Rectangle x:Name="OverlayRect"
            //            Height="{Binding ElementName=ScrollViewer,Path=ActualHeight}"
            //            Width="{Binding ElementName=ScrollViewer,Path=ActualWidth}"
            //            Fill="{StaticResource &#205;}"/>
            //<Rectangle x:Name="InnerOverlayRect"
            //            Height="{Binding ElementName=ScrollViewer,Path=ActualHeight}"
            //            Width="{Binding ElementName=ScrollViewer,Path=ActualWidth}"
            //            Fill="{StaticResource &#204;}"/>
            //</Canvas>
            //
            //<ItemsPresenter x:Name="ItemsPresenter" />


            //// ロードされていないVisualは操作できない？
            //var rectangles = new List<DependencyObject> { };
            //foreach (var tab in ribbon.Items)
            //{
            //    if (tab is RibbonTab)
            //        rectangles.AddRange(Util.GetVisualTreeChildrenByType((RibbonTab)tab, typeof(System.Windows.Shapes.Rectangle)));
            //    //rectangles.AddRange(Util.GetLogicalTreeChildrenByType((RibbonTab)tab, typeof(System.Windows.Shapes.Rectangle)));
            //}
            ////Debug.Assert(rectangles.Count() > 0);
            //foreach (var rectangle in rectangles)
            //{
            //    (rectangle as System.Windows.Shapes.Rectangle).Fill = Brushes.Transparent;
            //    (rectangle as System.Windows.Shapes.Rectangle).Fill = SystemColors.WindowBrush;
            //}
        }

        void Editor_KeyDown(object sender, KeyEventArgs e)
        {
        }

        static public Editor Create(Uri uri, SearchResult result)
        {
            var editor = Create(uri);
            //SPEC: 既に開いてあるドキュメントを何度開き直しても同じ結果
            editor.RichTextBox.CaretPosition = editor.RichTextBox.Document.ContentStart;
            editor.FindWord(result.FoundPhrase, result.FoundPhraseNumber);
            return editor;
        }

        static public Editor Create(Uri uri)
        {
            Editor editor;

            if (App.Instance.EditorWindows.ContainsKey(uri))
            {
                editor = App.Instance.EditorWindows[uri];
                editor.Activate();
            }
            else
            {
                editor = Create();
                editor.LoadDocument(uri);
            }

            return editor;
        }

        static public Editor Create()
        {
            return new Editor();
        }

        public void LoadDocument(Uri uri)
        {
            this.Title = Path.GetFileName(uri.LocalPath);

            this.RichTextBox.IsOnTextChangedEnabled = false;
            this.RichTextBox.Document.Blocks.Clear();
            //this.RichTextBox.Document.Language = System.Windows.Markup.XmlLanguage.GetLanguage("ja-jp");
            //Debug.Assert(this.RichTextBox.Document.Language.IetfLanguageTag == "ja-jp");
            using (this.RichTextBox.DeclareChangeBlock())
            {
                try
                {
                    using (var stream = new FileStream(uri.LocalPath, FileMode.Open, FileAccess.Read, FileShare.Read))
                    {
                        Util.ContentRangeOf(this.RichTextBox.Document).Load(stream, DataFormats.Rtf);

                        // 正しく読み込めた時だけ管理下に置く
                        this.DocumentUri = uri;

                        lock (App.Instance.EditorWindows)
                            lock (App.Instance.UntitledEditorWindows)
                            {
                                if (App.Instance.UntitledEditorWindows.Contains(this))
                                    App.Instance.UntitledEditorWindows.Remove(this);
                                App.Instance.EditorWindows[uri] = this;
                            }
                        this.managed = new FileInfo(uri.LocalPath);

                        //HACK: Hyperlinkを修復
                        //for (var pointer = this.RichTextBox.Document.ContentEnd; pointer != null && this.RichTextBox.Document.ContentStart.CompareTo(pointer) <= 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Backward))
                        var pointer = this.RichTextBox.Document.ContentStart;
                        while (pointer != null && pointer.CompareTo(this.RichTextBox.Document.ContentEnd) <= 0)
                        {
                            if ((pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.ElementStart)
                                && pointer.Parent is Hyperlink)
                            {
                                var link = (Hyperlink)pointer.Parent;
                                var range = Util.ContentRangeOf(link);
                                range.ClearAllProperties();
                                var newLink = CreateHyperlinkAt(range);

                                pointer = newLink.ElementEnd.GetNextContextPosition(LogicalDirection.Forward);
                            }
                            else
                            {
                                pointer = pointer.GetNextContextPosition(LogicalDirection.Forward);
                            }
                        }
                    }
                }
                catch (IOException ex)
                {
                    Util.p(ex);
                }
            }
            this.RichTextBox.IsOnTextChangedEnabled = true;
        }

        void RichTextBox_PreviewMouseDown(object sender, MouseButtonEventArgs e)
        {
        }

        void Editor_Closed(object sender, EventArgs e)
        {
            //FIXME: 未保存の場合だけSave()
            //lock (this.RichTextBox)
            //{
            //    Save(this.RichTextBox.Document);
            //}
            lock (App.Instance.UntitledEditorWindows)
            {
                if (App.Instance.UntitledEditorWindows.Contains(this))
                    App.Instance.UntitledEditorWindows.Remove(this);
            }
            lock (App.Instance.EditorWindows)
            {
                if (this.DocumentUri != null && App.Instance.EditorWindows.ContainsKey(this.DocumentUri))
                    App.Instance.EditorWindows.Remove(this.DocumentUri);
            }
        }

        void Editor_PreviewMouseMove(object sender, MouseEventArgs e)
        {
            this.Cursor = null;
            this.ForceCursor = false;
        }

        void Window_Loaded(object sender, RoutedEventArgs e)
        {
            //FIXME: 画像を追加すると以降のTextIndex→Pointer計算(GetRangeByTextIndex)がずれる
            //{
            //    var bitmap = new BitmapImage(new Uri(Path.Combine(new[] { basepath, "20130810232209.jpg" })));
            //    var image = new Image() { Source = bitmap, };
            //    image.MaxWidth = bitmap.PixelWidth / this.Ppi.Width;
            //    image.MaxHeight = bitmap.PixelHeight / this.Ppi.Height;
            //    InsertImage(image, this.RichTextBox.CaretPosition);
            //}

            this.RichTextBox.Focus();
        }

        void Editor_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            Debug.WriteLine(new { e.Key }, this.GetType().Name + ".Editor_PreviewKeyDown");

            var modifiers = e.KeyboardDevice.Modifiers;

            switch (e.Key)
            {
                case Key.Escape:
                    if (this.Popup.IsOpen)
                    {
                        e.Handled = true;
                        this.Popup.IsOpen = false;
                        this.CompletionRangePopup.IsOpen = false;
                        this.ListBox.Items.Filter = null;
                        this.RichTextBox.Focus();
                    }
                    else
                    {
                        e.Handled = true;
                        this.Close();
                    }
                    break;

                case Key.F1:
                    if (modifiers == ModifierKeys.Control)
                    {
                        e.Handled = true;

                        if (this.Ribbon.IsCollapsed)
                        {
                            this.Ribbon.IsCollapsed = false;
                            this.Ribbon.IsMinimized = true;
                            this.Ribbon.IsDropDownOpen = false;
                        }
                        else if (this.Ribbon.IsMinimized)
                        {
                            this.Ribbon.IsCollapsed = false;
                            this.Ribbon.IsMinimized = false;
                            this.Ribbon.IsDropDownOpen = false;
                        }
                        else
                        {
                            this.Ribbon.IsCollapsed = true;
                            this.Ribbon.IsMinimized = true;
                            this.Ribbon.IsDropDownOpen = false;
                        }

                        this.Ribbon.Focus();
                    }
                    break;

                case Key.F3:
                    switch (modifiers)
                    {
                        case ModifierKeys.None:
                            if (this.SearchString.Length > 0)
                            {
                                e.Handled = true;
                                FindNext(this.SearchString, LogicalDirection.Forward);
                            }
                            break;

                        case ModifierKeys.Shift:
                            if (this.SearchString.Length > 0)
                            {
                                e.Handled = true;
                                FindNext(this.SearchString, LogicalDirection.Backward);
                            }
                            break;

                        default:
                            break;
                    }
                    break;

                case Key.W:
                    if (modifiers == ModifierKeys.Control)
                    {
                        e.Handled = true;
                        this.Close();
                    }
                    break;

                default:
                    break;
            }
        }

        void Popup_Opened(object sender, EventArgs e)
        {
            var c = (Popup)sender;
            var listbox = (ListBox)c.Child;
            listbox.SelectedIndex = -1;
            //listbox.Focus();
        }

        //FIXME: ListBox -> AutoompleteBox
        void ListBox_KeyDown(object sender, KeyEventArgs e)
        {
            var c = (ListBox)sender;

            if (e.Key == Key.Return)
            {
                //Debug.Assert(!this.RichTextBox.Selection.IsEmpty);

                // Insert completion word, advance caret position
                var word = ((ListBoxItem)c.SelectedItem).Content as string;
                //var isEmpty = this.RichTextBox.Selection.IsEmpty;

                this.RichTextBox.IsOnTextChangedEnabled = false;
                using (this.RichTextBox.DeclareChangeBlock())
                {
                    {
                        //var selection = RemoveHyperlink(this.RichTextBox.Selection, this.RichTextBox.Selection);
                        var selection = RemoveHyperlink(this.CompletionRange, this.CompletionRange);
                        this.RichTextBox.Selection.Select(selection.Start, selection.End);
                    }

                    //this.RichTextBox.Selection.Text = word;
                    this.CompletionRange.Text = word;

                    //CreateHyperlinkAt(this.RichTextBox.Selection);
                    CreateHyperlinkAt(this.CompletionRange);

                    {
                        var position = this.RichTextBox.CaretPosition;
                        this.RichTextBox.Selection.Select(position, position);
                    }

                    //if (isEmpty)
                    //    this.RichTextBox.CaretPosition = this.RichTextBox.Selection.End;
                }
                this.RichTextBox.IsOnTextChangedEnabled = true;

                this.Popup.IsOpen = false;
                this.CompletionRangePopup.IsOpen = false;
                this.ListBox.Items.Filter = null;
                this.RichTextBox.Focus();
            }
            //else if (e.Key == Key.Escape)
            //{
            //    this.Popup.IsOpen = false;
            //    this.ListBox.Items.Filter = null;
            //    this.RichTextBox.Focus();
            //}
        }

        void pasteCommand_Executed(object sender, ExecutedRoutedEventArgs e) { }    //HACK: PreviewExecutedを発生させるため
        void pasteCommand_PreviewExecuted(object sender, ExecutedRoutedEventArgs e)
        {
            var c = (RichTextBoxEx)sender;

            if (Clipboard.ContainsText(TextDataFormat.Text))
            {
                Debug.WriteLine("Paste");
                e.Handled = true;

                TextRange range;
                {
                    var selection = this.RichTextBox.Selection;
                    TextPointer start, end;
                    var isEmpty = selection.IsEmpty;

                    selection.Text = Clipboard.GetText();

                    start = selection.Start;
                    end = selection.End;

                    if (isEmpty)
                        selection.Select(selection.End, selection.End);

                    range = new TextRange(start, end);
                }

                {
                    // http:
                    var match = Regex.Match(Util.TextOf(range), @"(?<=\s|\n|^)(?<target>https?://\S*?)", RegexOptions.IgnoreCase | RegexOptions.Multiline | RegexOptions.RightToLeft);  // 右から左へ探索するのはリンク化でマッチ位置がずれてもいいようにするため
                    while (match.Groups["target"].Success)
                    {
                        var group = match.Groups["target"];
                        var target = group.Value;
                        {
                            //var linkTo = target;
                            //var linkRange = new TextRange(Util.GetTextPointerByIndex(group.Index, range, LogicalDirection.Forward), Util.GetTextPointerByIndex(group.Index + group.Length, range, LogicalDirection.Backward));
                            var linkRange = new TextRange(Util.GetTextPointerByIndex2(group.Index, c.Document, LogicalDirection.Forward), Util.GetTextPointerByIndex2(group.Index + group.Length, c.Document, LogicalDirection.Backward));
                            c.IsOnTextChangedEnabled = false;
                            using (c.DeclareChangeBlock())
                            {
                                var selection = RemoveHyperlink(linkRange, c.Selection);
                                selection.Select(selection.Start, selection.End);

                                CreateHyperlinkAt(linkRange);
                            }
                            c.IsOnTextChangedEnabled = true;
                        }

                        match = match.NextMatch();
                    }
                }
            }
        }

        [Conditional("DEBUG")]
        void t_Editor()
        {
            var doc = new FlowDocument();
            doc.Name = "Untitled";
            doc.Blocks.AddRange(new[]{
                    new Paragraph(new Run("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ^")),
                });
            var range = new TextRange(doc.ContentStart, doc.ContentEnd);

            {
                var text = Util.TextOf(range);
                var r1 = Util.TextOf(range);
                Debug.Assert(r1 == text);
            }
            {
                //var r1 = Util.GetTextPointerByIndex(0, range, LogicalDirection.Forward);
                //var r2 = Util.GetTextPointerByIndex(0, range, LogicalDirection.Forward);
                //var r3 = Util.GetTextPointerByIndex(0, range, LogicalDirection.Forward, new[] { new Tuple<TextPointer, int?>(range.Start, 0) });
                //Debug.Assert(r1 != null); Debug.Assert(r2 != null); Debug.Assert(r3 != null);
                //eq(r1, r2, r3);
            }
            {
                //var lastidx = Util.TextOf(range).IndexOf("^");
                //var r1 = Util.GetTextPointerByIndex(lastidx, range, LogicalDirection.Forward);
                //var r2 = Util.GetTextPointerByIndex(lastidx, range, LogicalDirection.Forward, new[] { range.Start });
                //var r3 = Util.GetTextPointerByIndex(lastidx, range, LogicalDirection.Forward, new[] { new Tuple<TextPointer, int?>(range.Start, 0) });
                //Debug.Assert(r1 != null); Debug.Assert(r2 != null); Debug.Assert(r3 != null);
                //eq(r1, r2, r3);
            }
            //{
            //    //TODO:
            //    var lastidx = pointer.Text.IndexOf("^") + 1;
            //    var p1 = GetRangeByTextIndex(pointer, 0);
            //    var p2 = GetRangeByTextIndex(pointer, 0, pointer.End);
            //    var p3 = GetRangeByTextIndex(pointer, 0, new Tuple<TextPointer, int?>(pointer.End, lastidx));
            //    Debug.Assert(p1 != null); Debug.Assert(p2 != null); Debug.Assert(p3 != null);
            //    eq(p1, p2, p3);
            //}
            {
                //// test eq, neq
                //var r1 = Util.GetTextPointerByIndex(0, range, LogicalDirection.Forward);
                //var r2 = Util.GetTextPointerByIndex(1, range, LogicalDirection.Forward);
                //var r3 = Util.GetTextPointerByIndex(2, range, LogicalDirection.Forward);
                //eq(r1, r1);
                //eq(r1, r1, r1);
                //neq(r1, r2);
                //neq(r1, r1, r2);
                //neq(r1, r2, r1);
                //neq(r2, r1, r1);
                //neq(r1, r2, r3);
                //neq(r2, r3, r1);
                //neq(r3, r1, r2);
            }

            {
                var r1 = Util.GetTextPointerByIndex2(0, doc, LogicalDirection.Forward);
                var r2 = Util.GetTextPointerByIndex2(0, doc, LogicalDirection.Forward);
                Debug.Assert(r1 != null); Debug.Assert(r2 != null);
                eq(r1, r2);
            }
            {
                // test eq, neq
                var r1 = Util.GetTextPointerByIndex2(0, doc, LogicalDirection.Forward);
                var r2 = Util.GetTextPointerByIndex2(1, doc, LogicalDirection.Forward);
                var r3 = Util.GetTextPointerByIndex2(2, doc, LogicalDirection.Forward);
                eq(r1, r1);
                eq(r1, r1, r1);
                neq(r1, r2);
                neq(r1, r1, r2);
                neq(r1, r2, r1);
                neq(r2, r1, r1);
                neq(r1, r2, r3);
                neq(r2, r3, r1);
                neq(r3, r1, r2);
            }

        }

        #region Testing methods
        [Conditional("DEBUG")]
        static void eq(TextPointer p1, TextPointer p2)
        {
            Debug.Assert(p1.CompareTo(p2) == 0);
        }

        [Conditional("DEBUG")]
        static void eq(TextPointer p1, TextPointer p2, TextPointer p3)
        {
            eq(p1, p2);
            eq(p1, p3);
        }

        [Conditional("DEBUG")]
        static void neq(TextPointer p1, TextPointer p2)
        {
            Debug.Assert(!(p1.CompareTo(p2) == 0));
        }

        [Conditional("DEBUG")]
        static void neq(TextPointer p1, TextPointer p2, TextPointer p3)
        {
            Debug.Assert(!(p1.CompareTo(p2) == 0 && p1.CompareTo(p3) == 0));
        }

        [Conditional("DEBUG")]
        static void eq(TextRange r1, TextRange r2)
        {
            Debug.Assert(r1.Start.CompareTo(r2.Start) == 0 && r1.End.CompareTo(r2.End) == 0);
        }

        [Conditional("DEBUG")]
        static void eq(TextRange r1, TextRange r2, TextRange r3)
        {
            eq(r1, r2);
            eq(r1, r3);
        }

        [Conditional("DEBUG")]
        static void neq(TextRange r1, TextRange r2)
        {
            Debug.Assert(!(r1.Start.CompareTo(r2.Start) == 0 && r1.End.CompareTo(r2.End) == 0));
        }

        [Conditional("DEBUG")]
        static void neq(TextRange r1, TextRange r2, TextRange r3)
        {
            Debug.Assert(
                !(r1.Start.CompareTo(r2.Start) == 0 && r1.End.CompareTo(r2.End) == 0)
                || !(r1.Start.CompareTo(r3.Start) == 0 && r1.End.CompareTo(r3.End) == 0)
            );
        }
        #endregion

        Hyperlink FindHyperlinkFrom(TextElement from)
        {
            if (from == null)
                return null;
            else if (from.Parent is Hyperlink)
                return (Hyperlink)from.Parent;
            else
                return FindHyperlinkFrom((TextElement)from.Parent);
        }

        void InsertImage(Image image, TextPointer pointer)
        {
            var container = new BlockUIContainer(image);
            try
            {
                var floater = new Floater(container, pointer);
            }
            catch (InvalidOperationException ex)
            {
                // 例えばHyperlinkの中に画像を埋め込もうとしたとき
                //TODO: ユーザーに伝えるか、追加できる位置を見つけて追加。
                Util.p(ex);
            }
            catch (Exception ex)
            {
                Util.p(ex);
                EventLog.WriteEntry(ex.Source, ex.Message);
            }
        }

        /// <summary>
        /// 範囲内にあるHyperlinkを全て削除
        /// </summary>
        /// <param name="pointer"></param>
        /// <param name="caretSelection"></param>
        /// <returns>削除後のカーソル位置</returns>
        TextRange RemoveHyperlink(TextRange at, TextRange caretSelection)
        {
            //TODO: 見直し

            Debug.Assert(at.Start.CompareTo(at.End) <= 0);

            // Remark caret position
            Run run1;
            int pos1;
            if (caretSelection.Start.Parent is Run)
            {
                run1 = (Run)caretSelection.Start.Parent;
                pos1 = run1.ElementStart.GetOffsetToPosition(caretSelection.Start);
            }
            else
            {
                //HACK: Hyperlink直前で改段落したときなどに対処
                run1 = new Run("", caretSelection.Start);
                pos1 = run1.ElementStart.GetOffsetToPosition(caretSelection.Start);
            }

            Run run2;
            int pos2;
            if (caretSelection.End.Parent is Run)
            {
                run2 = (Run)caretSelection.End.Parent;
                pos2 = run2.ElementStart.GetOffsetToPosition(caretSelection.End);
            }
            else
            {
                //HACK: Hyperlink直前で改段落したときなどに対処
                run2 = new Run("", caretSelection.End);
                pos2 = run2.ElementStart.GetOffsetToPosition(caretSelection.End);
            }

            // Move link contents, Remove Hyperlink
            //for (var pointer = pointer.Start; pointer.CompareTo(pointer.End) < 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            for (var pointer = at.Start; pointer != null && pointer.CompareTo(at.End) <= 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                if (pointer.Parent is Run)
                {
                    var run = (Run)pointer.Parent;
                    if (run != null && run.Parent is Hyperlink)
                    {
                        try
                        {
                            var link = (Hyperlink)run.Parent;
                            foreach (var inline in link.Inlines.ToArray())
                            {
                                link.Inlines.Remove(inline);
                                link.SiblingInlines.InsertBefore(link, inline);    // 再処理しないように走査方向とは逆の方に挿入
                            }
                            link.SiblingInlines.Remove(link);
                        }
                        catch (NullReferenceException ex)
                        {
                            Util.p(ex);
                        }
                    }
                }
            }

            // Preserve caret position
            Debug.Assert(run1 != null && run2 != null);
            TextRange newRange = new TextRange(run1.ElementStart.GetPositionAtOffset(pos1), run2.ElementStart.GetPositionAtOffset(pos2));

            return newRange;
        }

        void Hyperlink_Click(object sender, RoutedEventArgs e)
        {
            var c = (Hyperlink)sender;

            var uri = LinkTargetToNavigateUri(Util.ContentRangeOf(c).Text);

            Debug.WriteLine(new { uri }, "Hyperlink_Click");
            if (uri == null)
            {
                //TODO: ユーザーに通知「リンク先が存在しない」
                return;
            }
            else if (uri.IsFile || uri.IsUnc)
            {
                e.Handled = true;
                if (File.Exists(uri.LocalPath))
                {
                    try
                    {
                        var path = uri.LocalPath;
                        if (path.LastIndexOf(".join.rtf") == (path.Length - ".join.rtf".Length - 1) + 1)
                        {
                            // inner link

                            // 再びこのウィンドウがアクティブになってしまうのを防ぐため、このイベントが終わってから新ウィンドウ生成・アクティブ化。
                            this.Dispatcher.BeginInvoke(new Action(() =>
                            {
                                var editor = Editor.Create(uri);
                                //editor.Owner = Application.Current.MainWindow;
                                editor.Show();
                                //editor.Activate();
                            }));

                        }
                        else
                        {
                            // interlink
                            var process = new Process();
                            process.StartInfo.FileName = uri.LocalPath;
                            process.StartInfo.UseShellExecute = true;
                            process.StartInfo.ErrorDialog = true;
                            process.Start();
                        }
                    }
                    catch (FileNotFoundException ex)
                    {
                        Util.p(ex);
                    }
                    catch (Exception ex)
                    {
                        Util.p(ex);
                        EventLog.WriteEntry(ex.Source, ex.Message);
                    }
                }
                else
                {
                    // dangling link

                    // 再びこのウィンドウがアクティブになってしまうのを防ぐため、このイベントが終わってから新ウィンドウ生成・アクティブ化。
                    this.Dispatcher.BeginInvoke(new Action(() =>
                    {
                        var editor = Editor.Create();
                        editor.Owner = this.Owner;

                        editor.RichTextBox.IsOnTextChangedEnabled = false;
                        using (editor.RichTextBox.DeclareChangeBlock())
                        {
                            var blocks = editor.RichTextBox.Document.Blocks;
                            if (blocks.FirstBlock != null)
                                blocks.InsertBefore(blocks.FirstBlock, new Paragraph(new Run(Path.GetFileName(uri.LocalPath).Replace(".join.rtf", ""))));
                            else
                                blocks.Add(new Paragraph(new Run(Path.GetFileName(uri.LocalPath).Replace(".join.rtf", ""))));
                        }
                        editor.RichTextBox.IsOnTextChangedEnabled = true;

                        editor.Show();
                        //editor.Activate();
                    }));
                }
            }
            else if (uri.IsAbsoluteUri)
            {
                Process.Start(uri.ToString());
            }
        }

        void Hyperlink_MouseDown(object sender, MouseButtonEventArgs e)
        {
            var c = (Hyperlink)sender;

            c.DoClick();
        }

        void Hyperlink_MouseUp(object sender, MouseButtonEventArgs e)
        {
        }

        public Uri LinkTargetToNavigateUri(string target)
        {
            Uri uri;

            if (Uri.TryCreate(target, UriKind.Absolute, out uri))
            {
                return uri;
            }
            else
            {
                //if (linkTargets.ContainsKey(target))
                {
                    // Danglink Linkもここで作る。
                    //FIXME: linkTargetsはあまり必要じゃない。対応する拡張子を複数にするなら必要。
                    //TODO: linkTargetsの更新が必要。
                    var path = Path.Combine(new[] { App.DocumentPath.FullName, linkTargets.ContainsKey(target)
                        ? linkTargets[target]
                        : Path.Combine(new[] {
                            App.DocumentPath.FullName,
                            Regex.Replace(target, "[" + Regex.Escape(string.Join("", Path.GetInvalidFileNameChars())) + "]", "-", RegexOptions.Singleline),
                        }) + ".join.rtf" });

                    if (Uri.TryCreate(path, UriKind.Absolute, out uri))
                    {
                        Debug.WriteLine(new { uri }, "LinkTargetToNavigateUri");
                        return uri;
                    }
                    else
                        return null;
                }
                //else
                //{
                //    return null;
                //}
            }
        }

        //public Hyperlink CreateHyperlinkAt(TextRange range)
        //{
        //    var linkTo = LinkTargetToNavigateUri(range.Text);
        //    return (linkTo == null) ? null : CreateHyperlinkAt(range, linkTo);
        //}

        public Hyperlink CreateHyperlinkAt(TextRange range)
        {
            Hyperlink link = null;

            try
            {
                Debug.WriteLine(new { range.Text }, "CreateHyperlinkAt");

                link = new Hyperlink(range.Start, range.End);
                {
                    //link.NavigateUri = linkTo;
                    link.NavigateUri = new Uri("about:blank");  //HACK: NavigateUriを設定しないと自動的に削除されてしまうため
                    link.ToolTip = range.Text;
                    link.Foreground = this.RichTextBox.Document.Foreground;
                    //link.Foreground = Brushes.Navy;
                    link.Cursor = Cursors.Hand;
                    //link.ForceCursor = true;
                    link.Focusable = false;
                    //link.Style = (Style)this.RichTextBox.Resources[typeof(Hyperlink)];
                    link.Click += new RoutedEventHandler(Hyperlink_Click);
                    link.MouseDown += new MouseButtonEventHandler(Hyperlink_MouseDown);
                    link.MouseUp += new MouseButtonEventHandler(Hyperlink_MouseUp);
                }
            }
            catch (InvalidOperationException ex)
            {
                Util.p(ex);
            }
            catch (Exception ex)
            {
                Util.p(ex);
                EventLog.WriteEntry(ex.Source, ex.Message);
            }

            Debug.Assert(link is Hyperlink || link == null);
            return link;
        }

        //private int _autoCompleteCount = 0;
        //private TextRange _selectionBeforeComplete = null;
        //private TextRange _selection = null;

        void RichTextBox_PreviewMouseMove(object sender, MouseEventArgs e)
        {
        }

        void RichTextBox_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            var c = (RichTextBoxEx)sender;

            Debug.WriteLine(new { }, "RichTextBox_PreviewKeyDown");

            this.Cursor = Cursors.None;
            this.ForceCursor = true;
            //textbox.IsReadOnly = false;
            //textbox.IsReadOnlyCaretVisible = true;

            if (e.Key == Key.Return && e.KeyboardDevice.Modifiers == ModifierKeys.None)
            {
                // break Hyperlink
                var range = this.RichTextBox.Selection;

                Debug.Assert(range is TextRange);
                var range_ = RemoveHyperlink(range, range);
                c.Selection.Select(range_.Start, range_.End);
            }
            else if (e.Key == Key.K && e.KeyboardDevice.Modifiers == ModifierKeys.Control)
            {
                // link
                c.IsOnTextChangedEnabled = false;

                using (c.DeclareChangeBlock())
                {
                    var selection = RemoveHyperlink(c.Selection, c.Selection);
                    c.Selection.Select(selection.Start, selection.End);
                    CreateHyperlinkAt(c.Selection);
                }

                c.IsOnTextChangedEnabled = true;
            }
            else if (e.Key == Key.Back && e.KeyboardDevice.Modifiers == ModifierKeys.None)
            {
                if (this.Popup.IsOpen && c.IsFocused)
                    SaveSelection();
            }
            else if (e.Key == Key.Space && e.KeyboardDevice.Modifiers.HasFlag(ModifierKeys.Control))
            {
                if (this.Popup.IsOpen)
                {
                    var paragraph = c.CaretPosition.Paragraph;
                    if (paragraph == null)
                    {
                    }
                    else
                    {
                        TextPointer currentPosition, end;
                        var range = this.CompletionRange;
                        if (range.Start.CompareTo(range.End) <= 0)
                        {
                            currentPosition = range.Start;
                            end = range.End;
                        }
                        else
                        {
                            currentPosition = range.End;
                            end = range.Start;
                        }

                        // 補完対象範囲は改行や段落境界を超えない
                        //this.CompletionRange.Select(currentPosition.GetPositionAtOffset(e.KeyboardDevice.Modifiers.HasFlag(ModifierKeys.Shift) ? +1 : -1), sel.CaretPosition);
                        var dir = e.KeyboardDevice.Modifiers.HasFlag(ModifierKeys.Shift) ? LogicalDirection.Forward : LogicalDirection.Backward;
                        TextPointer nextPosition = currentPosition;
                        {
                            var next = currentPosition.GetNextInsertionPosition(dir) ?? currentPosition;
                            for (var position = currentPosition; position != null && next.CompareTo(position) < 0; position = position.GetNextContextPosition(dir))
                            {
                                if (position.GetPointerContext(dir) == TextPointerContext.Text)
                                {
                                    nextPosition = next;
                                    break;
                                }
                            }
                        }

                        Debug.WriteLine(new { nextPosition.IsAtLineStartPosition });
                        //FIXME: CaretPositionよりもComplesionRangeの一端で
                        this.CompletionRange.Select(nextPosition, c.CaretPosition);
                        RenderCompletionRange();
                        UpdateCompletionList();
                    }
                }
                else
                {
                    {
                        // Adjust mask position displays the auto completion range
                        this.CompletionRange = new TextRange(c.Selection.Start, c.Selection.End);
                        //FIXME: Selectionを維持したい。
                        c.Selection.Select(c.Selection.End, c.Selection.End);
                        RenderCompletionRange();
                        UpdateCompletionList();
                    }

                    {
                        // Adjust Popup position
                        // TextPointerが必要なのでTextBox上では不可能。RichTextBoxでは可能。
                        var rect = this.RichTextBox.CaretPosition.GetCharacterRect(LogicalDirection.Backward);
                        this.Popup.Placement = PlacementMode.Relative;
                        this.Popup.PlacementTarget = this.RichTextBox;
                        rect.Offset(0, rect.Height);
                        this.Popup.PlacementRectangle = rect;
                    }

                    this.Popup.IsOpen = true;
                    this.CompletionRangePopup.IsOpen = true;
                    e.Handled = true;
                }
            }
            else if (e.Key == Key.F1)
            {
                //FIXME: remove
                // save
                var doc = c.Document;
                var range = new TextRange(doc.ContentStart, doc.ContentEnd);
                using (var fs = new FileStream(Path.Combine(Directory.GetCurrentDirectory(), "out.xaml"), FileMode.OpenOrCreate))
                {
                    range.Save(fs, DataFormats.Xaml, true);
                    fs.SetLength(fs.Position);
                }
                using (var fs = new FileStream(Path.Combine(Directory.GetCurrentDirectory(), "out.rtf"), FileMode.OpenOrCreate))
                {
                    range.Save(fs, DataFormats.Rtf, true);
                    fs.SetLength(fs.Position);
                }
                using (var fs = new FileStream(Path.Combine(Directory.GetCurrentDirectory(), "out.txt"), FileMode.OpenOrCreate))
                {
                    range.Save(fs, DataFormats.Text, true);
                    fs.SetLength(fs.Position);
                }
            }
            else if (e.Key == Key.Escape && e.KeyboardDevice.Modifiers.HasFlag(ModifierKeys.None))
            {
                if (this.Popup.IsOpen)
                {
                    // フォーカスはthis.PopupかRichTextBoxにあるので、両方でEscapeキーに反応する必要がある。
                    this.Popup.IsOpen = false;
                    this.CompletionRangePopup.IsOpen = false;
                    e.Handled = true;
                }
            }
            else if (e.Key == Key.Down && this.Popup.IsOpen)
            {
                this.ListBox.SelectedIndex = 0;
                this.ListBox.Focus();
                e.Handled = true;
            }
            else
            {
            }
        }

        void RenderCompletionRange()
        {
            var range = this.CompletionRange;

            var _pointer = CompletionRange.Start;
            this.CompletionRangeCanvas.Children.Clear();
            for (var pointer = CompletionRange.Start.GetNextInsertionPosition(LogicalDirection.Forward); pointer != null && pointer.CompareTo(range.End) <= 0; pointer = pointer.GetNextInsertionPosition(LogicalDirection.Forward))
            {
                var leftRect = _pointer.GetCharacterRect(LogicalDirection.Forward);
                var rightRect = pointer.GetCharacterRect(LogicalDirection.Backward);

                this.CompletionRangeCanvas.Children.Add(
                    new Shapes.Polygon()
                    {
                        Points = new PointCollection(new[] { rightRect.TopLeft, leftRect.TopRight, leftRect.BottomRight, rightRect.BottomLeft }),
                        Opacity = 0.25,
                        Fill = SystemColors.HighlightBrush,
                    });

                _pointer = pointer;
            }
        }

        void RichTextBox_KeyDown(object sender, KeyEventArgs e)
        {
            var c = (RichTextBoxEx)sender;

            Debug.WriteLine(new { }, "RichTextBox_KeyDown");

            if (e.Key == Key.Escape)
            {
                this.Popup.IsOpen = false;
                this.CompletionRangePopup.IsOpen = false;
                this.ListBox.Items.Filter = null;
                //this.RichTextBox.Focus();

                e.Handled = true;
            }
        }

        public bool Find(string phrase, LogicalDirection direction, bool bidirection)
        {
            var c = this.RichTextBox;

            if (Util.TextOf(c.Selection) == phrase)
            {
                return true;
            }
            else
            {
                c.Selection.Select(c.Selection.Start, c.Selection.Start);
                return FindNext(phrase, direction, bidirection);
            }
        }

        public bool Find(string phrase, LogicalDirection direction)
        {
            var c = this.RichTextBox;

            if (Util.TextOf(c.Selection) == phrase)
            {
                return true;
            }
            else
            {
                c.Selection.Select(c.Selection.Start, c.Selection.Start);
                return FindNext(phrase, direction);
            }
        }

        public bool FindNext(string phrase, LogicalDirection direction, bool bidirection)
        {
            var reverse = direction == LogicalDirection.Forward ? LogicalDirection.Backward : LogicalDirection.Forward;
            return (bidirection)
                ? FindNext(phrase, direction) || FindNext(phrase, reverse)
                : FindNext(phrase, direction);
        }

        public bool FindNext(string phrase, LogicalDirection direction)
        {
            var c = this.RichTextBox;
            var ret = false;

            //FIXME: rangeとtextのLengthが不整合
            var range = Util.ContentRangeOf(c.Document);
            var text = Util.TextOf(range);

            if (text.Length == 0)
                return ret;

            // 逆方向だと RegexOptions.RightToLeft, textbox.Selection.Start になる
            //FIXME: Searchと仕様を合わせて
            var query = Regex.Escape(phrase);

            Match match;

            if (direction == LogicalDirection.Forward)
            {
                var regex = new Regex(query, RegexOptions.IgnoreCase | RegexOptions.Multiline);
                var startat = Math.Min(Util.TextOf(range).Length - 1, Util.GetIndexByTextPointer(c.Selection.End, range));
                match = regex.Match(text, startat);
                //Debug.WriteLine(new { direction, index = Util.GetIndexByTextPointer(sel.Selection.End, range) });
            }
            else if (direction == LogicalDirection.Backward)
            {
                var regex = new Regex(query, RegexOptions.IgnoreCase | RegexOptions.Multiline | RegexOptions.RightToLeft);
                match = regex.Match(text, 0, Util.GetIndexByTextPointer(c.Selection.Start, range));
                //Debug.WriteLine(new { direction, index = Util.GetIndexByTextPointer(sel.Selection.Start, range) + 1 });
            }
            else
            {
                Debug.Fail("");
                match = null;
            }

            if (match.Success)
            {
                //var currentPosition = Util.GetTextPointerByIndex(range.Index, range, LogicalDirection.Forward, new Tuple<TextPointer, int?>[] { });
                //var end = Util.GetTextPointerByIndex(range.Index + range.Length, range, LogicalDirection.Backward, new Tuple<TextPointer, int?>[] { });
                var start = Util.GetTextPointerByIndex2(match.Index, c.Document, LogicalDirection.Forward);
                var end = Util.GetTextPointerByIndex2(match.Index + match.Length, c.Document, LogicalDirection.Backward);

                if (start != null && end != null)
                {
                    ret = true;
                    //FIXME: UIElementを使っているのでControllerへ
                    c.Selection.Select(start, end);
                }
            }
            else
            {
                ret = false;
                //FIXME: UIElementを使っているのでControllerへ
                c.Selection.Select(c.CaretPosition, c.CaretPosition);
            }

            return ret;
        }

        public bool FindWord(string word)
        {
            return FindWord(word, 1);
        }

        public bool FindWord(string word, int ordinal)
        {
            var c = this.RichTextBox;
            var ret = false;

            if (ordinal <= 0)
                return ret;

            //getTextPointerByIndexMemo.Clear();

            //FIXME: rangeとtextのLengthが不整合
            var range = Util.ContentRangeOf(c.Document);
            var text = Util.TextOf(range);

            if (text.Length == 0)
                return ret;

            // 逆方向だと RegexOptions.RightToLeft, textbox.Selection.Start になる
            //FIXME: Searchと仕様を合わせて
            var query = Regex.Escape(word);
            var regex = new Regex(query, RegexOptions.IgnoreCase | RegexOptions.Multiline);
            var startat = Math.Min(Util.TextOf(range).Length - 1, Util.GetIndexByTextPointer(c.Selection.End, range));
            var matches = regex.Matches(text, startat);

            if (matches.Count >= ordinal && matches[ordinal - 1].Success)
            {
                var match = matches[ordinal - 1];
                //FIXME: 検索語の間で包含関係があると正しく探せない。
                //var count = ordinal;
                //var origin = new Tuple<TextPointer, int?>(null, null);
                {
                    //var currentPosition = Util.GetTextPointerByIndex(range.Index, range, LogicalDirection.Forward, new Tuple<TextPointer, int?>[] { });
                    //var end = Util.GetTextPointerByIndex(range.Index + range.Length, range, LogicalDirection.Backward, new Tuple<TextPointer, int?>[] { });
                    var start = Util.GetTextPointerByIndex2(match.Index, c.Document, LogicalDirection.Forward);
                    var end = Util.GetTextPointerByIndex2(match.Index + match.Length, c.Document, LogicalDirection.Backward);

                    //TODO: 仕様について
                    //if (currentPosition == null || end == null)
                    //    break;

                    if (start != null && end != null)
                    {
                        ret = true;
                        c.Selection.Select(start, end);
                    }

                    //count--;
                    //origin = new Tuple<TextPointer, int?>(currentPosition, range.Index);
                    //origin = new Tuple<TextPointer, int?>(end, range.Index + range.Length);
                    //range = range.NextMatch();
                }
            }
            else
            {
                //MessageBox.Show("この方向に\"" + regex.ToString() + "\"は見つかりません");
            }

            return ret;
        }

        void RichTextBox_LostFocus(object sender, RoutedEventArgs e)
        {
            var c = (RichTextBox)sender;

            //if (this._selection != null)
            //{
            //    // Retrieve selection
            //    sel.Selection.Select(this._selection.Start, this._selection.End);
            //    this._selection = null;
            //}
        }

        private bool _imeActive = false;
        void OnPreviewTextInput(object sender, TextCompositionEventArgs e)
        {
            this._imeActive = false;

            //if (this.Popup.IsOpen && this.RichTextBox.IsFocused && this._selection == null)
            //    SaveSelection();

            var _compositionText = e.TextComposition.CompositionText;
            Debug.WriteLine(new { _compositionText }, "OnPreviewTextInput");
        }
        void OnPreviewTextInputStart(object sender, TextCompositionEventArgs e)
        {
            this._imeActive = true;

            //if (this.Popup.IsOpen && this.RichTextBox.IsFocused && this._selection == null)
            //    SaveSelection();

            var _compositionText = e.TextComposition.CompositionText;
            Debug.WriteLine(new { _compositionText }, "OnPreviewTextInputStart");
        }
        void OnPreviewTextInputUpdate(object sender, TextCompositionEventArgs e)
        {
            this._imeActive = true;

            //if (this.Popup.IsOpen && this.RichTextBox.IsFocused && this._selection == null)
            //    SaveSelection();

            var _compositionText = e.TextComposition.CompositionText;
            Debug.WriteLine(new { _compositionText }, "OnPreviewTextInputUpdate");
        }
        //void OnPreviewTextInput(object sender, TextCompositionEventArgs e) { this._imeActive = false; /* this._compositionText = e.TextComposition.CompositionText; Debug.WriteLine(new { this._compositionText }); */ }
        //void OnPreviewTextInputStart(object sender, TextCompositionEventArgs e) { this._imeActive = true; /* this._compositionText = e.TextComposition.CompositionText; Debug.WriteLine(new { this._compositionText }); */ }
        //void OnPreviewTextInputUpdate(object sender, TextCompositionEventArgs e) { this._imeActive = true; /* this._compositionText = e.TextComposition.CompositionText; Debug.WriteLine(new { this._compositionText }); */ }

        //FIXME: IMEオンのときはTextChangedの後に呼ばれる
        void RichTextBox_PreviewTextInput(object sender, TextCompositionEventArgs e)
        {
            Debug.WriteLine(new { e.Text, e.TextComposition.CompositionText, Device = e.Device.GetType().Name }, "RichTextBox_PreviewTextInput");

            var c = (RichTextBoxEx)sender;

            //if (this.Popup.IsOpen && sel.IsFocused)
            //    SaveSelection();
        }

        static internal class DebugInfo
        {
            static internal void WriteDebugInfo()
            {
                Util.p("[" + DateTime.Now.ToString() + "]");
                Debug.Indent();
                Util.p(DebugInfo.rtb_Selection, "Selection");
                Util.p(DebugInfo.rtb_CaretPositionOffset, "CaretPositionOffset");
                Util.p(DebugInfo.rtb_PointerContextForward.GetType().Name, "PointerContextForward");
                Util.p(DebugInfo.rtb_PointerContextBackward.GetType().Name, "PointerContextBackward");
                Util.p(DebugInfo.rtb_PointerParentType.Name, "PointerParentType");
                Util.p(DebugInfo.rtb_PointerParentString, "PointerParentString");
                Util.p(DebugInfo.rtb_PointerParentText, "PointerParentText");
                Debug.Unindent();
            }

            static internal TextRange rtb_Selection;
            static internal int rtb_CaretPositionOffset;
            static internal TextPointerContext rtb_PointerContextForward;
            static internal TextPointerContext rtb_PointerContextBackward;
            static internal Type rtb_PointerParentType;
            static internal string rtb_PointerParentString;
            static internal string rtb_PointerParentText;
        }

        void UpdateDebugInfo()
        {
            DebugInfo.rtb_Selection = this.RichTextBox.Selection;
            DebugInfo.rtb_CaretPositionOffset = this.RichTextBox.Document.ContentStart.GetOffsetToPosition(this.RichTextBox.CaretPosition);
            DebugInfo.rtb_PointerContextForward = this.RichTextBox.CaretPosition.GetPointerContext(LogicalDirection.Forward);
            DebugInfo.rtb_PointerContextBackward = this.RichTextBox.CaretPosition.GetPointerContext(LogicalDirection.Backward);
            DebugInfo.rtb_PointerParentString = this.RichTextBox.CaretPosition.Parent.ToString();
            DebugInfo.rtb_PointerParentType = this.RichTextBox.CaretPosition.Parent.GetType();

            if (DebugInfo.rtb_PointerParentType == typeof(Run))
                DebugInfo.rtb_PointerParentText = ((Run)this.RichTextBox.CaretPosition.Parent).Text;
        }

        // RichTextBox.Selectionの退避処理中にも呼ばれる。そのときはSelection.IsEmpty
        void RichTextBox_SelectionChanged(object sender, RoutedEventArgs e)
        {
            var c = (RichTextBoxEx)sender;

            Debug.WriteLine(new { this.Popup.IsOpen, this.IsTextChanged, this.RichTextBox.CaretPosition.IsAtInsertionPosition }, "RichTextBox_SelectionChanged");

            UpdateDebugInfo();
            DebugInfo.WriteDebugInfo();

            // カーソルが動いたか…this.RichTextBox.CaretPositionが更新されてから判定したいので、PreviewKeyDownではなくKeyDownで判定する必要がある。
            if (this.Popup.IsOpen)
            {
                if (!this.IsTextChanged)
                {
                    //FIXME: このブロックを SwitchCompletionMode(false) に置き換え
                    this.Popup.IsOpen = false;
                    this.CompletionRangePopup.IsOpen = false;
                    this.ListBox.Items.Filter = null;
                }
                this.IsTextChanged = false;
                e.Handled = true;
            }


            //if (sel.Selection.IsEmpty && !this._imeActive)
            //{
            //    this.Popup.IsOpen = false;
            //}

            //if (this.Popup.IsOpen)
            //{
            //}

            //if (sel.Selection.IsEmpty)
            //{
            //    this.Popup.IsOpen = false;
            //}
            //else
            //{
            //    Debug.WriteLine(new { autoCompleteHint = sel.Selection.Text }, "RichTextBox_TextChanged");
            //    Debug.Assert(!sel.Selection.IsEmpty, "IsEmpty");

            //    //FIXME: 前取り込み処理と競合
            //    //if (this.ListBox.Items.CanFilter)
            //    //    this.ListBox.Items.Filter = new Predicate<object>(_ => (_ as ListBoxItem ?? new ListBoxItem()).Content.ToString().IndexOf(sel.Selection.Text) >= 0);
            //}

            //FIXME: 前取り込み処理と競合
            //if (this.ListBox.Items.Count == 0)
            //{
            //    this.ListBox.Opacity = 0.25;
            //    this.ListBox.Items.Add(new ListBoxItem { Content = "_(:3｣ ∠)_" + new string(' ', 20) });
            //    //this.Popup.IsOpen = false;
            //    //this.ListBox.Items.Filter = null;
            //}
            //else
            //{
            //    this.ListBox.Opacity = 1.0;
            //}

        }

        bool IsTextChanged = false;
        void RichTextBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            Debug.WriteLine("");
            Debug.WriteLine(new { this._imeActive }, "RichTextBox_TextChanged");

            var c = (RichTextBoxEx)sender;

            ////FIXME: Selectionが解除される。退避したthis._selectionを生かせていない。
            //if (this._selection != null)
            //{
            //    // Retrieve selection
            //    //sel.Selection.Select(this._selection.Start, this._selection.End);
            //    sel.Selection.Select(this._selection.Start, sel.Selection.End); //HACK: sel.Selection.End: this._selection.Endだと位置がずれたりずれなかったりするので。
            //    Debug.WriteLine("Retreive Selection");
            //    this._selection = null;
            //}

            this.IsTextChanged = true;

            if (this._imeActive)
                return;

            //FIXME: IMEオフのときSelectionが解除されることがある？そういうときはCompletionRangeが空になっているかも知れない？
            //FIXME: UndoAction判定の中で。
            if (this.Popup.IsOpen)
            {
                Debug.Assert(this.CompletionRangePopup.IsOpen);

                Debug.WriteLine("CompletionRange.length: {0}", this.CompletionRange.Text.Length);

                this.CompletionRange.Select(this.CompletionRange.Start, c.CaretPosition);
                RenderCompletionRange();
                UpdateCompletionList();
            }

            if (e.UndoAction == UndoAction.Create || e.UndoAction == UndoAction.Merge
                || e.UndoAction == UndoAction.Undo || e.UndoAction == UndoAction.Redo)
            {
                //var addedRanges = e.Changes
                //    .Select(_ =>
                //    {
                //        var currentPosition = textbox.Document.ContentStart.GetPositionAtOffset(_.Offset, LogicalDirection.Forward);
                //        var end = currentPosition.GetPositionAtOffset(_.AddedLength, LogicalDirection.Forward);
                //        return new TextRange(currentPosition, end);
                //    })
                //    .Where(_ => !_.IsEmpty);

                var changedPositions = new List<TextPointer> { };
                {
                    var origin = c.Document.ContentStart;
                    foreach (var change in e.Changes)
                    {
                        changedPositions.Add(origin.GetPositionAtOffset(change.Offset, LogicalDirection.Forward));

                        if (change.AddedLength - change.RemovedLength > 0)
                            changedPositions.Add(origin.GetPositionAtOffset(change.Offset + change.AddedLength - change.RemovedLength, LogicalDirection.Forward));
                        // change.AddedLength - change.RemovedLength <= 0 のときは処理不要。
                    }
                    changedPositions = changedPositions.Distinct().ToList();
                }

                //foreach (var pointer in changedPositions)
                //{
                //    //SPEC: 既存リンクに文字を追加したとき、文字を削除したとき、範囲選択して文字追加（追加と削除を同時に実施）したときにリンク先を更新する
                //    if (pointer.GetPointerContext(LogicalDirection.Backward) == TextPointerContext.Text
                //        && pointer.Parent is TextElement)
                //    {
                //        var parent = pointer.Parent as TextElement;
                //        if (parent != null && parent.Parent is Hyperlink)
                //        {
                //            var link = (Hyperlink)parent.Parent;
                //            var uri = LinkTargetToNavigateUri(Util.ContentRangeOf(link).Text);
                //            if (link.NavigateUri != uri)
                //                link.NavigateUri = uri;
                //        }
                //    }
                //}
            }
            {
                var __files = new HashSet<string>(Directory.GetFileSystemEntries(App.DocumentPath.FullName, "*", SearchOption.AllDirectories));
                var __managed = this.managed != null ? new FileInfo(this.managed.FullName) : null;

                {
                    var filename = CreateFilenameFrom(c.Document, ".join.rtf");
                    var path = Path.Combine(App.DocumentPath.FullName, filename);
                    Debug.WriteLine(new { filename }, "RichTextBox_TextChanged");

                    if (this.managed != null && path == this.managed.FullName)
                    {
                        Debug.WriteLine("Save", "RichTextBox_TextChanged");
                        this.Title = Path.GetFileName(this.managed.Name);
                        Save(c.Document);
                    }
                    else
                    {
                        if (this.managed != null && this.managed.Exists)
                        {
                            if (Util.TextOf(Util.ContentRangeOf(c.Document)).Length == 0)
                            {
                                Debug.WriteLine("Delete:'" + this.managed.FullName + "'", "RichTextBox_TextChanged");
                                Debug.Assert(this.managed.FullName.IndexOf(App.DocumentPath.FullName) == 0);
                                this.managed.Delete();
                                this.managed = null;
                                this.Title = "";

                                lock (App.Instance.UntitledEditorWindows)
                                {
                                    if (App.Instance.UntitledEditorWindows.Contains(this))
                                        App.Instance.UntitledEditorWindows.Remove(this);
                                }
                                lock (App.Instance.EditorWindows)
                                {
                                    if (App.Instance.EditorWindows.ContainsKey(this.DocumentUri))
                                        App.Instance.EditorWindows.Remove(this.DocumentUri);
                                }
                            }
                            else
                            {
                                try
                                {
                                    Debug.WriteLine("Rename:'" + this.managed.Name + "' => '" + filename + "'", "RichTextBox_TextChanged");
                                    Debug.Assert(path.IndexOf(App.DocumentPath.FullName) == 0 && this.managed.FullName.IndexOf(App.DocumentPath.FullName) == 0);
                                    this.managed.MoveTo(path);
                                    Debug.Assert(this.managed.FullName == path);
                                    this.Title = Path.GetFileName(this.managed.Name);

                                    Save(c.Document);
                                }
                                catch (IOException ex)
                                {
                                    Util.p(ex);
                                }
                            }
                        }
                        else
                        {
                            this.managed = new FileInfo(path);
                            Debug.WriteLine("Create:'" + this.managed.Name + "'", "RichTextBox_TextChanged");
                            Debug.Assert(this.managed.FullName.IndexOf(App.DocumentPath.FullName) == 0);
                            this.Title = Path.GetFileName(this.managed.Name);

                            Save(c.Document);
                        }
                    }
                }

                {
                    // 対象外のファイルが消えていないこと
                    var prev = new HashSet<string>(__files);
                    if (__managed != null)
                        prev.Remove(__managed.FullName);

                    var files = new HashSet<string>(Directory.GetFileSystemEntries(App.DocumentPath.FullName, "*", SearchOption.AllDirectories));
                    Debug.Assert(files.IsSupersetOf(prev));
                }
            }
        }

        void SaveSelection()
        {
            var c = this.RichTextBox;

            ////FIXME: RichTextBox.Selectionが解除される…ここでのSelection退避が生かされていない
            //// Save selection
            //this._selection = new TextRange(sel.Selection.Start, sel.Selection.End);
            //sel.Selection.Select(sel.CaretPosition, sel.CaretPosition);
            //Debug.WriteLine("Save Selection");
        }

        private FileInfo managed = null;

        /// <summary>
        /// ドキュメントの1行目を元にして、ファイル名を生成
        /// </summary>
        string CreateFilenameFrom(FlowDocument document, string extension)
        {
            Debug.Assert(extension.Length > 0 ? extension[0] == '.' : true);
            Debug.Assert(App.DocumentPath.FullName.IndexOfAny(Path.GetInvalidPathChars()) < 0);
            Debug.WriteLine(new { text = Util.TextOf(Util.ContentRangeOf(document)), extension }, "CreateFilenameFrom");

            string filename = null;
            try
            {
                var firstBlock = document.Blocks.Where(_ => Util.TextOf(Util.ContentRangeOf(_)).Length > 0).FirstOrDefault();
                var text = (firstBlock is Block) ? Util.TextOf(Util.ContentRangeOf(firstBlock)) : DateTime.Now.ToString();
                //FIXME: 文字数制限。この後の番号部分と拡張子**とここには渡されていないディレクトリ**を含めて有効になるように。
                text = (text.Length > 150) ? text.Substring(0, 150) : text;

                Debug.WriteLine(new { firstline = text }, "CreateFilenameFrom");
                Debug.Assert(text is string && text.Length >= 0);

                for (var i = 0; ; i++)
                {
                    filename = ValidateFilename(text + (i > 0 ? " (" + i.ToString() + ")" : "") + extension);
                    if ((this.managed is FileInfo && filename == this.managed.Name) || !File.Exists(Path.Combine(App.DocumentPath.FullName, filename)))
                        break;
                }
            }
            catch (OverflowException ex)
            {
                Util.p(ex);
                EventLog.WriteEntry(ex.Source + ":" + Application.Current.MainWindow.Title, "Too many same filenames");
                throw;
            }

            {
                Debug.WriteLine(new { filename }, "CreateFilenameFrom");

                Debug.Assert(filename.IndexOfAny(Path.GetInvalidFileNameChars()) < 0);
                Debug.Assert(
                    (this.managed != null && filename == this.managed.Name)
                    || !File.Exists(Path.Combine(App.DocumentPath.FullName, filename)));
            }

            return filename;
        }

        static public string ValidateFilename(string filename)
        {
            return Regex.Replace(filename, "[" + Regex.Escape(string.Join("", Path.GetInvalidFileNameChars())) + "]", "-", RegexOptions.Singleline);
        }

        void Save(FlowDocument doc)
        {
            Save(Util.ContentRangeOf(doc));
        }

        void Save(TextRange range)
        {
            // save
            //doc.Language = System.Windows.Markup.XmlLanguage.GetLanguage("ja-jp");
            //Debug.Assert(doc.Language.IetfLanguageTag == "ja-jp");

            try
            {
                using (var fs = this.managed.Open(FileMode.OpenOrCreate, FileAccess.Write, FileShare.None))
                {
                    range.Save(fs, DataFormats.Rtf, true);

                    //HACK: ファイル末尾に余計な文字が残るので
                    fs.SetLength(fs.Position);

                    this.DocumentUri = new Uri(this.managed.FullName);
                    lock (App.Instance.UntitledEditorWindows)
                    {
                        if (App.Instance.UntitledEditorWindows.Contains(this))
                            App.Instance.UntitledEditorWindows.Remove(this);
                    }
                    lock (App.Instance.EditorWindows)
                    {
                        if (!App.Instance.EditorWindows.ContainsKey(this.DocumentUri))
                            App.Instance.EditorWindows[this.DocumentUri] = this;
                    }
                }
            }
            catch (IOException ex)
            {
                Util.p(ex);
            }
        }

        /// <remarks>ファイル保存時に実行するためのもの。</remarks>
        void UpdateBacklinkCache()
        {
            var doc = this.RichTextBox.Document;

            var nameLinksToNames = new Dictionary<string, HashSet<string>> { };
            var nameBacklinksToNames = new Dictionary<string, HashSet<string>> { };
            var localPath = GetLocalPathFrom(doc.Name);

            var linkTargets = new HashSet<string> { };
            for (var pointer = doc.ContentStart; pointer != null; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.ElementStart
                    && pointer.Parent is Hyperlink)
                {
                    var hyperlink = (Hyperlink)pointer.Parent;
                    if (hyperlink.NavigateUri != null)
                    {
                        var linkTargetName = GetDocumentNameFrom(hyperlink.NavigateUri);
                        linkTargets.Add(linkTargetName);
                    }
                }
            }

            // store link targets
            nameLinksToNames[doc.Name] = linkTargets;

            // store backlink targets
            foreach (var linkTarget in linkTargets)
            {
                if (linkTarget != null)
                {
                    if (!nameBacklinksToNames.ContainsKey(linkTarget))
                        nameBacklinksToNames[linkTarget] = new HashSet<string> { };
                    nameBacklinksToNames[linkTarget].Add(doc.Name);
                }
            }

        }

        string GetDocumentNameFrom(Uri uri)
        {
            return uri.IsFile ? Path.GetFileNameWithoutExtension(uri.LocalPath) : null;
        }

        string GetLocalPathFrom(string documentName)
        {
            return Path.ChangeExtension(Path.Combine(new[] { App.DocumentPath.FullName, documentName }), ".join.rtf");
        }

        void FlowDocument_DragEnter(object sender, DragEventArgs e)
        {
            Debug.WriteLine("FlowDocument_DragEnter");
        }

        void FlowDocument_DragOver(object sender, DragEventArgs e)
        {
            Debug.WriteLine("FlowDocument_DragOver");

            if (e.AllowedEffects.HasFlag(DragDropEffects.Copy)
                && (e.Data.GetDataPresent(DataFormats.FileDrop, true) || e.Data.GetDataPresent(DataFormats.MetafilePicture, true)))
            {
                e.Effects |= DragDropEffects.Copy;
                e.Handled = true;
            }
        }

        void FlowDocument_Drop(object sender, DragEventArgs e)
        {
            Debug.WriteLine("FlowDocument_Drop");

            var c = (FlowDocument)sender;
            //var textbox = (RichTextBoxEx)sel.Parent;
            //var window = (Editor)textbox.Parent;

            if (e.Data.GetDataPresent(DataFormats.Rtf))
            {
                return;
                //e.Effects = DragDropEffects.Move;
                //e.Handled = true;
                //var document = e.Data.GetData(DataFormats.Rtf, true) as FlowDocument;
                //if (document != null)
                //{
                //    try
                //    {
                //        this.RichTextBox.IsOnTextChangedEnabled = false;
                //        this.RichTextBox.Selection.Text = Util.TextOf(Util.ContentRangeOf(document));
                //        this.RichTextBox.IsOnTextChangedEnabled = true;
                //    }
                //    catch (NotSupportedException ex)
                //    {
                //        Util.p(ex);
                //    }
                //    catch (Exception ex)
                //    {
                //        Util.p(ex);
                //        EventLog.WriteEntry(ex.Source, ex.Message);
                //    }
                //}
            }
            if (e.Data.GetDataPresent(DataFormats.FileDrop, true))
            {
                e.Effects = DragDropEffects.Copy;
                e.Handled = true;
                var files = e.Data.GetData(DataFormats.FileDrop, true) as string[];
                Debug.WriteLine(new { files.Length }, "Drop");
                foreach (var f in files)
                {
                    Debug.WriteLine(new { f }, "Drop");
                    try
                    {
                        var bitmapimage = new BitmapImage(new Uri(f));
                        var image = new Image() { Source = bitmapimage };

                        //this.RichTextBox.IsOnTextChangedEnabled = false;
                        //TODO: CaretPositionではなくSelectionを置き換えたい。
                        //FIXME: IsOnTextChangedEnabledの操作ではなくTextChangedと同じ処理を呼び出して保存するように
                        this.InsertImage(image, this.RichTextBox.CaretPosition);
                        //this.RichTextBox.IsOnTextChangedEnabled = true;
                    }
                    catch (NotSupportedException ex)
                    {
                        Util.p(ex);
                        // BracketNameとして追加
                        //FIXME: BracketNameなので、ここでHyperlinkを作らなくていい。BracketName処理に任せる。
                        //TODO: 自動保存時の保存先と同じパスかサブディレクトリの場合は相対パスにしたい。
                        this.RichTextBox.IsOnTextChangedEnabled = false;
                        {
                            this.RichTextBox.Selection.Text = f;
                            //FIXME: IsOnTextChangedEnabledの操作ではなくTextChangedと同じ処理を呼び出して保存するように
                            this.RichTextBox.IsOnTextChangedEnabled = true;
                            this.CreateHyperlinkAt(this.RichTextBox.Selection);
                            this.RichTextBox.IsOnTextChangedEnabled = true;
                            //window.CreateHyperlinkAt(textbox.Selection, new Uri(f));
                            //this.RichTextBox.Selection.Start.InsertTextInRun("[[");
                            //this.RichTextBox.Selection.End.InsertTextInRun("]]");
                        }
                        this.RichTextBox.IsOnTextChangedEnabled = true;
                    }
                    catch (Exception ex)
                    {
                        Util.p(ex);
                        EventLog.WriteEntry(ex.Source, ex.Message);
                    }
                }
            }
            if (e.Data.GetDataPresent(DataFormats.MetafilePicture, true))
            {
                e.Effects = DragDropEffects.Copy;
                //e.Handled = true; //HACK:Wordウィンドウからのドラッグで貼れなくなるのでtrueにしない。
                var image = e.Data.GetData(DataFormats.MetafilePicture, true) as Image;
                if (image != null)
                {
                    try
                    {
                        this.RichTextBox.IsOnTextChangedEnabled = false;
                        this.InsertImage(image, this.RichTextBox.CaretPosition);
                        this.RichTextBox.IsOnTextChangedEnabled = true;
                    }
                    catch (NotSupportedException ex)
                    {
                        Util.p(ex);
                    }
                    catch (Exception ex)
                    {
                        Util.p(ex);
                        EventLog.WriteEntry(ex.Source, ex.Message);
                    }
                }
            }
        }

        void UpdateCompletionList()
        {
            //FIXME: Filterの設定をListBox生成時の1回きりに
            // Display AutoCompleteFrame
            Debug.Assert(this.ListBox.Items.CanFilter);
            Debug.WriteLine(new { autoCompleteHint = Util.TextOf(this.CompletionRange) }, "Popup");
            this.ListBox.Items.Filter = new Predicate<object>(_ =>
            {
                //var autoCompleteHint = sel.Selection.Text;
                var autoCompleteHint = Util.TextOf(this.CompletionRange);

                var __item = _ as ListBoxItem ?? new ListBoxItem() { Content = "\\" };
                var __content = __item.Content.ToString();
                //Debug.WriteLine(new { autoCompleteHint, __content });
                return (autoCompleteHint.Length <= __content.Length)
                    //TODO: StringComparisonの効果を確認
                    ? __content.IndexOf(autoCompleteHint, StringComparison.OrdinalIgnoreCase) >= 0  // 部分一致
                    : false;
            });

            //TODO: 効果を確認
            //Debug.Assert(this.ListBox.Items.CanSort);
            //this.ListBox.Items.SortDescriptions.Clear();
            ////FIXME: 長い順に表示。Itemがobject扱いになっているのでソートできない。
            //this.ListBox.Items.SortDescriptions.Add(new System.ComponentModel.SortDescription("Length", System.ComponentModel.ListSortDirection.Descending));
            //this.ListBox.Items.SortDescriptions.Add(new System.ComponentModel.SortDescription("@Content", System.ComponentModel.ListSortDirection.Descending));

            //Debug.WriteLine(new { this.ListBox.Items.Count });
            //foreach (var it in this.ListBox.Items)
            //    Debug.WriteLine(new { item = it });

            if (this.ListBox.Items.Count == 0)
            {
                this.ListBox.Opacity = 0.25;
                this.ListBox.Items.Add(new ListBoxItem { Content = "_(:3｣ ∠)_" + new string(' ', 20) });
                //this.Popup.IsOpen = false;
                //this.ListBox.Items.Filter = null;
            }
            else
            {
                this.ListBox.Opacity = 1.0;
            }
        }

        void MigiueBox_Loaded(object sender, RoutedEventArgs e)
        {
            var c = (TextBox)sender;
            //c.Foreground = new SolidColorBrush(Colors.Gray);
            //c.Foreground.Opacity = 0.5;
            c.Background = new VisualBrush();
            ((VisualBrush)c.Background).AlignmentX = AlignmentX.Right;
            ((VisualBrush)c.Background).Stretch = Stretch.None;
            ((VisualBrush)c.Background).Visual = new TextBlock();
            ((TextBlock)((VisualBrush)c.Background).Visual).FontStyle = FontStyles.Oblique;
            ((TextBlock)((VisualBrush)c.Background).Visual).Text = "（検索）";

            e.Handled = true;
        }

        void MigiueBox_LostKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            var c = (TextBox)sender;
            //c.Foreground.Opacity = 0.5;
            ((TextBlock)((VisualBrush)c.Background).Visual).Text = "（検索）";

            e.Handled = true;
        }

        void MigiueBox_GotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            var c = (TextBox)sender;
            //c.Foreground.Opacity = 1.0;
            ((TextBlock)((VisualBrush)c.Background).Visual).Text = "";

            e.Handled = true;
        }

        void MigiueBox_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            Util.p(new { e.Key }, "MigiueBox_PreviewKeyDown");

            switch (e.Key)
            {
                case Key.F4:
                    if (this.SearchString.Length > 0)
                    {
                        e.Handled = true;
                        var searchWindow = (Search)App.searchWindow;
                        searchWindow.SearchQuery = this.SearchString;
                        searchWindow.Show();
                        searchWindow.BeginSearch();
                    }
                    break;

                case Key.Down:
                    {
                        e.Handled = true;
                        FindNext(this.SearchString, LogicalDirection.Forward, bidirection: false);
                    }
                    break;

                case Key.Up:
                    {
                        e.Handled = true;
                        FindNext(this.SearchString, LogicalDirection.Backward, bidirection: false);
                    }
                    break;

                default:
                    break;
            }
        }

        void MigiueBox_KeyDown(object sender, KeyEventArgs e)
        {
            Util.p(new { e.Key }, "MigiueBox_KeyDown");

            var c = (TextBox)sender;

            switch (e.Key)
            {
                case Key.Return:
                    switch (e.KeyboardDevice.Modifiers)
                    {
                        case ModifierKeys.None:
                            {
                                e.Handled = true;
                                FindNext(this.SearchString, LogicalDirection.Forward, bidirection: false);
                            }
                            break;

                        case ModifierKeys.Shift:
                            {
                                e.Handled = true;
                                FindNext(this.SearchString, LogicalDirection.Backward, bidirection: false);
                            }
                            break;

                        default:
                            break;
                    }
                    break;

                default:
                    break;
            }
        }

        void MigiueBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            if (this._imeActive)
                return;

            var c = (TextBox)sender;

            this.SearchString = c.Text;
            if (c.Text.Length >= 1)
                Find(this.SearchString, LogicalDirection.Forward, bidirection: true);

            e.Handled = true;
        }

        void Ribbon_CreateDocumentButton_Click(object sender, RoutedEventArgs e)
        {
            //FIXME: コマンド化
            var editor = Editor.Create();
            ((App)App.Current).UntitledEditorWindows.Add(editor);
            editor.Show();

            e.Handled = true;
        }

        void Ribbon_PasteTimeStampButton_Click(object sender, RoutedEventArgs e)
        {
            var sel = this.RichTextBox.Selection;
            if (sel.Start.CompareTo(sel.End) == 0)
            {
                sel.Text = DateTime.Now.ToString();
                sel.Select(sel.End, sel.End);
            }
            else
            {
                sel.Text = DateTime.Now.ToString();
            }

            e.Handled = true;
        }

        void Ribbon_TextPasteButton_Click(object sender, RoutedEventArgs e)
        {
            this.RichTextBox.CaretPosition.InsertTextInRun(Clipboard.GetText(TextDataFormat.UnicodeText));

            e.Handled = true;
        }

        void Ribbon_FullTextSearchButton_Click(object sender, RoutedEventArgs e)
        {
            App.searchWindow.Show();
            App.searchWindow.Activate();

            e.Handled = true;
        }

        void Ribbon_FindButton_Click(object sender, RoutedEventArgs e)
        {
            //FIXME: なぜかキーボードフォーカスが移動しない。
            this.MigiueBox.Focus();

            e.Handled = true;
        }

        void Ribbon_SearchNextButton_Click(object sender, RoutedEventArgs e)
        {
            FindNext(this.SearchString, LogicalDirection.Forward, bidirection: false);

            e.Handled = true;
        }

        void Ribbon_SearchPreviousButton_Click(object sender, RoutedEventArgs e)
        {
            FindNext(this.SearchString, LogicalDirection.Backward, bidirection: false);

            e.Handled = true;
        }

        void Ribbon_ReplacementButton_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("（実装予定）");

            e.Handled = true;
        }

        private void MenuItem_OpenOptionWindow_Click(object sender, RoutedEventArgs e)
        {
            App.configWindow.Show();
            App.configWindow.Activate();

            e.Handled = true;
        }

        private void MenuItem_OpenHelp_Click(object sender, RoutedEventArgs e)
        {
            // ヘルプファイルはbinディレクトリにコピーされるようにファイルプロパティを設定しておく。
            //Process.Start(App.HelpFile.FullName);

            //FIXME:Cameyo向け。シェルによる関連付けを利用せずにヘルプファイルを開く。
            System.Windows.Forms.Help.ShowHelp(null, @"JoinNotes.chm", System.Windows.Forms.HelpNavigator.Index);

            e.Handled = true;
        }

        private void MenuItem_OpenTrayMenu_Click(object sender, RoutedEventArgs e)
        {
            App.mainWindow.ShowNotifyTrayMenu(this.PointToScreen(Mouse.GetPosition(this)));

            e.Handled = true;
        }

        private void MenuItem_Exit_Click(object sender, RoutedEventArgs e)
        {
            App.Instance.Shutdown();

            e.Handled = true;
        }

        private void MenuItem_AboutJoinNotes_Click(object sender, RoutedEventArgs e)
        {
            App.aboutWindow.ShowDialog();

            e.Handled = true;
        }

    }

}
