﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Windows;
using Forms = System.Windows.Forms;
using System.ComponentModel;
using System.Diagnostics;
using System.Windows.Media;
using System.IO;
using System.Reflection;

namespace JoinNotes
{
    /// <summary>
    /// App.xaml の相互作用ロジック
    /// </summary>
    public partial class App : Application
    {
        static internal Search searchWindow;
        static internal Config configWindow;
        static internal Forms.Form aboutWindow;
        //static internal Menu mainWindow;
        static internal NotifyTray mainWindow;
        static public FileInfo HelpFile;
        static private HashSet<Window> _shownWindows = new HashSet<Window> { };
        //internal string basepath;
        static internal DirectoryInfo DocumentPath;

        //static public Window MainWindow { get; private set; }
        static public App Instance { get; private set; }

        public Dictionary<Uri, Editor> EditorWindows = new Dictionary<Uri, Editor> { };
        public HashSet<Editor> UntitledEditorWindows = new HashSet<Editor> { };

        internal static string NotifyContainerTitle { get; private set; }

        protected override void OnStartup(StartupEventArgs e)
        {
            App.NotifyContainerTitle = Assembly.GetEntryAssembly().GetName().Name + " " + this.GetType().Name;

            var current = Process.GetCurrentProcess();

            //HACK: なぜかApp.xamlの<Application.Resources>セクションで定義するとデザイン時にファイルが見つからないエラーが出るので、ここで指定。
            this.Resources.Source = new Uri(@"pack://application:,,,/JoinNotes;component/Themes/Generic.xaml");

            App.HelpFile = new FileInfo("JoinNotes.chm");

            // デバッグ用
            var otherProcs = Process.GetProcessesByName("JoinNotes").ToList();
            otherProcs.AddRange(Process.GetProcessesByName("JoinNotes.vshost"));
            otherProcs = otherProcs.Where(p => p.Id != current.Id).ToList();
            //FIXME: リリース時はこちら
            //var otherProcs = Process.GetProcessesByName(current.ProcessName).Where(p => p.MainModule.FileName == current.MainModule.FileName && p.Id != current.Id);

            if (otherProcs.Count() == 0)
            {
                App.Instance = this;
                //App.mainWindow = new Menu();
                App.mainWindow = new NotifyTray();
                App.NotifyContainer = App.mainWindow;

                //HACK: 一度表示しないとなぜかプロセス外からEnumWindows()で発見できないので
                App.NotifyContainer.Show();
                App.NotifyContainer.Hide();

                App.searchWindow = new Search();
                App.configWindow = new Config();
                App.aboutWindow = new AboutBox1();

                App.Current.MainWindow = App.mainWindow;
                //App.Current.MainWindow = App.searchWindow;

                ////FIXME: remove
                //App.Current.MainWindow.Show();

                base.OnStartup(e);
            }
            else
            {
                Debug.Assert(otherProcs.Count() >= 1);
                otherProcs.ForEach(new Action<Process>((p) => Debug.WriteLine(new { p.MainWindowHandle, p.MainWindowTitle }, "Send wakeup message to ")));
                //Util.WakeupWindow(otherProcs.First().MainWindowHandle);
                Util.WakeupWindow(otherProcs.First());
                //Util.WakeupWindow(otherProcs.First().Handle);
                this.Shutdown();
            }
        }

        void Window_Closed(object sender, EventArgs e)
        {
            var c = (Window)sender;

            if (_shownWindows.Contains(c))
                _shownWindows.Remove(c);

            //FIXME: remove
            //this.Shutdown();
        }

        void FormClosed(object sender, Forms.FormClosedEventArgs e)
        {
            //FIXME: remove
            //this.Shutdown();
        }

        //FIXME: Application_Exitと統合
        protected override void OnExit(ExitEventArgs e)
        {
            base.OnExit(e);

            if (searchWindow != null)
                searchWindow.Close();
            if (configWindow != null)
                configWindow.Close();
            if (mainWindow != null)
                mainWindow.Close();
        }

        //static public Menu NotifyContainer { get; set; }
        static public Window NotifyContainer { get; set; }

        //void App_Startup(object sender, StartupEventArgs e)
        //{
        //    Debug.Assert(App.mainWindow != null && App.mainWindow.GetType() == typeof(NotifyTray));
        //    //App.NotifyContainer = new Menu();
        //    App.NotifyContainer = App.mainWindow;
        //}

        private void Application_Exit(object sender, ExitEventArgs e)
        {
            App.NotifyContainer.Close();

            if (Menu.HotKey_ActivateHotKey != null)
                try
                {
                    Menu.HotKey_ActivateHotKey.Unregister();
                }
                catch (Win32Exception ex)
                {
                    Debug.WriteLine(ex.Message, ex.Source);
                }
        }

        //TODO: 検証
        static public Size Ppi(Visual visual)
        {
            //†: http://social.msdn.microsoft.com/Forums/vstudio/en-US/61e93dca-e24c-4953-9719-22ce3f705353/finding-dpi-using-wpf
            var source = PresentationSource.FromVisual(visual);
            Debug.Assert(source is PresentationSource);
            var m = source.CompositionTarget.TransformToDevice;
            return new Size(m.M11 * 96.0, m.M22 * 96.0);
        }

        //FIXME: OnStartupと統合
        private void Application_Startup(object sender, StartupEventArgs e)
        {
            //App.DocumentPath = new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), @"Visual Studio 2010\Projects\JoinNotes\doc"));
            //App.DocumentPath = new DirectoryInfo(Path.GetFullPath(@"..\..\..\doc"));
            App.DocumentPath = new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), @"JoinNotes"));
            if (!App.DocumentPath.Exists)
                App.DocumentPath.Create();

            {
                var classname = JoinNotes.Properties.Settings.Default.StartupWindowClassName;
                switch (classname)
                {
                    //FIXME: ComboBoxでのラベルと設定値の対応付け方法
                    case "Editor":
                        {
                            //FIXME: コマンド化
                            var editor = Editor.Create(new Uri(Path.Combine(App.DocumentPath.FullName, JoinNotes.Properties.Settings.Default.StartPageName + @".join.rtf")));
                            //var editor = Editor.Create();
                            ((App)App.Current).UntitledEditorWindows.Add(editor);
                            editor.Show();

                            //FIXME: remove
                            editor.Closed += new EventHandler(Window_Closed);
                        }
                        break;

                    case "Search":
                        {
                            searchWindow.Show();

                            //FIXME: remove
                            searchWindow.Closed += new EventHandler(Window_Closed);
                        }
                        break;

                    case "Task":
                        {
                            mainWindow.Show();

                            ////FIXME: remove
                            //mainWindow.FormClosed += new Forms.FormClosedEventHandler(FormClosed);

                            //FIXME: remove
                            mainWindow.Closed += new EventHandler(Window_Closed);
                        }
                        break;

                    default:
                        Debug.Fail("Application_Startup");
                        break;
                }
            }

            Application.Current.MainWindow.Closed += new EventHandler(Window_Closed);
            configWindow.Closed += new EventHandler(Window_Closed);

            //{
            //    var activateHotKey = new HotKey(App.mainWindow.Handle,
            //        Menu.HotKey_ActivateHotKeyId,
            //        System.Windows.Forms.Keys.Oem5, // Oem5: \
            //        System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt); //HACK: Keys.AltはShiftキーのこと。
            //    Menu.HotKey_ActivateHotKey = activateHotKey;
            //}

            //searchWindow.Show();
            //editorWindow.Owner = Application.Current.MainWindow;

            //mainWindow.Show();
            //editorWindow.Show();
            //searchWindow.Show();
            //configWindow.Show();

            this.ShutdownMode = System.Windows.ShutdownMode.OnExplicitShutdown;

            //Application.Current.MainWindow.Show();
        }

        static public void SwitchApplicationVisibility()
        {
            {
                // ウィンドウが1つでも表示されていれば、全てを記録して非表示。1つも表示されていなければ記録してあるWindowを全て表示。
                var numberOfVisibleWindows = 0;
                {
                    var windows = Application.Current.Windows.GetEnumerator();
                    while (windows.MoveNext())
                    {
                        var window = (Window)windows.Current;
                        if (window.IsVisible)
                            numberOfVisibleWindows++;
                    }
                }

                if (numberOfVisibleWindows == 0)
                {
                    ActivateWindows();
                }
                else
                {
                    InactivateWindows();
                }
            }
        }

        internal static void InactivateWindows()
        {
            _shownWindows.Clear();
            var windows = App.Instance.Windows.GetEnumerator();
            while (windows.MoveNext())
            {
                var window = (Window)windows.Current;
                if (window.IsVisible)
                {
                    window.Visibility = Visibility.Collapsed;

                    //window.WindowState = WindowState.Minimized;
                    //window.Hide();

                    //window.ShowInTaskbar = false;
                    //window.WindowState = WindowState.Minimized;

                    _shownWindows.Add(window);
                }
            }
        }

        internal static void ActivateWindows()
        {
            //if (_shownWindows.Count == 0)
            //{
            //    var classname = JoinNotes.Properties.Settings.Default.StartupWindowClassName;
            //    switch (classname)
            //    {
            //        //FIXME: 設定値とComboBoxでのラベルの対応付け
            //        case "Editor":
            //            {
            //                //TODO: 開いていたファイルを開く。既にインスタンスがあればそれを表示するだけ。
            //                var editor = new Editor();
            //                ((App)App.Current).UntitledEditorWindows.Add(editor);
            //                //FIXME: 最大化 ←→ 最小化にならない？
            //                editor.WindowState = WindowState.Normal;
            //                editor.Activate();
            //            }
            //            break;

            //        case "Search":
            //            {
            //                searchWindow.Show();
            //                //FIXME: 最大化 ←→ 最小化にならない？
            //                searchWindow.WindowState = WindowState.Normal;
            //                searchWindow.Activate();
            //            }
            //            break;

            //        case "Task":
            //            {
            //                mainWindow.Show();
            //                //FIXME: 最大化 ←→ 最小化にならない？
            //                mainWindow.WindowState = Forms.FormWindowState.Normal;
            //                mainWindow.Activate();
            //            }
            //            break;

            //        default:
            //            Debug.Fail("comboBox1_SelectionChanged");
            //            break;
            //    }
            //}
            //else
            var en = App.Instance.Windows.GetEnumerator();
            while (en.MoveNext())
            {
                var window = (Window)en.Current;
                if (App._shownWindows.Contains(window))
                    window.Visibility = Visibility.Visible;
                if (window.WindowState == WindowState.Minimized)
                    window.WindowState = WindowState.Normal;
                if (window.IsVisible)
                    window.Activate();
            }
        }

    }

}
