/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import org.routine_work.simple_battery_logger.BatteryConstants;
import org.routine_work.util.Log;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class CsvFileMediaScanServiceStarter extends BroadcastReceiver
{

	private static final String LOG_TAG = "simple-battery-logger";

	@Override
	public void onReceive(Context context, Intent intent)
	{
		Log.v(LOG_TAG, "Hello");

		String action = intent.getAction();
		Log.d(LOG_TAG, "intent.action => " + action);

		if (BatteryConstants.EXPORT_ONE_DAY_DATA_CSV_FILE_COMPLETED_ACTION.equals(action))
		{
			final boolean exportCsvFileResult = intent.getBooleanExtra(BatteryConstants.EXTRA_RESULT, true);
			Log.d(LOG_TAG, "intent.EXTRA_RESULT => " + exportCsvFileResult);

			final String dateString = intent.getStringExtra(BatteryConstants.EXTRA_DATE);
			Log.d(LOG_TAG, "intent.EXTRA_DATE => " + dateString);

			final String csvFilePath = intent.getStringExtra(BatteryConstants.EXTRA_CSV_FILE_PATH);
			Log.d(LOG_TAG, "intent.EXTRA_CSV_FILE_PATH => " + csvFilePath);

			if (exportCsvFileResult)
			{
				Intent startCsvFileMediaScanService = new Intent(context, CsvFileMediaScanService.class);
				startCsvFileMediaScanService.putExtra(BatteryConstants.EXTRA_RESULT, exportCsvFileResult);
				startCsvFileMediaScanService.putExtra(BatteryConstants.EXTRA_DATE, dateString);
				startCsvFileMediaScanService.putExtra(BatteryConstants.EXTRA_CSV_FILE_PATH, csvFilePath);
				context.startService(startCsvFileMediaScanService);
			}
		}

		Log.v(LOG_TAG, "Bye");
	}
}
