package com.sample;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jivesoftware.smack.packet.IQ;
import org.w3c.dom.Element;

/**
 * Servlet implementation class HttpXmppSample
 */
public class HttpXmppMain extends HttpServlet {
	private static final long serialVersionUID = 1L;

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public HttpXmppMain() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		doExecute(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		doExecute(request, response);
	}

	private void doExecute(HttpServletRequest request,
			HttpServletResponse response) {
		try {
			XmlUtil util = XmlUtil.getInstance();
			Xmpp xmpp = Xmpp.getInstance();

			InputStream sis = request.getInputStream();
			InputStream is = util.convert(sis);

			Element root = util.parse(is);
			String id = util.getId(root);
			if (id == null) {
				return;
			}

			// 子ノードを取得
			is.reset();
			String str = util.getChild(is);

			Log.debug("HttpXmppSample", id, "RECV1", str);
			Map<String, TaskInfo> m = xmpp.getMap();
			TaskInfo info;
			try {
				Thread t = Thread.currentThread();
				info = new TaskInfo(id, t);
				m.put(id, info);

				Log.debug("HttpXmppSample", id, "SEND1", str);
				// XMPPでパケットを送信する
				xmpp.sendPacket(id, str);

				while (!info.isDone()) {
					Log.debug("HttpXmppSample", id, "YIELD", null);
					// 実行を他のスレッドに譲る
					Thread.yield();
				}
			} finally {
				m.remove(id);
			}

			// HTPPレスポンスを返す
			String result = info.getResult();
			Log.debug("HttpXmppSample", id, "SEND2", result);
			OutputStream os = response.getOutputStream();
			os.write(result.getBytes());
			os.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
