package com.sample;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtil {
	private static class XmlUtilHolder {
		private static final XmlUtil instance = new XmlUtil();
	}

	public static XmlUtil getInstance() {
		return XmlUtilHolder.instance;
	}

	/**
	 * InputStreamををXMLに変換する
	 * @param is
	 * @return
	 */
	public Element parse(InputStream is) {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		Element root = null;
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			try {
				Document doc = builder.parse(is);
				root = doc.getDocumentElement();
			} catch (SAXException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return root;
	}

	/**
	 * XMLがIQスタンザであり、中身がqueryの場合、idを返す
	 * @param root
	 * @return
	 */
	public String getId(Element root) {
		String id = null;

		// IQスタンザであることを確認
		String iq = root.getNodeName();
		if (!iq.equals("iq")) {
			return null;
		}

		// IDがあることを確認
		NamedNodeMap attr = root.getAttributes();
		Node nodeId = attr.getNamedItem("id");
		if (nodeId == null) {
			return null;
		}

		// 子ノードを取得し、queryタグであることを確認
		Node child = root.getFirstChild();
		if (child == null) {
			return null;
		}
		String query = child.getNodeName();
		if (!query.equals("query")) {
			return null;
		}

		id = nodeId.getNodeValue();
		return id;
	}

	/**
	 * XMLの親ノードを除いた、XML(文字列)を返す
	 * @param is
	 * @return
	 */
	public String getChild(InputStream is) {
		Transformer transformer = null;
		try {
			TransformerFactory transformerFactory = TransformerFactory
					.newInstance();
			transformer = transformerFactory.newTransformer();
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
			return null;
		}
		
		StringBuffer sb = new StringBuffer();

		Element root = parse(is);
		NodeList nodes = root.getChildNodes();
		int l = nodes.getLength();
		try {
			for (int i = 0; i < l; i++) {
				Node node = nodes.item(i);

				ByteArrayOutputStream os = new ByteArrayOutputStream();
				StreamResult sr = new StreamResult();
				sr.setOutputStream(os);
				transformer.transform(new DOMSource(node), sr);
				String str = os.toString();
				int pos = str.indexOf('>');
				str = str.substring(pos + 1);
				sb.append(str);
			}
		} catch (TransformerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
		return sb.toString();
	}

	/**
	 * InputStreamからByteArrayInputStreamに変換する
	 * @param is
	 * @return
	 */
	public ByteArrayInputStream convert(InputStream is) {
		byte[] b = new byte[1024];
		try {
			int l = is.read(b);
			return new ByteArrayInputStream(b, 0, l);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * InputStreamから文字列に変換する
	 * @param is
	 * @return
	 */
	public String read(InputStream is) {
		byte[] b = new byte[1024];
		try {
			int l = is.read(b);
			return new String(b, 0, l);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
}
