/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JLayeredPane;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeConfig;

public class MoeLayeredPane
extends JLayeredPane {
    private BufferedImage image;
    private TexturePaint paint;
    private float alpha;

    public MoeLayeredPane() {
        this.image = null;
        this.paint = null;
        this.alpha = MoeConfig.getOpacity();
    }

    public MoeLayeredPane(BufferedImage image) {
        this.setPicture(image);
        this.alpha = MoeConfig.getOpacity();
    }

    public void setBackground(BufferedImage image) {
        this.setPicture(image);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(this.makeComposite(this.alpha));
            if (this.getWidth() > this.image.getWidth() || this.getHeight() > this.image.getHeight()) {
                g2.setPaint(this.paint);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g2.drawImage((Image)this.image, 0, 0, this);
            }
            g2.dispose();
        }
        super.paintComponent(g);
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    private void setPicture(BufferedImage image) {
        this.image = image;
        if (image == null) {
            this.paint = null;
        } else {
            Rectangle rect = new Rectangle(image.getWidth(), image.getHeight());
            this.paint = new TexturePaint(image, rect);
        }
    }
}

