/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.foldermenu;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.L10n;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.MenuHelper;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.ShellLinkMenu;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.ShellLinkMenuItem;
import org.omegat.core.Core;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class MenuManager {
    private JMenu root = this.createLocalizedMenu(L10n.getFoldersMenuLabel());
    private ShellLinkMenu currentProject;
    private ShellLinkMenuItem currentSourceFile;
    private ShellLinkMenuItem currentTargetFile;

    public MenuManager() {
        this.root.addMenuKeyListener(MenuHelper.getMenuKeyListener());
        this.root.addMenuListener(MenuHelper.getRootMenuListener());
        try {
            this.currentProject = new ShellLinkMenu(L10n.getProjectRootMenuLabel());
            this.root.add(this.currentProject.getMenu());
        }
        catch (IOException ex) {
            Log.log(ex);
            return;
        }
        try {
            File confDir = new File(StaticUtils.getConfigDir());
            this.root.add(new ShellLinkMenu(confDir, L10n.getUserConfigMenuLabel()).getMenu());
        }
        catch (IOException ex) {
            Log.log(ex);
        }
        this.root.add(new JSeparator());
        this.currentSourceFile = new ShellLinkMenuItem(L10n.getSourceDocumentMenuLabel());
        this.root.add(this.currentSourceFile.getMenuItem());
        this.currentTargetFile = new ShellLinkMenuItem(L10n.getTargetDocumentMenuLabel());
        this.root.add(this.currentTargetFile.getMenuItem());
        JMenuBar mainMenuBar = (JMenuBar)Core.getMainWindow().getMainMenu().getOptionsMenu().getParent();
        mainMenuBar.add((Component)this.root, mainMenuBar.getMenuCount() - 1);
    }

    public void createProjectItems() {
        File rootDir = new File(Core.getProject().getProjectProperties().getProjectRoot());
        try {
            this.currentProject.link(rootDir);
        }
        catch (IOException ex) {
            Log.log(ex);
        }
    }

    public void removeAllProjectItems() {
        this.currentProject.unlink();
    }

    public void linkCurrentSourceFile(File file) throws IOException {
        String sourceRoot = Core.getProject().getProjectProperties().getSourceRoot();
        String midName = FileUtil.computeRelativePath(new File(sourceRoot), file);
        this.currentSourceFile.link(file, midName);
    }

    public void unlinkCurrentSourceFile() {
        this.currentSourceFile.unlink();
    }

    public void linkCurrentTargetFile(File file) throws IOException {
        String targetRoot = Core.getProject().getProjectProperties().getTargetRoot();
        String midName = FileUtil.computeRelativePath(new File(targetRoot), file);
        this.currentTargetFile.link(file, midName);
    }

    public void unlinkCurrentTargetFile() {
        this.currentTargetFile.unlink();
    }

    private JMenu createLocalizedMenu(String labelString) {
        JMenu m = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)m, (String)labelString);
        return m;
    }
}

