// Copyright(c) 2022, mocchi
// All rights reserved
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met :
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS gAS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include <vector>
#include <cstdio>
#include <cstdlib>
#include <cctype>

#include "mpfit.h"
#include "mist/mist.h"
#include "mist/matrix.h"

#include "ONGEO_RootFinding.hpp"

// QsQARsRASsSp̓o[W
// ߂l 0: A -1: s񎮂[A -2: QsQARsRASsSȊO̍s񂪓͂ꂽ
template <typename value_type> int inverse_234(mist::matrix<value_type> &a) {
	if (a.rows() != a.cols()) return -2;

	switch (a.rows()) {
		case 2:
		{
			double a11 = a(0, 0);
			double a12 = a(0, 1);
			double a21 = a(1, 0);
			double a22 = a(1, 1);
			double detA = a11 * a22 - a12 * a21;
			if (detA != 0) {
				a(0, 0) = static_cast<value_type>(a22 / detA);
				a(0, 1) = static_cast<value_type>(-a12 / detA);
				a(1, 0) = static_cast<value_type>(-a21 / detA);
				a(1, 1) = static_cast<value_type>(a11 / detA);
				return 0;
			} else {
				// s񎮂[
				return -1;
			}
		}
		break;

		case 3:
		{
			double a11 = a(0, 0), a12 = a(0, 1), a13 = a(0, 2);
			double a21 = a(1, 0), a22 = a(1, 1), a23 = a(1, 2);
			double a31 = a(2, 0), a32 = a(2, 1), a33 = a(2, 2);

			// ʂŗpW̌vZ
			double _22x33_23x32_ = a22 * a33 - a23 * a32;
			double _21x32_22x31_ = a21 * a32 - a22 * a31;
			double _23x31_21x33_ = a23 * a31 - a21 * a33;

			// s񎮂vZ
			double detA = a11 * _22x33_23x32_ + a13 * _21x32_22x31_ + a12 * _23x31_21x33_;

			// ts񂪑݂ꍇ̂tsvZ
			if (detA != 0) {
				// evf̒lvZ
				double A11 = _22x33_23x32_;
				double A12 = a13 * a32 - a12 * a33;
				double A13 = a12 * a23 - a13 * a22;
				double A21 = _23x31_21x33_;
				double A22 = a11 * a33 - a13 * a31;
				double A23 = a13 * a21 - a11 * a23;
				double A31 = _21x32_22x31_;
				double A32 = a12 * a31 - a11 * a32;
				double A33 = a11 * a22 - a12 * a21;

				double _1_detA = 1.0 / detA;
				a(0, 0) = static_cast<value_type>(A11 * _1_detA);
				a(0, 1) = static_cast<value_type>(A12 * _1_detA);
				a(0, 2) = static_cast<value_type>(A13 * _1_detA);
				a(1, 0) = static_cast<value_type>(A21 * _1_detA);
				a(1, 1) = static_cast<value_type>(A22 * _1_detA);
				a(1, 2) = static_cast<value_type>(A23 * _1_detA);
				a(2, 0) = static_cast<value_type>(A31 * _1_detA);
				a(2, 1) = static_cast<value_type>(A32 * _1_detA);
				a(2, 2) = static_cast<value_type>(A33 * _1_detA);
				return 0;
			} else {
				// s񎮂[
				return -1;
			}
		}
		break;

		case 4:
		{
			double a11 = a(0, 0), a12 = a(0, 1), a13 = a(0, 2), a14 = a(0, 3);
			double a21 = a(1, 0), a22 = a(1, 1), a23 = a(1, 2), a24 = a(1, 3);
			double a31 = a(2, 0), a32 = a(2, 1), a33 = a(2, 2), a34 = a(2, 3);
			double a41 = a(3, 0), a42 = a(3, 1), a43 = a(3, 2), a44 = a(3, 3);

			// ʂŗpW̌vZ
			double _33x44_34x43_ = a33 * a44 - a34 * a43;
			double _34x42_32x44_ = a34 * a42 - a32 * a44;
			double _32x43_33x42_ = a32 * a43 - a33 * a42;
			double _31x44_34x41_ = a31 * a44 - a34 * a41;
			double _33x41_31x43_ = a33 * a41 - a31 * a43;
			double _31x42_32x41_ = a31 * a42 - a32 * a41;

			// s񎮂vZ
			double detA = a11 * (a22 * _33x44_34x43_ + a23 * _34x42_32x44_ + a24 * _32x43_33x42_)
				- a12 * (a21 * _33x44_34x43_ - a23 * _31x44_34x41_ - a24 * _33x41_31x43_)
				- a13 * (a21 * _34x42_32x44_ + a22 * _31x44_34x41_ - a24 * _31x42_32x41_)
				- a14 * (a21 * _32x43_33x42_ + a22 * _33x41_31x43_ + a23 * _31x42_32x41_);

			// ts񂪑݂ꍇ̂tsvZ
			if (detA != 0) {
				// ʂŗpW̌vZ
				double _23x44_24x43_ = a23 * a44 - a24 * a43;
				double _24x42_22x44_ = a24 * a42 - a22 * a44;
				double _22x43_23x42_ = a22 * a43 - a23 * a42;
				double _24x33_23x34_ = a24 * a33 - a23 * a34;
				double _22x34_24x32_ = a22 * a34 - a24 * a32;
				double _23x32_22x33_ = a23 * a32 - a22 * a33;
				double _21x44_24x41_ = a21 * a44 - a24 * a41;
				double _23x41_21x43_ = a23 * a41 - a21 * a43;
				double _24x31_21x34_ = a24 * a31 - a21 * a34;
				double _21x33_23x31_ = a21 * a33 - a23 * a31;
				double _21x42_22x41_ = a21 * a42 - a22 * a41;
				double _22x31_21x32_ = a22 * a31 - a21 * a32;

				// evf̒lvZ
				double A11 = a22 * _33x44_34x43_ + a23 * _34x42_32x44_ + a24 * _32x43_33x42_;
				double A12 = -a12 * _33x44_34x43_ - a13 * _34x42_32x44_ - a14 * _32x43_33x42_;
				double A13 = a12 * _23x44_24x43_ + a13 * _24x42_22x44_ + a14 * _22x43_23x42_;
				double A14 = a12 * _24x33_23x34_ + a13 * _22x34_24x32_ + a14 * _23x32_22x33_;
				double A21 = -a21 * _33x44_34x43_ + a23 * _31x44_34x41_ + a24 * _33x41_31x43_;
				double A22 = a11 * _33x44_34x43_ - a13 * _31x44_34x41_ - a14 * _33x41_31x43_;
				double A23 = -a11 * _23x44_24x43_ + a13 * _21x44_24x41_ + a14 * _23x41_21x43_;
				double A24 = -a11 * _24x33_23x34_ + a13 * _24x31_21x34_ + a14 * _21x33_23x31_;
				double A31 = -a21 * _34x42_32x44_ - a22 * _31x44_34x41_ + a24 * _31x42_32x41_;
				double A32 = a11 * _34x42_32x44_ + a12 * _31x44_34x41_ - a14 * _31x42_32x41_;
				double A33 = -a11 * _24x42_22x44_ - a12 * _21x44_24x41_ + a14 * _21x42_22x41_;
				double A34 = -a11 * _22x34_24x32_ - a12 * _24x31_21x34_ + a14 * _22x31_21x32_;
				double A41 = -a21 * _32x43_33x42_ - a22 * _33x41_31x43_ - a23 * _31x42_32x41_;
				double A42 = a11 * _32x43_33x42_ + a12 * _33x41_31x43_ + a13 * _31x42_32x41_;
				double A43 = -a11 * _22x43_23x42_ - a12 * _23x41_21x43_ - a13 * _21x42_22x41_;
				double A44 = -a11 * _23x32_22x33_ - a12 * _21x33_23x31_ - a13 * _22x31_21x32_;

				double _1_detA = 1.0 / detA;
				a(0, 0) = static_cast<value_type>(A11 * _1_detA);
				a(0, 1) = static_cast<value_type>(A12 * _1_detA);
				a(0, 2) = static_cast<value_type>(A13 * _1_detA);
				a(0, 3) = static_cast<value_type>(A14 * _1_detA);
				a(1, 0) = static_cast<value_type>(A21 * _1_detA);
				a(1, 1) = static_cast<value_type>(A22 * _1_detA);
				a(1, 2) = static_cast<value_type>(A23 * _1_detA);
				a(1, 3) = static_cast<value_type>(A24 * _1_detA);
				a(2, 0) = static_cast<value_type>(A31 * _1_detA);
				a(2, 1) = static_cast<value_type>(A32 * _1_detA);
				a(2, 2) = static_cast<value_type>(A33 * _1_detA);
				a(2, 3) = static_cast<value_type>(A34 * _1_detA);
				a(3, 0) = static_cast<value_type>(A41 * _1_detA);
				a(3, 1) = static_cast<value_type>(A42 * _1_detA);
				a(3, 2) = static_cast<value_type>(A43 * _1_detA);
				a(3, 3) = static_cast<value_type>(A44 * _1_detA);
				return 0;
			} else {
				// s񎮂[
				return -1;
			}
		}
		break;
	}
	return -2;
}

struct spectral_item {
	int lambda;
	double v;
};

struct cmf_item {
	int lambda;
	double x, y, z;
}cmf_1031[]{
	{360,0.000129900000,0.000003917000,0.000606100000},
	{361,0.000145847000,0.000004393581,0.000680879200},
	{362,0.000163802100,0.000004929604,0.000765145600},
	{363,0.000184003700,0.000005532136,0.000860012400},
	{364,0.000206690200,0.000006208245,0.000966592800},
	{365,0.000232100000,0.000006965000,0.001086000000},
	{366,0.000260728000,0.000007813219,0.001220586000},
	{367,0.000293075000,0.000008767336,0.001372729000},
	{368,0.000329388000,0.000009839844,0.001543579000},
	{369,0.000369914000,0.000011043230,0.001734286000},
	{370,0.000414900000,0.000012390000,0.001946000000},
	{371,0.000464158700,0.000013886410,0.002177777000},
	{372,0.000518986000,0.000015557280,0.002435809000},
	{373,0.000581854000,0.000017442960,0.002731953000},
	{374,0.000655234700,0.000019583750,0.003078064000},
	{375,0.000741600000,0.000022020000,0.003486000000},
	{376,0.000845029600,0.000024839650,0.003975227000},
	{377,0.000964526800,0.000028041260,0.004540880000},
	{378,0.001094949000,0.000031531040,0.005158320000},
	{379,0.001231154000,0.000035215210,0.005802907000},
	{380,0.001368000000,0.000039000000,0.006450001000},
	{381,0.001502050000,0.000042826400,0.007083216000},
	{382,0.001642328000,0.000046914600,0.007745488000},
	{383,0.001802382000,0.000051589600,0.008501152000},
	{384,0.001995757000,0.000057176400,0.009414544000},
	{385,0.002236000000,0.000064000000,0.010549990000},
	{386,0.002535385000,0.000072344210,0.011965800000},
	{387,0.002892603000,0.000082212240,0.013655870000},
	{388,0.003300829000,0.000093508160,0.015588050000},
	{389,0.003753236000,0.000106136100,0.017730150000},
	{390,0.004243000000,0.000120000000,0.020050010000},
	{391,0.004762389000,0.000134984000,0.022511360000},
	{392,0.005330048000,0.000151492000,0.025202880000},
	{393,0.005978712000,0.000170208000,0.028279720000},
	{394,0.006741117000,0.000191816000,0.031897040000},
	{395,0.007650000000,0.000217000000,0.036210000000},
	{396,0.008751373000,0.000246906700,0.041437710000},
	{397,0.010028880000,0.000281240000,0.047503720000},
	{398,0.011421700000,0.000318520000,0.054119880000},
	{399,0.012869010000,0.000357266700,0.060998030000},
	{400,0.014310000000,0.000396000000,0.067850010000},
	{401,0.015704430000,0.000433714700,0.074486320000},
	{402,0.017147440000,0.000473024000,0.081361560000},
	{403,0.018781220000,0.000517876000,0.089153640000},
	{404,0.020748010000,0.000572218700,0.098540480000},
	{405,0.023190000000,0.000640000000,0.110200000000},
	{406,0.026207360000,0.000724560000,0.124613300000},
	{407,0.029782480000,0.000825500000,0.141701700000},
	{408,0.033880920000,0.000941160000,0.161303500000},
	{409,0.038468240000,0.001069880000,0.183256800000},
	{410,0.043510000000,0.001210000000,0.207400000000},
	{411,0.048995600000,0.001362091000,0.233692100000},
	{412,0.055022600000,0.001530752000,0.262611400000},
	{413,0.061718800000,0.001720368000,0.294774600000},
	{414,0.069212000000,0.001935323000,0.330798500000},
	{415,0.077630000000,0.002180000000,0.371300000000},
	{416,0.086958110000,0.002454800000,0.416209100000},
	{417,0.097176720000,0.002764000000,0.465464200000},
	{418,0.108406300000,0.003117800000,0.519694800000},
	{419,0.120767200000,0.003526400000,0.579530300000},
	{420,0.134380000000,0.004000000000,0.645600000000},
	{421,0.149358200000,0.004546240000,0.718483800000},
	{422,0.165395700000,0.005159320000,0.796713300000},
	{423,0.181983100000,0.005829280000,0.877845900000},
	{424,0.198611000000,0.006546160000,0.959439000000},
	{425,0.214770000000,0.007300000000,1.039050100000},
	{426,0.230186800000,0.008086507000,1.115367300000},
	{427,0.244879700000,0.008908720000,1.188497100000},
	{428,0.258777300000,0.009767680000,1.258123300000},
	{429,0.271807900000,0.010664430000,1.323929600000},
	{430,0.283900000000,0.011600000000,1.385600000000},
	{431,0.294943800000,0.012573170000,1.442635200000},
	{432,0.304896500000,0.013582720000,1.494803500000},
	{433,0.313787300000,0.014629680000,1.542190300000},
	{434,0.321645400000,0.015715090000,1.584880700000},
	{435,0.328500000000,0.016840000000,1.622960000000},
	{436,0.334351300000,0.018007360000,1.656404800000},
	{437,0.339210100000,0.019214480000,1.685295900000},
	{438,0.343121300000,0.020453920000,1.709874500000},
	{439,0.346129600000,0.021718240000,1.730382100000},
	{440,0.348280000000,0.023000000000,1.747060000000},
	{441,0.349599900000,0.024294610000,1.760044600000},
	{442,0.350147400000,0.025610240000,1.769623300000},
	{443,0.350013000000,0.026958570000,1.776263700000},
	{444,0.349287000000,0.028351250000,1.780433400000},
	{445,0.348060000000,0.029800000000,1.782600000000},
	{446,0.346373300000,0.031310830000,1.782968200000},
	{447,0.344262400000,0.032883680000,1.781699800000},
	{448,0.341808800000,0.034521120000,1.779198200000},
	{449,0.339094100000,0.036225710000,1.775867100000},
	{450,0.336200000000,0.038000000000,1.772110000000},
	{451,0.333197700000,0.039846670000,1.768258900000},
	{452,0.330041100000,0.041768000000,1.764039000000},
	{453,0.326635700000,0.043766000000,1.758943800000},
	{454,0.322886800000,0.045842670000,1.752466300000},
	{455,0.318700000000,0.048000000000,1.744100000000},
	{456,0.314025100000,0.050243680000,1.733559500000},
	{457,0.308884000000,0.052573040000,1.720858100000},
	{458,0.303290400000,0.054980560000,1.705936900000},
	{459,0.297257900000,0.057458720000,1.688737200000},
	{460,0.290800000000,0.060000000000,1.669200000000},
	{461,0.283970100000,0.062601970000,1.647528700000},
	{462,0.276721400000,0.065277520000,1.623412700000},
	{463,0.268917800000,0.068042080000,1.596022300000},
	{464,0.260422700000,0.070911090000,1.564528000000},
	{465,0.251100000000,0.073900000000,1.528100000000},
	{466,0.240847500000,0.077016000000,1.486111400000},
	{467,0.229851200000,0.080266400000,1.439521500000},
	{468,0.218407200000,0.083666800000,1.389879900000},
	{469,0.206811500000,0.087232800000,1.338736200000},
	{470,0.195360000000,0.090980000000,1.287640000000},
	{471,0.184213600000,0.094917550000,1.237422300000},
	{472,0.173327300000,0.099045840000,1.187824300000},
	{473,0.162688100000,0.103367400000,1.138761100000},
	{474,0.152283300000,0.107884600000,1.090148000000},
	{475,0.142100000000,0.112600000000,1.041900000000},
	{476,0.132178600000,0.117532000000,0.994197600000},
	{477,0.122569600000,0.122674400000,0.947347300000},
	{478,0.113275200000,0.127992800000,0.901453100000},
	{479,0.104297900000,0.133452800000,0.856619300000},
	{480,0.095640000000,0.139020000000,0.812950100000},
	{481,0.087299550000,0.144676400000,0.770517300000},
	{482,0.079308040000,0.150469300000,0.729444800000},
	{483,0.071717760000,0.156461900000,0.689913600000},
	{484,0.064580990000,0.162717700000,0.652104900000},
	{485,0.057950010000,0.169300000000,0.616200000000},
	{486,0.051862110000,0.176243100000,0.582328600000},
	{487,0.046281520000,0.183558100000,0.550416200000},
	{488,0.041150880000,0.191273500000,0.520337600000},
	{489,0.036412830000,0.199418000000,0.491967300000},
	{490,0.032010000000,0.208020000000,0.465180000000},
	{491,0.027917200000,0.217119900000,0.439924600000},
	{492,0.024144400000,0.226734500000,0.416183600000},
	{493,0.020687000000,0.236857100000,0.393882200000},
	{494,0.017540400000,0.247481200000,0.372945900000},
	{495,0.014700000000,0.258600000000,0.353300000000},
	{496,0.012161790000,0.270184900000,0.334857800000},
	{497,0.009919960000,0.282293900000,0.317552100000},
	{498,0.007967240000,0.295050500000,0.301337500000},
	{499,0.006296346000,0.308578000000,0.286168600000},
	{500,0.004900000000,0.323000000000,0.272000000000},
	{501,0.003777173000,0.338402100000,0.258817100000},
	{502,0.002945320000,0.354685800000,0.246483800000},
	{503,0.002424880000,0.371698600000,0.234771800000},
	{504,0.002236293000,0.389287500000,0.223453300000},
	{505,0.002400000000,0.407300000000,0.212300000000},
	{506,0.002925520000,0.425629900000,0.201169200000},
	{507,0.003836560000,0.444309600000,0.190119600000},
	{508,0.005174840000,0.463394400000,0.179225400000},
	{509,0.006982080000,0.482939500000,0.168560800000},
	{510,0.009300000000,0.503000000000,0.158200000000},
	{511,0.012149490000,0.523569300000,0.148138300000},
	{512,0.015535880000,0.544512000000,0.138375800000},
	{513,0.019477520000,0.565690000000,0.128994200000},
	{514,0.023992770000,0.586965300000,0.120075100000},
	{515,0.029100000000,0.608200000000,0.111700000000},
	{516,0.034814850000,0.629345600000,0.103904800000},
	{517,0.041120160000,0.650306800000,0.096667480000},
	{518,0.047985040000,0.670875200000,0.089982720000},
	{519,0.055378610000,0.690842400000,0.083845310000},
	{520,0.063270000000,0.710000000000,0.078249990000},
	{521,0.071635010000,0.728185200000,0.073208990000},
	{522,0.080462240000,0.745463600000,0.068678160000},
	{523,0.089739960000,0.761969400000,0.064567840000},
	{524,0.099456450000,0.777836800000,0.060788350000},
	{525,0.109600000000,0.793200000000,0.057250010000},
	{526,0.120167400000,0.808110400000,0.053904350000},
	{527,0.131114500000,0.822496200000,0.050746640000},
	{528,0.142367900000,0.836306800000,0.047752760000},
	{529,0.153854200000,0.849491600000,0.044898590000},
	{530,0.165500000000,0.862000000000,0.042160000000},
	{531,0.177257100000,0.873810800000,0.039507280000},
	{532,0.189140000000,0.884962400000,0.036935640000},
	{533,0.201169400000,0.895493600000,0.034458360000},
	{534,0.213365800000,0.905443200000,0.032088720000},
	{535,0.225749900000,0.914850100000,0.029840000000},
	{536,0.238320900000,0.923734800000,0.027711810000},
	{537,0.251066800000,0.932092400000,0.025694440000},
	{538,0.263992200000,0.939922600000,0.023787160000},
	{539,0.277101700000,0.947225200000,0.021989250000},
	{540,0.290400000000,0.954000000000,0.020300000000},
	{541,0.303891200000,0.960256100000,0.018718050000},
	{542,0.317572600000,0.966007400000,0.017240360000},
	{543,0.331438400000,0.971260600000,0.015863640000},
	{544,0.345482800000,0.976022500000,0.014584610000},
	{545,0.359700000000,0.980300000000,0.013400000000},
	{546,0.374083900000,0.984092400000,0.012307230000},
	{547,0.388639600000,0.987418200000,0.011301880000},
	{548,0.403378400000,0.990312800000,0.010377920000},
	{549,0.418311500000,0.992811600000,0.009529306000},
	{550,0.433449900000,0.994950100000,0.008749999000},
	{551,0.448795300000,0.996710800000,0.008035200000},
	{552,0.464336000000,0.998098300000,0.007381600000},
	{553,0.480064000000,0.999112000000,0.006785400000},
	{554,0.495971300000,0.999748200000,0.006242800000},
	{555,0.512050100000,1.000000000000,0.005749999000},
	{556,0.528295900000,0.999856700000,0.005303600000},
	{557,0.544691600000,0.999304600000,0.004899800000},
	{558,0.561209400000,0.998325500000,0.004534200000},
	{559,0.577821500000,0.996898700000,0.004202400000},
	{560,0.594500000000,0.995000000000,0.003900000000},
	{561,0.611220900000,0.992600500000,0.003623200000},
	{562,0.627975800000,0.989742600000,0.003370600000},
	{563,0.644760200000,0.986444400000,0.003141400000},
	{564,0.661569700000,0.982724100000,0.002934800000},
	{565,0.678400000000,0.978600000000,0.002749999000},
	{566,0.695239200000,0.974083700000,0.002585200000},
	{567,0.712058600000,0.969171200000,0.002438600000},
	{568,0.728828400000,0.963856800000,0.002309400000},
	{569,0.745518800000,0.958134900000,0.002196800000},
	{570,0.762100000000,0.952000000000,0.002100000000},
	{571,0.778543200000,0.945450400000,0.002017733000},
	{572,0.794825600000,0.938499200000,0.001948200000},
	{573,0.810926400000,0.931162800000,0.001889800000},
	{574,0.826824800000,0.923457600000,0.001840933000},
	{575,0.842500000000,0.915400000000,0.001800000000},
	{576,0.857932500000,0.907006400000,0.001766267000},
	{577,0.873081600000,0.898277200000,0.001737800000},
	{578,0.887894400000,0.889204800000,0.001711200000},
	{579,0.902318100000,0.879781600000,0.001683067000},
	{580,0.916300000000,0.870000000000,0.001650001000},
	{581,0.929799500000,0.859861300000,0.001610133000},
	{582,0.942798400000,0.849392000000,0.001564400000},
	{583,0.955277600000,0.838622000000,0.001513600000},
	{584,0.967217900000,0.827581300000,0.001458533000},
	{585,0.978600000000,0.816300000000,0.001400000000},
	{586,0.989385600000,0.804794700000,0.001336667000},
	{587,0.999548800000,0.793082000000,0.001270000000},
	{588,1.009089200000,0.781192000000,0.001205000000},
	{589,1.018006400000,0.769154700000,0.001146667000},
	{590,1.026300000000,0.757000000000,0.001100000000},
	{591,1.033982700000,0.744754100000,0.001068800000},
	{592,1.040986000000,0.732422400000,0.001049400000},
	{593,1.047188000000,0.720003600000,0.001035600000},
	{594,1.052466700000,0.707496500000,0.001021200000},
	{595,1.056700000000,0.694900000000,0.001000000000},
	{596,1.059794400000,0.682219200000,0.000968640000},
	{597,1.061799200000,0.669471600000,0.000929920000},
	{598,1.062806800000,0.656674400000,0.000886880000},
	{599,1.062909600000,0.643844800000,0.000842560000},
	{600,1.062200000000,0.631000000000,0.000800000000},
	{601,1.060735200000,0.618155500000,0.000760960000},
	{602,1.058443600000,0.605314400000,0.000723680000},
	{603,1.055224400000,0.592475600000,0.000685920000},
	{604,1.050976800000,0.579637900000,0.000645440000},
	{605,1.045600000000,0.566800000000,0.000600000000},
	{606,1.039036900000,0.553961100000,0.000547866700},
	{607,1.031360800000,0.541137200000,0.000491600000},
	{608,1.022666200000,0.528352800000,0.000435400000},
	{609,1.013047700000,0.515632300000,0.000383466700},
	{610,1.002600000000,0.503000000000,0.000340000000},
	{611,0.991367500000,0.490468800000,0.000307253300},
	{612,0.979331400000,0.478030400000,0.000283160000},
	{613,0.966491600000,0.465677600000,0.000265440000},
	{614,0.952847900000,0.453403200000,0.000251813300},
	{615,0.938400000000,0.441200000000,0.000240000000},
	{616,0.923194000000,0.429080000000,0.000229546700},
	{617,0.907244000000,0.417036000000,0.000220640000},
	{618,0.890502000000,0.405032000000,0.000211960000},
	{619,0.872920000000,0.393032000000,0.000202186700},
	{620,0.854449900000,0.381000000000,0.000190000000},
	{621,0.835084000000,0.368918400000,0.000174213300},
	{622,0.814946000000,0.356827200000,0.000155640000},
	{623,0.794186000000,0.344776800000,0.000135960000},
	{624,0.772954000000,0.332817600000,0.000116853300},
	{625,0.751400000000,0.321000000000,0.000100000000},
	{626,0.729583600000,0.309338100000,0.000086133330},
	{627,0.707588800000,0.297850400000,0.000074600000},
	{628,0.685602200000,0.286593600000,0.000065000000},
	{629,0.663810400000,0.275624500000,0.000056933330},
	{630,0.642400000000,0.265000000000,0.000049999990},
	{631,0.621514900000,0.254763200000,0.000044160000},
	{632,0.601113800000,0.244889600000,0.000039480000},
	{633,0.581105200000,0.235334400000,0.000035720000},
	{634,0.561397700000,0.226052800000,0.000032640000},
	{635,0.541900000000,0.217000000000,0.000030000000},
	{636,0.522599500000,0.208161600000,0.000027653330},
	{637,0.503546400000,0.199548800000,0.000025560000},
	{638,0.484743600000,0.191155200000,0.000023640000},
	{639,0.466193900000,0.182974400000,0.000021813330},
	{640,0.447900000000,0.175000000000,0.000020000000},
	{641,0.429861300000,0.167223500000,0.000018133330},
	{642,0.412098000000,0.159646400000,0.000016200000},
	{643,0.394644000000,0.152277600000,0.000014200000},
	{644,0.377533300000,0.145125900000,0.000012133330},
	{645,0.360800000000,0.138200000000,0.000010000000},
	{646,0.344456300000,0.131500300000,0.000007733333},
	{647,0.328516800000,0.125024800000,0.000005400000},
	{648,0.313019200000,0.118779200000,0.000003200000},
	{649,0.298001100000,0.112769100000,0.000001333333},
	{650,0.283500000000,0.107000000000,0.000000000000},
	{651,0.269544800000,0.101476200000,0.000000000000},
	{652,0.256118400000,0.096188640000,0.000000000000},
	{653,0.243189600000,0.091122960000,0.000000000000},
	{654,0.230727200000,0.086264850000,0.000000000000},
	{655,0.218700000000,0.081600000000,0.000000000000},
	{656,0.207097100000,0.077120640000,0.000000000000},
	{657,0.195923200000,0.072825520000,0.000000000000},
	{658,0.185170800000,0.068710080000,0.000000000000},
	{659,0.174832300000,0.064769760000,0.000000000000},
	{660,0.164900000000,0.061000000000,0.000000000000},
	{661,0.155366700000,0.057396210000,0.000000000000},
	{662,0.146230000000,0.053955040000,0.000000000000},
	{663,0.137490000000,0.050673760000,0.000000000000},
	{664,0.129146700000,0.047549650000,0.000000000000},
	{665,0.121200000000,0.044580000000,0.000000000000},
	{666,0.113639700000,0.041758720000,0.000000000000},
	{667,0.106465000000,0.039084960000,0.000000000000},
	{668,0.099690440000,0.036563840000,0.000000000000},
	{669,0.093330610000,0.034200480000,0.000000000000},
	{670,0.087400000000,0.032000000000,0.000000000000},
	{671,0.081900960000,0.029962610000,0.000000000000},
	{672,0.076804280000,0.028076640000,0.000000000000},
	{673,0.072077120000,0.026329360000,0.000000000000},
	{674,0.067686640000,0.024708050000,0.000000000000},
	{675,0.063600000000,0.023200000000,0.000000000000},
	{676,0.059806850000,0.021800770000,0.000000000000},
	{677,0.056282160000,0.020501120000,0.000000000000},
	{678,0.052971040000,0.019281080000,0.000000000000},
	{679,0.049818610000,0.018120690000,0.000000000000},
	{680,0.046770000000,0.017000000000,0.000000000000},
	{681,0.043784050000,0.015903790000,0.000000000000},
	{682,0.040875360000,0.014837180000,0.000000000000},
	{683,0.038072640000,0.013810680000,0.000000000000},
	{684,0.035404610000,0.012834780000,0.000000000000},
	{685,0.032900000000,0.011920000000,0.000000000000},
	{686,0.030564190000,0.011068310000,0.000000000000},
	{687,0.028380560000,0.010273390000,0.000000000000},
	{688,0.026344840000,0.009533311000,0.000000000000},
	{689,0.024452750000,0.008846157000,0.000000000000},
	{690,0.022700000000,0.008210000000,0.000000000000},
	{691,0.021084290000,0.007623781000,0.000000000000},
	{692,0.019599880000,0.007085424000,0.000000000000},
	{693,0.018237320000,0.006591476000,0.000000000000},
	{694,0.016987170000,0.006138485000,0.000000000000},
	{695,0.015840000000,0.005723000000,0.000000000000},
	{696,0.014790640000,0.005343059000,0.000000000000},
	{697,0.013831320000,0.004995796000,0.000000000000},
	{698,0.012948680000,0.004676404000,0.000000000000},
	{699,0.012129200000,0.004380075000,0.000000000000},
	{700,0.011359160000,0.004102000000,0.000000000000},
	{701,0.010629350000,0.003838453000,0.000000000000},
	{702,0.009938846000,0.003589099000,0.000000000000},
	{703,0.009288422000,0.003354219000,0.000000000000},
	{704,0.008678854000,0.003134093000,0.000000000000},
	{705,0.008110916000,0.002929000000,0.000000000000},
	{706,0.007582388000,0.002738139000,0.000000000000},
	{707,0.007088746000,0.002559876000,0.000000000000},
	{708,0.006627313000,0.002393244000,0.000000000000},
	{709,0.006195408000,0.002237275000,0.000000000000},
	{710,0.005790346000,0.002091000000,0.000000000000},
	{711,0.005409826000,0.001953587000,0.000000000000},
	{712,0.005052583000,0.001824580000,0.000000000000},
	{713,0.004717512000,0.001703580000,0.000000000000},
	{714,0.004403507000,0.001590187000,0.000000000000},
	{715,0.004109457000,0.001484000000,0.000000000000},
	{716,0.003833913000,0.001384496000,0.000000000000},
	{717,0.003575748000,0.001291268000,0.000000000000},
	{718,0.003334342000,0.001204092000,0.000000000000},
	{719,0.003109075000,0.001122744000,0.000000000000},
	{720,0.002899327000,0.001047000000,0.000000000000},
	{721,0.002704348000,0.000976589600,0.000000000000},
	{722,0.002523020000,0.000911108800,0.000000000000},
	{723,0.002354168000,0.000850133200,0.000000000000},
	{724,0.002196616000,0.000793238400,0.000000000000},
	{725,0.002049190000,0.000740000000,0.000000000000},
	{726,0.001910960000,0.000690082700,0.000000000000},
	{727,0.001781438000,0.000643310000,0.000000000000},
	{728,0.001660110000,0.000599496000,0.000000000000},
	{729,0.001546459000,0.000558454700,0.000000000000},
	{730,0.001439971000,0.000520000000,0.000000000000},
	{731,0.001340042000,0.000483913600,0.000000000000},
	{732,0.001246275000,0.000450052800,0.000000000000},
	{733,0.001158471000,0.000418345200,0.000000000000},
	{734,0.001076430000,0.000388718400,0.000000000000},
	{735,0.000999949300,0.000361100000,0.000000000000},
	{736,0.000928735800,0.000335383500,0.000000000000},
	{737,0.000862433200,0.000311440400,0.000000000000},
	{738,0.000800750300,0.000289165600,0.000000000000},
	{739,0.000743396000,0.000268453900,0.000000000000},
	{740,0.000690078600,0.000249200000,0.000000000000},
	{741,0.000640515600,0.000231301900,0.000000000000},
	{742,0.000594502100,0.000214685600,0.000000000000},
	{743,0.000551864600,0.000199288400,0.000000000000},
	{744,0.000512429000,0.000185047500,0.000000000000},
	{745,0.000476021300,0.000171900000,0.000000000000},
	{746,0.000442453600,0.000159778100,0.000000000000},
	{747,0.000411511700,0.000148604400,0.000000000000},
	{748,0.000382981400,0.000138301600,0.000000000000},
	{749,0.000356649100,0.000128792500,0.000000000000},
	{750,0.000332301100,0.000120000000,0.000000000000},
	{751,0.000309758600,0.000111859500,0.000000000000},
	{752,0.000288887100,0.000104322400,0.000000000000},
	{753,0.000269539400,0.000097335600,0.000000000000},
	{754,0.000251568200,0.000090845870,0.000000000000},
	{755,0.000234826100,0.000084800000,0.000000000000},
	{756,0.000219171000,0.000079146670,0.000000000000},
	{757,0.000204525800,0.000073858000,0.000000000000},
	{758,0.000190840500,0.000068916000,0.000000000000},
	{759,0.000178065400,0.000064302670,0.000000000000},
	{760,0.000166150500,0.000060000000,0.000000000000},
	{761,0.000155023600,0.000055981870,0.000000000000},
	{762,0.000144621900,0.000052225600,0.000000000000},
	{763,0.000134909800,0.000048718400,0.000000000000},
	{764,0.000125852000,0.000045447470,0.000000000000},
	{765,0.000117413000,0.000042400000,0.000000000000},
	{766,0.000109551500,0.000039561040,0.000000000000},
	{767,0.000102224500,0.000036915120,0.000000000000},
	{768,0.000095394450,0.000034448680,0.000000000000},
	{769,0.000089023900,0.000032148160,0.000000000000},
	{770,0.000083075270,0.000030000000,0.000000000000},
	{771,0.000077512690,0.000027991250,0.000000000000},
	{772,0.000072313040,0.000026113560,0.000000000000},
	{773,0.000067457780,0.000024360240,0.000000000000},
	{774,0.000062928440,0.000022724610,0.000000000000},
	{775,0.000058706520,0.000021200000,0.000000000000},
	{776,0.000054770280,0.000019778550,0.000000000000},
	{777,0.000051099180,0.000018452850,0.000000000000},
	{778,0.000047676540,0.000017216870,0.000000000000},
	{779,0.000044485670,0.000016064590,0.000000000000},
	{780,0.000041509940,0.000014990000,0.000000000000},
	{781,0.000038733240,0.000013987280,0.000000000000},
	{782,0.000036142030,0.000013051550,0.000000000000},
	{783,0.000033723520,0.000012178180,0.000000000000},
	{784,0.000031464870,0.000011362540,0.000000000000},
	{785,0.000029353260,0.000010600000,0.000000000000},
	{786,0.000027375730,0.000009885877,0.000000000000},
	{787,0.000025524330,0.000009217304,0.000000000000},
	{788,0.000023793760,0.000008592362,0.000000000000},
	{789,0.000022178700,0.000008009133,0.000000000000},
	{790,0.000020673830,0.000007465700,0.000000000000},
	{791,0.000019272260,0.000006959567,0.000000000000},
	{792,0.000017966400,0.000006487995,0.000000000000},
	{793,0.000016749910,0.000006048699,0.000000000000},
	{794,0.000015616480,0.000005639396,0.000000000000},
	{795,0.000014559770,0.000005257800,0.000000000000},
	{796,0.000013573870,0.000004901771,0.000000000000},
	{797,0.000012654360,0.000004569720,0.000000000000},
	{798,0.000011797230,0.000004260194,0.000000000000},
	{799,0.000010998440,0.000003971739,0.000000000000},
	{800,0.000010253980,0.000003702900,0.000000000000},
	{801,0.000009559646,0.000003452163,0.000000000000},
	{802,0.000008912044,0.000003218302,0.000000000000},
	{803,0.000008308358,0.000003000300,0.000000000000},
	{804,0.000007745769,0.000002797139,0.000000000000},
	{805,0.000007221456,0.000002607800,0.000000000000},
	{806,0.000006732475,0.000002431220,0.000000000000},
	{807,0.000006276423,0.000002266531,0.000000000000},
	{808,0.000005851304,0.000002113013,0.000000000000},
	{809,0.000005455118,0.000001969943,0.000000000000},
	{810,0.000005085868,0.000001836600,0.000000000000},
	{811,0.000004741466,0.000001712230,0.000000000000},
	{812,0.000004420236,0.000001596228,0.000000000000},
	{813,0.000004120783,0.000001488090,0.000000000000},
	{814,0.000003841716,0.000001387314,0.000000000000},
	{815,0.000003581652,0.000001293400,0.000000000000},
	{816,0.000003339127,0.000001205820,0.000000000000},
	{817,0.000003112949,0.000001124143,0.000000000000},
	{818,0.000002902121,0.000001048009,0.000000000000},
	{819,0.000002705645,0.000000977058,0.000000000000},
	{820,0.000002522525,0.000000910930,0.000000000000},
	{821,0.000002351726,0.000000849251,0.000000000000},
	{822,0.000002192415,0.000000791721,0.000000000000},
	{823,0.000002043902,0.000000738090,0.000000000000},
	{824,0.000001905497,0.000000688110,0.000000000000},
	{825,0.000001776509,0.000000641530,0.000000000000},
	{826,0.000001656215,0.000000598090,0.000000000000},
	{827,0.000001544022,0.000000557575,0.000000000000},
	{828,0.000001439440,0.000000519808,0.000000000000},
	{829,0.000001341977,0.000000484612,0.000000000000},
	{830,0.000001251141,0.000000451810,0.000000000000},
	{-1, 0}
};
void cmf_get_range(int &lambda_first, int &lambda_last) {
	for (int i = 0;; ++i) {
		if (cmf_1031[i].lambda == -1) {
			if (i > 0) {
				lambda_first = cmf_1031[0].lambda, lambda_last = cmf_1031[i - 1].lambda;
			} else {
				lambda_first = lambda_last = cmf_1031[0].lambda;
			}
			return;
		}
	}
}

// ez̔g͗\ߓ}đĂ
double cmf_convolution_y(spectral_item *spectral) {
	double y = 0;
	for (int i = 0; cmf_1031[i].lambda > 0; ++i) {
		y += cmf_1031[i].y * spectral[i].v;
	}
	return y;
}

double cmf_convolution_xyz(spectral_item *spectral1, spectral_item *spectral2, double &x, double &y, double &z) {
	x = y = z = 0;
	for (int i = 0; cmf_1031[i].lambda > 0; ++i) {
		auto &cmf_item = cmf_1031[i];
		double sp = spectral1[i].v * spectral2[i].v;
		x += cmf_item.x * sp;
		y += cmf_item.y * sp;
		z += cmf_item.z * sp;
	}
	return x + y + z;
}

// CIEW̃XyNg
// https://github.com/colour-science/colour/blob/develop/colour/colorimetry/datasets/illuminants/sds.py
// 
// The following *CIE* illuminants are available :
// -CIE Standard Illuminant A
// - CIE Illuminant B
// - CIE Illuminant C
// - CIE Illuminant D Series(D50, D55, D60, D65, D75)
// - CIE Illuminant E
// - Illuminants F Series(FL1, FL2, FL3, FL4, FL5, FL6, FL7, FL8, FL9, FL10,
// 					   FL11, FL12, FL3.1, FL3.10, FL3.11, FL3.12, FL3.13, FL3.14, FL3.15, FL3.2,
// 					   FL3.3, FL3.4, FL3.5, FL3.6, FL3.7, FL3.8, FL3.9)
// 	- High Pressure Discharge Lamps(HP1, HP2, HP3, HP4, HP5)
// 	- Typical LED illuminants(LED - B1, LED - B2, LED - B3, LED - B4, LED - B5, LED - BH1,
// 							  LED - RGB1, LED - V1, LED - V2)
// 	- Recommended indoor illuminants ID65 and ID50.
// 	The following *ISO* illuminants are available :
// - ISO 7589 Photographic Daylight
// - ISO 7589 Sensitometric Daylight
// - ISO 7589 Studio Tungsten
// - ISO 7589 Sensitometric Studio Tungsten
// - ISO 7589 Photoflood
// - ISO 7589 Sensitometric Photoflood
// - ISO 7589 Sensitometric Printer
// 
// Copyright 2013 Colour Developers
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met :
// *Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
// * Neither the name of the Colour Developers nor the
// names of its contributors may be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED.IN NO EVENT SHALL COLOUR DEVELOPERS BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

spectral_item 
std_illuminant_A[] = {
	{300, 0.930483},
	{305, 1.128210},
	{310, 1.357690},
	{315, 1.622190},
	{320, 1.925080},
	{325, 2.269800},
	{330, 2.659810},
	{335, 3.098610},
	{340, 3.589680},
	{345, 4.136480},
	{350, 4.742380},
	{355, 5.410700},
	{360, 6.144620},
	{365, 6.947200},
	{370, 7.821350},
	{375, 8.769800},
	{380, 9.795100},
	{385, 10.899600},
	{390, 12.085300},
	{395, 13.354300},
	{400, 14.708000},
	{405, 16.148000},
	{410, 17.675300},
	{415, 19.290700},
	{420, 20.995000},
	{425, 22.788300},
	{430, 24.670900},
	{435, 26.642500},
	{440, 28.702700},
	{445, 30.850800},
	{450, 33.085900},
	{455, 35.406800},
	{460, 37.812100},
	{465, 40.300200},
	{470, 42.869300},
	{475, 45.517400},
	{480, 48.242300},
	{485, 51.041800},
	{490, 53.913200},
	{495, 56.853900},
	{500, 59.861100},
	{505, 62.932000},
	{510, 66.063500},
	{515, 69.252500},
	{520, 72.495900},
	{525, 75.790300},
	{530, 79.132600},
	{535, 82.519300},
	{540, 85.947000},
	{545, 89.412400},
	{550, 92.912000},
	{555, 96.442300},
	{560, 100.000000},
	{565, 103.582000},
	{570, 107.184000},
	{575, 110.803000},
	{580, 114.436000},
	{585, 118.080000},
	{590, 121.731000},
	{595, 125.386000},
	{600, 129.043000},
	{605, 132.697000},
	{610, 136.346000},
	{615, 139.988000},
	{620, 143.618000},
	{625, 147.235000},
	{630, 150.836000},
	{635, 154.418000},
	{640, 157.979000},
	{645, 161.516000},
	{650, 165.028000},
	{655, 168.510000},
	{660, 171.963000},
	{665, 175.383000},
	{670, 178.769000},
	{675, 182.118000},
	{680, 185.429000},
	{685, 188.701000},
	{690, 191.931000},
	{695, 195.118000},
	{700, 198.261000},
	{705, 201.359000},
	{710, 204.409000},
	{715, 207.411000},
	{720, 210.365000},
	{725, 213.268000},
	{730, 216.120000},
	{735, 218.920000},
	{740, 221.667000},
	{745, 224.361000},
	{750, 227.000000},
	{755, 229.585000},
	{760, 232.115000},
	{765, 234.589000},
	{770, 237.008000},
	{775, 239.370000},
	{780, 241.675000},
	{-1, 0}
},
std_illuminant_B[] = {
	{320, 0.02},
	{325, 0.26},
	{330, 0.50},
	{335, 1.45},
	{340, 2.40},
	{345, 4.00},
	{350, 5.60},
	{355, 7.60},
	{360, 9.60},
	{365, 12.40},
	{370, 15.20},
	{375, 18.80},
	{380, 22.40},
	{385, 26.85},
	{390, 31.30},
	{395, 36.18},
	{400, 41.30},
	{405, 46.62},
	{410, 52.10},
	{415, 57.70},
	{420, 63.20},
	{425, 68.37},
	{430, 73.10},
	{435, 77.31},
	{440, 80.80},
	{445, 83.44},
	{450, 85.40},
	{455, 86.88},
	{460, 88.30},
	{465, 90.08},
	{470, 92.00},
	{475, 93.75},
	{480, 95.20},
	{485, 96.23},
	{490, 96.50},
	{495, 95.71},
	{500, 94.20},
	{505, 92.37},
	{510, 90.70},
	{515, 89.95},
	{520, 89.50},
	{525, 90.43},
	{530, 92.20},
	{535, 94.46},
	{540, 96.90},
	{545, 99.16},
	{550, 101.00},
	{555, 102.20},
	{560, 102.80},
	{565, 102.92},
	{570, 102.60},
	{575, 101.90},
	{580, 101.00},
	{585, 100.07},
	{590, 99.20},
	{595, 98.44},
	{600, 98.00},
	{605, 98.08},
	{610, 98.50},
	{615, 99.06},
	{620, 99.70},
	{625, 100.36},
	{630, 101.00},
	{635, 101.56},
	{640, 102.20},
	{645, 103.05},
	{650, 103.90},
	{655, 104.59},
	{660, 105.00},
	{665, 105.08},
	{670, 104.90},
	{675, 104.55},
	{680, 103.90},
	{685, 102.84},
	{690, 101.60},
	{695, 100.38},
	{700, 99.10},
	{705, 97.70},
	{710, 96.20},
	{715, 94.60},
	{720, 92.90},
	{725, 91.10},
	{730, 89.40},
	{735, 88.00},
	{740, 86.90},
	{745, 85.90},
	{750, 85.20},
	{755, 84.80},
	{760, 84.70},
	{765, 84.90},
	{770, 85.40},
	{775, 86.10},
	{780, 87.00},
	{-1,0}
},
std_illuminant_C[] = {
	{300, 0.00},
	{305, 0.00},
	{310, 0.00},
	{315, 0.00},
	{320, 0.01},
	{325, 0.20},
	{330, 0.40},
	{335, 1.55},
	{340, 2.70},
	{345, 4.85},
	{350, 7.00},
	{355, 9.95},
	{360, 12.90},
	{365, 17.20},
	{370, 21.40},
	{375, 27.50},
	{380, 33.00},
	{385, 39.92},
	{390, 47.40},
	{395, 55.17},
	{400, 63.30},
	{405, 71.81},
	{410, 80.60},
	{415, 89.53},
	{420, 98.10},
	{425, 105.80},
	{430, 112.40},
	{435, 117.75},
	{440, 121.50},
	{445, 123.45},
	{450, 124.00},
	{455, 123.60},
	{460, 123.10},
	{465, 123.30},
	{470, 123.80},
	{475, 124.09},
	{480, 123.90},
	{485, 122.92},
	{490, 120.70},
	{495, 116.90},
	{500, 112.10},
	{505, 106.98},
	{510, 102.30},
	{515, 98.81},
	{520, 96.90},
	{525, 96.78},
	{530, 98.00},
	{535, 99.94},
	{540, 102.10},
	{545, 103.95},
	{550, 105.20},
	{555, 105.67},
	{560, 105.30},
	{565, 104.11},
	{570, 102.30},
	{575, 100.15},
	{580, 97.80},
	{585, 95.43},
	{590, 93.20},
	{595, 91.22},
	{600, 89.70},
	{605, 88.83},
	{610, 88.40},
	{615, 88.19},
	{620, 88.10},
	{625, 88.06},
	{630, 88.00},
	{635, 87.86},
	{640, 87.80},
	{645, 87.99},
	{650, 88.20},
	{655, 88.20},
	{660, 87.90},
	{665, 87.22},
	{670, 86.30},
	{675, 85.30},
	{680, 84.00},
	{685, 82.21},
	{690, 80.20},
	{695, 78.24},
	{700, 76.30},
	{705, 74.36},
	{710, 72.40},
	{715, 70.40},
	{720, 68.30},
	{725, 66.30},
	{730, 64.40},
	{735, 62.80},
	{740, 61.50},
	{745, 60.20},
	{750, 59.20},
	{755, 58.50},
	{760, 58.10},
	{765, 58.00},
	{770, 58.20},
	{775, 58.50},
	{780, 59.10},
	{-1, 0}
},
std_illuminant_D50[] = {
	{300, 0.019},
	{305, 1.035},
	{310, 2.051},
	{315, 4.914},
	{320, 7.778},
	{325, 11.263},
	{330, 14.748},
	{335, 16.348},
	{340, 17.948},
	{345, 19.479},
	{350, 21.010},
	{355, 22.476},
	{360, 23.942},
	{365, 25.451},
	{370, 26.961},
	{375, 25.724},
	{380, 24.488},
	{385, 27.179},
	{390, 29.871},
	{395, 39.589},
	{400, 49.308},
	{405, 52.910},
	{410, 56.513},
	{415, 58.273},
	{420, 60.034},
	{425, 58.926},
	{430, 57.818},
	{435, 66.321},
	{440, 74.825},
	{445, 81.036},
	{450, 87.247},
	{455, 88.930},
	{460, 90.612},
	{465, 90.990},
	{470, 91.368},
	{475, 93.238},
	{480, 95.109},
	{485, 93.536},
	{490, 91.963},
	{495, 93.843},
	{500, 95.724},
	{505, 96.169},
	{510, 96.613},
	{515, 96.871},
	{520, 97.129},
	{525, 99.614},
	{530, 102.099},
	{535, 101.427},
	{540, 100.755},
	{545, 101.536},
	{550, 102.317},
	{555, 101.159},
	{560, 100.000},
	{565, 98.868},
	{570, 97.735},
	{575, 98.327},
	{580, 98.918},
	{585, 96.208},
	{590, 93.499},
	{595, 95.593},
	{600, 97.688},
	{605, 98.478},
	{610, 99.269},
	{615, 99.155},
	{620, 99.042},
	{625, 97.382},
	{630, 95.722},
	{635, 97.290},
	{640, 98.857},
	{645, 97.262},
	{650, 95.667},
	{655, 96.929},
	{660, 98.190},
	{665, 100.597},
	{670, 103.003},
	{675, 101.068},
	{680, 99.133},
	{685, 93.257},
	{690, 87.381},
	{695, 89.492},
	{700, 91.604},
	{705, 92.246},
	{710, 92.889},
	{715, 84.872},
	{720, 76.854},
	{725, 81.683},
	{730, 86.511},
	{735, 89.546},
	{740, 92.580},
	{745, 85.405},
	{750, 78.230},
	{755, 67.961},
	{760, 57.692},
	{765, 70.307},
	{770, 82.923},
	{775, 80.599},
	{780, 78.274},
	{-1,0}
},
std_illuminant_D55[] = {
	{300, 0.024},
	{305, 1.048},
	{310, 2.072},
	{315, 6.648},
	{320, 11.224},
	{325, 15.936},
	{330, 20.647},
	{335, 22.266},
	{340, 23.885},
	{345, 25.851},
	{350, 27.817},
	{355, 29.219},
	{360, 30.621},
	{365, 32.464},
	{370, 34.308},
	{375, 33.446},
	{380, 32.584},
	{385, 35.335},
	{390, 38.087},
	{395, 49.518},
	{400, 60.949},
	{405, 64.751},
	{410, 68.554},
	{415, 70.065},
	{420, 71.577},
	{425, 69.746},
	{430, 67.914},
	{435, 76.760},
	{440, 85.605},
	{445, 91.799},
	{450, 97.993},
	{455, 99.228},
	{460, 100.463},
	{465, 100.188},
	{470, 99.913},
	{475, 101.326},
	{480, 102.739},
	{485, 100.409},
	{490, 98.078},
	{495, 99.379},
	{500, 100.680},
	{505, 100.688},
	{510, 100.695},
	{515, 100.341},
	{520, 99.987},
	{525, 102.098},
	{530, 104.210},
	{535, 103.156},
	{540, 102.102},
	{545, 102.535},
	{550, 102.968},
	{555, 101.484},
	{560, 100.000},
	{565, 98.608},
	{570, 97.216},
	{575, 97.482},
	{580, 97.749},
	{585, 94.590},
	{590, 91.432},
	{595, 92.926},
	{600, 94.419},
	{605, 94.780},
	{610, 95.140},
	{615, 94.680},
	{620, 94.220},
	{625, 92.334},
	{630, 90.448},
	{635, 91.389},
	{640, 92.330},
	{645, 90.592},
	{650, 88.854},
	{655, 89.586},
	{660, 90.317},
	{665, 92.133},
	{670, 93.950},
	{675, 91.953},
	{680, 89.956},
	{685, 84.817},
	{690, 79.677},
	{695, 81.258},
	{700, 82.840},
	{705, 83.842},
	{710, 84.844},
	{715, 77.539},
	{720, 70.235},
	{725, 74.768},
	{730, 79.301},
	{735, 82.147},
	{740, 84.993},
	{745, 78.437},
	{750, 71.880},
	{755, 62.337},
	{760, 52.793},
	{765, 64.360},
	{770, 75.927},
	{775, 73.872},
	{780, 71.818},
	{-1, 0}
},
std_illuminant_D60[] = {
	{300, 0.029300000000000},
	{305, 1.289900000000000},
	{310, 2.550500000000000},
	{315, 9.041250000000000},
	{320, 15.532000000000000},
	{325, 21.966749999999998},
	{330, 28.401499999999999},
	{335, 29.958349999999996},
	{340, 31.515199999999993},
	{345, 33.784249999999993},
	{350, 36.053299999999993},
	{355, 37.231000000000002},
	{360, 38.408700000000003},
	{365, 40.673299999999998},
	{370, 42.937899999999999},
	{375, 42.088699999999989},
	{380, 41.239499999999992},
	{385, 43.844649999999994},
	{390, 46.449799999999996},
	{395, 59.301949999999998},
	{400, 72.154099999999985},
	{405, 76.222049999999996},
	{410, 80.289999999999992},
	{415, 81.534099999999995},
	{420, 82.778199999999998},
	{425, 80.177449999999993},
	{430, 77.576700000000002},
	{435, 86.598399999999998},
	{440, 95.620100000000008},
	{445, 101.762249999999995},
	{450, 107.904399999999995},
	{455, 108.711099999999988},
	{460, 109.517799999999994},
	{465, 108.622950000000003},
	{470, 107.728099999999998},
	{475, 108.691100000000006},
	{480, 109.654100000000000},
	{485, 106.669200000000004},
	{490, 103.684299999999993},
	{495, 104.449399999999997},
	{500, 105.214499999999987},
	{505, 104.814899999999994},
	{510, 104.415300000000002},
	{515, 103.469750000000005},
	{520, 102.524200000000008},
	{525, 104.290850000000006},
	{530, 106.057500000000005},
	{535, 104.685499999999990},
	{540, 103.313499999999991},
	{545, 103.426649999999995},
	{550, 103.539800000000014},
	{555, 101.769899999999993},
	{560, 100.000000000000000},
	{565, 98.375900000000001},
	{570, 96.751799999999989},
	{575, 96.731899999999996},
	{580, 96.712000000000003},
	{585, 93.295199999999994},
	{590, 89.878399999999999},
	{595, 90.907100000000000},
	{600, 91.935800000000000},
	{605, 91.975850000000008},
	{610, 92.015900000000002},
	{615, 91.284099999999995},
	{620, 90.552300000000002},
	{625, 88.488850000000014},
	{630, 86.425399999999996},
	{635, 86.933099999999996},
	{640, 87.440799999999996},
	{645, 85.631000000000000},
	{650, 83.821200000000005},
	{655, 84.180300000000003},
	{660, 84.539400000000001},
	{665, 85.911799999999999},
	{670, 87.284199999999998},
	{675, 85.272999999999996},
	{680, 83.261799999999994},
	{685, 78.628749999999997},
	{690, 73.995699999999999},
	{695, 75.204800000000006},
	{700, 76.413899999999998},
	{705, 77.643449999999987},
	{710, 78.873000000000005},
	{715, 72.098499999999987},
	{720, 65.323999999999998},
	{725, 69.635199999999998},
	{730, 73.946400000000011},
	{735, 76.652699999999996},
	{740, 79.358999999999995},
	{745, 73.262649999999994},
	{750, 67.166299999999993},
	{755, 58.165050000000001},
	{760, 49.163800000000002},
	{765, 59.950200000000002},
	{770, 70.736599999999996},
	{775, 68.878900000000002},
	{780, 67.021200000000007},
	{785, 67.522600000000011},
	{790, 68.024000000000001},
	{795, 65.439549999999997},
	{800, 62.855099999999993},
	{805, 58.865049999999997},
	{810, 54.875000000000000},
	{815, 57.786200000000001},
	{820, 60.697400000000002},
	{825, 62.226949999999995},
	{830, 63.756500000000003},
	{-1, 0}
},
std_illuminant_D65[] = {
	{300, 0.034100},
	{305, 1.664300},
	{310, 3.294500},
	{315, 11.765200},
	{320, 20.236000},
	{325, 28.644700},
	{330, 37.053500},
	{335, 38.501100},
	{340, 39.948800},
	{345, 42.430200},
	{350, 44.911700},
	{355, 45.775000},
	{360, 46.638300},
	{365, 49.363700},
	{370, 52.089100},
	{375, 51.032300},
	{380, 49.975500},
	{385, 52.311800},
	{390, 54.648200},
	{395, 68.701500},
	{400, 82.754900},
	{405, 87.120400},
	{410, 91.486000},
	{415, 92.458900},
	{420, 93.431800},
	{425, 90.057000},
	{430, 86.682300},
	{435, 95.773600},
	{440, 104.865000},
	{445, 110.936000},
	{450, 117.008000},
	{455, 117.410000},
	{460, 117.812000},
	{465, 116.336000},
	{470, 114.861000},
	{475, 115.392000},
	{480, 115.923000},
	{485, 112.367000},
	{490, 108.811000},
	{495, 109.082000},
	{500, 109.354000},
	{505, 108.578000},
	{510, 107.802000},
	{515, 106.296000},
	{520, 104.790000},
	{525, 106.239000},
	{530, 107.689000},
	{535, 106.047000},
	{540, 104.405000},
	{545, 104.225000},
	{550, 104.046000},
	{555, 102.023000},
	{560, 100.000000},
	{565, 98.167100},
	{570, 96.334200},
	{575, 96.061100},
	{580, 95.788000},
	{585, 92.236800},
	{590, 88.685600},
	{595, 89.345900},
	{600, 90.006200},
	{605, 89.802600},
	{610, 89.599100},
	{615, 88.648900},
	{620, 87.698700},
	{625, 85.493600},
	{630, 83.288600},
	{635, 83.493900},
	{640, 83.699200},
	{645, 81.863000},
	{650, 80.026800},
	{655, 80.120700},
	{660, 80.214600},
	{665, 81.246200},
	{670, 82.277800},
	{675, 80.281000},
	{680, 78.284200},
	{685, 74.002700},
	{690, 69.721300},
	{695, 70.665200},
	{700, 71.609100},
	{705, 72.979000},
	{710, 74.349000},
	{715, 67.976500},
	{720, 61.604000},
	{725, 65.744800},
	{730, 69.885600},
	{735, 72.486300},
	{740, 75.087000},
	{745, 69.339800},
	{750, 63.592700},
	{755, 55.005400},
	{760, 46.418200},
	{765, 56.611800},
	{770, 66.805400},
	{775, 65.094100},
	{780, 63.382800},
	{-1, 0}
},
std_illuminant_D75[] = {
	{300, 0.043},
	{305, 2.588},
	{310, 5.133},
	{315, 17.470},
	{320, 29.808},
	{325, 42.369},
	{330, 54.930},
	{335, 56.095},
	{340, 57.259},
	{345, 60.000},
	{350, 62.740},
	{355, 62.861},
	{360, 62.982},
	{365, 66.647},
	{370, 70.312},
	{375, 68.507},
	{380, 66.703},
	{385, 68.333},
	{390, 69.963},
	{395, 85.946},
	{400, 101.929},
	{405, 106.911},
	{410, 111.894},
	{415, 112.346},
	{420, 112.798},
	{425, 107.945},
	{430, 103.092},
	{435, 112.145},
	{440, 121.198},
	{445, 127.104},
	{450, 133.010},
	{455, 132.682},
	{460, 132.355},
	{465, 129.838},
	{470, 127.322},
	{475, 127.061},
	{480, 126.800},
	{485, 122.291},
	{490, 117.783},
	{495, 117.186},
	{500, 116.589},
	{505, 115.146},
	{510, 113.702},
	{515, 111.181},
	{520, 108.659},
	{525, 109.552},
	{530, 110.445},
	{535, 108.367},
	{540, 106.289},
	{545, 105.596},
	{550, 104.904},
	{555, 102.452},
	{560, 100.000},
	{565, 97.808},
	{570, 95.616},
	{575, 94.914},
	{580, 94.213},
	{585, 90.605},
	{590, 86.997},
	{595, 87.112},
	{600, 87.227},
	{605, 86.684},
	{610, 86.140},
	{615, 84.861},
	{620, 83.581},
	{625, 81.164},
	{630, 78.747},
	{635, 78.587},
	{640, 78.428},
	{645, 76.614},
	{650, 74.801},
	{655, 74.562},
	{660, 74.324},
	{665, 74.873},
	{670, 75.422},
	{675, 73.499},
	{680, 71.576},
	{685, 67.714},
	{690, 63.852},
	{695, 64.464},
	{700, 65.076},
	{705, 66.573},
	{710, 68.070},
	{715, 62.256},
	{720, 56.443},
	{725, 60.343},
	{730, 64.242},
	{735, 66.697},
	{740, 69.151},
	{745, 63.890},
	{750, 58.629},
	{755, 50.623},
	{760, 42.617},
	{765, 51.985},
	{770, 61.352},
	{775, 59.838},
	{780, 58.324},
	{-1, 0}
},
std_illuminant_E[] = {
	{360, 100.000},
	{365, 100.000},
	{370, 100.000},
	{375, 100.000},
	{380, 100.000},
	{385, 100.000},
	{390, 100.000},
	{395, 100.000},
	{400, 100.000},
	{405, 100.000},
	{410, 100.000},
	{415, 100.000},
	{420, 100.000},
	{425, 100.000},
	{430, 100.000},
	{435, 100.000},
	{440, 100.000},
	{445, 100.000},
	{450, 100.000},
	{455, 100.000},
	{460, 100.000},
	{465, 100.000},
	{470, 100.000},
	{475, 100.000},
	{480, 100.000},
	{485, 100.000},
	{490, 100.000},
	{495, 100.000},
	{500, 100.000},
	{505, 100.000},
	{510, 100.000},
	{515, 100.000},
	{520, 100.000},
	{525, 100.000},
	{530, 100.000},
	{535, 100.000},
	{540, 100.000},
	{545, 100.000},
	{550, 100.000},
	{555, 100.000},
	{560, 100.000},
	{565, 100.000},
	{570, 100.000},
	{575, 100.000},
	{580, 100.000},
	{585, 100.000},
	{590, 100.000},
	{595, 100.000},
	{600, 100.000},
	{605, 100.000},
	{610, 100.000},
	{615, 100.000},
	{620, 100.000},
	{625, 100.000},
	{630, 100.000},
	{635, 100.000},
	{640, 100.000},
	{645, 100.000},
	{650, 100.000},
	{655, 100.000},
	{660, 100.000},
	{665, 100.000},
	{670, 100.000},
	{675, 100.000},
	{680, 100.000},
	{685, 100.000},
	{690, 100.000},
	{695, 100.000},
	{700, 100.000},
	{705, 100.000},
	{710, 100.000},
	{715, 100.000},
	{720, 100.000},
	{725, 100.000},
	{730, 100.000},
	{735, 100.000},
	{740, 100.000},
	{745, 100.000},
	{750, 100.000},
	{755, 100.000},
	{760, 100.000},
	{765, 100.000},
	{770, 100.000},
	{775, 100.000},
	{780, 100.000},
	{785, 100.000},
	{790, 100.000},
	{795, 100.000},
	{800, 100.000},
	{805, 100.000},
	{810, 100.000},
	{815, 100.000},
	{820, 100.000},
	{825, 100.000},
	{830, 100.000},
	{-1, 0}
},
std_illuminant_FL1[] = {
	{380, 1.87},
	{385, 2.36},
	{390, 2.94},
	{395, 3.47},
	{400, 5.17},
	{405, 19.49},
	{410, 6.13},
	{415, 6.24},
	{420, 7.01},
	{425, 7.79},
	{430, 8.56},
	{435, 43.67},
	{440, 16.94},
	{445, 10.72},
	{450, 11.35},
	{455, 11.89},
	{460, 12.37},
	{465, 12.75},
	{470, 13.00},
	{475, 13.15},
	{480, 13.23},
	{485, 13.17},
	{490, 13.13},
	{495, 12.85},
	{500, 12.52},
	{505, 12.20},
	{510, 11.83},
	{515, 11.50},
	{520, 11.22},
	{525, 11.05},
	{530, 11.03},
	{535, 11.18},
	{540, 11.53},
	{545, 27.74},
	{550, 17.05},
	{555, 13.55},
	{560, 14.33},
	{565, 15.01},
	{570, 15.52},
	{575, 18.29},
	{580, 19.55},
	{585, 15.48},
	{590, 14.91},
	{595, 14.15},
	{600, 13.22},
	{605, 12.19},
	{610, 11.12},
	{615, 10.03},
	{620, 8.95},
	{625, 7.96},
	{630, 7.02},
	{635, 6.20},
	{640, 5.42},
	{645, 4.73},
	{650, 4.15},
	{655, 3.64},
	{660, 3.20},
	{665, 2.81},
	{670, 2.47},
	{675, 2.18},
	{680, 1.93},
	{685, 1.72},
	{690, 1.67},
	{695, 1.43},
	{700, 1.29},
	{705, 1.19},
	{710, 1.08},
	{715, 0.96},
	{720, 0.88},
	{725, 0.81},
	{730, 0.77},
	{735, 0.75},
	{740, 0.73},
	{745, 0.68},
	{750, 0.69},
	{755, 0.64},
	{760, 0.68},
	{765, 0.69},
	{770, 0.61},
	{775, 0.52},
	{780, 0.43},
	{-1, 0}
},
std_illuminant_FL2[] = {
	{380, 1.18},
	{385, 1.48},
	{390, 1.84},
	{395, 2.15},
	{400, 3.44},
	{405, 15.69},
	{410, 3.85},
	{415, 3.74},
	{420, 4.19},
	{425, 4.62},
	{430, 5.06},
	{435, 34.98},
	{440, 11.81},
	{445, 6.27},
	{450, 6.63},
	{455, 6.93},
	{460, 7.19},
	{465, 7.40},
	{470, 7.54},
	{475, 7.62},
	{480, 7.65},
	{485, 7.62},
	{490, 7.62},
	{495, 7.45},
	{500, 7.28},
	{505, 7.15},
	{510, 7.05},
	{515, 7.04},
	{520, 7.16},
	{525, 7.47},
	{530, 8.04},
	{535, 8.88},
	{540, 10.01},
	{545, 24.88},
	{550, 16.64},
	{555, 14.59},
	{560, 16.16},
	{565, 17.56},
	{570, 18.62},
	{575, 21.47},
	{580, 22.79},
	{585, 19.29},
	{590, 18.66},
	{595, 17.73},
	{600, 16.54},
	{605, 15.21},
	{610, 13.80},
	{615, 12.36},
	{620, 10.95},
	{625, 9.65},
	{630, 8.40},
	{635, 7.32},
	{640, 6.31},
	{645, 5.43},
	{650, 4.68},
	{655, 4.02},
	{660, 3.45},
	{665, 2.96},
	{670, 2.55},
	{675, 2.19},
	{680, 1.89},
	{685, 1.64},
	{690, 1.53},
	{695, 1.27},
	{700, 1.10},
	{705, 0.99},
	{710, 0.88},
	{715, 0.76},
	{720, 0.68},
	{725, 0.61},
	{730, 0.56},
	{735, 0.54},
	{740, 0.51},
	{745, 0.47},
	{750, 0.47},
	{755, 0.43},
	{760, 0.46},
	{765, 0.47},
	{770, 0.40},
	{775, 0.33},
	{780, 0.27},
	{-1, 0}
},
std_illuminant_FL3[] = {
	{380, 0.82},
	{385, 1.02},
	{390, 1.26},
	{395, 1.44},
	{400, 2.57},
	{405, 14.36},
	{410, 2.70},
	{415, 2.45},
	{420, 2.73},
	{425, 3.00},
	{430, 3.28},
	{435, 31.85},
	{440, 9.47},
	{445, 4.02},
	{450, 4.25},
	{455, 4.44},
	{460, 4.59},
	{465, 4.72},
	{470, 4.80},
	{475, 4.86},
	{480, 4.87},
	{485, 4.85},
	{490, 4.88},
	{495, 4.77},
	{500, 4.67},
	{505, 4.62},
	{510, 4.62},
	{515, 4.73},
	{520, 4.99},
	{525, 5.48},
	{530, 6.25},
	{535, 7.34},
	{540, 8.78},
	{545, 23.82},
	{550, 16.14},
	{555, 14.59},
	{560, 16.63},
	{565, 18.49},
	{570, 19.95},
	{575, 23.11},
	{580, 24.69},
	{585, 21.41},
	{590, 20.85},
	{595, 19.93},
	{600, 18.67},
	{605, 17.22},
	{610, 15.65},
	{615, 14.04},
	{620, 12.45},
	{625, 10.95},
	{630, 9.51},
	{635, 8.27},
	{640, 7.11},
	{645, 6.09},
	{650, 5.22},
	{655, 4.45},
	{660, 3.80},
	{665, 3.23},
	{670, 2.75},
	{675, 2.33},
	{680, 1.99},
	{685, 1.70},
	{690, 1.55},
	{695, 1.27},
	{700, 1.09},
	{705, 0.96},
	{710, 0.83},
	{715, 0.71},
	{720, 0.62},
	{725, 0.54},
	{730, 0.49},
	{735, 0.46},
	{740, 0.43},
	{745, 0.39},
	{750, 0.39},
	{755, 0.35},
	{760, 0.38},
	{765, 0.39},
	{770, 0.33},
	{775, 0.28},
	{780, 0.21},
	{-1, 0}
},
std_illuminant_FL4[] = {
	{380, 0.57},
	{385, 0.70},
	{390, 0.87},
	{395, 0.98},
	{400, 2.01},
	{405, 13.75},
	{410, 1.95},
	{415, 1.59},
	{420, 1.76},
	{425, 1.93},
	{430, 2.10},
	{435, 30.28},
	{440, 8.03},
	{445, 2.55},
	{450, 2.70},
	{455, 2.82},
	{460, 2.91},
	{465, 2.99},
	{470, 3.04},
	{475, 3.08},
	{480, 3.09},
	{485, 3.09},
	{490, 3.14},
	{495, 3.06},
	{500, 3.00},
	{505, 2.98},
	{510, 3.01},
	{515, 3.14},
	{520, 3.41},
	{525, 3.90},
	{530, 4.69},
	{535, 5.81},
	{540, 7.32},
	{545, 22.59},
	{550, 15.11},
	{555, 13.88},
	{560, 16.33},
	{565, 18.68},
	{570, 20.64},
	{575, 24.28},
	{580, 26.26},
	{585, 23.28},
	{590, 22.94},
	{595, 22.14},
	{600, 20.91},
	{605, 19.43},
	{610, 17.74},
	{615, 16.00},
	{620, 14.42},
	{625, 12.56},
	{630, 10.93},
	{635, 9.52},
	{640, 8.18},
	{645, 7.01},
	{650, 6.00},
	{655, 5.11},
	{660, 4.36},
	{665, 3.69},
	{670, 3.13},
	{675, 2.64},
	{680, 2.24},
	{685, 1.91},
	{690, 1.70},
	{695, 1.39},
	{700, 1.18},
	{705, 1.03},
	{710, 0.88},
	{715, 0.74},
	{720, 0.64},
	{725, 0.54},
	{730, 0.49},
	{735, 0.46},
	{740, 0.42},
	{745, 0.37},
	{750, 0.37},
	{755, 0.33},
	{760, 0.35},
	{765, 0.36},
	{770, 0.31},
	{775, 0.26},
	{780, 0.19},
	{-1, 0}
},
std_illuminant_FL5[] = {
	{380, 1.87},
	{385, 2.35},
	{390, 2.92},
	{395, 3.45},
	{400, 5.10},
	{405, 18.91},
	{410, 6.00},
	{415, 6.11},
	{420, 6.85},
	{425, 7.58},
	{430, 8.31},
	{435, 40.76},
	{440, 16.06},
	{445, 10.32},
	{450, 10.91},
	{455, 11.40},
	{460, 11.83},
	{465, 12.17},
	{470, 12.40},
	{475, 12.54},
	{480, 12.58},
	{485, 12.52},
	{490, 12.47},
	{495, 12.20},
	{500, 11.89},
	{505, 11.61},
	{510, 11.33},
	{515, 11.10},
	{520, 10.96},
	{525, 10.97},
	{530, 11.16},
	{535, 11.54},
	{540, 12.12},
	{545, 27.78},
	{550, 17.73},
	{555, 14.47},
	{560, 15.20},
	{565, 15.77},
	{570, 16.10},
	{575, 18.54},
	{580, 19.50},
	{585, 15.39},
	{590, 14.64},
	{595, 13.72},
	{600, 12.69},
	{605, 11.57},
	{610, 10.45},
	{615, 9.35},
	{620, 8.29},
	{625, 7.32},
	{630, 6.41},
	{635, 5.63},
	{640, 4.90},
	{645, 4.26},
	{650, 3.72},
	{655, 3.25},
	{660, 2.83},
	{665, 2.49},
	{670, 2.19},
	{675, 1.93},
	{680, 1.71},
	{685, 1.52},
	{690, 1.48},
	{695, 1.26},
	{700, 1.13},
	{705, 1.05},
	{710, 0.96},
	{715, 0.85},
	{720, 0.78},
	{725, 0.72},
	{730, 0.68},
	{735, 0.67},
	{740, 0.65},
	{745, 0.61},
	{750, 0.62},
	{755, 0.59},
	{760, 0.62},
	{765, 0.64},
	{770, 0.55},
	{775, 0.47},
	{780, 0.40},
	{-1, 0}
},
std_illuminant_FL6[] = {
	{380, 1.05},
	{385, 1.31},
	{390, 1.63},
	{395, 1.90},
	{400, 3.11},
	{405, 14.80},
	{410, 3.43},
	{415, 3.30},
	{420, 3.68},
	{425, 4.07},
	{430, 4.45},
	{435, 32.61},
	{440, 10.74},
	{445, 5.48},
	{450, 5.78},
	{455, 6.03},
	{460, 6.25},
	{465, 6.41},
	{470, 6.52},
	{475, 6.58},
	{480, 6.59},
	{485, 6.56},
	{490, 6.56},
	{495, 6.42},
	{500, 6.28},
	{505, 6.20},
	{510, 6.19},
	{515, 6.30},
	{520, 6.60},
	{525, 7.12},
	{530, 7.94},
	{535, 9.07},
	{540, 10.49},
	{545, 25.22},
	{550, 17.46},
	{555, 15.63},
	{560, 17.22},
	{565, 18.53},
	{570, 19.43},
	{575, 21.97},
	{580, 23.01},
	{585, 19.41},
	{590, 18.56},
	{595, 17.42},
	{600, 16.09},
	{605, 14.64},
	{610, 13.15},
	{615, 11.68},
	{620, 10.25},
	{625, 8.95},
	{630, 7.74},
	{635, 6.69},
	{640, 5.71},
	{645, 4.87},
	{650, 4.16},
	{655, 3.55},
	{660, 3.02},
	{665, 2.57},
	{670, 2.20},
	{675, 1.87},
	{680, 1.60},
	{685, 1.37},
	{690, 1.29},
	{695, 1.05},
	{700, 0.91},
	{705, 0.81},
	{710, 0.71},
	{715, 0.61},
	{720, 0.54},
	{725, 0.48},
	{730, 0.44},
	{735, 0.43},
	{740, 0.40},
	{745, 0.37},
	{750, 0.38},
	{755, 0.35},
	{760, 0.39},
	{765, 0.41},
	{770, 0.33},
	{775, 0.26},
	{780, 0.21},
	{-1, 0}
},
std_illuminant_FL7[] ={
	{380, 2.56},
	{385, 3.18},
	{390, 3.84},
	{395, 4.53},
	{400, 6.15},
	{405, 19.37},
	{410, 7.37},
	{415, 7.05},
	{420, 7.71},
	{425, 8.41},
	{430, 9.15},
	{435, 44.14},
	{440, 17.52},
	{445, 11.35},
	{450, 12.00},
	{455, 12.58},
	{460, 13.08},
	{465, 13.45},
	{470, 13.71},
	{475, 13.88},
	{480, 13.95},
	{485, 13.93},
	{490, 13.82},
	{495, 13.64},
	{500, 13.43},
	{505, 13.25},
	{510, 13.08},
	{515, 12.93},
	{520, 12.78},
	{525, 12.60},
	{530, 12.44},
	{535, 12.33},
	{540, 12.26},
	{545, 29.52},
	{550, 17.05},
	{555, 12.44},
	{560, 12.58},
	{565, 12.72},
	{570, 12.83},
	{575, 15.46},
	{580, 16.75},
	{585, 12.83},
	{590, 12.67},
	{595, 12.45},
	{600, 12.19},
	{605, 11.89},
	{610, 11.60},
	{615, 11.35},
	{620, 11.12},
	{625, 10.95},
	{630, 10.76},
	{635, 10.42},
	{640, 10.11},
	{645, 10.04},
	{650, 10.02},
	{655, 10.11},
	{660, 9.87},
	{665, 8.65},
	{670, 7.27},
	{675, 6.44},
	{680, 5.83},
	{685, 5.41},
	{690, 5.04},
	{695, 4.57},
	{700, 4.12},
	{705, 3.77},
	{710, 3.46},
	{715, 3.08},
	{720, 2.73},
	{725, 2.47},
	{730, 2.25},
	{735, 2.06},
	{740, 1.90},
	{745, 1.75},
	{750, 1.62},
	{755, 1.54},
	{760, 1.45},
	{765, 1.32},
	{770, 1.17},
	{775, 0.99},
	{780, 0.81},
	{-1, 0}
},
std_illuminant_FL8[] = {
	{380, 1.21},
	{385, 1.50},
	{390, 1.81},
	{395, 2.13},
	{400, 3.17},
	{405, 13.08},
	{410, 3.83},
	{415, 3.45},
	{420, 3.86},
	{425, 4.42},
	{430, 5.09},
	{435, 34.10},
	{440, 12.42},
	{445, 7.68},
	{450, 8.60},
	{455, 9.46},
	{460, 10.24},
	{465, 10.84},
	{470, 11.33},
	{475, 11.71},
	{480, 11.98},
	{485, 12.17},
	{490, 12.28},
	{495, 12.32},
	{500, 12.35},
	{505, 12.44},
	{510, 12.55},
	{515, 12.68},
	{520, 12.77},
	{525, 12.72},
	{530, 12.60},
	{535, 12.43},
	{540, 12.22},
	{545, 28.96},
	{550, 16.51},
	{555, 11.79},
	{560, 11.76},
	{565, 11.77},
	{570, 11.84},
	{575, 14.61},
	{580, 16.11},
	{585, 12.34},
	{590, 12.53},
	{595, 12.72},
	{600, 12.92},
	{605, 13.12},
	{610, 13.34},
	{615, 13.61},
	{620, 13.87},
	{625, 14.07},
	{630, 14.20},
	{635, 14.16},
	{640, 14.13},
	{645, 14.34},
	{650, 14.50},
	{655, 14.46},
	{660, 14.00},
	{665, 12.58},
	{670, 10.99},
	{675, 9.98},
	{680, 9.22},
	{685, 8.62},
	{690, 8.07},
	{695, 7.39},
	{700, 6.71},
	{705, 6.16},
	{710, 5.63},
	{715, 5.03},
	{720, 4.46},
	{725, 4.02},
	{730, 3.66},
	{735, 3.36},
	{740, 3.09},
	{745, 2.85},
	{750, 2.65},
	{755, 2.51},
	{760, 2.37},
	{765, 2.15},
	{770, 1.89},
	{775, 1.61},
	{780, 1.32},
	{-1, 0}
},
std_illuminant_FL9[] ={
	{380, 0.90},
	{385, 1.12},
	{390, 1.36},
	{395, 1.60},
	{400, 2.59},
	{405, 12.80},
	{410, 3.05},
	{415, 2.56},
	{420, 2.86},
	{425, 3.30},
	{430, 3.82},
	{435, 32.62},
	{440, 10.77},
	{445, 5.84},
	{450, 6.57},
	{455, 7.25},
	{460, 7.86},
	{465, 8.35},
	{470, 8.75},
	{475, 9.06},
	{480, 9.31},
	{485, 9.48},
	{490, 9.61},
	{495, 9.68},
	{500, 9.74},
	{505, 9.88},
	{510, 10.04},
	{515, 10.26},
	{520, 10.48},
	{525, 10.63},
	{530, 10.78},
	{535, 10.96},
	{540, 11.18},
	{545, 27.71},
	{550, 16.29},
	{555, 12.28},
	{560, 12.74},
	{565, 13.21},
	{570, 13.65},
	{575, 16.57},
	{580, 18.14},
	{585, 14.55},
	{590, 14.65},
	{595, 14.66},
	{600, 14.61},
	{605, 14.50},
	{610, 14.39},
	{615, 14.40},
	{620, 14.47},
	{625, 14.62},
	{630, 14.72},
	{635, 14.55},
	{640, 14.40},
	{645, 14.58},
	{650, 14.88},
	{655, 15.51},
	{660, 15.47},
	{665, 13.20},
	{670, 10.57},
	{675, 9.18},
	{680, 8.25},
	{685, 7.57},
	{690, 7.03},
	{695, 6.35},
	{700, 5.72},
	{705, 5.25},
	{710, 4.80},
	{715, 4.29},
	{720, 3.80},
	{725, 3.43},
	{730, 3.12},
	{735, 2.86},
	{740, 2.64},
	{745, 2.43},
	{750, 2.26},
	{755, 2.14},
	{760, 2.02},
	{765, 1.83},
	{770, 1.61},
	{775, 1.38},
	{780, 1.12},
	{-1, 0}
},
std_illuminant_FL10[] = {
	{380, 1.11},
	{385, 0.80},
	{390, 0.62},
	{395, 0.57},
	{400, 1.48},
	{405, 12.16},
	{410, 2.12},
	{415, 2.70},
	{420, 3.74},
	{425, 5.14},
	{430, 6.75},
	{435, 34.39},
	{440, 14.86},
	{445, 10.40},
	{450, 10.76},
	{455, 10.67},
	{460, 10.11},
	{465, 9.27},
	{470, 8.29},
	{475, 7.29},
	{480, 7.91},
	{485, 16.64},
	{490, 16.73},
	{495, 10.44},
	{500, 5.94},
	{505, 3.34},
	{510, 2.35},
	{515, 1.88},
	{520, 1.59},
	{525, 1.47},
	{530, 1.80},
	{535, 5.71},
	{540, 40.98},
	{545, 73.69},
	{550, 33.61},
	{555, 8.24},
	{560, 3.38},
	{565, 2.47},
	{570, 2.14},
	{575, 4.86},
	{580, 11.45},
	{585, 14.79},
	{590, 12.16},
	{595, 8.97},
	{600, 6.52},
	{605, 8.31},
	{610, 44.12},
	{615, 34.55},
	{620, 12.09},
	{625, 12.15},
	{630, 10.52},
	{635, 4.43},
	{640, 1.95},
	{645, 2.19},
	{650, 3.19},
	{655, 2.77},
	{660, 2.29},
	{665, 2.00},
	{670, 1.52},
	{675, 1.35},
	{680, 1.47},
	{685, 1.79},
	{690, 1.74},
	{695, 1.02},
	{700, 1.14},
	{705, 3.32},
	{710, 4.49},
	{715, 2.05},
	{720, 0.49},
	{725, 0.24},
	{730, 0.21},
	{735, 0.21},
	{740, 0.24},
	{745, 0.24},
	{750, 0.21},
	{755, 0.17},
	{760, 0.21},
	{765, 0.22},
	{770, 0.17},
	{775, 0.12},
	{780, 0.09},
	{-1, 0}
},
std_illuminant_FL11[] = {
	{380, 0.91},
	{385, 0.63},
	{390, 0.46},
	{395, 0.37},
	{400, 1.29},
	{405, 12.68},
	{410, 1.59},
	{415, 1.79},
	{420, 2.46},
	{425, 3.33},
	{430, 4.49},
	{435, 33.94},
	{440, 12.13},
	{445, 6.95},
	{450, 7.19},
	{455, 7.12},
	{460, 6.72},
	{465, 6.13},
	{470, 5.46},
	{475, 4.79},
	{480, 5.66},
	{485, 14.29},
	{490, 14.96},
	{495, 8.97},
	{500, 4.72},
	{505, 2.33},
	{510, 1.47},
	{515, 1.10},
	{520, 0.89},
	{525, 0.83},
	{530, 1.18},
	{535, 4.90},
	{540, 39.59},
	{545, 72.84},
	{550, 32.61},
	{555, 7.52},
	{560, 2.83},
	{565, 1.96},
	{570, 1.67},
	{575, 4.43},
	{580, 11.28},
	{585, 14.76},
	{590, 12.73},
	{595, 9.74},
	{600, 7.33},
	{605, 9.72},
	{610, 55.27},
	{615, 42.58},
	{620, 13.18},
	{625, 13.16},
	{630, 12.26},
	{635, 5.11},
	{640, 2.07},
	{645, 2.34},
	{650, 3.58},
	{655, 3.01},
	{660, 2.48},
	{665, 2.14},
	{670, 1.54},
	{675, 1.33},
	{680, 1.46},
	{685, 1.94},
	{690, 2.00},
	{695, 1.20},
	{700, 1.35},
	{705, 4.10},
	{710, 5.58},
	{715, 2.51},
	{720, 0.57},
	{725, 0.27},
	{730, 0.23},
	{735, 0.21},
	{740, 0.24},
	{745, 0.24},
	{750, 0.20},
	{755, 0.24},
	{760, 0.32},
	{765, 0.26},
	{770, 0.16},
	{775, 0.12},
	{780, 0.09},
	{-1, 0}
},
std_illuminant_FL12[] = {
	{380, 0.96},
	{385, 0.64},
	{390, 0.40},
	{395, 0.33},
	{400, 1.19},
	{405, 12.48},
	{410, 1.12},
	{415, 0.94},
	{420, 1.08},
	{425, 1.37},
	{430, 1.78},
	{435, 29.05},
	{440, 7.90},
	{445, 2.65},
	{450, 2.71},
	{455, 2.65},
	{460, 2.49},
	{465, 2.33},
	{470, 2.10},
	{475, 1.91},
	{480, 3.01},
	{485, 10.83},
	{490, 11.88},
	{495, 6.88},
	{500, 3.43},
	{505, 1.49},
	{510, 0.92},
	{515, 0.71},
	{520, 0.60},
	{525, 0.63},
	{530, 1.10},
	{535, 4.56},
	{540, 34.40},
	{545, 65.40},
	{550, 29.48},
	{555, 7.16},
	{560, 3.08},
	{565, 2.47},
	{570, 2.27},
	{575, 5.09},
	{580, 11.96},
	{585, 15.32},
	{590, 14.27},
	{595, 11.86},
	{600, 9.28},
	{605, 12.31},
	{610, 68.53},
	{615, 53.02},
	{620, 14.67},
	{625, 14.38},
	{630, 14.71},
	{635, 6.46},
	{640, 2.57},
	{645, 2.75},
	{650, 4.18},
	{655, 3.44},
	{660, 2.81},
	{665, 2.42},
	{670, 1.64},
	{675, 1.36},
	{680, 1.49},
	{685, 2.14},
	{690, 2.34},
	{695, 1.42},
	{700, 1.61},
	{705, 5.04},
	{710, 6.98},
	{715, 3.19},
	{720, 0.71},
	{725, 0.30},
	{730, 0.26},
	{735, 0.23},
	{740, 0.28},
	{745, 0.28},
	{750, 0.21},
	{755, 0.17},
	{760, 0.21},
	{765, 0.19},
	{770, 0.15},
	{775, 0.10},
	{780, 0.05},
	{-1, 0}
},
std_illuminant_FL3_1[] = {
	{380, 2.39},
	{385, 2.93},
	{390, 3.82},
	{395, 4.23},
	{400, 4.97},
	{405, 86.30},
	{410, 11.65},
	{415, 7.09},
	{420, 7.84},
	{425, 8.59},
	{430, 9.44},
	{435, 196.54},
	{440, 10.94},
	{445, 11.38},
	{450, 11.89},
	{455, 12.37},
	{460, 12.81},
	{465, 13.15},
	{470, 13.39},
	{475, 13.56},
	{480, 13.59},
	{485, 13.56},
	{490, 14.07},
	{495, 13.39},
	{500, 13.29},
	{505, 13.25},
	{510, 13.53},
	{515, 14.24},
	{520, 15.74},
	{525, 18.26},
	{530, 22.28},
	{535, 27.97},
	{540, 35.70},
	{545, 148.98},
	{550, 56.55},
	{555, 68.68},
	{560, 79.99},
	{565, 91.47},
	{570, 101.32},
	{575, 123.16},
	{580, 129.53},
	{585, 115.05},
	{590, 113.48},
	{595, 110.08},
	{600, 104.28},
	{605, 97.98},
	{610, 89.60},
	{615, 80.74},
	{620, 71.92},
	{625, 63.50},
	{630, 55.46},
	{635, 47.97},
	{640, 41.39},
	{645, 35.50},
	{650, 30.32},
	{655, 25.79},
	{660, 21.84},
	{665, 18.53},
	{670, 15.67},
	{675, 13.22},
	{680, 11.14},
	{685, 9.40},
	{690, 8.65},
	{695, 6.75},
	{700, 5.69},
	{705, 4.87},
	{710, 4.29},
	{715, 3.54},
	{720, 3.03},
	{725, 2.62},
	{730, 2.28},
	{735, 1.94},
	{740, 1.70},
	{745, 1.50},
	{750, 1.36},
	{755, 1.16},
	{760, 4.91},
	{765, 0.95},
	{770, 1.50},
	{775, 0.89},
	{780, 0.68},
	{-1, 0}
},
std_illuminant_FL3_2[] = {
	{380, 5.80},
	{385, 6.99},
	{390, 8.70},
	{395, 9.89},
	{400, 11.59},
	{405, 94.53},
	{410, 20.80},
	{415, 16.52},
	{420, 18.30},
	{425, 20.33},
	{430, 22.00},
	{435, 231.90},
	{440, 25.81},
	{445, 27.63},
	{450, 29.10},
	{455, 30.61},
	{460, 31.92},
	{465, 33.11},
	{470, 33.83},
	{475, 34.70},
	{480, 35.02},
	{485, 35.22},
	{490, 35.81},
	{495, 35.14},
	{500, 35.14},
	{505, 34.90},
	{510, 34.70},
	{515, 35.02},
	{520, 36.13},
	{525, 37.92},
	{530, 40.62},
	{535, 44.70},
	{540, 49.63},
	{545, 154.16},
	{550, 62.21},
	{555, 68.92},
	{560, 75.83},
	{565, 81.95},
	{570, 86.95},
	{575, 103.54},
	{580, 109.94},
	{585, 91.95},
	{590, 89.85},
	{595, 87.15},
	{600, 83.26},
	{605, 78.93},
	{610, 73.93},
	{615, 68.84},
	{620, 63.44},
	{625, 58.84},
	{630, 53.84},
	{635, 49.43},
	{640, 45.54},
	{645, 41.53},
	{650, 38.31},
	{655, 34.62},
	{660, 31.80},
	{665, 29.02},
	{670, 26.72},
	{675, 24.22},
	{680, 22.19},
	{685, 20.41},
	{690, 19.10},
	{695, 16.79},
	{700, 15.13},
	{705, 13.82},
	{710, 12.63},
	{715, 11.39},
	{720, 10.32},
	{725, 9.21},
	{730, 8.89},
	{735, 7.50},
	{740, 6.71},
	{745, 6.11},
	{750, 5.40},
	{755, 4.80},
	{760, 8.70},
	{765, 4.01},
	{770, 4.09},
	{775, 3.30},
	{780, 2.82},
	{-1, 0}
},
std_illuminant_FL3_3[] = {
	{380, 8.94},
	{385, 11.21},
	{390, 14.08},
	{395, 16.48},
	{400, 19.63},
	{405, 116.33},
	{410, 32.07},
	{415, 29.72},
	{420, 33.39},
	{425, 36.94},
	{430, 40.33},
	{435, 262.66},
	{440, 46.87},
	{445, 49.79},
	{450, 52.46},
	{455, 54.81},
	{460, 56.81},
	{465, 58.44},
	{470, 59.52},
	{475, 60.12},
	{480, 60.24},
	{485, 59.88},
	{490, 59.88},
	{495, 58.60},
	{500, 57.85},
	{505, 56.29},
	{510, 54.81},
	{515, 53.42},
	{520, 52.70},
	{525, 52.50},
	{530, 53.30},
	{535, 54.89},
	{540, 57.61},
	{545, 182.75},
	{550, 65.27},
	{555, 69.41},
	{560, 73.28},
	{565, 76.56},
	{570, 78.67},
	{575, 95.74},
	{580, 97.22},
	{585, 76.79},
	{590, 73.36},
	{595, 69.33},
	{600, 64.23},
	{605, 58.92},
	{610, 53.38},
	{615, 47.91},
	{620, 42.61},
	{625, 37.74},
	{630, 33.11},
	{635, 29.04},
	{640, 25.29},
	{645, 22.10},
	{650, 19.31},
	{655, 16.84},
	{660, 14.68},
	{665, 12.89},
	{670, 11.37},
	{675, 9.97},
	{680, 8.82},
	{685, 7.86},
	{690, 7.78},
	{695, 6.30},
	{700, 5.67},
	{705, 5.15},
	{710, 4.91},
	{715, 4.31},
	{720, 3.99},
	{725, 3.67},
	{730, 3.43},
	{735, 3.19},
	{740, 2.95},
	{745, 2.75},
	{750, 2.63},
	{755, 2.43},
	{760, 7.14},
	{765, 2.19},
	{770, 2.71},
	{775, 2.00},
	{780, 1.80},
	{-1, 0}
},
std_illuminant_FL3_4[] = {
	{380, 3.46},
	{385, 3.86},
	{390, 4.41},
	{395, 4.51},
	{400, 4.86},
	{405, 71.22},
	{410, 8.72},
	{415, 5.36},
	{420, 5.61},
	{425, 5.91},
	{430, 6.42},
	{435, 192.77},
	{440, 7.77},
	{445, 8.37},
	{450, 9.22},
	{455, 10.18},
	{460, 11.18},
	{465, 12.28},
	{470, 13.38},
	{475, 14.54},
	{480, 15.74},
	{485, 17.09},
	{490, 19.60},
	{495, 21.05},
	{500, 23.96},
	{505, 27.77},
	{510, 32.68},
	{515, 38.29},
	{520, 43.76},
	{525, 47.72},
	{530, 50.27},
	{535, 51.78},
	{540, 52.68},
	{545, 167.36},
	{550, 55.29},
	{555, 56.94},
	{560, 59.30},
	{565, 62.15},
	{570, 65.26},
	{575, 84.26},
	{580, 89.22},
	{585, 75.79},
	{590, 79.19},
	{595, 82.80},
	{600, 85.76},
	{605, 88.62},
	{610, 91.12},
	{615, 93.43},
	{620, 96.89},
	{625, 101.45},
	{630, 103.65},
	{635, 100.30},
	{640, 97.89},
	{645, 96.59},
	{650, 106.21},
	{655, 109.97},
	{660, 117.49},
	{665, 96.04},
	{670, 80.15},
	{675, 70.42},
	{680, 65.01},
	{685, 60.15},
	{690, 56.04},
	{695, 50.92},
	{700, 46.26},
	{705, 42.60},
	{710, 38.85},
	{715, 35.09},
	{720, 31.73},
	{725, 28.77},
	{730, 25.76},
	{735, 23.16},
	{740, 21.30},
	{745, 18.55},
	{750, 17.74},
	{755, 14.74},
	{760, 12.93},
	{765, 13.63},
	{770, 10.43},
	{775, 9.67},
	{780, 8.07},
	{-1, 0}
},
std_illuminant_FL3_5[] = {
	{380, 4.72},
	{385, 5.82},
	{390, 7.18},
	{395, 8.39},
	{400, 9.96},
	{405, 58.86},
	{410, 15.78},
	{415, 15.10},
	{420, 17.30},
	{425, 19.66},
	{430, 22.43},
	{435, 176.00},
	{440, 28.67},
	{445, 31.92},
	{450, 35.38},
	{455, 38.73},
	{460, 41.98},
	{465, 44.92},
	{470, 47.49},
	{475, 49.58},
	{480, 51.21},
	{485, 52.36},
	{490, 53.99},
	{495, 53.78},
	{500, 54.04},
	{505, 53.88},
	{510, 53.62},
	{515, 53.25},
	{520, 53.09},
	{525, 52.88},
	{530, 52.99},
	{535, 53.15},
	{540, 53.67},
	{545, 167.93},
	{550, 55.61},
	{555, 56.82},
	{560, 58.39},
	{565, 60.22},
	{570, 62.21},
	{575, 81.45},
	{580, 84.96},
	{585, 68.71},
	{590, 70.70},
	{595, 73.01},
	{600, 74.69},
	{605, 76.26},
	{610, 77.68},
	{615, 78.67},
	{620, 80.14},
	{625, 81.71},
	{630, 82.08},
	{635, 79.98},
	{640, 78.15},
	{645, 76.52},
	{650, 79.20},
	{655, 79.51},
	{660, 81.08},
	{665, 70.76},
	{670, 62.58},
	{675, 56.87},
	{680, 52.83},
	{685, 49.11},
	{690, 46.28},
	{695, 42.24},
	{700, 38.58},
	{705, 35.59},
	{710, 32.76},
	{715, 29.61},
	{720, 26.89},
	{725, 24.53},
	{730, 22.17},
	{735, 20.02},
	{740, 18.45},
	{745, 16.09},
	{750, 15.62},
	{755, 13.10},
	{760, 11.69},
	{765, 12.42},
	{770, 9.43},
	{775, 8.96},
	{780, 7.39},
	{-1, 0}
},
std_illuminant_FL3_6[] = {
	{380, 5.53},
	{385, 6.63},
	{390, 8.07},
	{395, 9.45},
	{400, 11.28},
	{405, 61.47},
	{410, 17.80},
	{415, 17.47},
	{420, 20.12},
	{425, 23.05},
	{430, 26.37},
	{435, 186.01},
	{440, 33.94},
	{445, 37.98},
	{450, 42.12},
	{455, 46.38},
	{460, 50.30},
	{465, 53.95},
	{470, 56.94},
	{475, 59.48},
	{480, 61.36},
	{485, 62.68},
	{490, 64.34},
	{495, 63.90},
	{500, 63.85},
	{505, 63.24},
	{510, 62.46},
	{515, 61.41},
	{520, 60.47},
	{525, 59.48},
	{530, 58.65},
	{535, 57.93},
	{540, 57.49},
	{545, 175.17},
	{550, 57.27},
	{555, 57.49},
	{560, 57.99},
	{565, 58.76},
	{570, 59.64},
	{575, 78.77},
	{580, 81.26},
	{585, 63.18},
	{590, 64.29},
	{595, 65.78},
	{600, 66.77},
	{605, 67.77},
	{610, 68.60},
	{615, 69.10},
	{620, 70.15},
	{625, 71.69},
	{630, 71.97},
	{635, 69.81},
	{640, 68.05},
	{645, 66.66},
	{650, 69.70},
	{655, 70.37},
	{660, 72.47},
	{665, 62.30},
	{670, 54.45},
	{675, 49.20},
	{680, 45.60},
	{685, 42.40},
	{690, 40.02},
	{695, 36.48},
	{700, 33.28},
	{705, 30.84},
	{710, 28.30},
	{715, 25.65},
	{720, 23.33},
	{725, 21.23},
	{730, 19.29},
	{735, 17.41},
	{740, 16.31},
	{745, 14.21},
	{750, 14.04},
	{755, 11.55},
	{760, 10.39},
	{765, 11.28},
	{770, 8.51},
	{775, 8.24},
	{780, 7.02},
	{-1, 0}
},
std_illuminant_FL3_7[] = {
	{380, 3.79},
	{385, 2.56},
	{390, 1.91},
	{395, 1.42},
	{400, 1.51},
	{405, 73.64},
	{410, 7.37},
	{415, 4.69},
	{420, 5.33},
	{425, 6.75},
	{430, 8.51},
	{435, 181.81},
	{440, 11.71},
	{445, 11.96},
	{450, 12.18},
	{455, 11.90},
	{460, 11.16},
	{465, 11.22},
	{470, 9.83},
	{475, 8.94},
	{480, 12.08},
	{485, 52.56},
	{490, 55.42},
	{495, 31.69},
	{500, 16.03},
	{505, 6.72},
	{510, 4.59},
	{515, 3.67},
	{520, 3.02},
	{525, 3.21},
	{530, 4.90},
	{535, 19.05},
	{540, 177.64},
	{545, 347.34},
	{550, 116.80},
	{555, 31.87},
	{560, 16.37},
	{565, 14.92},
	{570, 14.12},
	{575, 29.50},
	{580, 61.40},
	{585, 85.05},
	{590, 64.86},
	{595, 65.01},
	{600, 53.17},
	{605, 34.22},
	{610, 427.27},
	{615, 201.10},
	{620, 58.63},
	{625, 72.01},
	{630, 88.19},
	{635, 20.07},
	{640, 13.10},
	{645, 12.92},
	{650, 24.54},
	{655, 15.94},
	{660, 13.56},
	{665, 13.38},
	{670, 8.42},
	{675, 6.57},
	{680, 7.18},
	{685, 9.90},
	{690, 11.47},
	{695, 8.88},
	{700, 3.05},
	{705, 22.04},
	{710, 42.79},
	{715, 14.40},
	{720, 1.88},
	{725, 1.60},
	{730, 1.42},
	{735, 1.05},
	{740, 1.23},
	{745, 1.76},
	{750, 0.74},
	{755, 0.52},
	{760, 4.10},
	{765, 0.46},
	{770, 0.99},
	{775, 0.43},
	{780, 0.00},
	{-1, 0}
},
std_illuminant_FL3_8[] = {
	{380, 4.18},
	{385, 2.93},
	{390, 2.29},
	{395, 1.98},
	{400, 2.44},
	{405, 70.70},
	{410, 10.19},
	{415, 9.79},
	{420, 13.21},
	{425, 17.79},
	{430, 22.98},
	{435, 191.43},
	{440, 31.76},
	{445, 33.35},
	{450, 33.87},
	{455, 32.89},
	{460, 30.60},
	{465, 28.28},
	{470, 24.81},
	{475, 21.60},
	{480, 23.40},
	{485, 68.99},
	{490, 70.85},
	{495, 42.29},
	{500, 22.67},
	{505, 11.08},
	{510, 7.66},
	{515, 6.07},
	{520, 5.07},
	{525, 4.88},
	{530, 6.26},
	{535, 20.29},
	{540, 204.67},
	{545, 390.25},
	{550, 135.69},
	{555, 34.57},
	{560, 15.71},
	{565, 12.60},
	{570, 11.05},
	{575, 25.05},
	{580, 54.98},
	{585, 82.84},
	{590, 58.22},
	{595, 53.06},
	{600, 41.44},
	{605, 25.26},
	{610, 329.89},
	{615, 161.29},
	{620, 54.19},
	{625, 66.30},
	{630, 71.43},
	{635, 15.74},
	{640, 10.22},
	{645, 10.68},
	{650, 20.32},
	{655, 14.13},
	{660, 11.72},
	{665, 11.75},
	{670, 7.87},
	{675, 6.38},
	{680, 7.23},
	{685, 8.94},
	{690, 9.79},
	{695, 7.26},
	{700, 2.59},
	{705, 17.03},
	{710, 33.69},
	{715, 12.02},
	{720, 1.68},
	{725, 1.50},
	{730, 1.31},
	{735, 1.01},
	{740, 1.16},
	{745, 1.59},
	{750, 0.79},
	{755, 0.67},
	{760, 4.82},
	{765, 0.61},
	{770, 1.25},
	{775, 0.79},
	{780, 0.58},
	{-1, 0}
},
std_illuminant_FL3_9[] = {
	{380, 3.77},
	{385, 2.64},
	{390, 2.06},
	{395, 1.87},
	{400, 2.55},
	{405, 71.68},
	{410, 12.05},
	{415, 13.57},
	{420, 19.60},
	{425, 27.33},
	{430, 35.39},
	{435, 211.82},
	{440, 49.02},
	{445, 51.83},
	{450, 52.50},
	{455, 50.73},
	{460, 46.93},
	{465, 42.42},
	{470, 37.16},
	{475, 31.84},
	{480, 31.94},
	{485, 77.74},
	{490, 79.45},
	{495, 47.93},
	{500, 26.24},
	{505, 13.15},
	{510, 8.80},
	{515, 6.70},
	{520, 5.38},
	{525, 4.93},
	{530, 6.06},
	{535, 19.76},
	{540, 215.94},
	{545, 412.13},
	{550, 142.39},
	{555, 34.74},
	{560, 14.76},
	{565, 10.99},
	{570, 9.25},
	{575, 23.50},
	{580, 53.05},
	{585, 81.90},
	{590, 54.92},
	{595, 47.80},
	{600, 36.65},
	{605, 21.82},
	{610, 285.69},
	{615, 139.94},
	{620, 53.37},
	{625, 64.30},
	{630, 64.04},
	{635, 13.79},
	{640, 9.06},
	{645, 9.83},
	{650, 18.60},
	{655, 13.38},
	{660, 10.99},
	{665, 10.77},
	{670, 7.57},
	{675, 6.19},
	{680, 7.09},
	{685, 8.54},
	{690, 8.77},
	{695, 6.41},
	{700, 2.26},
	{705, 15.02},
	{710, 29.39},
	{715, 10.22},
	{720, 1.42},
	{725, 1.23},
	{730, 1.10},
	{735, 0.84},
	{740, 0.97},
	{745, 1.35},
	{750, 0.65},
	{755, 0.13},
	{760, 4.22},
	{765, 0.10},
	{770, 0.68},
	{775, 0.16},
	{780, 0.00},
	{-1, 0}
},
std_illuminant_FL3_10[] = {
	{380, 0.25},
	{385, 0.00},
	{390, 0.00},
	{395, 0.00},
	{400, 0.69},
	{405, 21.24},
	{410, 2.18},
	{415, 1.86},
	{420, 3.10},
	{425, 5.00},
	{430, 7.03},
	{435, 45.08},
	{440, 16.78},
	{445, 12.28},
	{450, 13.31},
	{455, 13.66},
	{460, 13.69},
	{465, 13.13},
	{470, 12.28},
	{475, 11.42},
	{480, 11.66},
	{485, 22.04},
	{490, 26.17},
	{495, 18.57},
	{500, 11.36},
	{505, 6.83},
	{510, 5.58},
	{515, 4.88},
	{520, 4.31},
	{525, 3.76},
	{530, 3.61},
	{535, 5.62},
	{540, 38.59},
	{545, 100.00},
	{550, 36.54},
	{555, 10.57},
	{560, 2.98},
	{565, 2.05},
	{570, 1.84},
	{575, 6.09},
	{580, 17.27},
	{585, 21.77},
	{590, 18.72},
	{595, 10.15},
	{600, 7.26},
	{605, 5.17},
	{610, 56.66},
	{615, 49.39},
	{620, 18.57},
	{625, 14.21},
	{630, 14.01},
	{635, 5.99},
	{640, 2.68},
	{645, 3.14},
	{650, 6.25},
	{655, 5.78},
	{660, 6.75},
	{665, 5.16},
	{670, 3.03},
	{675, 1.57},
	{680, 1.72},
	{685, 1.54},
	{690, 1.71},
	{695, 1.10},
	{700, 0.28},
	{705, 3.65},
	{710, 7.54},
	{715, 2.34},
	{720, 0.05},
	{725, 0.04},
	{730, 0.04},
	{735, 0.03},
	{740, 0.03},
	{745, 0.02},
	{750, 0.02},
	{755, 0.01},
	{760, 0.01},
	{765, 0.00},
	{770, 0.00},
	{775, 0.00},
	{780, 0.00},
	{-1, 0}
},
std_illuminant_FL3_11[] = {
	{380, 3.85},
	{385, 2.91},
	{390, 2.56},
	{395, 2.59},
	{400, 3.63},
	{405, 74.54},
	{410, 14.69},
	{415, 17.22},
	{420, 24.99},
	{425, 34.40},
	{430, 44.57},
	{435, 228.08},
	{440, 61.53},
	{445, 65.31},
	{450, 66.35},
	{455, 64.37},
	{460, 59.81},
	{465, 54.24},
	{470, 47.42},
	{475, 41.10},
	{480, 40.04},
	{485, 85.54},
	{490, 86.55},
	{495, 53.47},
	{500, 30.91},
	{505, 17.41},
	{510, 12.56},
	{515, 10.10},
	{520, 8.48},
	{525, 7.74},
	{530, 8.58},
	{535, 21.39},
	{540, 220.12},
	{545, 417.35},
	{550, 146.13},
	{555, 36.67},
	{560, 16.51},
	{565, 12.56},
	{570, 10.81},
	{575, 25.31},
	{580, 53.31},
	{585, 80.75},
	{590, 53.56},
	{595, 44.02},
	{600, 33.05},
	{605, 20.26},
	{610, 233.61},
	{615, 118.20},
	{620, 51.66},
	{625, 61.27},
	{630, 55.15},
	{635, 12.95},
	{640, 8.93},
	{645, 9.77},
	{650, 17.12},
	{655, 13.01},
	{660, 10.45},
	{665, 10.33},
	{670, 7.70},
	{675, 6.34},
	{680, 7.35},
	{685, 8.22},
	{690, 7.93},
	{695, 5.70},
	{700, 2.23},
	{705, 12.43},
	{710, 24.24},
	{715, 8.74},
	{720, 1.39},
	{725, 1.23},
	{730, 1.10},
	{735, 0.84},
	{740, 0.94},
	{745, 1.23},
	{750, 0.68},
	{755, 0.52},
	{760, 4.60},
	{765, 0.45},
	{770, 1.04},
	{775, 0.45},
	{780, 0.00},
	{-1, 0}
},
std_illuminant_FL3_12[] = {
	{380, 1.62},
	{385, 2.06},
	{390, 2.71},
	{395, 3.11},
	{400, 3.67},
	{405, 74.60},
	{410, 8.88},
	{415, 4.77},
	{420, 4.72},
	{425, 4.72},
	{430, 4.94},
	{435, 150.29},
	{440, 6.08},
	{445, 7.13},
	{450, 9.10},
	{455, 11.76},
	{460, 14.96},
	{465, 18.54},
	{470, 22.48},
	{475, 26.76},
	{480, 31.66},
	{485, 40.93},
	{490, 45.83},
	{495, 46.00},
	{500, 45.26},
	{505, 43.16},
	{510, 41.63},
	{515, 39.75},
	{520, 37.83},
	{525, 36.16},
	{530, 35.25},
	{535, 37.04},
	{540, 59.86},
	{545, 183.53},
	{550, 59.03},
	{555, 47.93},
	{560, 48.67},
	{565, 52.69},
	{570, 57.24},
	{575, 77.75},
	{580, 87.81},
	{585, 80.55},
	{590, 84.83},
	{595, 86.84},
	{600, 91.44},
	{605, 96.51},
	{610, 105.25},
	{615, 106.74},
	{620, 108.53},
	{625, 106.92},
	{630, 101.54},
	{635, 95.20},
	{640, 89.34},
	{645, 82.95},
	{650, 75.78},
	{655, 68.65},
	{660, 61.70},
	{665, 55.23},
	{670, 48.58},
	{675, 42.90},
	{680, 37.74},
	{685, 32.93},
	{690, 29.65},
	{695, 25.19},
	{700, 21.69},
	{705, 19.28},
	{710, 17.36},
	{715, 14.74},
	{720, 12.86},
	{725, 11.28},
	{730, 9.97},
	{735, 8.88},
	{740, 7.78},
	{745, 7.04},
	{750, 6.30},
	{755, 5.55},
	{760, 10.15},
	{765, 4.50},
	{770, 4.81},
	{775, 3.72},
	{780, 3.28},
	{-1, 0}
},
std_illuminant_FL3_13[] = {
	{380, 2.23},
	{385, 2.92},
	{390, 3.91},
	{395, 4.55},
	{400, 5.46},
	{405, 77.40},
	{410, 11.25},
	{415, 7.69},
	{420, 8.29},
	{425, 8.98},
	{430, 10.01},
	{435, 204.45},
	{440, 13.75},
	{445, 16.88},
	{450, 21.73},
	{455, 27.96},
	{460, 34.92},
	{465, 41.96},
	{470, 48.62},
	{475, 54.33},
	{480, 59.49},
	{485, 67.91},
	{490, 70.01},
	{495, 66.40},
	{500, 62.07},
	{505, 56.95},
	{510, 52.70},
	{515, 48.54},
	{520, 44.80},
	{525, 41.75},
	{530, 39.77},
	{535, 40.50},
	{540, 59.27},
	{545, 184.09},
	{550, 59.06},
	{555, 49.95},
	{560, 50.90},
	{565, 54.51},
	{570, 58.33},
	{575, 77.49},
	{580, 85.78},
	{585, 76.20},
	{590, 78.73},
	{595, 78.95},
	{600, 81.48},
	{605, 84.57},
	{610, 87.75},
	{615, 89.56},
	{620, 91.36},
	{625, 89.00},
	{630, 83.67},
	{635, 78.26},
	{640, 73.19},
	{645, 67.61},
	{650, 61.42},
	{655, 55.49},
	{660, 49.78},
	{665, 44.46},
	{670, 39.13},
	{675, 34.45},
	{680, 30.28},
	{685, 26.37},
	{690, 23.88},
	{695, 20.10},
	{700, 17.40},
	{705, 15.29},
	{710, 13.62},
	{715, 11.68},
	{720, 10.31},
	{725, 9.11},
	{730, 8.03},
	{735, 7.13},
	{740, 6.31},
	{745, 5.67},
	{750, 5.11},
	{755, 4.55},
	{760, 9.06},
	{765, 3.74},
	{770, 4.04},
	{775, 3.14},
	{780, 2.75},
	{-1, 0}
},
std_illuminant_FL3_14[] = {
	{380, 2.87},
	{385, 3.69},
	{390, 4.87},
	{395, 5.82},
	{400, 7.17},
	{405, 72.21},
	{410, 13.69},
	{415, 11.12},
	{420, 12.43},
	{425, 13.90},
	{430, 15.82},
	{435, 200.99},
	{440, 21.72},
	{445, 26.33},
	{450, 32.85},
	{455, 40.80},
	{460, 49.23},
	{465, 57.39},
	{470, 65.26},
	{475, 71.99},
	{480, 78.25},
	{485, 88.85},
	{490, 91.67},
	{495, 86.81},
	{500, 80.42},
	{505, 73.82},
	{510, 69.12},
	{515, 63.69},
	{520, 58.44},
	{525, 53.57},
	{530, 49.66},
	{535, 48.44},
	{540, 72.56},
	{545, 200.42},
	{550, 65.00},
	{555, 47.49},
	{560, 44.14},
	{565, 44.71},
	{570, 46.01},
	{575, 63.52},
	{580, 71.73},
	{585, 63.52},
	{590, 64.13},
	{595, 63.74},
	{600, 66.82},
	{605, 70.65},
	{610, 79.29},
	{615, 80.77},
	{620, 83.59},
	{625, 82.59},
	{630, 77.60},
	{635, 72.47},
	{640, 68.34},
	{645, 63.82},
	{650, 58.57},
	{655, 53.18},
	{660, 47.97},
	{665, 43.14},
	{670, 38.19},
	{675, 33.85},
	{680, 29.94},
	{685, 26.24},
	{690, 23.90},
	{695, 20.33},
	{700, 17.42},
	{705, 15.64},
	{710, 14.34},
	{715, 12.21},
	{720, 10.65},
	{725, 9.43},
	{730, 8.34},
	{735, 7.52},
	{740, 6.73},
	{745, 6.08},
	{750, 5.52},
	{755, 5.00},
	{760, 9.47},
	{765, 4.08},
	{770, 4.43},
	{775, 3.39},
	{780, 3.17},
	{-1, 0}
},
std_illuminant_FL3_15[] = {
	{380, 300},
	{385, 286},
	{390, 268},
	{395, 244},
	{400, 304},
	{405, 581},
	{410, 225},
	{415, 155},
	{420, 152},
	{425, 170},
	{430, 295},
	{435, 1417},
	{440, 607},
	{445, 343},
	{450, 386},
	{455, 430},
	{460, 469},
	{465, 502},
	{470, 531},
	{475, 552},
	{480, 567},
	{485, 572},
	{490, 575},
	{495, 561},
	{500, 548},
	{505, 527},
	{510, 507},
	{515, 482},
	{520, 461},
	{525, 438},
	{530, 418},
	{535, 404},
	{540, 429},
	{545, 1016},
	{550, 581},
	{555, 370},
	{560, 368},
	{565, 371},
	{570, 377},
	{575, 490},
	{580, 525},
	{585, 402},
	{590, 404},
	{595, 412},
	{600, 418},
	{605, 425},
	{610, 428},
	{615, 432},
	{620, 433},
	{625, 431},
	{630, 427},
	{635, 420},
	{640, 410},
	{645, 399},
	{650, 385},
	{655, 370},
	{660, 352},
	{665, 336},
	{670, 317},
	{675, 298},
	{680, 277},
	{685, 260},
	{690, 242},
	{695, 223},
	{700, 202},
	{705, 187},
	{710, 167},
	{715, 152},
	{720, 136},
	{725, 125},
	{730, 113},
	{735, 103},
	{740, 93},
	{745, 84},
	{750, 75},
	{755, 66},
	{760, 58},
	{765, 51},
	{770, 46},
	{775, 41},
	{780, 37},
	{-1, 0}
},
std_illuminant_HP1[] = {
	{380, 1.90},
	{385, 2.20},
	{390, 2.50},
	{395, 2.70},
	{400, 3.10},
	{405, 4.30},
	{410, 3.80},
	{415, 4.20},
	{420, 4.80},
	{425, 5.19},
	{430, 5.89},
	{435, 7.39},
	{440, 7.89},
	{445, 5.69},
	{450, 12.89},
	{455, 6.69},
	{460, 4.30},
	{465, 20.78},
	{470, 12.99},
	{475, 6.69},
	{480, 1.40},
	{485, 1.50},
	{490, 3.20},
	{495, 18.18},
	{500, 56.24},
	{505, 2.90},
	{510, 2.10},
	{515, 13.39},
	{520, 2.10},
	{525, 2.00},
	{530, 2.20},
	{535, 2.30},
	{540, 2.60},
	{545, 5.10},
	{550, 11.39},
	{555, 15.48},
	{560, 20.78},
	{565, 55.64},
	{570, 254.03},
	{575, 56.14},
	{580, 111.78},
	{585, 297.98},
	{590, 142.55},
	{595, 334.84},
	{600, 189.40},
	{605, 117.78},
	{610, 79.92},
	{615, 108.09},
	{620, 46.85},
	{625, 38.16},
	{630, 32.47},
	{635, 28.37},
	{640, 25.37},
	{645, 22.98},
	{650, 20.38},
	{655, 19.78},
	{660, 17.78},
	{665, 16.78},
	{670, 19.18},
	{675, 17.98},
	{680, 13.69},
	{685, 9.99},
	{690, 8.19},
	{695, 7.59},
	{700, 6.99},
	{705, 6.79},
	{710, 6.49},
	{715, 6.39},
	{720, 6.09},
	{725, 5.99},
	{730, 5.79},
	{735, 5.79},
	{740, 5.79},
	{745, 5.79},
	{750, 6.39},
	{755, 5.99},
	{760, 5.59},
	{765, 31.97},
	{770, 27.87},
	{775, 5.89},
	{780, 6.69},
	{-1, 0}
},
std_illuminant_HP2[] = {
	{380, 2.64},
	{385, 2.77},
	{390, 3.42},
	{395, 3.68},
	{400, 4.33},
	{405, 5.50},
	{410, 5.94},
	{415, 7.20},
	{420, 9.02},
	{425, 10.27},
	{430, 12.48},
	{435, 16.82},
	{440, 16.04},
	{445, 15.26},
	{450, 22.58},
	{455, 20.07},
	{460, 15.13},
	{465, 25.27},
	{470, 28.04},
	{475, 15.99},
	{480, 10.40},
	{485, 11.10},
	{490, 13.44},
	{495, 22.62},
	{500, 49.71},
	{505, 17.21},
	{510, 17.12},
	{515, 27.26},
	{520, 20.02},
	{525, 21.54},
	{530, 23.36},
	{535, 25.66},
	{540, 29.69},
	{545, 43.12},
	{550, 98.30},
	{555, 125.60},
	{560, 134.57},
	{565, 149.70},
	{570, 166.12},
	{575, 98.77},
	{580, 30.47},
	{585, 1.17},
	{590, 0.39},
	{595, 1.65},
	{600, 21.41},
	{605, 76.11},
	{610, 126.16},
	{615, 161.96},
	{620, 160.06},
	{625, 158.19},
	{630, 153.69},
	{635, 147.40},
	{640, 140.60},
	{645, 134.92},
	{650, 127.59},
	{655, 124.65},
	{660, 118.02},
	{665, 113.94},
	{670, 118.10},
	{675, 115.16},
	{680, 102.85},
	{685, 90.54},
	{690, 83.34},
	{695, 79.44},
	{700, 76.97},
	{705, 74.85},
	{710, 73.12},
	{715, 71.51},
	{720, 70.13},
	{725, 69.04},
	{730, 67.48},
	{735, 66.70},
	{740, 66.31},
	{745, 65.14},
	{750, 65.70},
	{755, 64.79},
	{760, 64.10},
	{765, 83.04},
	{770, 86.25},
	{775, 63.93},
	{780, 64.92},
	{-1, 0}
},
std_illuminant_HP3[] = {
	{380, 3.15},
	{385, 7.49},
	{390, 10.87},
	{395, 12.57},
	{400, 12.97},
	{405, 21.29},
	{410, 26.29},
	{415, 30.18},
	{420, 43.06},
	{425, 29.58},
	{430, 23.18},
	{435, 35.28},
	{440, 26.29},
	{445, 24.29},
	{450, 22.91},
	{455, 26.20},
	{460, 29.31},
	{465, 25.30},
	{470, 28.14},
	{475, 24.05},
	{480, 21.82},
	{485, 20.51},
	{490, 23.05},
	{495, 26.98},
	{500, 30.96},
	{505, 30.72},
	{510, 27.13},
	{515, 29.55},
	{520, 34.22},
	{525, 29.98},
	{530, 41.21},
	{535, 173.14},
	{540, 141.37},
	{545, 64.98},
	{550, 33.83},
	{555, 34.26},
	{560, 33.32},
	{565, 52.80},
	{570, 74.29},
	{575, 47.97},
	{580, 49.20},
	{585, 96.07},
	{590, 85.41},
	{595, 175.18},
	{600, 153.73},
	{605, 120.22},
	{610, 98.90},
	{615, 90.22},
	{620, 70.07},
	{625, 66.84},
	{630, 57.61},
	{635, 53.03},
	{640, 49.85},
	{645, 48.16},
	{650, 42.76},
	{655, 50.64},
	{660, 48.42},
	{665, 41.27},
	{670, 43.44},
	{675, 40.48},
	{680, 35.16},
	{685, 34.94},
	{690, 24.68},
	{695, 24.70},
	{700, 21.49},
	{705, 19.49},
	{710, 18.48},
	{715, 17.55},
	{720, 17.36},
	{725, 17.09},
	{730, 16.32},
	{735, 16.07},
	{740, 16.58},
	{745, 15.78},
	{750, 17.66},
	{755, 20.46},
	{760, 16.59},
	{765, 17.81},
	{770, 16.07},
	{775, 14.83},
	{780, 14.61},
	{-1, 0}
},
std_illuminant_HP4[] = {
	{380, 9.80},
	{385, 13.30},
	{390, 19.97},
	{395, 25.81},
	{400, 24.69},
	{405, 47.66},
	{410, 54.44},
	{415, 63.82},
	{420, 85.52},
	{425, 60.54},
	{430, 38.37},
	{435, 88.20},
	{440, 44.94},
	{445, 35.64},
	{450, 30.75},
	{455, 33.77},
	{460, 40.81},
	{465, 33.77},
	{470, 35.28},
	{475, 32.55},
	{480, 29.44},
	{485, 26.16},
	{490, 29.96},
	{495, 32.83},
	{500, 33.58},
	{505, 41.16},
	{510, 32.93},
	{515, 32.13},
	{520, 34.45},
	{525, 30.12},
	{530, 41.13},
	{535, 187.10},
	{540, 101.37},
	{545, 123.96},
	{550, 42.47},
	{555, 34.73},
	{560, 31.82},
	{565, 54.67},
	{570, 57.45},
	{575, 70.43},
	{580, 69.50},
	{585, 49.37},
	{590, 183.35},
	{595, 162.15},
	{600, 109.35},
	{605, 72.38},
	{610, 70.60},
	{615, 58.08},
	{620, 44.13},
	{625, 50.20},
	{630, 40.80},
	{635, 37.91},
	{640, 36.71},
	{645, 38.30},
	{650, 31.24},
	{655, 35.31},
	{660, 45.62},
	{665, 35.82},
	{670, 89.91},
	{675, 36.01},
	{680, 32.57},
	{685, 39.26},
	{690, 23.27},
	{695, 25.30},
	{700, 20.02},
	{705, 17.54},
	{710, 16.25},
	{715, 15.20},
	{720, 15.15},
	{725, 15.22},
	{730, 14.26},
	{735, 12.63},
	{740, 14.75},
	{745, 13.19},
	{750, 17.63},
	{755, 23.38},
	{760, 16.02},
	{765, 24.46},
	{770, 22.05},
	{775, 16.11},
	{780, 12.91},
	{-1, 0}
},
std_illuminant_HP5[] = {
	{380, 0.34},
	{385, 7.11},
	{390, 11.49},
	{395, 14.97},
	{400, 14.95},
	{405, 29.14},
	{410, 38.08},
	{415, 51.56},
	{420, 62.56},
	{425, 55.61},
	{430, 41.98},
	{435, 50.02},
	{440, 42.14},
	{445, 39.04},
	{450, 40.52},
	{455, 45.29},
	{460, 51.01},
	{465, 49.18},
	{470, 49.05},
	{475, 46.12},
	{480, 45.73},
	{485, 39.46},
	{490, 44.39},
	{495, 46.14},
	{500, 49.54},
	{505, 59.76},
	{510, 48.47},
	{515, 48.38},
	{520, 48.70},
	{525, 44.25},
	{530, 54.42},
	{535, 128.93},
	{540, 81.26},
	{545, 67.36},
	{550, 48.48},
	{555, 51.41},
	{560, 48.88},
	{565, 68.52},
	{570, 80.85},
	{575, 65.96},
	{580, 59.43},
	{585, 67.57},
	{590, 128.34},
	{595, 131.85},
	{600, 101.70},
	{605, 77.05},
	{610, 66.27},
	{615, 77.09},
	{620, 60.51},
	{625, 65.23},
	{630, 57.86},
	{635, 56.20},
	{640, 54.32},
	{645, 56.34},
	{650, 45.74},
	{655, 50.79},
	{660, 56.66},
	{665, 51.99},
	{670, 84.31},
	{675, 47.48},
	{680, 47.46},
	{685, 61.78},
	{690, 34.51},
	{695, 38.74},
	{700, 30.98},
	{705, 25.45},
	{710, 22.88},
	{715, 20.82},
	{720, 21.05},
	{725, 20.81},
	{730, 18.69},
	{735, 17.54},
	{740, 19.58},
	{745, 16.42},
	{750, 23.77},
	{755, 35.39},
	{760, 21.37},
	{765, 34.58},
	{770, 30.21},
	{775, 19.71},
	{780, 15.61},
	{-1, 0}
},
std_illuminant_LED_B1[] = {
	{380, 0.00},
	{385, 0.01},
	{390, 0.01},
	{395, 0.02},
	{400, 0.04},
	{405, 0.07},
	{410, 0.15},
	{415, 0.28},
	{420, 0.53},
	{425, 0.92},
	{430, 1.54},
	{435, 2.52},
	{440, 4.16},
	{445, 6.39},
	{450, 7.89},
	{455, 7.57},
	{460, 6.25},
	{465, 5.16},
	{470, 4.37},
	{475, 3.84},
	{480, 3.70},
	{485, 3.88},
	{490, 4.26},
	{495, 4.79},
	{500, 5.41},
	{505, 6.05},
	{510, 6.70},
	{515, 7.34},
	{520, 7.98},
	{525, 8.64},
	{530, 9.31},
	{535, 10.02},
	{540, 10.76},
	{545, 11.53},
	{550, 12.38},
	{555, 13.28},
	{560, 14.23},
	{565, 15.20},
	{570, 16.20},
	{575, 17.19},
	{580, 18.14},
	{585, 19.02},
	{590, 19.78},
	{595, 20.38},
	{600, 20.80},
	{605, 21.00},
	{610, 20.97},
	{615, 20.71},
	{620, 20.23},
	{625, 19.56},
	{630, 18.76},
	{635, 17.82},
	{640, 16.78},
	{645, 15.66},
	{650, 14.49},
	{655, 13.31},
	{660, 12.15},
	{665, 11.02},
	{670, 9.95},
	{675, 8.93},
	{680, 7.98},
	{685, 7.10},
	{690, 6.30},
	{695, 5.57},
	{700, 4.89},
	{705, 4.26},
	{710, 3.72},
	{715, 3.25},
	{720, 2.83},
	{725, 2.47},
	{730, 2.15},
	{735, 1.87},
	{740, 1.63},
	{745, 1.42},
	{750, 1.25},
	{755, 1.10},
	{760, 0.97},
	{765, 0.86},
	{770, 0.76},
	{775, 0.68},
	{780, 0.61},
	{-1, 0}
},
std_illuminant_LED_B2[] = {
	{380, 0.00},
	{385, 0.00},
	{390, 0.00},
	{395, 0.01},
	{400, 0.02},
	{405, 0.05},
	{410, 0.11},
	{415, 0.24},
	{420, 0.50},
	{425, 0.96},
	{430, 1.71},
	{435, 2.82},
	{440, 4.71},
	{445, 7.87},
	{450, 10.56},
	{455, 10.24},
	{460, 7.94},
	{465, 6.25},
	{470, 5.23},
	{475, 4.36},
	{480, 4.00},
	{485, 4.17},
	{490, 4.59},
	{495, 5.21},
	{500, 5.96},
	{505, 6.72},
	{510, 7.44},
	{515, 8.11},
	{520, 8.74},
	{525, 9.39},
	{530, 10.06},
	{535, 10.75},
	{540, 11.49},
	{545, 12.25},
	{550, 13.05},
	{555, 13.86},
	{560, 14.70},
	{565, 15.50},
	{570, 16.28},
	{575, 17.00},
	{580, 17.69},
	{585, 18.31},
	{590, 18.83},
	{595, 19.24},
	{600, 19.51},
	{605, 19.59},
	{610, 19.48},
	{615, 19.19},
	{620, 18.72},
	{625, 18.10},
	{630, 17.34},
	{635, 16.47},
	{640, 15.51},
	{645, 14.49},
	{650, 13.42},
	{655, 12.33},
	{660, 11.26},
	{665, 10.24},
	{670, 9.25},
	{675, 8.30},
	{680, 7.42},
	{685, 6.60},
	{690, 5.85},
	{695, 5.17},
	{700, 4.55},
	{705, 3.99},
	{710, 3.49},
	{715, 3.04},
	{720, 2.65},
	{725, 2.31},
	{730, 2.01},
	{735, 1.75},
	{740, 1.52},
	{745, 1.32},
	{750, 1.15},
	{755, 1.00},
	{760, 0.87},
	{765, 0.76},
	{770, 0.67},
	{775, 0.59},
	{780, 0.52},
	{-1, 0}
},
std_illuminant_LED_B3[] = {
	{380, 0.00},
	{385, 0.00},
	{390, 0.01},
	{395, 0.02},
	{400, 0.05},
	{405, 0.11},
	{410, 0.25},
	{415, 0.56},
	{420, 1.20},
	{425, 2.37},
	{430, 4.24},
	{435, 7.17},
	{440, 12.11},
	{445, 17.70},
	{450, 18.87},
	{455, 14.58},
	{460, 9.90},
	{465, 7.53},
	{470, 6.02},
	{475, 5.11},
	{480, 5.17},
	{485, 5.82},
	{490, 6.77},
	{495, 7.88},
	{500, 8.94},
	{505, 9.82},
	{510, 10.52},
	{515, 11.06},
	{520, 11.51},
	{525, 11.93},
	{530, 12.37},
	{535, 12.83},
	{540, 13.31},
	{545, 13.79},
	{550, 14.26},
	{555, 14.68},
	{560, 15.08},
	{565, 15.42},
	{570, 15.72},
	{575, 15.97},
	{580, 16.18},
	{585, 16.37},
	{590, 16.50},
	{595, 16.55},
	{600, 16.50},
	{605, 16.32},
	{610, 16.00},
	{615, 15.54},
	{620, 14.96},
	{625, 14.27},
	{630, 13.48},
	{635, 12.62},
	{640, 11.71},
	{645, 10.78},
	{650, 9.85},
	{655, 8.93},
	{660, 8.04},
	{665, 7.20},
	{670, 6.42},
	{675, 5.69},
	{680, 5.02},
	{685, 4.42},
	{690, 3.88},
	{695, 3.39},
	{700, 2.95},
	{705, 2.56},
	{710, 2.22},
	{715, 1.92},
	{720, 1.65},
	{725, 1.43},
	{730, 1.23},
	{735, 1.06},
	{740, 0.91},
	{745, 0.78},
	{750, 0.68},
	{755, 0.58},
	{760, 0.50},
	{765, 0.43},
	{770, 0.37},
	{775, 0.32},
	{780, 0.28},
	{-1, 0}
},
std_illuminant_LED_B4[] = {
	{380, 0.00},
	{385, 0.00},
	{390, 0.00},
	{395, 0.01},
	{400, 0.03},
	{405, 0.08},
	{410, 0.21},
	{415, 0.54},
	{420, 1.31},
	{425, 2.75},
	{430, 5.04},
	{435, 8.31},
	{440, 13.37},
	{445, 20.61},
	{450, 25.91},
	{455, 24.12},
	{460, 17.47},
	{465, 11.90},
	{470, 8.62},
	{475, 6.34},
	{480, 4.89},
	{485, 4.25},
	{490, 4.19},
	{495, 4.70},
	{500, 5.77},
	{505, 7.27},
	{510, 8.94},
	{515, 10.60},
	{520, 12.11},
	{525, 13.36},
	{530, 14.30},
	{535, 15.02},
	{540, 15.54},
	{545, 15.90},
	{550, 16.15},
	{555, 16.33},
	{560, 16.42},
	{565, 16.44},
	{570, 16.36},
	{575, 16.20},
	{580, 15.98},
	{585, 15.70},
	{590, 15.36},
	{595, 14.93},
	{600, 14.44},
	{605, 13.86},
	{610, 13.24},
	{615, 12.57},
	{620, 11.84},
	{625, 11.12},
	{630, 10.38},
	{635, 9.65},
	{640, 8.91},
	{645, 8.19},
	{650, 7.51},
	{655, 6.86},
	{660, 6.21},
	{665, 5.60},
	{670, 5.05},
	{675, 4.54},
	{680, 4.05},
	{685, 3.62},
	{690, 3.23},
	{695, 2.87},
	{700, 2.53},
	{705, 2.24},
	{710, 1.99},
	{715, 1.76},
	{720, 1.55},
	{725, 1.37},
	{730, 1.21},
	{735, 1.07},
	{740, 0.95},
	{745, 0.85},
	{750, 0.75},
	{755, 0.67},
	{760, 0.61},
	{765, 0.55},
	{770, 0.50},
	{775, 0.45},
	{780, 0.42},
	{-1, 0}
},
std_illuminant_LED_B5[] = {
	{380, 0.00},
	{385, 0.01},
	{390, 0.01},
	{395, 0.03},
	{400, 0.07},
	{405, 0.16},
	{410, 0.35},
	{415, 0.78},
	{420, 1.67},
	{425, 3.30},
	{430, 5.94},
	{435, 9.92},
	{440, 16.15},
	{445, 25.15},
	{450, 32.34},
	{455, 31.18},
	{460, 23.46},
	{465, 16.39},
	{470, 12.08},
	{475, 9.08},
	{480, 7.21},
	{485, 6.48},
	{490, 6.49},
	{495, 7.05},
	{500, 8.10},
	{505, 9.45},
	{510, 10.88},
	{515, 12.22},
	{520, 13.38},
	{525, 14.29},
	{530, 14.98},
	{535, 15.48},
	{540, 15.81},
	{545, 16.01},
	{550, 16.10},
	{555, 16.13},
	{560, 16.10},
	{565, 15.98},
	{570, 15.77},
	{575, 15.50},
	{580, 15.15},
	{585, 14.76},
	{590, 14.31},
	{595, 13.79},
	{600, 13.22},
	{605, 12.59},
	{610, 11.91},
	{615, 11.20},
	{620, 10.47},
	{625, 9.73},
	{630, 9.00},
	{635, 8.27},
	{640, 7.57},
	{645, 6.90},
	{650, 6.25},
	{655, 5.65},
	{660, 5.08},
	{665, 4.55},
	{670, 4.06},
	{675, 3.61},
	{680, 3.22},
	{685, 2.86},
	{690, 2.54},
	{695, 2.26},
	{700, 2.00},
	{705, 1.75},
	{710, 1.54},
	{715, 1.36},
	{720, 1.20},
	{725, 1.05},
	{730, 0.93},
	{735, 0.82},
	{740, 0.72},
	{745, 0.64},
	{750, 0.56},
	{755, 0.49},
	{760, 0.44},
	{765, 0.39},
	{770, 0.35},
	{775, 0.31},
	{780, 0.27},
	{-1, 0}
},
std_illuminant_LED_BH1[] = {
	{380, 0.00},
	{385, 0.01},
	{390, 0.02},
	{395, 0.04},
	{400, 0.08},
	{405, 0.17},
	{410, 0.41},
	{415, 0.93},
	{420, 1.84},
	{425, 3.05},
	{430, 4.29},
	{435, 5.69},
	{440, 7.06},
	{445, 7.91},
	{450, 7.74},
	{455, 6.62},
	{460, 5.13},
	{465, 3.85},
	{470, 2.94},
	{475, 2.34},
	{480, 1.99},
	{485, 1.92},
	{490, 2.19},
	{495, 2.87},
	{500, 4.03},
	{505, 5.64},
	{510, 7.49},
	{515, 9.25},
	{520, 10.82},
	{525, 12.11},
	{530, 13.08},
	{535, 13.66},
	{540, 14.01},
	{545, 14.19},
	{550, 14.28},
	{555, 14.27},
	{560, 14.19},
	{565, 14.03},
	{570, 13.82},
	{575, 13.59},
	{580, 13.35},
	{585, 13.20},
	{590, 13.19},
	{595, 13.46},
	{600, 14.31},
	{605, 16.15},
	{610, 19.49},
	{615, 25.07},
	{620, 33.87},
	{625, 40.75},
	{630, 35.59},
	{635, 21.59},
	{640, 11.11},
	{645, 7.27},
	{650, 5.58},
	{655, 4.64},
	{660, 3.98},
	{665, 3.48},
	{670, 3.07},
	{675, 2.73},
	{680, 2.42},
	{685, 2.15},
	{690, 1.91},
	{695, 1.70},
	{700, 1.50},
	{705, 1.33},
	{710, 1.18},
	{715, 1.05},
	{720, 0.93},
	{725, 0.83},
	{730, 0.74},
	{735, 0.65},
	{740, 0.57},
	{745, 0.51},
	{750, 0.46},
	{755, 0.41},
	{760, 0.37},
	{765, 0.34},
	{770, 0.30},
	{775, 0.28},
	{780, 0.25},
	{-1, 0}
},
std_illuminant_LED_RGB1[] = {
	{380, 0.00},
	{385, 0.00},
	{390, 0.00},
	{395, 0.01},
	{400, 0.02},
	{405, 0.05},
	{410, 0.11},
	{415, 0.24},
	{420, 0.50},
	{425, 0.94},
	{430, 1.60},
	{435, 2.43},
	{440, 3.38},
	{445, 4.59},
	{450, 5.84},
	{455, 5.56},
	{460, 4.00},
	{465, 3.14},
	{470, 2.80},
	{475, 2.68},
	{480, 3.03},
	{485, 3.98},
	{490, 5.53},
	{495, 7.84},
	{500, 10.96},
	{505, 14.61},
	{510, 18.01},
	{515, 20.24},
	{520, 20.57},
	{525, 19.22},
	{530, 16.93},
	{535, 14.58},
	{540, 12.61},
	{545, 11.09},
	{550, 9.93},
	{555, 9.11},
	{560, 8.60},
	{565, 8.31},
	{570, 8.21},
	{575, 8.24},
	{580, 8.42},
	{585, 8.74},
	{590, 9.25},
	{595, 10.00},
	{600, 11.10},
	{605, 12.74},
	{610, 15.35},
	{615, 19.43},
	{620, 26.01},
	{625, 36.47},
	{630, 51.10},
	{635, 62.69},
	{640, 52.07},
	{645, 28.62},
	{650, 15.50},
	{655, 9.58},
	{660, 6.54},
	{665, 4.95},
	{670, 4.01},
	{675, 3.37},
	{680, 2.89},
	{685, 2.51},
	{690, 2.18},
	{695, 1.92},
	{700, 1.67},
	{705, 1.44},
	{710, 1.25},
	{715, 1.09},
	{720, 0.93},
	{725, 0.82},
	{730, 0.71},
	{735, 0.61},
	{740, 0.53},
	{745, 0.45},
	{750, 0.40},
	{755, 0.35},
	{760, 0.30},
	{765, 0.27},
	{770, 0.24},
	{775, 0.21},
	{780, 0.17},
	{-1, 0}
},
std_illuminant_LED_V1[] = {
	{380, 0.01},
	{385, 0.03},
	{390, 0.14},
	{395, 0.61},
	{400, 2.62},
	{405, 8.43},
	{410, 16.51},
	{415, 17.90},
	{420, 11.26},
	{425, 5.94},
	{430, 3.31},
	{435, 2.25},
	{440, 2.07},
	{445, 2.29},
	{450, 2.68},
	{455, 3.15},
	{460, 3.64},
	{465, 4.18},
	{470, 4.83},
	{475, 5.57},
	{480, 6.40},
	{485, 7.27},
	{490, 8.08},
	{495, 8.73},
	{500, 9.21},
	{505, 9.54},
	{510, 9.75},
	{515, 9.91},
	{520, 10.06},
	{525, 10.26},
	{530, 10.51},
	{535, 10.82},
	{540, 11.17},
	{545, 11.55},
	{550, 11.92},
	{555, 12.30},
	{560, 12.68},
	{565, 13.07},
	{570, 13.52},
	{575, 14.06},
	{580, 14.70},
	{585, 15.46},
	{590, 16.38},
	{595, 17.39},
	{600, 18.50},
	{605, 19.51},
	{610, 20.52},
	{615, 21.52},
	{620, 22.38},
	{625, 23.07},
	{630, 23.51},
	{635, 23.71},
	{640, 23.67},
	{645, 23.35},
	{650, 22.81},
	{655, 22.01},
	{660, 21.03},
	{665, 19.91},
	{670, 18.69},
	{675, 17.39},
	{680, 16.05},
	{685, 14.69},
	{690, 13.36},
	{695, 12.04},
	{700, 10.80},
	{705, 9.62},
	{710, 8.54},
	{715, 7.57},
	{720, 6.68},
	{725, 5.86},
	{730, 5.12},
	{735, 4.46},
	{740, 3.88},
	{745, 3.37},
	{750, 2.94},
	{755, 2.54},
	{760, 2.21},
	{765, 1.90},
	{770, 1.65},
	{775, 1.44},
	{780, 1.22},
	{-1, 0}
},
std_illuminant_LED_V2[] = {
	{380, 0.01},
	{385, 0.06},
	{390, 0.26},
	{395, 1.15},
	{400, 4.47},
	{405, 11.98},
	{410, 19.89},
	{415, 20.24},
	{420, 14.39},
	{425, 8.95},
	{430, 5.78},
	{435, 4.65},
	{440, 4.86},
	{445, 5.78},
	{450, 6.97},
	{455, 8.10},
	{460, 9.05},
	{465, 9.82},
	{470, 10.52},
	{475, 11.21},
	{480, 11.87},
	{485, 12.50},
	{490, 12.98},
	{495, 13.23},
	{500, 13.30},
	{505, 13.21},
	{510, 13.05},
	{515, 12.88},
	{520, 12.74},
	{525, 12.68},
	{530, 12.70},
	{535, 12.77},
	{540, 12.91},
	{545, 13.04},
	{550, 13.16},
	{555, 13.26},
	{560, 13.35},
	{565, 13.42},
	{570, 13.52},
	{575, 13.64},
	{580, 13.83},
	{585, 14.07},
	{590, 14.42},
	{595, 14.82},
	{600, 15.26},
	{605, 15.64},
	{610, 16.03},
	{615, 16.40},
	{620, 16.67},
	{625, 16.88},
	{630, 16.93},
	{635, 16.85},
	{640, 16.62},
	{645, 16.23},
	{650, 15.72},
	{655, 15.07},
	{660, 14.31},
	{665, 13.45},
	{670, 12.57},
	{675, 11.64},
	{680, 10.69},
	{685, 9.78},
	{690, 8.87},
	{695, 8.00},
	{700, 7.17},
	{705, 6.37},
	{710, 5.65},
	{715, 5.01},
	{720, 4.42},
	{725, 3.88},
	{730, 3.39},
	{735, 2.95},
	{740, 2.58},
	{745, 2.24},
	{750, 1.95},
	{755, 1.70},
	{760, 1.47},
	{765, 1.30},
	{770, 1.10},
	{775, 0.96},
	{780, 0.84},
	{-1, 0}
},
std_illuminant_ID65[] = {
	{300, 0.00},
	{305, 0.00},
	{310, 0.00},
	{315, 0.00},
	{320, 0.03},
	{325, 0.33},
	{330, 1.60},
	{335, 4.17},
	{340, 8.76},
	{345, 15.61},
	{350, 24.24},
	{355, 31.93},
	{360, 37.94},
	{365, 43.65},
	{370, 47.99},
	{375, 47.23},
	{380, 46.01},
	{385, 49.19},
	{390, 52.63},
	{395, 67.11},
	{400, 81.45},
	{405, 85.97},
	{410, 90.20},
	{415, 90.96},
	{420, 91.75},
	{425, 88.40},
	{430, 85.08},
	{435, 93.98},
	{440, 102.94},
	{445, 109.14},
	{450, 115.49},
	{455, 116.30},
	{460, 117.08},
	{465, 115.89},
	{470, 114.62},
	{475, 115.30},
	{480, 115.97},
	{485, 112.55},
	{490, 109.12},
	{495, 109.48},
	{500, 109.82},
	{505, 109.12},
	{510, 108.41},
	{515, 106.93},
	{520, 105.42},
	{525, 106.84},
	{530, 108.25},
	{535, 106.54},
	{540, 104.83},
	{545, 104.57},
	{550, 104.29},
	{555, 102.16},
	{560, 100.00},
	{565, 98.03},
	{570, 96.01},
	{575, 95.50},
	{580, 94.97},
	{585, 91.19},
	{590, 87.44},
	{595, 87.84},
	{600, 88.27},
	{605, 87.86},
	{610, 87.41},
	{615, 86.16},
	{620, 84.90},
	{625, 82.50},
	{630, 80.13},
	{635, 80.05},
	{640, 79.97},
	{645, 77.97},
	{650, 75.97},
	{655, 75.83},
	{660, 75.69},
	{665, 76.44},
	{670, 77.15},
	{675, 74.94},
	{680, 72.77},
	{685, 68.58},
	{690, 64.42},
	{695, 65.04},
	{700, 65.62},
	{705, 66.60},
	{710, 67.57},
	{715, 61.51},
	{720, 55.50},
	{725, 59.00},
	{730, 62.46},
	{735, 64.50},
	{740, 66.48},
	{745, 61.13},
	{750, 55.83},
	{755, 48.09},
	{760, 40.41},
	{765, 49.09},
	{770, 57.70},
	{775, 56.00},
	{780, 54.30},
	{-1, 0}
},
std_illuminant_ID50[] = {
	{300, 0.00},
	{305, 0.00},
	{310, 0.00},
	{315, 0.00},
	{320, 0.01},
	{325, 0.13},
	{330, 0.64},
	{335, 1.77},
	{340, 3.94},
	{345, 7.16},
	{350, 11.34},
	{355, 15.68},
	{360, 19.48},
	{365, 22.50},
	{370, 24.84},
	{375, 23.81},
	{380, 22.55},
	{385, 25.56},
	{390, 28.77},
	{395, 38.67},
	{400, 48.53},
	{405, 52.21},
	{410, 55.72},
	{415, 57.33},
	{420, 58.95},
	{425, 57.84},
	{430, 56.75},
	{435, 65.08},
	{440, 73.45},
	{445, 79.73},
	{450, 86.12},
	{455, 88.09},
	{460, 90.05},
	{465, 90.64},
	{470, 91.18},
	{475, 93.17},
	{480, 95.14},
	{485, 93.69},
	{490, 92.23},
	{495, 94.19},
	{500, 96.13},
	{505, 96.65},
	{510, 97.16},
	{515, 97.44},
	{520, 97.71},
	{525, 100.18},
	{530, 102.63},
	{535, 101.90},
	{540, 101.16},
	{545, 101.87},
	{550, 102.56},
	{555, 101.29},
	{560, 100.00},
	{565, 98.73},
	{570, 97.41},
	{575, 97.75},
	{580, 98.07},
	{585, 95.12},
	{590, 92.18},
	{595, 93.98},
	{600, 95.80},
	{605, 96.35},
	{610, 96.85},
	{615, 96.37},
	{620, 95.88},
	{625, 93.97},
	{630, 92.09},
	{635, 93.28},
	{640, 94.45},
	{645, 92.64},
	{650, 90.82},
	{655, 91.74},
	{660, 92.65},
	{665, 94.65},
	{670, 96.58},
	{675, 94.35},
	{680, 92.14},
	{685, 86.42},
	{690, 80.74},
	{695, 82.37},
	{700, 83.94},
	{705, 84.18},
	{710, 84.42},
	{715, 76.80},
	{720, 69.24},
	{725, 73.31},
	{730, 77.32},
	{735, 79.68},
	{740, 81.97},
	{745, 75.30},
	{750, 68.69},
	{755, 59.42},
	{760, 50.23},
	{765, 60.97},
	{770, 71.62},
	{775, 69.34},
	{780, 67.06},
	{-1, 0},
};

struct std_illuminant {
	const char *name;
	spectral_item *sp;
} std_illuminants[] = {
	{"A", std_illuminant_A},
	{"B", std_illuminant_B},
	{"C", std_illuminant_C},
	{"D50", std_illuminant_D50},
	{"D55", std_illuminant_D55},
	{"D65", std_illuminant_D65},
	{"E", std_illuminant_E},
	{"FL1", std_illuminant_FL1},
	{"FL2", std_illuminant_FL2},
	{"FL3", std_illuminant_FL3},
	{"FL4", std_illuminant_FL4},
	{"FL5", std_illuminant_FL5},
	{"FL6", std_illuminant_FL6},
	{"FL7", std_illuminant_FL7},
	{"FL8", std_illuminant_FL8},
	{"FL9", std_illuminant_FL9},
	{"FL10", std_illuminant_FL10},
	{"FL11", std_illuminant_FL11},
	{"FL12", std_illuminant_FL12},
	{"FL3_1", std_illuminant_FL3_1},
	{"FL3_2", std_illuminant_FL3_2},
	{"FL3_3", std_illuminant_FL3_3},
	{"FL3_4", std_illuminant_FL3_4},
	{"FL3_5", std_illuminant_FL3_5},
	{"FL3_6", std_illuminant_FL3_6},
	{"FL3_7", std_illuminant_FL3_7},
	{"FL3_8", std_illuminant_FL3_8},
	{"FL3_9", std_illuminant_FL3_9},
	{"FL3_10", std_illuminant_FL3_10},
	{"FL3_11", std_illuminant_FL3_11},
	{"FL3_12", std_illuminant_FL3_12},
	{"FL3_13", std_illuminant_FL3_13},
	{"FL3_14", std_illuminant_FL3_14},
	{"FL3_15", std_illuminant_FL3_15},
	{"HP1", std_illuminant_HP1},
	{"HP2", std_illuminant_HP2},
	{"HP3", std_illuminant_HP3},
	{"HP4", std_illuminant_HP4},
	{"HP5", std_illuminant_HP5},
	{"LED_B1", std_illuminant_LED_B1},
	{"LED_B2", std_illuminant_LED_B2},
	{"LED_B3", std_illuminant_LED_B3},
	{"LED_B4", std_illuminant_LED_B4},
	{"LED_B5", std_illuminant_LED_B5},
	{"LED_BH1", std_illuminant_LED_BH1},
	{"LED_RGB1", std_illuminant_LED_RGB1},
	{"LED_V1", std_illuminant_LED_V1},
	{"LED_V2", std_illuminant_LED_V2},
	{"ID65", std_illuminant_ID65},
	{"ID50", std_illuminant_ID50},
	{0}
};

// }ZF[CƎˎ̑Fl
// https://www.rit.edu/science/munsell-color-science-lab-educational-resources
struct muncell_to_xy {
	const char *hue;
	int V, C;
	double x, y;
}muncell_to_xy_illumi_C[] = {
	{ "10RP", 1, 2, 0.3629, 0.271 },
	{ "10RP", 1, 4, 0.392, 0.2423 },
	{ "10RP", 1, 6, 0.4151, 0.2169 },
	{ "10RP", 1, 8, 0.4357, 0.1921 },
	{ "10RP", 1, 10, 0.4521, 0.171 },
	{ "10RP", 1, 12, 0.4668, 0.1514 },
	{ "2.5R", 1, 2, 0.3768, 0.2816 },
	{ "2.5R", 1, 4, 0.4166, 0.2569 },
	{ "2.5R", 1, 6, 0.4515, 0.2329 },
	{ "2.5R", 1, 8, 0.4812, 0.2103 },
	{ "2.5R", 1, 10, 0.5058, 0.19 },
	{ "5R", 1, 2, 0.3908, 0.2929 },
	{ "5R", 1, 4, 0.442, 0.2728 },
	{ "5R", 1, 6, 0.4885, 0.2515 },
	{ "5R", 1, 8, 0.5282, 0.2297 },
	{ "5R", 1, 10, 0.5604, 0.21 },
	{ "7.5R", 1, 2, 0.402, 0.3034 },
	{ "7.5R", 1, 4, 0.466, 0.2888 },
	{ "7.5R", 1, 6, 0.5235, 0.2698 },
	{ "7.5R", 1, 8, 0.5722, 0.2487 },
	{ "7.5R", 1, 10, 0.6111, 0.229 },
	{ "10R", 1, 2, 0.4128, 0.3154 },
	{ "10R", 1, 4, 0.4933, 0.3068 },
	{ "10R", 1, 6, 0.5584, 0.2921 },
	{ "10R", 1, 8, 0.6178, 0.2713 },
	{ "10R", 1, 10, 0.6661, 0.2499 },
	{ "2.5YR", 1, 2, 0.4258, 0.3344 },
	{ "2.5YR", 1, 4, 0.5311, 0.3371 },
	{ "2.5YR", 1, 6, 0.6048, 0.327 },
	{ "2.5YR", 1, 8, 0.6721, 0.3058 },
	{ "5YR", 1, 2, 0.4377, 0.358 },
	{ "5YR", 1, 4, 0.566, 0.3795 },
	{ "7.5YR", 1, 2, 0.443, 0.3775 },
	{ "10YR", 1, 2, 0.4446, 0.3982 },
	{ "2.5Y", 1, 2, 0.4362, 0.4177 },
	{ "5Y", 1, 2, 0.423, 0.4265 },
	{ "7.5Y", 1, 2, 0.4042, 0.4287 },
	{ "10Y", 1, 2, 0.3802, 0.4212 },
	{ "2.5GY", 1, 2, 0.354, 0.4088 },
	{ "5GY", 1, 2, 0.3359, 0.3982 },
	{ "5GY", 1, 4, 0.3765, 0.5942 },
	{ "7.5GY", 1, 2, 0.3154, 0.384 },
	{ "7.5GY", 1, 4, 0.3133, 0.538 },
	{ "10GY", 1, 2, 0.3006, 0.372 },
	{ "10GY", 1, 4, 0.2722, 0.4903 },
	{ "10GY", 1, 6, 0.2232, 0.6392 },
	{ "2.5G", 1, 2, 0.291, 0.3634 },
	{ "2.5G", 1, 4, 0.2454, 0.4489 },
	{ "2.5G", 1, 6, 0.1711, 0.5619 },
	{ "2.5G", 1, 8, 0.062, 0.6896 },
	{ "5G", 1, 2, 0.2833, 0.3564 },
	{ "5G", 1, 4, 0.229, 0.4218 },
	{ "5G", 1, 6, 0.1468, 0.4996 },
	{ "5G", 1, 8, 0.0559, 0.571 },
	{ "7.5G", 1, 2, 0.2758, 0.3484 },
	{ "7.5G", 1, 4, 0.2159, 0.3967 },
	{ "7.5G", 1, 6, 0.1344, 0.4505 },
	{ "7.5G", 1, 8, 0.053, 0.4943 },
	{ "10G", 1, 2, 0.2689, 0.3407 },
	{ "10G", 1, 4, 0.204, 0.3724 },
	{ "10G", 1, 6, 0.1249, 0.4019 },
	{ "10G", 1, 8, 0.0511, 0.4158 },
	{ "2.5BG", 1, 2, 0.26, 0.3289 },
	{ "2.5BG", 1, 4, 0.1883, 0.3406 },
	{ "2.5BG", 1, 6, 0.1169, 0.3452 },
	{ "2.5BG", 1, 8, 0.0476, 0.3458 },
	{ "5BG", 1, 2, 0.25, 0.3141 },
	{ "5BG", 1, 4, 0.1753, 0.3021 },
	{ "5BG", 1, 6, 0.1093, 0.286 },
	{ "7.5BG", 1, 2, 0.243, 0.3023 },
	{ "7.5BG", 1, 4, 0.1702, 0.2768 },
	{ "7.5BG", 1, 6, 0.1059, 0.2485 },
	{ "10BG", 1, 2, 0.2362, 0.2882 },
	{ "10BG", 1, 4, 0.1658, 0.2496 },
	{ "10BG", 1, 6, 0.1074, 0.2129 },
	{ "2.5B", 1, 2, 0.2322, 0.2781 },
	{ "2.5B", 1, 4, 0.1649, 0.2324 },
	{ "2.5B", 1, 6, 0.1118, 0.1908 },
	{ "5B", 1, 2, 0.2291, 0.2677 },
	{ "5B", 1, 4, 0.1667, 0.2168 },
	{ "5B", 1, 6, 0.1212, 0.1745 },
	{ "7.5B", 1, 2, 0.2291, 0.2579 },
	{ "7.5B", 1, 4, 0.1716, 0.2048 },
	{ "7.5B", 1, 6, 0.1303, 0.1639 },
	{ "7.5B", 1, 8, 0.0968, 0.128 },
	{ "10B", 1, 2, 0.2309, 0.2491 },
	{ "10B", 1, 4, 0.1783, 0.1974 },
	{ "10B", 1, 6, 0.1392, 0.1563 },
	{ "10B", 1, 8, 0.1077, 0.1218 },
	{ "2.5PB", 1, 2, 0.236, 0.242 },
	{ "2.5PB", 1, 4, 0.1895, 0.1911 },
	{ "2.5PB", 1, 6, 0.1539, 0.1491 },
	{ "2.5PB", 1, 8, 0.1273, 0.1157 },
	{ "5PB", 1, 2, 0.2427, 0.2368 },
	{ "5PB", 1, 4, 0.2012, 0.1867 },
	{ "5PB", 1, 6, 0.1678, 0.1447 },
	{ "5PB", 1, 8, 0.1447, 0.1124 },
	{ "5PB", 1, 10, 0.1285, 0.087 },
	{ "7.5PB", 1, 2, 0.2547, 0.231 },
	{ "7.5PB", 1, 4, 0.2232, 0.1821 },
	{ "7.5PB", 1, 6, 0.2, 0.1422 },
	{ "7.5PB", 1, 8, 0.1872, 0.1141 },
	{ "7.5PB", 1, 10, 0.1804, 0.095 },
	{ "7.5PB", 1, 12, 0.1763, 0.0804 },
	{ "7.5PB", 1, 14, 0.1738, 0.0688 },
	{ "7.5PB", 1, 16, 0.172, 0.0583 },
	{ "7.5PB", 1, 18, 0.1709, 0.0518 },
	{ "7.5PB", 1, 20, 0.1701, 0.0454 },
	{ "7.5PB", 1, 22, 0.1696, 0.0402 },
	{ "7.5PB", 1, 24, 0.1691, 0.0352 },
	{ "7.5PB", 1, 26, 0.1689, 0.0309 },
	{ "7.5PB", 1, 28, 0.1686, 0.027 },
	{ "7.5PB", 1, 30, 0.1684, 0.0234 },
	{ "7.5PB", 1, 32, 0.1682, 0.0202 },
	{ "7.5PB", 1, 34, 0.1682, 0.018 },
	{ "7.5PB", 1, 36, 0.1681, 0.016 },
	{ "7.5PB", 1, 38, 0.168, 0.014 },
	{ "10PB", 1, 2, 0.2677, 0.228 },
	{ "10PB", 1, 4, 0.2459, 0.1828 },
	{ "10PB", 1, 6, 0.229, 0.147 },
	{ "10PB", 1, 8, 0.219, 0.1228 },
	{ "10PB", 1, 10, 0.212, 0.1029 },
	{ "10PB", 1, 12, 0.207, 0.0869 },
	{ "10PB", 1, 14, 0.2038, 0.0745 },
	{ "10PB", 1, 16, 0.2008, 0.0638 },
	{ "10PB", 1, 18, 0.1991, 0.0564 },
	{ "10PB", 1, 20, 0.1976, 0.0493 },
	{ "10PB", 1, 22, 0.1965, 0.0436 },
	{ "10PB", 1, 24, 0.1952, 0.038 },
	{ "10PB", 1, 26, 0.1942, 0.0326 },
	{ "10PB", 1, 28, 0.1936, 0.0281 },
	{ "10PB", 1, 30, 0.1928, 0.024 },
	{ "2.5P", 1, 2, 0.2808, 0.2296 },
	{ "2.5P", 1, 4, 0.2668, 0.1874 },
	{ "2.5P", 1, 6, 0.257, 0.1559 },
	{ "2.5P", 1, 8, 0.2496, 0.1303 },
	{ "2.5P", 1, 10, 0.2441, 0.1112 },
	{ "2.5P", 1, 12, 0.2394, 0.094 },
	{ "2.5P", 1, 14, 0.2361, 0.081 },
	{ "2.5P", 1, 16, 0.2331, 0.0696 },
	{ "2.5P", 1, 18, 0.2312, 0.0618 },
	{ "2.5P", 1, 20, 0.2295, 0.0542 },
	{ "2.5P", 1, 22, 0.2279, 0.0473 },
	{ "2.5P", 1, 24, 0.2266, 0.0418 },
	{ "2.5P", 1, 26, 0.2251, 0.0355 },
	{ "5P", 1, 2, 0.2936, 0.233 },
	{ "5P", 1, 4, 0.2854, 0.1927 },
	{ "5P", 1, 6, 0.2794, 0.1628 },
	{ "5P", 1, 8, 0.2742, 0.1375 },
	{ "5P", 1, 10, 0.2701, 0.1178 },
	{ "5P", 1, 12, 0.267, 0.1006 },
	{ "5P", 1, 14, 0.2645, 0.0863 },
	{ "5P", 1, 16, 0.2625, 0.0746 },
	{ "5P", 1, 18, 0.2612, 0.0667 },
	{ "5P", 1, 20, 0.2601, 0.0586 },
	{ "5P", 1, 22, 0.259, 0.0509 },
	{ "7.5P", 1, 2, 0.303, 0.2361 },
	{ "7.5P", 1, 4, 0.2991, 0.1974 },
	{ "7.5P", 1, 6, 0.296, 0.1682 },
	{ "7.5P", 1, 8, 0.2932, 0.1429 },
	{ "7.5P", 1, 10, 0.2905, 0.1229 },
	{ "7.5P", 1, 12, 0.2884, 0.1059 },
	{ "7.5P", 1, 14, 0.2868, 0.0903 },
	{ "7.5P", 1, 16, 0.2852, 0.079 },
	{ "7.5P", 1, 18, 0.2841, 0.0706 },
	{ "7.5P", 1, 20, 0.2831, 0.0625 },
	{ "10P", 1, 2, 0.3132, 0.2404 },
	{ "10P", 1, 4, 0.3132, 0.2032 },
	{ "10P", 1, 6, 0.3126, 0.1737 },
	{ "10P", 1, 8, 0.3114, 0.1481 },
	{ "10P", 1, 10, 0.3102, 0.1282 },
	{ "10P", 1, 12, 0.3094, 0.111 },
	{ "10P", 1, 14, 0.3084, 0.0952 },
	{ "10P", 1, 16, 0.3078, 0.0839 },
	{ "10P", 1, 18, 0.3069, 0.0748 },
	{ "2.5RP", 1, 2, 0.324, 0.2459 },
	{ "2.5RP", 1, 4, 0.329, 0.2095 },
	{ "2.5RP", 1, 6, 0.3321, 0.1811 },
	{ "2.5RP", 1, 8, 0.3342, 0.1551 },
	{ "2.5RP", 1, 10, 0.3354, 0.1351 },
	{ "2.5RP", 1, 12, 0.3361, 0.1181 },
	{ "2.5RP", 1, 14, 0.3368, 0.102 },
	{ "2.5RP", 1, 16, 0.3368, 0.0902 },
	{ "5RP", 1, 2, 0.3378, 0.2542 },
	{ "5RP", 1, 4, 0.3503, 0.2196 },
	{ "5RP", 1, 6, 0.3588, 0.192 },
	{ "5RP", 1, 8, 0.366, 0.1662 },
	{ "5RP", 1, 10, 0.3727, 0.1458 },
	{ "5RP", 1, 12, 0.3772, 0.1283 },
	{ "5RP", 1, 14, 0.3811, 0.1138 },
	{ "7.5RP", 1, 2, 0.3498, 0.2617 },
	{ "7.5RP", 1, 4, 0.3705, 0.23 },
	{ "7.5RP", 1, 6, 0.3865, 0.2036 },
	{ "7.5RP", 1, 8, 0.4005, 0.1793 },
	{ "7.5RP", 1, 10, 0.4132, 0.158 },
	{ "7.5RP", 1, 12, 0.424, 0.14 },
	{ "10RP", 2, 2, 0.3532, 0.2957 },
	{ "10RP", 2, 4, 0.385, 0.2778 },
	{ "10RP", 2, 6, 0.4139, 0.2608 },
	{ "10RP", 2, 8, 0.4428, 0.2419 },
	{ "10RP", 2, 10, 0.4678, 0.2237 },
	{ "10RP", 2, 12, 0.4911, 0.206 },
	{ "10RP", 2, 14, 0.5129, 0.1888 },
	{ "2.5R", 2, 2, 0.3614, 0.3033 },
	{ "2.5R", 2, 4, 0.4021, 0.29 },
	{ "2.5R", 2, 6, 0.439, 0.276 },
	{ "2.5R", 2, 8, 0.4776, 0.2593 },
	{ "2.5R", 2, 10, 0.5122, 0.2428 },
	{ "2.5R", 2, 12, 0.5438, 0.2254 },
	{ "2.5R", 2, 14, 0.5734, 0.2083 },
	{ "5R", 2, 2, 0.3692, 0.3111 },
	{ "5R", 2, 4, 0.4184, 0.3032 },
	{ "5R", 2, 6, 0.4642, 0.2934 },
	{ "5R", 2, 8, 0.5143, 0.28 },
	{ "5R", 2, 10, 0.5557, 0.2633 },
	{ "5R", 2, 12, 0.593, 0.2465 },
	{ "5R", 2, 14, 0.6302, 0.2287 },
	{ "7.5R", 2, 2, 0.3751, 0.3181 },
	{ "7.5R", 2, 4, 0.4335, 0.3169 },
	{ "7.5R", 2, 6, 0.4875, 0.3123 },
	{ "7.5R", 2, 8, 0.5433, 0.3027 },
	{ "7.5R", 2, 10, 0.5952, 0.2874 },
	{ "7.5R", 2, 12, 0.6392, 0.2704 },
	{ "7.5R", 2, 14, 0.6791, 0.252 },
	{ "10R", 2, 2, 0.3811, 0.3274 },
	{ "10R", 2, 4, 0.4481, 0.333 },
	{ "10R", 2, 6, 0.5095, 0.3331 },
	{ "10R", 2, 8, 0.5713, 0.3259 },
	{ "10R", 2, 10, 0.6247, 0.312 },
	{ "10R", 2, 12, 0.6732, 0.2937 },
	{ "10R", 2, 14, 0.7165, 0.2734 },
	{ "2.5YR", 2, 2, 0.3852, 0.3365 },
	{ "2.5YR", 2, 4, 0.4598, 0.3508 },
	{ "2.5YR", 2, 6, 0.528, 0.3581 },
	{ "2.5YR", 2, 8, 0.5995, 0.359 },
	{ "5YR", 2, 2, 0.388, 0.3476 },
	{ "5YR", 2, 4, 0.4674, 0.3738 },
	{ "5YR", 2, 6, 0.5426, 0.3925 },
	{ "7.5YR", 2, 2, 0.3889, 0.359 },
	{ "7.5YR", 2, 4, 0.469, 0.3964 },
	{ "7.5YR", 2, 6, 0.5475, 0.4271 },
	{ "10YR", 2, 2, 0.3872, 0.3688 },
	{ "10YR", 2, 4, 0.4676, 0.4168 },
	{ "2.5Y", 2, 2, 0.3825, 0.3785 },
	{ "2.5Y", 2, 4, 0.4627, 0.4392 },
	{ "5Y", 2, 2, 0.3757, 0.3839 },
	{ "5Y", 2, 4, 0.4543, 0.4573 },
	{ "7.5Y", 2, 2, 0.366, 0.3858 },
	{ "7.5Y", 2, 4, 0.4401, 0.4723 },
	{ "10Y", 2, 2, 0.3556, 0.3848 },
	{ "10Y", 2, 4, 0.4188, 0.4789 },
	{ "2.5GY", 2, 2, 0.3421, 0.3803 },
	{ "2.5GY", 2, 4, 0.3881, 0.4752 },
	{ "5GY", 2, 2, 0.3309, 0.3743 },
	{ "5GY", 2, 4, 0.3582, 0.465 },
	{ "5GY", 2, 6, 0.3839, 0.5748 },
	{ "7.5GY", 2, 2, 0.3165, 0.365 },
	{ "7.5GY", 2, 4, 0.3248, 0.4457 },
	{ "7.5GY", 2, 6, 0.326, 0.5379 },
	{ "7.5GY", 2, 8, 0.316, 0.6509 },
	{ "10GY", 2, 2, 0.3069, 0.358 },
	{ "10GY", 2, 4, 0.2986, 0.424 },
	{ "10GY", 2, 6, 0.2852, 0.4972 },
	{ "10GY", 2, 8, 0.2628, 0.5837 },
	{ "10GY", 2, 10, 0.2307, 0.6814 },
	{ "10GY", 2, 12, 0.1907, 0.7798 },
	{ "2.5G", 2, 2, 0.2978, 0.3507 },
	{ "2.5G", 2, 4, 0.2763, 0.3998 },
	{ "2.5G", 2, 6, 0.2493, 0.4522 },
	{ "2.5G", 2, 8, 0.2192, 0.5042 },
	{ "2.5G", 2, 10, 0.1773, 0.5698 },
	{ "2.5G", 2, 12, 0.1307, 0.6308 },
	{ "2.5G", 2, 14, 0.082, 0.686 },
	{ "2.5G", 2, 16, 0.0329, 0.7358 },
	{ "5G", 2, 2, 0.2918, 0.345 },
	{ "5G", 2, 4, 0.264, 0.3845 },
	{ "5G", 2, 6, 0.2318, 0.4231 },
	{ "5G", 2, 8, 0.1979, 0.4583 },
	{ "5G", 2, 10, 0.156, 0.4981 },
	{ "5G", 2, 12, 0.112, 0.5358 },
	{ "5G", 2, 14, 0.0688, 0.5691 },
	{ "5G", 2, 16, 0.0277, 0.5986 },
	{ "7.5G", 2, 2, 0.2869, 0.34 },
	{ "7.5G", 2, 4, 0.254, 0.3705 },
	{ "7.5G", 2, 6, 0.22, 0.3983 },
	{ "7.5G", 2, 8, 0.1842, 0.4244 },
	{ "7.5G", 2, 10, 0.1442, 0.4505 },
	{ "7.5G", 2, 12, 0.1022, 0.4759 },
	{ "7.5G", 2, 14, 0.0629, 0.4973 },
	{ "7.5G", 2, 16, 0.0276, 0.5153 },
	{ "10G", 2, 2, 0.282, 0.3341 },
	{ "10G", 2, 4, 0.2442, 0.3559 },
	{ "10G", 2, 6, 0.2092, 0.3739 },
	{ "10G", 2, 8, 0.1705, 0.3911 },
	{ "10G", 2, 10, 0.1321, 0.4059 },
	{ "10G", 2, 12, 0.0934, 0.4183 },
	{ "10G", 2, 14, 0.0599, 0.427 },
	{ "10G", 2, 16, 0.0285, 0.4327 },
	{ "2.5BG", 2, 2, 0.2765, 0.3271 },
	{ "2.5BG", 2, 4, 0.2343, 0.3378 },
	{ "2.5BG", 2, 6, 0.1971, 0.3452 },
	{ "2.5BG", 2, 8, 0.1557, 0.3517 },
	{ "2.5BG", 2, 10, 0.119, 0.3551 },
	{ "2.5BG", 2, 12, 0.0851, 0.3576 },
	{ "2.5BG", 2, 14, 0.0555, 0.3588 },
	{ "5BG", 2, 2, 0.2697, 0.3175 },
	{ "5BG", 2, 4, 0.2234, 0.315 },
	{ "5BG", 2, 6, 0.1843, 0.311 },
	{ "5BG", 2, 8, 0.1405, 0.3037 },
	{ "5BG", 2, 10, 0.105, 0.2956 },
	{ "5BG", 2, 12, 0.0769, 0.288 },
	{ "7.5BG", 2, 2, 0.2651, 0.3098 },
	{ "7.5BG", 2, 4, 0.2162, 0.2981 },
	{ "7.5BG", 2, 6, 0.1747, 0.2853 },
	{ "7.5BG", 2, 8, 0.1325, 0.271 },
	{ "7.5BG", 2, 10, 0.0991, 0.2582 },
	{ "7.5BG", 2, 12, 0.0724, 0.2478 },
	{ "10BG", 2, 2, 0.2606, 0.301 },
	{ "10BG", 2, 4, 0.2096, 0.279 },
	{ "10BG", 2, 6, 0.1669, 0.257 },
	{ "10BG", 2, 8, 0.1258, 0.2331 },
	{ "10BG", 2, 10, 0.0929, 0.2133 },
	{ "2.5B", 2, 2, 0.2578, 0.294 },
	{ "2.5B", 2, 4, 0.206, 0.2649 },
	{ "2.5B", 2, 6, 0.1621, 0.2358 },
	{ "2.5B", 2, 8, 0.123, 0.2076 },
	{ "2.5B", 2, 10, 0.0911, 0.1828 },
	{ "5B", 2, 2, 0.2559, 0.2874 },
	{ "5B", 2, 4, 0.2048, 0.2518 },
	{ "5B", 2, 6, 0.1617, 0.2162 },
	{ "5B", 2, 8, 0.1245, 0.1827 },
	{ "5B", 2, 10, 0.0965, 0.1558 },
	{ "7.5B", 2, 2, 0.2545, 0.2799 },
	{ "7.5B", 2, 4, 0.2063, 0.24 },
	{ "7.5B", 2, 6, 0.1658, 0.2026 },
	{ "7.5B", 2, 8, 0.1313, 0.1692 },
	{ "7.5B", 2, 10, 0.1051, 0.1422 },
	{ "10B", 2, 2, 0.2558, 0.2725 },
	{ "10B", 2, 4, 0.2102, 0.2313 },
	{ "10B", 2, 6, 0.1716, 0.1937 },
	{ "10B", 2, 8, 0.1396, 0.1603 },
	{ "10B", 2, 10, 0.1157, 0.1346 },
	{ "2.5PB", 2, 2, 0.2592, 0.2675 },
	{ "2.5PB", 2, 4, 0.2175, 0.2245 },
	{ "2.5PB", 2, 6, 0.1825, 0.1857 },
	{ "2.5PB", 2, 8, 0.154, 0.153 },
	{ "2.5PB", 2, 10, 0.1332, 0.1278 },
	{ "2.5PB", 2, 12, 0.1166, 0.1076 },
	{ "5PB", 2, 2, 0.2638, 0.2624 },
	{ "5PB", 2, 4, 0.2263, 0.2192 },
	{ "5PB", 2, 6, 0.1942, 0.1811 },
	{ "5PB", 2, 8, 0.1685, 0.1491 },
	{ "5PB", 2, 10, 0.15, 0.124 },
	{ "5PB", 2, 12, 0.1363, 0.1048 },
	{ "5PB", 2, 14, 0.1253, 0.0873 },
	{ "7.5PB", 2, 2, 0.2712, 0.2582 },
	{ "7.5PB", 2, 4, 0.242, 0.2148 },
	{ "7.5PB", 2, 6, 0.2189, 0.179 },
	{ "7.5PB", 2, 8, 0.2005, 0.1495 },
	{ "7.5PB", 2, 10, 0.1882, 0.1258 },
	{ "7.5PB", 2, 12, 0.1813, 0.1094 },
	{ "7.5PB", 2, 14, 0.1762, 0.0955 },
	{ "7.5PB", 2, 16, 0.1728, 0.0839 },
	{ "7.5PB", 2, 18, 0.1701, 0.0742 },
	{ "7.5PB", 2, 20, 0.1685, 0.0666 },
	{ "7.5PB", 2, 22, 0.167, 0.0594 },
	{ "7.5PB", 2, 24, 0.166, 0.0538 },
	{ "7.5PB", 2, 26, 0.1653, 0.0492 },
	{ "7.5PB", 2, 28, 0.1647, 0.0451 },
	{ "7.5PB", 2, 30, 0.164, 0.0409 },
	{ "7.5PB", 2, 32, 0.1635, 0.0373 },
	{ "7.5PB", 2, 34, 0.163, 0.034 },
	{ "7.5PB", 2, 36, 0.1628, 0.031 },
	{ "7.5PB", 2, 38, 0.1623, 0.028 },
	{ "10PB", 2, 2, 0.2803, 0.2567 },
	{ "10PB", 2, 4, 0.26, 0.2162 },
	{ "10PB", 2, 6, 0.244, 0.184 },
	{ "10PB", 2, 8, 0.2294, 0.1551 },
	{ "10PB", 2, 10, 0.22, 0.133 },
	{ "10PB", 2, 12, 0.2139, 0.117 },
	{ "10PB", 2, 14, 0.2087, 0.1026 },
	{ "10PB", 2, 16, 0.2052, 0.091 },
	{ "10PB", 2, 18, 0.2021, 0.0808 },
	{ "10PB", 2, 20, 0.1998, 0.0718 },
	{ "10PB", 2, 22, 0.1978, 0.0643 },
	{ "10PB", 2, 24, 0.1962, 0.0578 },
	{ "10PB", 2, 26, 0.1949, 0.052 },
	{ "10PB", 2, 28, 0.1937, 0.0471 },
	{ "10PB", 2, 30, 0.1925, 0.042 },
	{ "10PB", 2, 32, 0.1918, 0.0379 },
	{ "10PB", 2, 34, 0.1911, 0.0344 },
	{ "2.5P", 2, 2, 0.2892, 0.2583 },
	{ "2.5P", 2, 4, 0.2758, 0.2208 },
	{ "2.5P", 2, 6, 0.2661, 0.1921 },
	{ "2.5P", 2, 8, 0.257, 0.1635 },
	{ "2.5P", 2, 10, 0.2501, 0.1422 },
	{ "2.5P", 2, 12, 0.2449, 0.1245 },
	{ "2.5P", 2, 14, 0.2406, 0.11 },
	{ "2.5P", 2, 16, 0.2372, 0.098 },
	{ "2.5P", 2, 18, 0.2345, 0.0873 },
	{ "2.5P", 2, 20, 0.232, 0.0779 },
	{ "2.5P", 2, 22, 0.2298, 0.0696 },
	{ "2.5P", 2, 24, 0.2277, 0.0621 },
	{ "2.5P", 2, 26, 0.226, 0.0555 },
	{ "2.5P", 2, 28, 0.2245, 0.0491 },
	{ "2.5P", 2, 30, 0.2231, 0.0432 },
	{ "5P", 2, 2, 0.2984, 0.2612 },
	{ "5P", 2, 4, 0.2908, 0.2261 },
	{ "5P", 2, 6, 0.285, 0.1992 },
	{ "5P", 2, 8, 0.2791, 0.1707 },
	{ "5P", 2, 10, 0.2748, 0.15 },
	{ "5P", 2, 12, 0.2709, 0.132 },
	{ "5P", 2, 14, 0.2676, 0.1163 },
	{ "5P", 2, 16, 0.2652, 0.1045 },
	{ "5P", 2, 18, 0.2632, 0.0935 },
	{ "5P", 2, 20, 0.2612, 0.0838 },
	{ "5P", 2, 22, 0.2597, 0.075 },
	{ "5P", 2, 24, 0.2582, 0.0669 },
	{ "5P", 2, 26, 0.2569, 0.0594 },
	{ "5P", 2, 28, 0.2559, 0.0525 },
	{ "7.5P", 2, 2, 0.3071, 0.2647 },
	{ "7.5P", 2, 4, 0.3048, 0.2321 },
	{ "7.5P", 2, 6, 0.3025, 0.2058 },
	{ "7.5P", 2, 8, 0.3, 0.1781 },
	{ "7.5P", 2, 10, 0.2979, 0.1569 },
	{ "7.5P", 2, 12, 0.2956, 0.1392 },
	{ "7.5P", 2, 14, 0.2938, 0.1235 },
	{ "7.5P", 2, 16, 0.2922, 0.1106 },
	{ "7.5P", 2, 18, 0.2912, 0.0995 },
	{ "7.5P", 2, 20, 0.2902, 0.0901 },
	{ "7.5P", 2, 22, 0.289, 0.0799 },
	{ "7.5P", 2, 24, 0.2882, 0.0719 },
	{ "10P", 2, 2, 0.3161, 0.2691 },
	{ "10P", 2, 4, 0.3189, 0.239 },
	{ "10P", 2, 6, 0.3207, 0.2132 },
	{ "10P", 2, 8, 0.3219, 0.1862 },
	{ "10P", 2, 10, 0.323, 0.1659 },
	{ "10P", 2, 12, 0.3233, 0.1477 },
	{ "10P", 2, 14, 0.3235, 0.1317 },
	{ "10P", 2, 16, 0.3235, 0.1181 },
	{ "10P", 2, 18, 0.3233, 0.1063 },
	{ "10P", 2, 20, 0.3231, 0.0962 },
	{ "10P", 2, 22, 0.323, 0.0861 },
	{ "2.5RP", 2, 2, 0.3279, 0.2754 },
	{ "2.5RP", 2, 4, 0.3382, 0.2496 },
	{ "2.5RP", 2, 6, 0.347, 0.2259 },
	{ "2.5RP", 2, 8, 0.3555, 0.2003 },
	{ "2.5RP", 2, 10, 0.3617, 0.18 },
	{ "2.5RP", 2, 12, 0.3668, 0.1618 },
	{ "2.5RP", 2, 14, 0.3711, 0.1449 },
	{ "2.5RP", 2, 16, 0.3748, 0.131 },
	{ "2.5RP", 2, 18, 0.3778, 0.1188 },
	{ "2.5RP", 2, 20, 0.3802, 0.108 },
	{ "5RP", 2, 2, 0.3383, 0.2829 },
	{ "5RP", 2, 4, 0.3558, 0.2597 },
	{ "5RP", 2, 6, 0.3708, 0.238 },
	{ "5RP", 2, 8, 0.3858, 0.214 },
	{ "5RP", 2, 10, 0.3971, 0.1939 },
	{ "5RP", 2, 12, 0.408, 0.1764 },
	{ "5RP", 2, 14, 0.418, 0.1598 },
	{ "5RP", 2, 16, 0.4269, 0.1454 },
	{ "5RP", 2, 18, 0.4338, 0.134 },
	{ "7.5RP", 2, 2, 0.3459, 0.2892 },
	{ "7.5RP", 2, 4, 0.3702, 0.2683 },
	{ "7.5RP", 2, 6, 0.3918, 0.249 },
	{ "7.5RP", 2, 8, 0.4137, 0.2276 },
	{ "7.5RP", 2, 10, 0.4321, 0.2082 },
	{ "7.5RP", 2, 12, 0.4481, 0.1903 },
	{ "7.5RP", 2, 14, 0.4624, 0.1737 },
	{ "7.5RP", 2, 16, 0.4744, 0.1595 },
	{ "10RP", 3, 2, 0.3526, 0.3068 },
	{ "10RP", 3, 4, 0.3889, 0.2969 },
	{ "10RP", 3, 6, 0.4218, 0.2864 },
	{ "10RP", 3, 8, 0.4552, 0.2741 },
	{ "10RP", 3, 10, 0.4851, 0.2618 },
	{ "10RP", 3, 12, 0.5139, 0.2489 },
	{ "10RP", 3, 14, 0.538, 0.2369 },
	{ "10RP", 3, 16, 0.5628, 0.2241 },
	{ "2.5R", 3, 2, 0.3591, 0.313 },
	{ "2.5R", 3, 4, 0.4021, 0.3076 },
	{ "2.5R", 3, 6, 0.4409, 0.3009 },
	{ "2.5R", 3, 8, 0.4821, 0.2918 },
	{ "2.5R", 3, 10, 0.5191, 0.2811 },
	{ "2.5R", 3, 12, 0.5536, 0.2691 },
	{ "2.5R", 3, 14, 0.5828, 0.2579 },
	{ "2.5R", 3, 16, 0.6116, 0.2456 },
	{ "5R", 3, 2, 0.3645, 0.319 },
	{ "5R", 3, 4, 0.4148, 0.319 },
	{ "5R", 3, 6, 0.4592, 0.3168 },
	{ "5R", 3, 8, 0.5064, 0.3114 },
	{ "5R", 3, 10, 0.55, 0.3024 },
	{ "5R", 3, 12, 0.5884, 0.2904 },
	{ "5R", 3, 14, 0.6204, 0.2789 },
	{ "5R", 3, 16, 0.652, 0.266 },
	{ "7.5R", 3, 2, 0.369, 0.3248 },
	{ "7.5R", 3, 4, 0.424, 0.3302 },
	{ "7.5R", 3, 6, 0.4738, 0.3316 },
	{ "7.5R", 3, 8, 0.5251, 0.3297 },
	{ "7.5R", 3, 10, 0.573, 0.324 },
	{ "7.5R", 3, 12, 0.6158, 0.3129 },
	{ "7.5R", 3, 14, 0.6492, 0.3012 },
	{ "7.5R", 3, 16, 0.6817, 0.2872 },
	{ "10R", 3, 2, 0.3728, 0.3314 },
	{ "10R", 3, 4, 0.4308, 0.3412 },
	{ "10R", 3, 6, 0.4854, 0.3467 },
	{ "10R", 3, 8, 0.5393, 0.3477 },
	{ "10R", 3, 10, 0.5871, 0.344 },
	{ "10R", 3, 12, 0.6322, 0.3361 },
	{ "10R", 3, 14, 0.6703, 0.3249 },
	{ "2.5YR", 3, 2, 0.3757, 0.3391 },
	{ "2.5YR", 3, 4, 0.436, 0.3563 },
	{ "2.5YR", 3, 6, 0.4954, 0.3692 },
	{ "2.5YR", 3, 8, 0.5475, 0.3771 },
	{ "2.5YR", 3, 10, 0.5941, 0.3818 },
	{ "5YR", 3, 2, 0.3771, 0.3476 },
	{ "5YR", 3, 4, 0.4376, 0.3715 },
	{ "5YR", 3, 6, 0.4966, 0.3908 },
	{ "5YR", 3, 8, 0.5456, 0.404 },
	{ "7.5YR", 3, 2, 0.3771, 0.3549 },
	{ "7.5YR", 3, 4, 0.4378, 0.3865 },
	{ "7.5YR", 3, 6, 0.493, 0.4116 },
	{ "7.5YR", 3, 8, 0.539, 0.4306 },
	{ "10YR", 3, 2, 0.3747, 0.363 },
	{ "10YR", 3, 4, 0.4341, 0.4018 },
	{ "10YR", 3, 6, 0.4872, 0.4326 },
	{ "10YR", 3, 8, 0.5305, 0.4559 },
	{ "2.5Y", 3, 2, 0.3703, 0.37 },
	{ "2.5Y", 3, 4, 0.4277, 0.4166 },
	{ "2.5Y", 3, 6, 0.4784, 0.4531 },
	{ "5Y", 3, 2, 0.3646, 0.3748 },
	{ "5Y", 3, 4, 0.4191, 0.4283 },
	{ "5Y", 3, 6, 0.467, 0.4711 },
	{ "7.5Y", 3, 2, 0.3589, 0.3778 },
	{ "7.5Y", 3, 4, 0.4086, 0.4379 },
	{ "7.5Y", 3, 6, 0.4526, 0.4889 },
	{ "10Y", 3, 2, 0.3513, 0.3789 },
	{ "10Y", 3, 4, 0.3961, 0.4452 },
	{ "10Y", 3, 6, 0.4345, 0.5026 },
	{ "2.5GY", 3, 2, 0.3412, 0.3768 },
	{ "2.5GY", 3, 4, 0.3772, 0.4484 },
	{ "2.5GY", 3, 6, 0.4069, 0.511 },
	{ "5GY", 3, 2, 0.3319, 0.3729 },
	{ "5GY", 3, 4, 0.3554, 0.4429 },
	{ "5GY", 3, 6, 0.375, 0.5109 },
	{ "5GY", 3, 8, 0.3924, 0.5832 },
	{ "7.5GY", 3, 2, 0.318, 0.3644 },
	{ "7.5GY", 3, 4, 0.327, 0.4288 },
	{ "7.5GY", 3, 6, 0.3333, 0.4967 },
	{ "7.5GY", 3, 8, 0.3341, 0.57 },
	{ "7.5GY", 3, 10, 0.3266, 0.6448 },
	{ "10GY", 3, 2, 0.3088, 0.3578 },
	{ "10GY", 3, 4, 0.3053, 0.4123 },
	{ "10GY", 3, 6, 0.2992, 0.4717 },
	{ "10GY", 3, 8, 0.2887, 0.5361 },
	{ "10GY", 3, 10, 0.2724, 0.6026 },
	{ "10GY", 3, 12, 0.2531, 0.67 },
	{ "10GY", 3, 14, 0.2283, 0.7423 },
	{ "2.5G", 3, 2, 0.2999, 0.35 },
	{ "2.5G", 3, 4, 0.2836, 0.3915 },
	{ "2.5G", 3, 6, 0.2642, 0.4342 },
	{ "2.5G", 3, 8, 0.2435, 0.4752 },
	{ "2.5G", 3, 10, 0.217, 0.5211 },
	{ "2.5G", 3, 12, 0.1902, 0.5642 },
	{ "2.5G", 3, 14, 0.1626, 0.6052 },
	{ "2.5G", 3, 16, 0.1341, 0.642 },
	{ "2.5G", 3, 18, 0.1049, 0.6766 },
	{ "2.5G", 3, 20, 0.072, 0.7127 },
	{ "2.5G", 3, 22, 0.039, 0.7468 },
	{ "5G", 3, 2, 0.2935, 0.3439 },
	{ "5G", 3, 4, 0.2711, 0.378 },
	{ "5G", 3, 6, 0.2471, 0.41 },
	{ "5G", 3, 8, 0.2228, 0.438 },
	{ "5G", 3, 10, 0.1935, 0.4682 },
	{ "5G", 3, 12, 0.166, 0.4948 },
	{ "5G", 3, 14, 0.1382, 0.5197 },
	{ "5G", 3, 16, 0.112, 0.5414 },
	{ "5G", 3, 18, 0.0882, 0.5605 },
	{ "5G", 3, 20, 0.062, 0.5802 },
	{ "5G", 3, 22, 0.034, 0.6011 },
	{ "7.5G", 3, 2, 0.289, 0.3391 },
	{ "7.5G", 3, 4, 0.2618, 0.3667 },
	{ "7.5G", 3, 6, 0.2346, 0.3901 },
	{ "7.5G", 3, 8, 0.2088, 0.4101 },
	{ "7.5G", 3, 10, 0.18, 0.431 },
	{ "7.5G", 3, 12, 0.1516, 0.4505 },
	{ "7.5G", 3, 14, 0.1262, 0.4667 },
	{ "7.5G", 3, 16, 0.1023, 0.4818 },
	{ "7.5G", 3, 18, 0.0798, 0.4954 },
	{ "7.5G", 3, 20, 0.0568, 0.5082 },
	{ "7.5G", 3, 22, 0.0332, 0.5206 },
	{ "10G", 3, 2, 0.2844, 0.3337 },
	{ "10G", 3, 4, 0.2525, 0.3537 },
	{ "10G", 3, 6, 0.224, 0.3699 },
	{ "10G", 3, 8, 0.197, 0.3841 },
	{ "10G", 3, 10, 0.1688, 0.3974 },
	{ "10G", 3, 12, 0.1411, 0.4095 },
	{ "10G", 3, 14, 0.1161, 0.4192 },
	{ "10G", 3, 16, 0.0925, 0.4275 },
	{ "10G", 3, 18, 0.0718, 0.434 },
	{ "10G", 3, 20, 0.0528, 0.4393 },
	{ "10G", 3, 22, 0.0333, 0.4444 },
	{ "2.5BG", 3, 2, 0.2799, 0.3271 },
	{ "2.5BG", 3, 4, 0.2437, 0.3386 },
	{ "2.5BG", 3, 6, 0.2132, 0.3468 },
	{ "2.5BG", 3, 8, 0.1845, 0.3531 },
	{ "2.5BG", 3, 10, 0.1552, 0.358 },
	{ "2.5BG", 3, 12, 0.1288, 0.362 },
	{ "2.5BG", 3, 14, 0.1051, 0.3648 },
	{ "2.5BG", 3, 16, 0.0843, 0.3667 },
	{ "2.5BG", 3, 18, 0.0648, 0.3682 },
	{ "2.5BG", 3, 20, 0.0482, 0.3695 },
	{ "5BG", 3, 2, 0.2742, 0.3192 },
	{ "5BG", 3, 4, 0.2343, 0.32 },
	{ "5BG", 3, 6, 0.202, 0.3188 },
	{ "5BG", 3, 8, 0.1703, 0.3159 },
	{ "5BG", 3, 10, 0.141, 0.3118 },
	{ "5BG", 3, 12, 0.1158, 0.3071 },
	{ "5BG", 3, 14, 0.094, 0.3027 },
	{ "5BG", 3, 16, 0.0735, 0.2979 },
	{ "5BG", 3, 18, 0.058, 0.294 },
	{ "7.5BG", 3, 2, 0.2699, 0.312 },
	{ "7.5BG", 3, 4, 0.2272, 0.3041 },
	{ "7.5BG", 3, 6, 0.1928, 0.2958 },
	{ "7.5BG", 3, 8, 0.162, 0.2872 },
	{ "7.5BG", 3, 10, 0.1326, 0.2784 },
	{ "7.5BG", 3, 12, 0.1086, 0.2706 },
	{ "7.5BG", 3, 14, 0.0874, 0.2627 },
	{ "7.5BG", 3, 16, 0.0691, 0.2559 },
	{ "10BG", 3, 2, 0.266, 0.305 },
	{ "10BG", 3, 4, 0.2221, 0.2886 },
	{ "10BG", 3, 6, 0.1861, 0.2722 },
	{ "10BG", 3, 8, 0.1551, 0.2571 },
	{ "10BG", 3, 10, 0.125, 0.2411 },
	{ "10BG", 3, 12, 0.1018, 0.2281 },
	{ "10BG", 3, 14, 0.0798, 0.2151 },
	{ "2.5B", 3, 2, 0.2636, 0.2983 },
	{ "2.5B", 3, 4, 0.2183, 0.2748 },
	{ "2.5B", 3, 6, 0.1826, 0.2536 },
	{ "2.5B", 3, 8, 0.1511, 0.2331 },
	{ "2.5B", 3, 10, 0.122, 0.2132 },
	{ "2.5B", 3, 12, 0.0989, 0.1963 },
	{ "5B", 3, 2, 0.2617, 0.2921 },
	{ "5B", 3, 4, 0.2176, 0.2632 },
	{ "5B", 3, 6, 0.1835, 0.2375 },
	{ "5B", 3, 8, 0.1527, 0.2119 },
	{ "5B", 3, 10, 0.1259, 0.1879 },
	{ "5B", 3, 12, 0.1042, 0.1681 },
	{ "7.5B", 3, 2, 0.2616, 0.2857 },
	{ "7.5B", 3, 4, 0.22, 0.2536 },
	{ "7.5B", 3, 6, 0.1875, 0.2258 },
	{ "7.5B", 3, 8, 0.1583, 0.1987 },
	{ "7.5B", 3, 10, 0.1343, 0.1756 },
	{ "7.5B", 3, 12, 0.1131, 0.1542 },
	{ "10B", 3, 2, 0.2631, 0.2801 },
	{ "10B", 3, 4, 0.2246, 0.2467 },
	{ "10B", 3, 6, 0.1933, 0.2173 },
	{ "10B", 3, 8, 0.1658, 0.1905 },
	{ "10B", 3, 10, 0.1432, 0.1675 },
	{ "10B", 3, 12, 0.1228, 0.146 },
	{ "10B", 3, 14, 0.1065, 0.1285 },
	{ "2.5PB", 3, 2, 0.2663, 0.2756 },
	{ "2.5PB", 3, 4, 0.2312, 0.2405 },
	{ "2.5PB", 3, 6, 0.2022, 0.2101 },
	{ "2.5PB", 3, 8, 0.178, 0.1833 },
	{ "2.5PB", 3, 10, 0.1576, 0.16 },
	{ "2.5PB", 3, 12, 0.1398, 0.1395 },
	{ "2.5PB", 3, 14, 0.1251, 0.1218 },
	{ "5PB", 3, 2, 0.2708, 0.2719 },
	{ "5PB", 3, 4, 0.2393, 0.2361 },
	{ "5PB", 3, 6, 0.2122, 0.2052 },
	{ "5PB", 3, 8, 0.1908, 0.1799 },
	{ "5PB", 3, 10, 0.1718, 0.1562 },
	{ "5PB", 3, 12, 0.1557, 0.1356 },
	{ "5PB", 3, 14, 0.1431, 0.1184 },
	{ "5PB", 3, 16, 0.1318, 0.1024 },
	{ "5PB", 3, 18, 0.1228, 0.0895 },
	{ "7.5PB", 3, 2, 0.2777, 0.2687 },
	{ "7.5PB", 3, 4, 0.252, 0.2319 },
	{ "7.5PB", 3, 6, 0.2311, 0.201 },
	{ "7.5PB", 3, 8, 0.2149, 0.1761 },
	{ "7.5PB", 3, 10, 0.2005, 0.1536 },
	{ "7.5PB", 3, 12, 0.1903, 0.1353 },
	{ "7.5PB", 3, 14, 0.1824, 0.1188 },
	{ "7.5PB", 3, 16, 0.1765, 0.1048 },
	{ "7.5PB", 3, 18, 0.173, 0.0948 },
	{ "7.5PB", 3, 20, 0.1702, 0.0867 },
	{ "7.5PB", 3, 22, 0.1677, 0.0782 },
	{ "7.5PB", 3, 24, 0.1658, 0.0711 },
	{ "7.5PB", 3, 26, 0.1642, 0.0655 },
	{ "7.5PB", 3, 28, 0.1632, 0.0609 },
	{ "7.5PB", 3, 30, 0.1621, 0.0556 },
	{ "7.5PB", 3, 32, 0.1612, 0.0511 },
	{ "7.5PB", 3, 34, 0.1608, 0.048 },
	{ "10PB", 3, 2, 0.2847, 0.267 },
	{ "10PB", 3, 4, 0.266, 0.2319 },
	{ "10PB", 3, 6, 0.2511, 0.2031 },
	{ "10PB", 3, 8, 0.2387, 0.1786 },
	{ "10PB", 3, 10, 0.2278, 0.1565 },
	{ "10PB", 3, 12, 0.2206, 0.1407 },
	{ "10PB", 3, 14, 0.2142, 0.125 },
	{ "10PB", 3, 16, 0.2092, 0.1118 },
	{ "10PB", 3, 18, 0.206, 0.102 },
	{ "10PB", 3, 20, 0.203, 0.093 },
	{ "10PB", 3, 22, 0.2004, 0.0847 },
	{ "10PB", 3, 24, 0.1982, 0.0772 },
	{ "10PB", 3, 26, 0.1963, 0.0708 },
	{ "10PB", 3, 28, 0.195, 0.065 },
	{ "10PB", 3, 30, 0.1938, 0.0599 },
	{ "10PB", 3, 32, 0.1926, 0.0542 },
	{ "10PB", 3, 34, 0.1918, 0.0503 },
	{ "2.5P", 3, 2, 0.2922, 0.268 },
	{ "2.5P", 3, 4, 0.2792, 0.2342 },
	{ "2.5P", 3, 6, 0.2691, 0.2072 },
	{ "2.5P", 3, 8, 0.2615, 0.1845 },
	{ "2.5P", 3, 10, 0.2548, 0.1638 },
	{ "2.5P", 3, 12, 0.2498, 0.148 },
	{ "2.5P", 3, 14, 0.2449, 0.1325 },
	{ "2.5P", 3, 16, 0.241, 0.1198 },
	{ "2.5P", 3, 18, 0.238, 0.1094 },
	{ "2.5P", 3, 20, 0.2354, 0.1003 },
	{ "2.5P", 3, 22, 0.2329, 0.0911 },
	{ "2.5P", 3, 24, 0.2305, 0.0832 },
	{ "2.5P", 3, 26, 0.2286, 0.0765 },
	{ "2.5P", 3, 28, 0.2268, 0.0698 },
	{ "2.5P", 3, 30, 0.2252, 0.0638 },
	{ "2.5P", 3, 32, 0.2242, 0.0587 },
	{ "2.5P", 3, 34, 0.223, 0.0543 },
	{ "5P", 3, 2, 0.2997, 0.27 },
	{ "5P", 3, 4, 0.2928, 0.2386 },
	{ "5P", 3, 6, 0.287, 0.2135 },
	{ "5P", 3, 8, 0.2819, 0.191 },
	{ "5P", 3, 10, 0.2772, 0.1707 },
	{ "5P", 3, 12, 0.2739, 0.1539 },
	{ "5P", 3, 14, 0.2707, 0.1397 },
	{ "5P", 3, 16, 0.268, 0.1272 },
	{ "5P", 3, 18, 0.2657, 0.1163 },
	{ "5P", 3, 20, 0.2639, 0.1074 },
	{ "5P", 3, 22, 0.262, 0.0978 },
	{ "5P", 3, 24, 0.2602, 0.0891 },
	{ "5P", 3, 26, 0.259, 0.0822 },
	{ "5P", 3, 28, 0.2579, 0.075 },
	{ "5P", 3, 30, 0.2568, 0.069 },
	{ "5P", 3, 32, 0.2557, 0.063 },
	{ "7.5P", 3, 2, 0.3088, 0.274 },
	{ "7.5P", 3, 4, 0.3072, 0.2448 },
	{ "7.5P", 3, 6, 0.3057, 0.2208 },
	{ "7.5P", 3, 8, 0.3037, 0.1981 },
	{ "7.5P", 3, 10, 0.302, 0.1794 },
	{ "7.5P", 3, 12, 0.3003, 0.1618 },
	{ "7.5P", 3, 14, 0.2992, 0.1475 },
	{ "7.5P", 3, 16, 0.2981, 0.1356 },
	{ "7.5P", 3, 18, 0.2969, 0.1239 },
	{ "7.5P", 3, 20, 0.2961, 0.1151 },
	{ "7.5P", 3, 22, 0.2953, 0.1057 },
	{ "7.5P", 3, 24, 0.2944, 0.0967 },
	{ "7.5P", 3, 26, 0.2938, 0.0892 },
	{ "7.5P", 3, 28, 0.293, 0.0812 },
	{ "7.5P", 3, 30, 0.2922, 0.075 },
	{ "10P", 3, 2, 0.317, 0.279 },
	{ "10P", 3, 4, 0.3214, 0.2517 },
	{ "10P", 3, 6, 0.3243, 0.2293 },
	{ "10P", 3, 8, 0.3269, 0.2075 },
	{ "10P", 3, 10, 0.3286, 0.1889 },
	{ "10P", 3, 12, 0.3301, 0.1715 },
	{ "10P", 3, 14, 0.3309, 0.1572 },
	{ "10P", 3, 16, 0.332, 0.1456 },
	{ "10P", 3, 18, 0.3329, 0.1332 },
	{ "10P", 3, 20, 0.3332, 0.124 },
	{ "10P", 3, 22, 0.334, 0.1146 },
	{ "10P", 3, 24, 0.3341, 0.1055 },
	{ "10P", 3, 26, 0.3343, 0.0978 },
	{ "2.5RP", 3, 2, 0.3272, 0.2861 },
	{ "2.5RP", 3, 4, 0.34, 0.2624 },
	{ "2.5RP", 3, 6, 0.3501, 0.2425 },
	{ "2.5RP", 3, 8, 0.3598, 0.2233 },
	{ "2.5RP", 3, 10, 0.3681, 0.2054 },
	{ "2.5RP", 3, 12, 0.3754, 0.1898 },
	{ "2.5RP", 3, 14, 0.3818, 0.1758 },
	{ "2.5RP", 3, 16, 0.3876, 0.1629 },
	{ "2.5RP", 3, 18, 0.3929, 0.1506 },
	{ "2.5RP", 3, 20, 0.3969, 0.1413 },
	{ "2.5RP", 3, 22, 0.4018, 0.1304 },
	{ "5RP", 3, 2, 0.337, 0.294 },
	{ "5RP", 3, 4, 0.3586, 0.2742 },
	{ "5RP", 3, 6, 0.3765, 0.2569 },
	{ "5RP", 3, 8, 0.393, 0.2395 },
	{ "5RP", 3, 10, 0.4073, 0.2235 },
	{ "5RP", 3, 12, 0.4199, 0.2089 },
	{ "5RP", 3, 14, 0.4313, 0.1944 },
	{ "5RP", 3, 16, 0.4418, 0.1809 },
	{ "5RP", 3, 18, 0.4503, 0.1695 },
	{ "5RP", 3, 20, 0.4577, 0.1593 },
	{ "7.5RP", 3, 2, 0.345, 0.3001 },
	{ "7.5RP", 3, 4, 0.3739, 0.2851 },
	{ "7.5RP", 3, 6, 0.399, 0.2708 },
	{ "7.5RP", 3, 8, 0.4234, 0.2556 },
	{ "7.5RP", 3, 10, 0.4445, 0.2419 },
	{ "7.5RP", 3, 12, 0.4654, 0.2273 },
	{ "7.5RP", 3, 14, 0.4831, 0.214 },
	{ "7.5RP", 3, 16, 0.4991, 0.2011 },
	{ "7.5RP", 3, 18, 0.513, 0.1893 },
	{ "10RP", 4, 2, 0.3417, 0.3106 },
	{ "10RP", 4, 4, 0.3715, 0.3042 },
	{ "10RP", 4, 6, 0.3999, 0.2972 },
	{ "10RP", 4, 8, 0.4282, 0.289 },
	{ "10RP", 4, 10, 0.4528, 0.2811 },
	{ "10RP", 4, 12, 0.4789, 0.2717 },
	{ "10RP", 4, 14, 0.502, 0.2623 },
	{ "10RP", 4, 16, 0.5234, 0.253 },
	{ "10RP", 4, 18, 0.5466, 0.2424 },
	{ "10RP", 4, 20, 0.5674, 0.2319 },
	{ "2.5R", 4, 2, 0.3461, 0.315 },
	{ "2.5R", 4, 4, 0.3806, 0.3125 },
	{ "2.5R", 4, 6, 0.4141, 0.3085 },
	{ "2.5R", 4, 8, 0.4472, 0.3031 },
	{ "2.5R", 4, 10, 0.4774, 0.2969 },
	{ "2.5R", 4, 12, 0.5072, 0.2897 },
	{ "2.5R", 4, 14, 0.5369, 0.281 },
	{ "2.5R", 4, 16, 0.562, 0.2724 },
	{ "2.5R", 4, 18, 0.5898, 0.2622 },
	{ "5R", 4, 2, 0.3508, 0.32 },
	{ "5R", 4, 4, 0.3916, 0.3223 },
	{ "5R", 4, 6, 0.4299, 0.3226 },
	{ "5R", 4, 8, 0.469, 0.3209 },
	{ "5R", 4, 10, 0.5043, 0.3176 },
	{ "5R", 4, 12, 0.5385, 0.3129 },
	{ "5R", 4, 14, 0.5734, 0.3057 },
	{ "5R", 4, 16, 0.6039, 0.2978 },
	{ "5R", 4, 18, 0.6329, 0.2881 },
	{ "7.5R", 4, 2, 0.3538, 0.3236 },
	{ "7.5R", 4, 4, 0.399, 0.33 },
	{ "7.5R", 4, 6, 0.4415, 0.334 },
	{ "7.5R", 4, 8, 0.485, 0.3359 },
	{ "7.5R", 4, 10, 0.5235, 0.3351 },
	{ "7.5R", 4, 12, 0.5603, 0.3321 },
	{ "7.5R", 4, 14, 0.5959, 0.3269 },
	{ "7.5R", 4, 16, 0.626, 0.3192 },
	{ "7.5R", 4, 18, 0.6538, 0.31 },
	{ "7.5R", 4, 20, 0.6806, 0.2988 },
	{ "10R", 4, 2, 0.3582, 0.3294 },
	{ "10R", 4, 4, 0.4078, 0.3412 },
	{ "10R", 4, 6, 0.4535, 0.35 },
	{ "10R", 4, 8, 0.4995, 0.3557 },
	{ "10R", 4, 10, 0.5418, 0.358 },
	{ "10R", 4, 12, 0.5801, 0.3588 },
	{ "10R", 4, 14, 0.6154, 0.3568 },
	{ "10R", 4, 16, 0.6409, 0.3533 },
	{ "2.5YR", 4, 2, 0.3624, 0.3367 },
	{ "2.5YR", 4, 4, 0.4141, 0.3539 },
	{ "2.5YR", 4, 6, 0.4612, 0.3674 },
	{ "2.5YR", 4, 8, 0.5071, 0.3777 },
	{ "2.5YR", 4, 10, 0.5475, 0.3856 },
	{ "2.5YR", 4, 12, 0.5809, 0.391 },
	{ "5YR", 4, 2, 0.3651, 0.3442 },
	{ "5YR", 4, 4, 0.4187, 0.3679 },
	{ "5YR", 4, 6, 0.4651, 0.3859 },
	{ "5YR", 4, 8, 0.507, 0.3994 },
	{ "5YR", 4, 10, 0.5432, 0.4097 },
	{ "5YR", 4, 12, 0.5729, 0.4169 },
	{ "7.5YR", 4, 2, 0.3662, 0.3504 },
	{ "7.5YR", 4, 4, 0.4208, 0.3809 },
	{ "7.5YR", 4, 6, 0.4655, 0.4029 },
	{ "7.5YR", 4, 8, 0.5038, 0.4204 },
	{ "7.5YR", 4, 10, 0.5356, 0.4342 },
	{ "10YR", 4, 2, 0.366, 0.359 },
	{ "10YR", 4, 4, 0.4189, 0.3948 },
	{ "10YR", 4, 6, 0.4618, 0.4213 },
	{ "10YR", 4, 8, 0.4965, 0.4414 },
	{ "10YR", 4, 10, 0.525, 0.4573 },
	{ "2.5Y", 4, 2, 0.3633, 0.3654 },
	{ "2.5Y", 4, 4, 0.4138, 0.4076 },
	{ "2.5Y", 4, 6, 0.4542, 0.4391 },
	{ "2.5Y", 4, 8, 0.4865, 0.4625 },
	{ "2.5Y", 4, 10, 0.512, 0.48 },
	{ "5Y", 4, 2, 0.359, 0.3701 },
	{ "5Y", 4, 4, 0.4069, 0.4188 },
	{ "5Y", 4, 6, 0.4451, 0.455 },
	{ "5Y", 4, 8, 0.4745, 0.481 },
	{ "7.5Y", 4, 2, 0.3542, 0.3727 },
	{ "7.5Y", 4, 4, 0.3982, 0.4272 },
	{ "7.5Y", 4, 6, 0.4331, 0.4688 },
	{ "7.5Y", 4, 8, 0.4595, 0.499 },
	{ "10Y", 4, 2, 0.3476, 0.3732 },
	{ "10Y", 4, 4, 0.3871, 0.4321 },
	{ "10Y", 4, 6, 0.419, 0.4795 },
	{ "10Y", 4, 8, 0.443, 0.5153 },
	{ "2.5GY", 4, 2, 0.3382, 0.3706 },
	{ "2.5GY", 4, 4, 0.3708, 0.4329 },
	{ "2.5GY", 4, 6, 0.3968, 0.4857 },
	{ "2.5GY", 4, 8, 0.4174, 0.53 },
	{ "5GY", 4, 2, 0.3312, 0.3678 },
	{ "5GY", 4, 4, 0.3538, 0.4284 },
	{ "5GY", 4, 6, 0.3718, 0.4852 },
	{ "5GY", 4, 8, 0.3868, 0.5384 },
	{ "5GY", 4, 10, 0.3983, 0.585 },
	{ "7.5GY", 4, 2, 0.3185, 0.3604 },
	{ "7.5GY", 4, 4, 0.3281, 0.4157 },
	{ "7.5GY", 4, 6, 0.3355, 0.4739 },
	{ "7.5GY", 4, 8, 0.34, 0.5348 },
	{ "7.5GY", 4, 10, 0.3395, 0.5913 },
	{ "7.5GY", 4, 12, 0.3348, 0.6468 },
	{ "10GY", 4, 2, 0.3109, 0.355 },
	{ "10GY", 4, 4, 0.31, 0.4018 },
	{ "10GY", 4, 6, 0.3069, 0.455 },
	{ "10GY", 4, 8, 0.3008, 0.5095 },
	{ "10GY", 4, 10, 0.2908, 0.5672 },
	{ "10GY", 4, 12, 0.2758, 0.6282 },
	{ "10GY", 4, 14, 0.259, 0.6858 },
	{ "10GY", 4, 16, 0.2422, 0.736 },
	{ "2.5G", 4, 2, 0.3012, 0.347 },
	{ "2.5G", 4, 4, 0.2891, 0.3821 },
	{ "2.5G", 4, 6, 0.2735, 0.4215 },
	{ "2.5G", 4, 8, 0.2561, 0.4597 },
	{ "2.5G", 4, 10, 0.2355, 0.5006 },
	{ "2.5G", 4, 12, 0.2128, 0.5425 },
	{ "2.5G", 4, 14, 0.1909, 0.5779 },
	{ "2.5G", 4, 16, 0.1682, 0.6111 },
	{ "2.5G", 4, 18, 0.1446, 0.6431 },
	{ "2.5G", 4, 20, 0.123, 0.6706 },
	{ "2.5G", 4, 22, 0.1009, 0.6975 },
	{ "2.5G", 4, 24, 0.076, 0.725 },
	{ "2.5G", 4, 26, 0.0528, 0.7502 },
	{ "5G", 4, 2, 0.2959, 0.3417 },
	{ "5G", 4, 4, 0.2781, 0.3704 },
	{ "5G", 4, 6, 0.2581, 0.3992 },
	{ "5G", 4, 8, 0.2359, 0.4266 },
	{ "5G", 4, 10, 0.2115, 0.4532 },
	{ "5G", 4, 12, 0.1843, 0.4807 },
	{ "5G", 4, 14, 0.1627, 0.5015 },
	{ "5G", 4, 16, 0.1402, 0.5214 },
	{ "5G", 4, 18, 0.1188, 0.54 },
	{ "5G", 4, 20, 0.1018, 0.5543 },
	{ "5G", 4, 22, 0.0841, 0.5684 },
	{ "5G", 4, 24, 0.0614, 0.5857 },
	{ "5G", 4, 26, 0.0407, 0.601 },
	{ "7.5G", 4, 2, 0.2919, 0.3371 },
	{ "7.5G", 4, 4, 0.2702, 0.3602 },
	{ "7.5G", 4, 6, 0.2467, 0.3822 },
	{ "7.5G", 4, 8, 0.2232, 0.4022 },
	{ "7.5G", 4, 10, 0.1989, 0.4219 },
	{ "7.5G", 4, 12, 0.1706, 0.4419 },
	{ "7.5G", 4, 14, 0.15, 0.4562 },
	{ "7.5G", 4, 16, 0.1293, 0.4703 },
	{ "7.5G", 4, 18, 0.1086, 0.4842 },
	{ "7.5G", 4, 20, 0.0928, 0.4942 },
	{ "7.5G", 4, 22, 0.077, 0.504 },
	{ "7.5G", 4, 24, 0.0581, 0.5151 },
	{ "7.5G", 4, 26, 0.0392, 0.5258 },
	{ "10G", 4, 2, 0.288, 0.3327 },
	{ "10G", 4, 4, 0.2628, 0.3498 },
	{ "10G", 4, 6, 0.2374, 0.3655 },
	{ "10G", 4, 8, 0.2124, 0.3799 },
	{ "10G", 4, 10, 0.1876, 0.3933 },
	{ "10G", 4, 12, 0.1602, 0.407 },
	{ "10G", 4, 14, 0.1398, 0.4168 },
	{ "10G", 4, 16, 0.1212, 0.4245 },
	{ "10G", 4, 18, 0.1006, 0.433 },
	{ "10G", 4, 20, 0.085, 0.4388 },
	{ "10G", 4, 22, 0.0702, 0.444 },
	{ "10G", 4, 24, 0.0553, 0.4492 },
	{ "10G", 4, 26, 0.04, 0.4545 },
	{ "2.5BG", 4, 2, 0.284, 0.327 },
	{ "2.5BG", 4, 4, 0.2552, 0.3375 },
	{ "2.5BG", 4, 6, 0.2278, 0.3463 },
	{ "2.5BG", 4, 8, 0.2006, 0.354 },
	{ "2.5BG", 4, 10, 0.1738, 0.36 },
	{ "2.5BG", 4, 12, 0.1492, 0.3649 },
	{ "2.5BG", 4, 14, 0.1283, 0.3688 },
	{ "2.5BG", 4, 16, 0.1102, 0.372 },
	{ "2.5BG", 4, 18, 0.0915, 0.3754 },
	{ "2.5BG", 4, 20, 0.0768, 0.3773 },
	{ "2.5BG", 4, 22, 0.0636, 0.3788 },
	{ "2.5BG", 4, 24, 0.051, 0.38 },
	{ "5BG", 4, 2, 0.2799, 0.3208 },
	{ "5BG", 4, 4, 0.248, 0.3232 },
	{ "5BG", 4, 6, 0.2182, 0.324 },
	{ "5BG", 4, 8, 0.189, 0.3234 },
	{ "5BG", 4, 10, 0.1618, 0.3219 },
	{ "5BG", 4, 12, 0.1379, 0.3198 },
	{ "5BG", 4, 14, 0.117, 0.317 },
	{ "5BG", 4, 16, 0.0992, 0.3141 },
	{ "5BG", 4, 18, 0.0828, 0.3108 },
	{ "5BG", 4, 20, 0.0675, 0.3075 },
	{ "7.5BG", 4, 2, 0.2764, 0.3148 },
	{ "7.5BG", 4, 4, 0.2429, 0.3108 },
	{ "7.5BG", 4, 6, 0.2113, 0.3052 },
	{ "7.5BG", 4, 8, 0.1815, 0.2985 },
	{ "7.5BG", 4, 10, 0.154, 0.291 },
	{ "7.5BG", 4, 12, 0.1298, 0.284 },
	{ "7.5BG", 4, 14, 0.1092, 0.2774 },
	{ "7.5BG", 4, 16, 0.0922, 0.2718 },
	{ "7.5BG", 4, 18, 0.0768, 0.2667 },
	{ "10BG", 4, 2, 0.274, 0.3091 },
	{ "10BG", 4, 4, 0.2384, 0.2984 },
	{ "10BG", 4, 6, 0.2065, 0.2863 },
	{ "10BG", 4, 8, 0.176, 0.273 },
	{ "10BG", 4, 10, 0.148, 0.26 },
	{ "10BG", 4, 12, 0.1248, 0.2484 },
	{ "10BG", 4, 14, 0.1033, 0.2376 },
	{ "10BG", 4, 16, 0.0888, 0.2298 },
	{ "2.5B", 4, 2, 0.2727, 0.3038 },
	{ "2.5B", 4, 4, 0.236, 0.2872 },
	{ "2.5B", 4, 6, 0.2048, 0.2708 },
	{ "2.5B", 4, 8, 0.1737, 0.2524 },
	{ "2.5B", 4, 10, 0.1463, 0.2354 },
	{ "2.5B", 4, 12, 0.1247, 0.2209 },
	{ "2.5B", 4, 14, 0.1027, 0.2057 },
	{ "2.5B", 4, 16, 0.09, 0.1973 },
	{ "5B", 4, 2, 0.2723, 0.2992 },
	{ "5B", 4, 4, 0.2363, 0.2782 },
	{ "5B", 4, 6, 0.206, 0.2572 },
	{ "5B", 4, 8, 0.1759, 0.2345 },
	{ "5B", 4, 10, 0.1512, 0.2148 },
	{ "5B", 4, 12, 0.1299, 0.1963 },
	{ "5B", 4, 14, 0.1098, 0.1785 },
	{ "7.5B", 4, 2, 0.2733, 0.2947 },
	{ "7.5B", 4, 4, 0.2388, 0.2704 },
	{ "7.5B", 4, 6, 0.2102, 0.247 },
	{ "7.5B", 4, 8, 0.1821, 0.2232 },
	{ "7.5B", 4, 10, 0.1601, 0.2028 },
	{ "7.5B", 4, 12, 0.1393, 0.1837 },
	{ "7.5B", 4, 14, 0.1204, 0.1655 },
	{ "10B", 4, 2, 0.2753, 0.291 },
	{ "10B", 4, 4, 0.2429, 0.2648 },
	{ "10B", 4, 6, 0.2157, 0.2407 },
	{ "10B", 4, 8, 0.1893, 0.216 },
	{ "10B", 4, 10, 0.1681, 0.1954 },
	{ "10B", 4, 12, 0.1487, 0.176 },
	{ "10B", 4, 14, 0.131, 0.158 },
	{ "10B", 4, 16, 0.1155, 0.1416 },
	{ "2.5PB", 4, 2, 0.2782, 0.2876 },
	{ "2.5PB", 4, 4, 0.2487, 0.2597 },
	{ "2.5PB", 4, 6, 0.2235, 0.2343 },
	{ "2.5PB", 4, 8, 0.1995, 0.2094 },
	{ "2.5PB", 4, 10, 0.1805, 0.1888 },
	{ "2.5PB", 4, 12, 0.1634, 0.1698 },
	{ "2.5PB", 4, 14, 0.1473, 0.1513 },
	{ "2.5PB", 4, 16, 0.1336, 0.1349 },
	{ "2.5PB", 4, 18, 0.1218, 0.1208 },
	{ "5PB", 4, 2, 0.2816, 0.2842 },
	{ "5PB", 4, 4, 0.2562, 0.256 },
	{ "5PB", 4, 6, 0.2325, 0.23 },
	{ "5PB", 4, 8, 0.2103, 0.205 },
	{ "5PB", 4, 10, 0.1925, 0.1843 },
	{ "5PB", 4, 12, 0.1773, 0.1659 },
	{ "5PB", 4, 14, 0.1627, 0.1479 },
	{ "5PB", 4, 16, 0.1504, 0.1317 },
	{ "5PB", 4, 18, 0.1392, 0.1167 },
	{ "5PB", 4, 20, 0.1288, 0.1027 },
	{ "7.5PB", 4, 2, 0.2861, 0.2819 },
	{ "7.5PB", 4, 4, 0.2657, 0.2528 },
	{ "7.5PB", 4, 6, 0.2471, 0.2266 },
	{ "7.5PB", 4, 8, 0.2304, 0.2023 },
	{ "7.5PB", 4, 10, 0.2158, 0.1811 },
	{ "7.5PB", 4, 12, 0.2037, 0.1629 },
	{ "7.5PB", 4, 14, 0.1941, 0.1468 },
	{ "7.5PB", 4, 16, 0.1861, 0.1316 },
	{ "7.5PB", 4, 18, 0.1798, 0.1185 },
	{ "7.5PB", 4, 20, 0.1742, 0.1058 },
	{ "7.5PB", 4, 22, 0.1713, 0.098 },
	{ "7.5PB", 4, 24, 0.1684, 0.0899 },
	{ "7.5PB", 4, 26, 0.1659, 0.0825 },
	{ "10PB", 4, 2, 0.2911, 0.2804 },
	{ "10PB", 4, 4, 0.2759, 0.2522 },
	{ "10PB", 4, 6, 0.2618, 0.2263 },
	{ "10PB", 4, 8, 0.2497, 0.2038 },
	{ "10PB", 4, 10, 0.2388, 0.1837 },
	{ "10PB", 4, 12, 0.2298, 0.1659 },
	{ "10PB", 4, 14, 0.222, 0.1503 },
	{ "10PB", 4, 16, 0.217, 0.1373 },
	{ "10PB", 4, 18, 0.212, 0.1256 },
	{ "10PB", 4, 20, 0.2075, 0.114 },
	{ "10PB", 4, 22, 0.2048, 0.1064 },
	{ "10PB", 4, 24, 0.202, 0.0985 },
	{ "10PB", 4, 26, 0.1994, 0.0904 },
	{ "10PB", 4, 28, 0.1971, 0.084 },
	{ "10PB", 4, 30, 0.1952, 0.0778 },
	{ "2.5P", 4, 2, 0.2962, 0.2807 },
	{ "2.5P", 4, 4, 0.2855, 0.2531 },
	{ "2.5P", 4, 6, 0.2763, 0.23 },
	{ "2.5P", 4, 8, 0.2685, 0.2089 },
	{ "2.5P", 4, 10, 0.2619, 0.1903 },
	{ "2.5P", 4, 12, 0.2559, 0.173 },
	{ "2.5P", 4, 14, 0.2509, 0.1585 },
	{ "2.5P", 4, 16, 0.2467, 0.1452 },
	{ "2.5P", 4, 18, 0.243, 0.1332 },
	{ "2.5P", 4, 20, 0.2394, 0.1221 },
	{ "2.5P", 4, 22, 0.2371, 0.1143 },
	{ "2.5P", 4, 24, 0.2348, 0.1062 },
	{ "2.5P", 4, 26, 0.2322, 0.0978 },
	{ "2.5P", 4, 28, 0.2302, 0.0909 },
	{ "2.5P", 4, 30, 0.2285, 0.0847 },
	{ "2.5P", 4, 32, 0.2265, 0.0774 },
	{ "5P", 4, 2, 0.3022, 0.2825 },
	{ "5P", 4, 4, 0.2958, 0.2565 },
	{ "5P", 4, 6, 0.2903, 0.2347 },
	{ "5P", 4, 8, 0.2855, 0.215 },
	{ "5P", 4, 10, 0.2814, 0.1967 },
	{ "5P", 4, 12, 0.2778, 0.1808 },
	{ "5P", 4, 14, 0.2747, 0.166 },
	{ "5P", 4, 16, 0.2718, 0.152 },
	{ "5P", 4, 18, 0.2693, 0.1408 },
	{ "5P", 4, 20, 0.267, 0.13 },
	{ "5P", 4, 22, 0.2652, 0.1218 },
	{ "5P", 4, 24, 0.2635, 0.1132 },
	{ "5P", 4, 26, 0.2618, 0.1052 },
	{ "5P", 4, 28, 0.26, 0.0971 },
	{ "5P", 4, 30, 0.2588, 0.0907 },
	{ "5P", 4, 32, 0.2574, 0.0833 },
	{ "7.5P", 4, 2, 0.3093, 0.2859 },
	{ "7.5P", 4, 4, 0.3084, 0.2622 },
	{ "7.5P", 4, 6, 0.3076, 0.2416 },
	{ "7.5P", 4, 8, 0.3066, 0.2228 },
	{ "7.5P", 4, 10, 0.3056, 0.206 },
	{ "7.5P", 4, 12, 0.3045, 0.1905 },
	{ "7.5P", 4, 14, 0.3035, 0.1755 },
	{ "7.5P", 4, 16, 0.3028, 0.1621 },
	{ "7.5P", 4, 18, 0.3016, 0.15 },
	{ "7.5P", 4, 20, 0.301, 0.1396 },
	{ "7.5P", 4, 22, 0.3001, 0.1306 },
	{ "7.5P", 4, 24, 0.2993, 0.1225 },
	{ "7.5P", 4, 26, 0.2986, 0.1135 },
	{ "7.5P", 4, 28, 0.2979, 0.1062 },
	{ "7.5P", 4, 30, 0.2969, 0.0979 },
	{ "7.5P", 4, 32, 0.2962, 0.0906 },
	{ "10P", 4, 2, 0.3162, 0.2902 },
	{ "10P", 4, 4, 0.321, 0.2686 },
	{ "10P", 4, 6, 0.3248, 0.2493 },
	{ "10P", 4, 8, 0.328, 0.2318 },
	{ "10P", 4, 10, 0.3306, 0.2162 },
	{ "10P", 4, 12, 0.3331, 0.2014 },
	{ "10P", 4, 14, 0.3351, 0.1875 },
	{ "10P", 4, 16, 0.337, 0.1756 },
	{ "10P", 4, 18, 0.3386, 0.1626 },
	{ "10P", 4, 20, 0.34, 0.15 },
	{ "10P", 4, 22, 0.3411, 0.1424 },
	{ "10P", 4, 24, 0.3421, 0.1337 },
	{ "10P", 4, 26, 0.3428, 0.1248 },
	{ "10P", 4, 28, 0.3432, 0.1172 },
	{ "10P", 4, 30, 0.344, 0.108 },
	{ "2.5RP", 4, 2, 0.3231, 0.2951 },
	{ "2.5RP", 4, 4, 0.334, 0.277 },
	{ "2.5RP", 4, 6, 0.3442, 0.2595 },
	{ "2.5RP", 4, 8, 0.3533, 0.2438 },
	{ "2.5RP", 4, 10, 0.3608, 0.2301 },
	{ "2.5RP", 4, 12, 0.3683, 0.2162 },
	{ "2.5RP", 4, 14, 0.3748, 0.2039 },
	{ "2.5RP", 4, 16, 0.3807, 0.1923 },
	{ "2.5RP", 4, 18, 0.3865, 0.1802 },
	{ "2.5RP", 4, 20, 0.3926, 0.1679 },
	{ "2.5RP", 4, 22, 0.3967, 0.1593 },
	{ "2.5RP", 4, 24, 0.4011, 0.1504 },
	{ "2.5RP", 4, 26, 0.4048, 0.1428 },
	{ "5RP", 4, 2, 0.331, 0.301 },
	{ "5RP", 4, 4, 0.3491, 0.2872 },
	{ "5RP", 4, 6, 0.3671, 0.2733 },
	{ "5RP", 4, 8, 0.3833, 0.26 },
	{ "5RP", 4, 10, 0.396, 0.2489 },
	{ "5RP", 4, 12, 0.4104, 0.2361 },
	{ "5RP", 4, 14, 0.4225, 0.2249 },
	{ "5RP", 4, 16, 0.4339, 0.2139 },
	{ "5RP", 4, 18, 0.4455, 0.2023 },
	{ "5RP", 4, 20, 0.4571, 0.1906 },
	{ "5RP", 4, 22, 0.4656, 0.1821 },
	{ "7.5RP", 4, 2, 0.3371, 0.3061 },
	{ "7.5RP", 4, 4, 0.3612, 0.2963 },
	{ "7.5RP", 4, 6, 0.385, 0.2859 },
	{ "7.5RP", 4, 8, 0.4072, 0.275 },
	{ "7.5RP", 4, 10, 0.4259, 0.2651 },
	{ "7.5RP", 4, 12, 0.445, 0.2541 },
	{ "7.5RP", 4, 14, 0.4629, 0.2437 },
	{ "7.5RP", 4, 16, 0.4799, 0.2329 },
	{ "7.5RP", 4, 18, 0.4965, 0.2217 },
	{ "7.5RP", 4, 20, 0.513, 0.2101 },
	{ "10RP", 5, 2, 0.3332, 0.3131 },
	{ "10RP", 5, 4, 0.3594, 0.309 },
	{ "10RP", 5, 6, 0.3851, 0.3039 },
	{ "10RP", 5, 8, 0.4105, 0.298 },
	{ "10RP", 5, 10, 0.4332, 0.2918 },
	{ "10RP", 5, 12, 0.4579, 0.2841 },
	{ "10RP", 5, 14, 0.4767, 0.2776 },
	{ "10RP", 5, 16, 0.4986, 0.2695 },
	{ "10RP", 5, 18, 0.5185, 0.262 },
	{ "10RP", 5, 20, 0.5396, 0.2535 },
	{ "2.5R", 5, 2, 0.336, 0.3158 },
	{ "2.5R", 5, 4, 0.366, 0.3148 },
	{ "2.5R", 5, 6, 0.396, 0.313 },
	{ "2.5R", 5, 8, 0.4252, 0.3101 },
	{ "2.5R", 5, 10, 0.4533, 0.3058 },
	{ "2.5R", 5, 12, 0.482, 0.3002 },
	{ "2.5R", 5, 14, 0.5047, 0.295 },
	{ "2.5R", 5, 16, 0.53, 0.288 },
	{ "2.5R", 5, 18, 0.554, 0.2804 },
	{ "2.5R", 5, 20, 0.5784, 0.2719 },
	{ "5R", 5, 2, 0.3392, 0.3192 },
	{ "5R", 5, 4, 0.374, 0.322 },
	{ "5R", 5, 6, 0.4078, 0.3238 },
	{ "5R", 5, 8, 0.4413, 0.324 },
	{ "5R", 5, 10, 0.4747, 0.3227 },
	{ "5R", 5, 12, 0.5071, 0.3194 },
	{ "5R", 5, 14, 0.5341, 0.3158 },
	{ "5R", 5, 16, 0.5637, 0.3102 },
	{ "5R", 5, 18, 0.5918, 0.3038 },
	{ "5R", 5, 20, 0.6142, 0.297 },
	{ "7.5R", 5, 2, 0.3425, 0.3229 },
	{ "7.5R", 5, 4, 0.3806, 0.3294 },
	{ "7.5R", 5, 6, 0.418, 0.3348 },
	{ "7.5R", 5, 8, 0.4563, 0.3387 },
	{ "7.5R", 5, 10, 0.4927, 0.3399 },
	{ "7.5R", 5, 12, 0.528, 0.3389 },
	{ "7.5R", 5, 14, 0.559, 0.337 },
	{ "7.5R", 5, 16, 0.5901, 0.3331 },
	{ "7.5R", 5, 18, 0.6161, 0.3277 },
	{ "7.5R", 5, 20, 0.6388, 0.3216 },
	{ "10R", 5, 2, 0.3465, 0.3278 },
	{ "10R", 5, 4, 0.3879, 0.3398 },
	{ "10R", 5, 6, 0.4299, 0.3499 },
	{ "10R", 5, 8, 0.4713, 0.3575 },
	{ "10R", 5, 10, 0.5113, 0.363 },
	{ "10R", 5, 12, 0.5481, 0.366 },
	{ "10R", 5, 14, 0.5771, 0.3664 },
	{ "10R", 5, 16, 0.6037, 0.3657 },
	{ "10R", 5, 18, 0.6297, 0.3642 },
	{ "2.5YR", 5, 2, 0.3506, 0.3337 },
	{ "2.5YR", 5, 4, 0.3925, 0.3494 },
	{ "2.5YR", 5, 6, 0.4365, 0.364 },
	{ "2.5YR", 5, 8, 0.4795, 0.3758 },
	{ "2.5YR", 5, 10, 0.5175, 0.3844 },
	{ "2.5YR", 5, 12, 0.5482, 0.3909 },
	{ "2.5YR", 5, 14, 0.5731, 0.3953 },
	{ "2.5YR", 5, 16, 0.5933, 0.3989 },
	{ "5YR", 5, 2, 0.353, 0.3395 },
	{ "5YR", 5, 4, 0.3968, 0.3614 },
	{ "5YR", 5, 6, 0.442, 0.3808 },
	{ "5YR", 5, 8, 0.483, 0.396 },
	{ "5YR", 5, 10, 0.5161, 0.4064 },
	{ "5YR", 5, 12, 0.5422, 0.4141 },
	{ "5YR", 5, 14, 0.5642, 0.4201 },
	{ "7.5YR", 5, 2, 0.354, 0.3445 },
	{ "7.5YR", 5, 4, 0.3991, 0.3714 },
	{ "7.5YR", 5, 6, 0.444, 0.3954 },
	{ "7.5YR", 5, 8, 0.482, 0.4141 },
	{ "7.5YR", 5, 10, 0.5108, 0.4276 },
	{ "7.5YR", 5, 12, 0.5335, 0.4378 },
	{ "7.5YR", 5, 14, 0.5506, 0.445 },
	{ "10YR", 5, 2, 0.3546, 0.3514 },
	{ "10YR", 5, 4, 0.3995, 0.384 },
	{ "10YR", 5, 6, 0.4428, 0.4128 },
	{ "10YR", 5, 8, 0.477, 0.4338 },
	{ "10YR", 5, 10, 0.5025, 0.4489 },
	{ "10YR", 5, 12, 0.5211, 0.46 },
	{ "2.5Y", 5, 2, 0.3534, 0.357 },
	{ "2.5Y", 5, 4, 0.3968, 0.3954 },
	{ "2.5Y", 5, 6, 0.438, 0.4292 },
	{ "2.5Y", 5, 8, 0.4685, 0.4524 },
	{ "2.5Y", 5, 10, 0.4905, 0.4683 },
	{ "2.5Y", 5, 12, 0.5082, 0.4812 },
	{ "5Y", 5, 2, 0.35, 0.362 },
	{ "5Y", 5, 4, 0.3915, 0.4057 },
	{ "5Y", 5, 6, 0.4302, 0.4435 },
	{ "5Y", 5, 8, 0.4579, 0.4692 },
	{ "5Y", 5, 10, 0.4777, 0.4876 },
	{ "5Y", 5, 12, 0.4932, 0.5019 },
	{ "7.5Y", 5, 2, 0.347, 0.364 },
	{ "7.5Y", 5, 4, 0.385, 0.412 },
	{ "7.5Y", 5, 6, 0.4199, 0.4551 },
	{ "7.5Y", 5, 8, 0.445, 0.485 },
	{ "7.5Y", 5, 10, 0.4632, 0.5057 },
	{ "7.5Y", 5, 12, 0.4767, 0.5208 },
	{ "10Y", 5, 2, 0.3422, 0.3648 },
	{ "10Y", 5, 4, 0.3762, 0.4158 },
	{ "10Y", 5, 6, 0.4072, 0.4621 },
	{ "10Y", 5, 8, 0.4307, 0.4967 },
	{ "10Y", 5, 10, 0.4468, 0.5209 },
	{ "10Y", 5, 12, 0.459, 0.539 },
	{ "2.5GY", 5, 2, 0.3352, 0.3636 },
	{ "2.5GY", 5, 4, 0.3621, 0.4143 },
	{ "2.5GY", 5, 6, 0.3879, 0.4646 },
	{ "2.5GY", 5, 8, 0.4088, 0.5068 },
	{ "2.5GY", 5, 10, 0.4224, 0.5369 },
	{ "2.5GY", 5, 12, 0.4333, 0.5602 },
	{ "5GY", 5, 2, 0.3289, 0.3612 },
	{ "5GY", 5, 4, 0.3482, 0.4097 },
	{ "5GY", 5, 6, 0.3663, 0.4614 },
	{ "5GY", 5, 8, 0.3815, 0.5093 },
	{ "5GY", 5, 10, 0.3928, 0.5485 },
	{ "5GY", 5, 12, 0.4011, 0.5802 },
	{ "7.5GY", 5, 2, 0.3188, 0.356 },
	{ "7.5GY", 5, 4, 0.3274, 0.3994 },
	{ "7.5GY", 5, 6, 0.3354, 0.4483 },
	{ "7.5GY", 5, 8, 0.3412, 0.4976 },
	{ "7.5GY", 5, 10, 0.3451, 0.549 },
	{ "7.5GY", 5, 12, 0.345, 0.5949 },
	{ "7.5GY", 5, 14, 0.3429, 0.6335 },
	{ "10GY", 5, 2, 0.311, 0.3508 },
	{ "10GY", 5, 4, 0.3111, 0.3881 },
	{ "10GY", 5, 6, 0.3108, 0.4301 },
	{ "10GY", 5, 8, 0.308, 0.4759 },
	{ "10GY", 5, 10, 0.3028, 0.5237 },
	{ "10GY", 5, 12, 0.294, 0.5751 },
	{ "10GY", 5, 14, 0.2838, 0.6208 },
	{ "10GY", 5, 16, 0.2702, 0.67 },
	{ "10GY", 5, 18, 0.2549, 0.7179 },
	{ "2.5G", 5, 2, 0.303, 0.3445 },
	{ "2.5G", 5, 4, 0.2943, 0.3735 },
	{ "2.5G", 5, 6, 0.2841, 0.4045 },
	{ "2.5G", 5, 8, 0.271, 0.438 },
	{ "2.5G", 5, 10, 0.2565, 0.4705 },
	{ "2.5G", 5, 12, 0.2385, 0.5071 },
	{ "2.5G", 5, 14, 0.2211, 0.5411 },
	{ "2.5G", 5, 16, 0.2005, 0.5759 },
	{ "2.5G", 5, 18, 0.1782, 0.6095 },
	{ "2.5G", 5, 20, 0.1579, 0.6392 },
	{ "2.5G", 5, 22, 0.1377, 0.6674 },
	{ "2.5G", 5, 24, 0.1188, 0.6918 },
	{ "2.5G", 5, 26, 0.0992, 0.7155 },
	{ "2.5G", 5, 28, 0.0794, 0.7385 },
	{ "5G", 5, 2, 0.2978, 0.3392 },
	{ "5G", 5, 4, 0.2841, 0.3628 },
	{ "5G", 5, 6, 0.269, 0.386 },
	{ "5G", 5, 8, 0.2511, 0.4107 },
	{ "5G", 5, 10, 0.2329, 0.4331 },
	{ "5G", 5, 12, 0.2104, 0.4578 },
	{ "5G", 5, 14, 0.1912, 0.4773 },
	{ "5G", 5, 16, 0.1695, 0.4981 },
	{ "5G", 5, 18, 0.1489, 0.5171 },
	{ "5G", 5, 20, 0.1318, 0.5321 },
	{ "5G", 5, 22, 0.1144, 0.5463 },
	{ "5G", 5, 24, 0.0953, 0.5628 },
	{ "5G", 5, 26, 0.0784, 0.5761 },
	{ "5G", 5, 28, 0.0609, 0.5898 },
	{ "7.5G", 5, 2, 0.2945, 0.3355 },
	{ "7.5G", 5, 4, 0.2775, 0.3545 },
	{ "7.5G", 5, 6, 0.2598, 0.3724 },
	{ "7.5G", 5, 8, 0.2395, 0.3915 },
	{ "7.5G", 5, 10, 0.22, 0.4082 },
	{ "7.5G", 5, 12, 0.1964, 0.4271 },
	{ "7.5G", 5, 14, 0.1776, 0.4415 },
	{ "7.5G", 5, 16, 0.1571, 0.4561 },
	{ "7.5G", 5, 18, 0.1372, 0.4705 },
	{ "7.5G", 5, 20, 0.1212, 0.4817 },
	{ "7.5G", 5, 22, 0.105, 0.4927 },
	{ "7.5G", 5, 24, 0.0878, 0.5039 },
	{ "7.5G", 5, 26, 0.073, 0.5131 },
	{ "7.5G", 5, 28, 0.0585, 0.5224 },
	{ "10G", 5, 2, 0.291, 0.331 },
	{ "10G", 5, 4, 0.2711, 0.3455 },
	{ "10G", 5, 6, 0.2519, 0.3587 },
	{ "10G", 5, 8, 0.2297, 0.373 },
	{ "10G", 5, 10, 0.2095, 0.3853 },
	{ "10G", 5, 12, 0.1852, 0.3992 },
	{ "10G", 5, 14, 0.1671, 0.4089 },
	{ "10G", 5, 16, 0.1469, 0.4192 },
	{ "10G", 5, 18, 0.1275, 0.4288 },
	{ "10G", 5, 20, 0.112, 0.436 },
	{ "10G", 5, 22, 0.0958, 0.4428 },
	{ "10G", 5, 24, 0.0811, 0.4491 },
	{ "10G", 5, 26, 0.069, 0.4542 },
	{ "10G", 5, 28, 0.0572, 0.459 },
	{ "2.5BG", 5, 2, 0.288, 0.327 },
	{ "2.5BG", 5, 4, 0.2659, 0.3369 },
	{ "2.5BG", 5, 6, 0.2448, 0.3452 },
	{ "2.5BG", 5, 8, 0.2205, 0.3537 },
	{ "2.5BG", 5, 10, 0.198, 0.3606 },
	{ "2.5BG", 5, 12, 0.1735, 0.3668 },
	{ "2.5BG", 5, 14, 0.1559, 0.3708 },
	{ "2.5BG", 5, 16, 0.1348, 0.375 },
	{ "2.5BG", 5, 18, 0.1165, 0.3785 },
	{ "2.5BG", 5, 20, 0.1005, 0.3814 },
	{ "2.5BG", 5, 22, 0.0861, 0.3832 },
	{ "2.5BG", 5, 24, 0.0738, 0.3851 },
	{ "5BG", 5, 2, 0.2841, 0.321 },
	{ "5BG", 5, 4, 0.2591, 0.3246 },
	{ "5BG", 5, 6, 0.236, 0.327 },
	{ "5BG", 5, 8, 0.21, 0.328 },
	{ "5BG", 5, 10, 0.185, 0.328 },
	{ "5BG", 5, 12, 0.1614, 0.328 },
	{ "5BG", 5, 14, 0.1448, 0.3275 },
	{ "5BG", 5, 16, 0.1243, 0.3261 },
	{ "5BG", 5, 18, 0.1046, 0.3244 },
	{ "5BG", 5, 20, 0.0904, 0.3231 },
	{ "5BG", 5, 22, 0.0781, 0.3211 },
	{ "7.5BG", 5, 2, 0.2812, 0.3161 },
	{ "7.5BG", 5, 4, 0.255, 0.315 },
	{ "7.5BG", 5, 6, 0.2292, 0.3125 },
	{ "7.5BG", 5, 8, 0.203, 0.3082 },
	{ "7.5BG", 5, 10, 0.1776, 0.3032 },
	{ "7.5BG", 5, 12, 0.1537, 0.2976 },
	{ "7.5BG", 5, 14, 0.1364, 0.2932 },
	{ "7.5BG", 5, 16, 0.1167, 0.288 },
	{ "7.5BG", 5, 18, 0.0982, 0.2828 },
	{ "10BG", 5, 2, 0.2796, 0.3111 },
	{ "10BG", 5, 4, 0.2512, 0.304 },
	{ "10BG", 5, 6, 0.2234, 0.2952 },
	{ "10BG", 5, 8, 0.197, 0.286 },
	{ "10BG", 5, 10, 0.1716, 0.276 },
	{ "10BG", 5, 12, 0.1485, 0.2662 },
	{ "10BG", 5, 14, 0.1308, 0.2582 },
	{ "10BG", 5, 16, 0.1108, 0.2489 },
	{ "2.5B", 5, 2, 0.2791, 0.3071 },
	{ "2.5B", 5, 4, 0.2492, 0.2954 },
	{ "2.5B", 5, 6, 0.221, 0.2823 },
	{ "2.5B", 5, 8, 0.1947, 0.2687 },
	{ "2.5B", 5, 10, 0.1697, 0.2549 },
	{ "2.5B", 5, 12, 0.1461, 0.2406 },
	{ "2.5B", 5, 14, 0.1283, 0.2292 },
	{ "2.5B", 5, 16, 0.109, 0.2166 },
	{ "5B", 5, 2, 0.2794, 0.3032 },
	{ "5B", 5, 4, 0.2493, 0.2879 },
	{ "5B", 5, 6, 0.2215, 0.2701 },
	{ "5B", 5, 8, 0.1958, 0.2519 },
	{ "5B", 5, 10, 0.1729, 0.2347 },
	{ "5B", 5, 12, 0.1505, 0.2172 },
	{ "5B", 5, 14, 0.132, 0.2021 },
	{ "5B", 5, 16, 0.1132, 0.1863 },
	{ "7.5B", 5, 2, 0.2803, 0.3 },
	{ "7.5B", 5, 4, 0.2511, 0.2808 },
	{ "7.5B", 5, 6, 0.2248, 0.2612 },
	{ "7.5B", 5, 8, 0.2007, 0.2417 },
	{ "7.5B", 5, 10, 0.1792, 0.223 },
	{ "7.5B", 5, 12, 0.1584, 0.2042 },
	{ "7.5B", 5, 14, 0.1404, 0.1878 },
	{ "7.5B", 5, 16, 0.123, 0.1711 },
	{ "10B", 5, 2, 0.2821, 0.2966 },
	{ "10B", 5, 4, 0.2547, 0.2757 },
	{ "10B", 5, 6, 0.2299, 0.2548 },
	{ "10B", 5, 8, 0.2067, 0.2344 },
	{ "10B", 5, 10, 0.186, 0.2149 },
	{ "10B", 5, 12, 0.1666, 0.1964 },
	{ "10B", 5, 14, 0.1492, 0.1797 },
	{ "10B", 5, 16, 0.1326, 0.1632 },
	{ "10B", 5, 18, 0.1203, 0.1505 },
	{ "2.5PB", 5, 2, 0.2847, 0.2942 },
	{ "2.5PB", 5, 4, 0.26, 0.272 },
	{ "2.5PB", 5, 6, 0.2365, 0.2488 },
	{ "2.5PB", 5, 8, 0.2157, 0.2278 },
	{ "2.5PB", 5, 10, 0.1968, 0.2078 },
	{ "2.5PB", 5, 12, 0.1793, 0.1894 },
	{ "2.5PB", 5, 14, 0.1642, 0.1728 },
	{ "2.5PB", 5, 16, 0.1495, 0.1559 },
	{ "2.5PB", 5, 18, 0.1363, 0.141 },
	{ "5PB", 5, 2, 0.2882, 0.2923 },
	{ "5PB", 5, 4, 0.2662, 0.2687 },
	{ "5PB", 5, 6, 0.2447, 0.2449 },
	{ "5PB", 5, 8, 0.2255, 0.2239 },
	{ "5PB", 5, 10, 0.208, 0.2041 },
	{ "5PB", 5, 12, 0.1918, 0.1858 },
	{ "5PB", 5, 14, 0.1773, 0.1689 },
	{ "5PB", 5, 16, 0.1638, 0.1521 },
	{ "5PB", 5, 18, 0.1518, 0.1365 },
	{ "7.5PB", 5, 2, 0.2918, 0.2908 },
	{ "7.5PB", 5, 4, 0.2739, 0.2666 },
	{ "7.5PB", 5, 6, 0.2563, 0.2417 },
	{ "7.5PB", 5, 8, 0.2417, 0.2204 },
	{ "7.5PB", 5, 10, 0.2285, 0.202 },
	{ "7.5PB", 5, 12, 0.2157, 0.183 },
	{ "7.5PB", 5, 14, 0.2042, 0.1661 },
	{ "7.5PB", 5, 16, 0.1945, 0.1511 },
	{ "7.5PB", 5, 18, 0.1862, 0.1365 },
	{ "7.5PB", 5, 20, 0.1794, 0.1239 },
	{ "10PB", 5, 2, 0.2959, 0.2905 },
	{ "10PB", 5, 4, 0.2821, 0.2659 },
	{ "10PB", 5, 6, 0.2686, 0.2412 },
	{ "10PB", 5, 8, 0.2572, 0.2211 },
	{ "10PB", 5, 10, 0.2478, 0.203 },
	{ "10PB", 5, 12, 0.2384, 0.1857 },
	{ "10PB", 5, 14, 0.2299, 0.1698 },
	{ "10PB", 5, 16, 0.2224, 0.1555 },
	{ "10PB", 5, 18, 0.2174, 0.1444 },
	{ "10PB", 5, 20, 0.2121, 0.1329 },
	{ "10PB", 5, 22, 0.2082, 0.1225 },
	{ "2.5P", 5, 2, 0.3, 0.2912 },
	{ "2.5P", 5, 4, 0.2898, 0.2667 },
	{ "2.5P", 5, 6, 0.2806, 0.2444 },
	{ "2.5P", 5, 8, 0.2728, 0.224 },
	{ "2.5P", 5, 10, 0.2665, 0.2075 },
	{ "2.5P", 5, 12, 0.2608, 0.1913 },
	{ "2.5P", 5, 14, 0.256, 0.1774 },
	{ "2.5P", 5, 16, 0.2515, 0.1644 },
	{ "2.5P", 5, 18, 0.2476, 0.1532 },
	{ "2.5P", 5, 20, 0.2438, 0.1419 },
	{ "2.5P", 5, 22, 0.2402, 0.1315 },
	{ "2.5P", 5, 24, 0.2372, 0.1223 },
	{ "2.5P", 5, 26, 0.2348, 0.114 },
	{ "5P", 5, 2, 0.3045, 0.2928 },
	{ "5P", 5, 4, 0.2986, 0.2699 },
	{ "5P", 5, 6, 0.2932, 0.2487 },
	{ "5P", 5, 8, 0.2885, 0.2296 },
	{ "5P", 5, 10, 0.2845, 0.2137 },
	{ "5P", 5, 12, 0.2806, 0.1977 },
	{ "5P", 5, 14, 0.2775, 0.1847 },
	{ "5P", 5, 16, 0.2744, 0.1718 },
	{ "5P", 5, 18, 0.2718, 0.1604 },
	{ "5P", 5, 20, 0.2694, 0.1499 },
	{ "5P", 5, 22, 0.2673, 0.1398 },
	{ "5P", 5, 24, 0.2652, 0.1304 },
	{ "5P", 5, 26, 0.2635, 0.1224 },
	{ "5P", 5, 28, 0.2618, 0.1135 },
	{ "7.5P", 5, 2, 0.3103, 0.2959 },
	{ "7.5P", 5, 4, 0.31, 0.275 },
	{ "7.5P", 5, 6, 0.3093, 0.2555 },
	{ "7.5P", 5, 8, 0.3087, 0.2375 },
	{ "7.5P", 5, 10, 0.308, 0.223 },
	{ "7.5P", 5, 12, 0.3071, 0.208 },
	{ "7.5P", 5, 14, 0.3068, 0.1951 },
	{ "7.5P", 5, 16, 0.306, 0.183 },
	{ "7.5P", 5, 18, 0.3052, 0.1711 },
	{ "7.5P", 5, 20, 0.3042, 0.1606 },
	{ "7.5P", 5, 22, 0.3038, 0.15 },
	{ "7.5P", 5, 24, 0.303, 0.1423 },
	{ "7.5P", 5, 26, 0.3022, 0.1331 },
	{ "7.5P", 5, 28, 0.3018, 0.1253 },
	{ "7.5P", 5, 30, 0.301, 0.117 },
	{ "10P", 5, 2, 0.3148, 0.2986 },
	{ "10P", 5, 4, 0.3198, 0.2807 },
	{ "10P", 5, 6, 0.3243, 0.263 },
	{ "10P", 5, 8, 0.328, 0.2464 },
	{ "10P", 5, 10, 0.3308, 0.2328 },
	{ "10P", 5, 12, 0.3335, 0.2187 },
	{ "10P", 5, 14, 0.336, 0.2066 },
	{ "10P", 5, 16, 0.3382, 0.1951 },
	{ "10P", 5, 18, 0.3401, 0.184 },
	{ "10P", 5, 20, 0.3422, 0.1735 },
	{ "10P", 5, 22, 0.3437, 0.1644 },
	{ "10P", 5, 24, 0.345, 0.1555 },
	{ "10P", 5, 26, 0.3468, 0.146 },
	{ "10P", 5, 28, 0.3478, 0.1388 },
	{ "10P", 5, 30, 0.349, 0.1308 },
	{ "2.5RP", 5, 2, 0.3199, 0.3019 },
	{ "2.5RP", 5, 4, 0.3298, 0.2869 },
	{ "2.5RP", 5, 6, 0.3396, 0.2718 },
	{ "2.5RP", 5, 8, 0.349, 0.257 },
	{ "2.5RP", 5, 10, 0.356, 0.2452 },
	{ "2.5RP", 5, 12, 0.3635, 0.2325 },
	{ "2.5RP", 5, 14, 0.3703, 0.2211 },
	{ "2.5RP", 5, 16, 0.3763, 0.2108 },
	{ "2.5RP", 5, 18, 0.3821, 0.2007 },
	{ "2.5RP", 5, 20, 0.3873, 0.1909 },
	{ "2.5RP", 5, 22, 0.3924, 0.1814 },
	{ "2.5RP", 5, 24, 0.3965, 0.1738 },
	{ "2.5RP", 5, 26, 0.4011, 0.1652 },
	{ "5RP", 5, 2, 0.3256, 0.3065 },
	{ "5RP", 5, 4, 0.3421, 0.2954 },
	{ "5RP", 5, 6, 0.3585, 0.2842 },
	{ "5RP", 5, 8, 0.3748, 0.2729 },
	{ "5RP", 5, 10, 0.388, 0.263 },
	{ "5RP", 5, 12, 0.4022, 0.2523 },
	{ "5RP", 5, 14, 0.4142, 0.2428 },
	{ "5RP", 5, 16, 0.4261, 0.2331 },
	{ "5RP", 5, 18, 0.4372, 0.2242 },
	{ "5RP", 5, 20, 0.4484, 0.215 },
	{ "5RP", 5, 22, 0.4581, 0.2068 },
	{ "5RP", 5, 24, 0.4683, 0.1978 },
	{ "7.5RP", 5, 2, 0.3296, 0.3098 },
	{ "7.5RP", 5, 4, 0.3515, 0.3024 },
	{ "7.5RP", 5, 6, 0.3726, 0.2941 },
	{ "7.5RP", 5, 8, 0.3932, 0.2852 },
	{ "7.5RP", 5, 10, 0.4108, 0.2773 },
	{ "7.5RP", 5, 12, 0.4303, 0.2675 },
	{ "7.5RP", 5, 14, 0.4454, 0.2596 },
	{ "7.5RP", 5, 16, 0.4617, 0.2506 },
	{ "7.5RP", 5, 18, 0.4761, 0.2421 },
	{ "7.5RP", 5, 20, 0.4915, 0.233 },
	{ "7.5RP", 5, 22, 0.5045, 0.2248 },
	{ "10RP", 6, 2, 0.3292, 0.3141 },
	{ "10RP", 6, 4, 0.3508, 0.3112 },
	{ "10RP", 6, 6, 0.374, 0.3074 },
	{ "10RP", 6, 8, 0.393, 0.3038 },
	{ "10RP", 6, 10, 0.415, 0.2989 },
	{ "10RP", 6, 12, 0.436, 0.2936 },
	{ "10RP", 6, 14, 0.4552, 0.2881 },
	{ "10RP", 6, 16, 0.4781, 0.2812 },
	{ "10RP", 6, 18, 0.4961, 0.2751 },
	{ "2.5R", 6, 2, 0.3318, 0.3166 },
	{ "2.5R", 6, 4, 0.3566, 0.3163 },
	{ "2.5R", 6, 6, 0.3832, 0.3158 },
	{ "2.5R", 6, 8, 0.4065, 0.3144 },
	{ "2.5R", 6, 10, 0.432, 0.3118 },
	{ "2.5R", 6, 12, 0.4568, 0.3082 },
	{ "2.5R", 6, 14, 0.479, 0.3041 },
	{ "2.5R", 6, 16, 0.5041, 0.2983 },
	{ "2.5R", 6, 18, 0.5262, 0.2928 },
	{ "5R", 6, 2, 0.3343, 0.319 },
	{ "5R", 6, 4, 0.3628, 0.3221 },
	{ "5R", 6, 6, 0.3921, 0.3244 },
	{ "5R", 6, 8, 0.4187, 0.3251 },
	{ "5R", 6, 10, 0.448, 0.325 },
	{ "5R", 6, 12, 0.476, 0.3234 },
	{ "5R", 6, 14, 0.502, 0.3212 },
	{ "5R", 6, 16, 0.5297, 0.3179 },
	{ "5R", 6, 18, 0.5552, 0.3138 },
	{ "7.5R", 6, 2, 0.3381, 0.3228 },
	{ "7.5R", 6, 4, 0.3692, 0.3291 },
	{ "7.5R", 6, 6, 0.4, 0.334 },
	{ "7.5R", 6, 8, 0.4318, 0.3383 },
	{ "7.5R", 6, 10, 0.4655, 0.3412 },
	{ "7.5R", 6, 12, 0.4961, 0.3428 },
	{ "7.5R", 6, 14, 0.5265, 0.3431 },
	{ "7.5R", 6, 16, 0.556, 0.342 },
	{ "7.5R", 6, 18, 0.5829, 0.3396 },
	{ "10R", 6, 2, 0.3417, 0.3268 },
	{ "10R", 6, 4, 0.3768, 0.3381 },
	{ "10R", 6, 6, 0.4103, 0.3473 },
	{ "10R", 6, 8, 0.4449, 0.355 },
	{ "10R", 6, 10, 0.4812, 0.3619 },
	{ "10R", 6, 12, 0.515, 0.3667 },
	{ "10R", 6, 14, 0.5468, 0.3697 },
	{ "10R", 6, 16, 0.5741, 0.3713 },
	{ "10R", 6, 18, 0.6009, 0.372 },
	{ "2.5YR", 6, 2, 0.3453, 0.3321 },
	{ "2.5YR", 6, 4, 0.3806, 0.3467 },
	{ "2.5YR", 6, 6, 0.418, 0.36 },
	{ "2.5YR", 6, 8, 0.4533, 0.3708 },
	{ "2.5YR", 6, 10, 0.4891, 0.3806 },
	{ "2.5YR", 6, 12, 0.5215, 0.3887 },
	{ "2.5YR", 6, 14, 0.5488, 0.3947 },
	{ "2.5YR", 6, 16, 0.5698, 0.399 },
	{ "2.5YR", 6, 18, 0.5879, 0.4021 },
	{ "5YR", 6, 2, 0.3474, 0.3373 },
	{ "5YR", 6, 4, 0.384, 0.3564 },
	{ "5YR", 6, 6, 0.4229, 0.375 },
	{ "5YR", 6, 8, 0.4592, 0.39 },
	{ "5YR", 6, 10, 0.4921, 0.4022 },
	{ "5YR", 6, 12, 0.5199, 0.4119 },
	{ "5YR", 6, 14, 0.5423, 0.4188 },
	{ "5YR", 6, 16, 0.5597, 0.4239 },
	{ "5YR", 6, 18, 0.5715, 0.427 },
	{ "7.5YR", 6, 2, 0.3487, 0.3421 },
	{ "7.5YR", 6, 4, 0.386, 0.3652 },
	{ "7.5YR", 6, 6, 0.4242, 0.3876 },
	{ "7.5YR", 6, 8, 0.4596, 0.4064 },
	{ "7.5YR", 6, 10, 0.4904, 0.422 },
	{ "7.5YR", 6, 12, 0.5145, 0.4331 },
	{ "7.5YR", 6, 14, 0.532, 0.4412 },
	{ "7.5YR", 6, 16, 0.5468, 0.4478 },
	{ "10YR", 6, 2, 0.3491, 0.3483 },
	{ "10YR", 6, 4, 0.3861, 0.3767 },
	{ "10YR", 6, 6, 0.424, 0.403 },
	{ "10YR", 6, 8, 0.457, 0.4249 },
	{ "10YR", 6, 10, 0.4843, 0.4416 },
	{ "10YR", 6, 12, 0.505, 0.4536 },
	{ "10YR", 6, 14, 0.52, 0.4623 },
	{ "2.5Y", 6, 2, 0.348, 0.354 },
	{ "2.5Y", 6, 4, 0.384, 0.3867 },
	{ "2.5Y", 6, 6, 0.4203, 0.4176 },
	{ "2.5Y", 6, 8, 0.4517, 0.4421 },
	{ "2.5Y", 6, 10, 0.476, 0.4607 },
	{ "2.5Y", 6, 12, 0.4928, 0.473 },
	{ "2.5Y", 6, 14, 0.5061, 0.4829 },
	{ "5Y", 6, 2, 0.3457, 0.358 },
	{ "5Y", 6, 4, 0.3794, 0.3955 },
	{ "5Y", 6, 6, 0.414, 0.4305 },
	{ "5Y", 6, 8, 0.4426, 0.4588 },
	{ "5Y", 6, 10, 0.4639, 0.479 },
	{ "5Y", 6, 12, 0.478, 0.492 },
	{ "5Y", 6, 14, 0.4905, 0.5038 },
	{ "7.5Y", 6, 2, 0.3431, 0.3601 },
	{ "7.5Y", 6, 4, 0.3745, 0.4004 },
	{ "7.5Y", 6, 6, 0.406, 0.44 },
	{ "7.5Y", 6, 8, 0.4321, 0.4719 },
	{ "7.5Y", 6, 10, 0.4512, 0.4943 },
	{ "7.5Y", 6, 12, 0.4638, 0.5087 },
	{ "7.5Y", 6, 14, 0.4754, 0.522 },
	{ "10Y", 6, 2, 0.3398, 0.3611 },
	{ "10Y", 6, 4, 0.3679, 0.4033 },
	{ "10Y", 6, 6, 0.396, 0.4452 },
	{ "10Y", 6, 8, 0.4201, 0.4812 },
	{ "10Y", 6, 10, 0.4372, 0.5068 },
	{ "10Y", 6, 12, 0.4488, 0.5237 },
	{ "10Y", 6, 14, 0.4593, 0.5392 },
	{ "2.5GY", 6, 2, 0.3342, 0.3607 },
	{ "2.5GY", 6, 4, 0.3572, 0.4038 },
	{ "2.5GY", 6, 6, 0.3799, 0.447 },
	{ "2.5GY", 6, 8, 0.4006, 0.4885 },
	{ "2.5GY", 6, 10, 0.4159, 0.519 },
	{ "2.5GY", 6, 12, 0.4269, 0.5414 },
	{ "2.5GY", 6, 14, 0.4354, 0.5594 },
	{ "5GY", 6, 2, 0.3288, 0.3592 },
	{ "5GY", 6, 4, 0.3461, 0.4008 },
	{ "5GY", 6, 6, 0.3622, 0.4438 },
	{ "5GY", 6, 8, 0.3772, 0.488 },
	{ "5GY", 6, 10, 0.3891, 0.5264 },
	{ "5GY", 6, 12, 0.398, 0.5564 },
	{ "5GY", 6, 14, 0.4042, 0.5788 },
	{ "7.5GY", 6, 2, 0.3193, 0.355 },
	{ "7.5GY", 6, 4, 0.3275, 0.3922 },
	{ "7.5GY", 6, 6, 0.3351, 0.4321 },
	{ "7.5GY", 6, 8, 0.3418, 0.4768 },
	{ "7.5GY", 6, 10, 0.3463, 0.5196 },
	{ "7.5GY", 6, 12, 0.3488, 0.5596 },
	{ "7.5GY", 6, 14, 0.3498, 0.5985 },
	{ "7.5GY", 6, 16, 0.3498, 0.6282 },
	{ "10GY", 6, 2, 0.3112, 0.3496 },
	{ "10GY", 6, 4, 0.3124, 0.3822 },
	{ "10GY", 6, 6, 0.3128, 0.4175 },
	{ "10GY", 6, 8, 0.3116, 0.4563 },
	{ "10GY", 6, 10, 0.3086, 0.4949 },
	{ "10GY", 6, 12, 0.3037, 0.5358 },
	{ "10GY", 6, 14, 0.2962, 0.5802 },
	{ "10GY", 6, 16, 0.2872, 0.6199 },
	{ "10GY", 6, 18, 0.2763, 0.6616 },
	{ "10GY", 6, 20, 0.2648, 0.7004 },
	{ "2.5G", 6, 2, 0.3039, 0.3437 },
	{ "2.5G", 6, 4, 0.2967, 0.3695 },
	{ "2.5G", 6, 6, 0.2892, 0.3963 },
	{ "2.5G", 6, 8, 0.2799, 0.4239 },
	{ "2.5G", 6, 10, 0.269, 0.453 },
	{ "2.5G", 6, 12, 0.2574, 0.4814 },
	{ "2.5G", 6, 14, 0.2426, 0.5133 },
	{ "2.5G", 6, 16, 0.2278, 0.543 },
	{ "2.5G", 6, 18, 0.2102, 0.5737 },
	{ "2.5G", 6, 20, 0.1922, 0.6035 },
	{ "2.5G", 6, 22, 0.1739, 0.6318 },
	{ "2.5G", 6, 24, 0.1536, 0.6605 },
	{ "2.5G", 6, 26, 0.134, 0.6871 },
	{ "2.5G", 6, 28, 0.1145, 0.7122 },
	{ "5G", 6, 2, 0.2988, 0.3382 },
	{ "5G", 6, 4, 0.2868, 0.3595 },
	{ "5G", 6, 6, 0.2748, 0.3795 },
	{ "5G", 6, 8, 0.2612, 0.399 },
	{ "5G", 6, 10, 0.2466, 0.4181 },
	{ "5G", 6, 12, 0.2293, 0.439 },
	{ "5G", 6, 14, 0.213, 0.4571 },
	{ "5G", 6, 16, 0.196, 0.4751 },
	{ "5G", 6, 18, 0.1785, 0.4924 },
	{ "5G", 6, 20, 0.1609, 0.5091 },
	{ "5G", 6, 22, 0.1432, 0.5252 },
	{ "5G", 6, 24, 0.1252, 0.5408 },
	{ "5G", 6, 26, 0.1079, 0.556 },
	{ "5G", 6, 28, 0.0908, 0.5695 },
	{ "7.5G", 6, 2, 0.2958, 0.3344 },
	{ "7.5G", 6, 4, 0.2807, 0.3522 },
	{ "7.5G", 6, 6, 0.2662, 0.3672 },
	{ "7.5G", 6, 8, 0.251, 0.3829 },
	{ "7.5G", 6, 10, 0.235, 0.3979 },
	{ "7.5G", 6, 12, 0.2171, 0.4138 },
	{ "7.5G", 6, 14, 0.2001, 0.4278 },
	{ "7.5G", 6, 16, 0.1832, 0.4414 },
	{ "7.5G", 6, 18, 0.1654, 0.4551 },
	{ "7.5G", 6, 20, 0.1485, 0.4677 },
	{ "7.5G", 6, 22, 0.1325, 0.4795 },
	{ "7.5G", 6, 24, 0.1159, 0.491 },
	{ "7.5G", 6, 26, 0.101, 0.5018 },
	{ "7.5G", 6, 28, 0.0858, 0.5127 },
	{ "10G", 6, 2, 0.2929, 0.3303 },
	{ "10G", 6, 4, 0.2749, 0.3443 },
	{ "10G", 6, 6, 0.2591, 0.3558 },
	{ "10G", 6, 8, 0.242, 0.3679 },
	{ "10G", 6, 10, 0.2247, 0.3796 },
	{ "10G", 6, 12, 0.206, 0.3914 },
	{ "10G", 6, 14, 0.1895, 0.4015 },
	{ "10G", 6, 16, 0.1722, 0.4113 },
	{ "10G", 6, 18, 0.1551, 0.4208 },
	{ "10G", 6, 20, 0.1382, 0.4299 },
	{ "10G", 6, 22, 0.123, 0.4378 },
	{ "10G", 6, 24, 0.107, 0.4458 },
	{ "10G", 6, 26, 0.0941, 0.452 },
	{ "2.5BG", 6, 2, 0.2902, 0.3268 },
	{ "2.5BG", 6, 4, 0.2702, 0.3369 },
	{ "2.5BG", 6, 6, 0.2526, 0.3448 },
	{ "2.5BG", 6, 8, 0.2332, 0.3522 },
	{ "2.5BG", 6, 10, 0.2148, 0.3584 },
	{ "2.5BG", 6, 12, 0.1954, 0.3645 },
	{ "2.5BG", 6, 14, 0.1779, 0.3699 },
	{ "2.5BG", 6, 16, 0.16, 0.3748 },
	{ "2.5BG", 6, 18, 0.1428, 0.379 },
	{ "2.5BG", 6, 20, 0.1269, 0.3829 },
	{ "2.5BG", 6, 22, 0.112, 0.386 },
	{ "5BG", 6, 2, 0.2872, 0.3219 },
	{ "5BG", 6, 4, 0.2648, 0.3262 },
	{ "5BG", 6, 6, 0.2441, 0.329 },
	{ "5BG", 6, 8, 0.2236, 0.3311 },
	{ "5BG", 6, 10, 0.2037, 0.3329 },
	{ "5BG", 6, 12, 0.1844, 0.3337 },
	{ "5BG", 6, 14, 0.1662, 0.3343 },
	{ "5BG", 6, 16, 0.1491, 0.3345 },
	{ "5BG", 6, 18, 0.1325, 0.3345 },
	{ "5BG", 6, 20, 0.1168, 0.3344 },
	{ "7.5BG", 6, 2, 0.2849, 0.3172 },
	{ "7.5BG", 6, 4, 0.2604, 0.3169 },
	{ "7.5BG", 6, 6, 0.2384, 0.3155 },
	{ "7.5BG", 6, 8, 0.2171, 0.3138 },
	{ "7.5BG", 6, 10, 0.1961, 0.311 },
	{ "7.5BG", 6, 12, 0.1762, 0.3081 },
	{ "7.5BG", 6, 14, 0.1585, 0.3052 },
	{ "7.5BG", 6, 16, 0.1408, 0.3017 },
	{ "7.5BG", 6, 18, 0.1248, 0.2981 },
	{ "10BG", 6, 2, 0.2837, 0.3132 },
	{ "10BG", 6, 4, 0.2578, 0.3078 },
	{ "10BG", 6, 6, 0.2335, 0.3015 },
	{ "10BG", 6, 8, 0.2116, 0.295 },
	{ "10BG", 6, 10, 0.1909, 0.2881 },
	{ "10BG", 6, 12, 0.1698, 0.2802 },
	{ "10BG", 6, 14, 0.1518, 0.2729 },
	{ "10BG", 6, 16, 0.1337, 0.2651 },
	{ "10BG", 6, 18, 0.1181, 0.2581 },
	{ "2.5B", 6, 2, 0.2835, 0.3097 },
	{ "2.5B", 6, 4, 0.2571, 0.3008 },
	{ "2.5B", 6, 6, 0.2312, 0.2899 },
	{ "2.5B", 6, 8, 0.208, 0.2789 },
	{ "2.5B", 6, 10, 0.1879, 0.2682 },
	{ "2.5B", 6, 12, 0.166, 0.2561 },
	{ "2.5B", 6, 14, 0.148, 0.2459 },
	{ "2.5B", 6, 16, 0.1294, 0.2348 },
	{ "5B", 6, 2, 0.2842, 0.3063 },
	{ "5B", 6, 4, 0.2579, 0.2938 },
	{ "5B", 6, 6, 0.232, 0.2789 },
	{ "5B", 6, 8, 0.2088, 0.2635 },
	{ "5B", 6, 10, 0.1883, 0.2487 },
	{ "5B", 6, 12, 0.1685, 0.2339 },
	{ "5B", 6, 14, 0.1496, 0.2193 },
	{ "5B", 6, 16, 0.131, 0.2048 },
	{ "7.5B", 6, 2, 0.2854, 0.3037 },
	{ "7.5B", 6, 4, 0.2602, 0.2881 },
	{ "7.5B", 6, 6, 0.2352, 0.2708 },
	{ "7.5B", 6, 8, 0.2132, 0.2537 },
	{ "7.5B", 6, 10, 0.1934, 0.2374 },
	{ "7.5B", 6, 12, 0.1734, 0.2203 },
	{ "7.5B", 6, 14, 0.1556, 0.2043 },
	{ "7.5B", 6, 16, 0.1376, 0.1879 },
	{ "10B", 6, 2, 0.2871, 0.3012 },
	{ "10B", 6, 4, 0.2637, 0.284 },
	{ "10B", 6, 6, 0.2399, 0.265 },
	{ "10B", 6, 8, 0.2189, 0.2468 },
	{ "10B", 6, 10, 0.2, 0.2298 },
	{ "10B", 6, 12, 0.1803, 0.2114 },
	{ "10B", 6, 14, 0.1629, 0.1947 },
	{ "10B", 6, 16, 0.1454, 0.1778 },
	{ "2.5PB", 6, 2, 0.2897, 0.2991 },
	{ "2.5PB", 6, 4, 0.2684, 0.2804 },
	{ "2.5PB", 6, 6, 0.2465, 0.2599 },
	{ "2.5PB", 6, 8, 0.2274, 0.2406 },
	{ "2.5PB", 6, 10, 0.2095, 0.2225 },
	{ "2.5PB", 6, 12, 0.1913, 0.2038 },
	{ "2.5PB", 6, 14, 0.1754, 0.1868 },
	{ "5PB", 6, 2, 0.2923, 0.2978 },
	{ "5PB", 6, 4, 0.2734, 0.2778 },
	{ "5PB", 6, 6, 0.2533, 0.2558 },
	{ "5PB", 6, 8, 0.236, 0.2365 },
	{ "5PB", 6, 10, 0.2197, 0.2188 },
	{ "5PB", 6, 12, 0.2026, 0.1999 },
	{ "5PB", 6, 14, 0.1873, 0.1822 },
	{ "7.5PB", 6, 2, 0.2955, 0.2963 },
	{ "7.5PB", 6, 4, 0.2798, 0.2752 },
	{ "7.5PB", 6, 6, 0.2638, 0.2531 },
	{ "7.5PB", 6, 8, 0.2505, 0.2347 },
	{ "7.5PB", 6, 10, 0.2378, 0.2168 },
	{ "7.5PB", 6, 12, 0.2241, 0.1975 },
	{ "7.5PB", 6, 14, 0.2119, 0.1799 },
	{ "10PB", 6, 2, 0.2988, 0.2961 },
	{ "10PB", 6, 4, 0.2863, 0.2747 },
	{ "10PB", 6, 6, 0.274, 0.2533 },
	{ "10PB", 6, 8, 0.2637, 0.2352 },
	{ "10PB", 6, 10, 0.254, 0.2176 },
	{ "10PB", 6, 12, 0.244, 0.1998 },
	{ "10PB", 6, 14, 0.2352, 0.1839 },
	{ "10PB", 6, 16, 0.2265, 0.1671 },
	{ "2.5P", 6, 2, 0.3016, 0.296 },
	{ "2.5P", 6, 4, 0.2932, 0.2759 },
	{ "2.5P", 6, 6, 0.2842, 0.255 },
	{ "2.5P", 6, 8, 0.277, 0.2372 },
	{ "2.5P", 6, 10, 0.2703, 0.2204 },
	{ "2.5P", 6, 12, 0.2647, 0.2052 },
	{ "2.5P", 6, 14, 0.2593, 0.1909 },
	{ "2.5P", 6, 16, 0.2548, 0.1768 },
	{ "2.5P", 6, 18, 0.2504, 0.1658 },
	{ "5P", 6, 2, 0.305, 0.2967 },
	{ "5P", 6, 4, 0.3001, 0.2778 },
	{ "5P", 6, 6, 0.295, 0.2585 },
	{ "5P", 6, 8, 0.2905, 0.2421 },
	{ "5P", 6, 10, 0.2862, 0.226 },
	{ "5P", 6, 12, 0.2829, 0.2121 },
	{ "5P", 6, 14, 0.2794, 0.1979 },
	{ "5P", 6, 16, 0.2761, 0.1852 },
	{ "5P", 6, 18, 0.2731, 0.1738 },
	{ "5P", 6, 20, 0.2702, 0.1621 },
	{ "7.5P", 6, 2, 0.3107, 0.2993 },
	{ "7.5P", 6, 4, 0.3107, 0.2831 },
	{ "7.5P", 6, 6, 0.3101, 0.265 },
	{ "7.5P", 6, 8, 0.3099, 0.2502 },
	{ "7.5P", 6, 10, 0.3092, 0.235 },
	{ "7.5P", 6, 12, 0.309, 0.2222 },
	{ "7.5P", 6, 14, 0.3084, 0.2095 },
	{ "7.5P", 6, 16, 0.308, 0.1976 },
	{ "7.5P", 6, 18, 0.3075, 0.187 },
	{ "7.5P", 6, 20, 0.3069, 0.1745 },
	{ "7.5P", 6, 22, 0.3062, 0.1638 },
	{ "7.5P", 6, 24, 0.3058, 0.1547 },
	{ "10P", 6, 2, 0.3146, 0.3018 },
	{ "10P", 6, 4, 0.3181, 0.2871 },
	{ "10P", 6, 6, 0.3226, 0.2716 },
	{ "10P", 6, 8, 0.3259, 0.2584 },
	{ "10P", 6, 10, 0.3293, 0.245 },
	{ "10P", 6, 12, 0.3321, 0.2329 },
	{ "10P", 6, 14, 0.3349, 0.2203 },
	{ "10P", 6, 16, 0.337, 0.2095 },
	{ "10P", 6, 18, 0.3388, 0.1995 },
	{ "10P", 6, 20, 0.3409, 0.1882 },
	{ "10P", 6, 22, 0.3426, 0.1785 },
	{ "10P", 6, 24, 0.3441, 0.1698 },
	{ "10P", 6, 26, 0.3457, 0.1604 },
	{ "2.5RP", 6, 2, 0.3188, 0.3048 },
	{ "2.5RP", 6, 4, 0.3272, 0.2929 },
	{ "2.5RP", 6, 6, 0.3362, 0.2799 },
	{ "2.5RP", 6, 8, 0.3437, 0.2688 },
	{ "2.5RP", 6, 10, 0.3509, 0.2578 },
	{ "2.5RP", 6, 12, 0.3582, 0.2462 },
	{ "2.5RP", 6, 14, 0.3652, 0.2355 },
	{ "2.5RP", 6, 16, 0.3718, 0.2251 },
	{ "2.5RP", 6, 18, 0.3773, 0.2158 },
	{ "2.5RP", 6, 20, 0.3833, 0.2056 },
	{ "2.5RP", 6, 22, 0.3877, 0.1978 },
	{ "2.5RP", 6, 24, 0.3927, 0.1892 },
	{ "5RP", 6, 2, 0.3232, 0.3085 },
	{ "5RP", 6, 4, 0.3371, 0.3001 },
	{ "5RP", 6, 6, 0.352, 0.2904 },
	{ "5RP", 6, 8, 0.3648, 0.282 },
	{ "5RP", 6, 10, 0.3769, 0.2738 },
	{ "5RP", 6, 12, 0.39, 0.2646 },
	{ "5RP", 6, 14, 0.4023, 0.2552 },
	{ "5RP", 6, 16, 0.4136, 0.2467 },
	{ "5RP", 6, 18, 0.4245, 0.2382 },
	{ "5RP", 6, 20, 0.4368, 0.2283 },
	{ "5RP", 6, 22, 0.4449, 0.2219 },
	{ "7.5RP", 6, 2, 0.3261, 0.3113 },
	{ "7.5RP", 6, 4, 0.3439, 0.3056 },
	{ "7.5RP", 6, 6, 0.3635, 0.2987 },
	{ "7.5RP", 6, 8, 0.3791, 0.2929 },
	{ "7.5RP", 6, 10, 0.396, 0.286 },
	{ "7.5RP", 6, 12, 0.4125, 0.2784 },
	{ "7.5RP", 6, 14, 0.4285, 0.2705 },
	{ "7.5RP", 6, 16, 0.4448, 0.2622 },
	{ "7.5RP", 6, 18, 0.4581, 0.2549 },
	{ "7.5RP", 6, 20, 0.4735, 0.2464 },
	{ "10RP", 7, 2, 0.3258, 0.3148 },
	{ "10RP", 7, 4, 0.3446, 0.3125 },
	{ "10RP", 7, 6, 0.3648, 0.3098 },
	{ "10RP", 7, 8, 0.3851, 0.3067 },
	{ "10RP", 7, 10, 0.404, 0.303 },
	{ "10RP", 7, 12, 0.426, 0.298 },
	{ "10RP", 7, 14, 0.4456, 0.2931 },
	{ "10RP", 7, 16, 0.4648, 0.2878 },
	{ "2.5R", 7, 2, 0.3284, 0.317 },
	{ "2.5R", 7, 4, 0.3499, 0.3171 },
	{ "2.5R", 7, 6, 0.3728, 0.317 },
	{ "2.5R", 7, 8, 0.3961, 0.316 },
	{ "2.5R", 7, 10, 0.4183, 0.3144 },
	{ "2.5R", 7, 12, 0.4435, 0.3119 },
	{ "2.5R", 7, 14, 0.466, 0.3082 },
	{ "2.5R", 7, 16, 0.4885, 0.3039 },
	{ "5R", 7, 2, 0.3306, 0.319 },
	{ "5R", 7, 4, 0.3552, 0.3222 },
	{ "5R", 7, 6, 0.3805, 0.3244 },
	{ "5R", 7, 8, 0.4067, 0.3256 },
	{ "5R", 7, 10, 0.432, 0.326 },
	{ "5R", 7, 12, 0.4595, 0.3252 },
	{ "5R", 7, 14, 0.4848, 0.3238 },
	{ "7.5R", 7, 2, 0.3335, 0.322 },
	{ "7.5R", 7, 4, 0.3611, 0.3282 },
	{ "7.5R", 7, 6, 0.3888, 0.3336 },
	{ "7.5R", 7, 8, 0.4196, 0.3382 },
	{ "7.5R", 7, 10, 0.447, 0.3413 },
	{ "7.5R", 7, 12, 0.4777, 0.3435 },
	{ "7.5R", 7, 14, 0.5059, 0.345 },
	{ "7.5R", 7, 16, 0.5341, 0.3452 },
	{ "10R", 7, 2, 0.336, 0.3253 },
	{ "10R", 7, 4, 0.3671, 0.336 },
	{ "10R", 7, 6, 0.3984, 0.3452 },
	{ "10R", 7, 8, 0.4308, 0.3533 },
	{ "10R", 7, 10, 0.46, 0.3596 },
	{ "10R", 7, 12, 0.493, 0.3659 },
	{ "10R", 7, 14, 0.5234, 0.37 },
	{ "10R", 7, 16, 0.5519, 0.3729 },
	{ "2.5YR", 7, 2, 0.3392, 0.3298 },
	{ "2.5YR", 7, 4, 0.3715, 0.3439 },
	{ "2.5YR", 7, 6, 0.4053, 0.357 },
	{ "2.5YR", 7, 8, 0.4371, 0.3679 },
	{ "2.5YR", 7, 10, 0.4671, 0.3768 },
	{ "2.5YR", 7, 12, 0.5001, 0.3861 },
	{ "2.5YR", 7, 14, 0.5297, 0.3938 },
	{ "2.5YR", 7, 16, 0.5522, 0.3989 },
	{ "2.5YR", 7, 18, 0.5695, 0.4024 },
	{ "2.5YR", 7, 20, 0.5824, 0.4046 },
	{ "5YR", 7, 2, 0.3421, 0.3349 },
	{ "5YR", 7, 4, 0.375, 0.353 },
	{ "5YR", 7, 6, 0.4091, 0.3701 },
	{ "5YR", 7, 8, 0.4402, 0.3842 },
	{ "5YR", 7, 10, 0.4711, 0.3972 },
	{ "5YR", 7, 12, 0.5007, 0.4081 },
	{ "5YR", 7, 14, 0.5252, 0.4168 },
	{ "5YR", 7, 16, 0.5437, 0.4228 },
	{ "5YR", 7, 18, 0.5564, 0.4267 },
	{ "5YR", 7, 20, 0.5657, 0.4298 },
	{ "7.5YR", 7, 2, 0.3437, 0.3397 },
	{ "7.5YR", 7, 4, 0.3772, 0.3613 },
	{ "7.5YR", 7, 6, 0.4107, 0.382 },
	{ "7.5YR", 7, 8, 0.4415, 0.3996 },
	{ "7.5YR", 7, 10, 0.4704, 0.4151 },
	{ "7.5YR", 7, 12, 0.497, 0.4282 },
	{ "7.5YR", 7, 14, 0.5174, 0.4381 },
	{ "7.5YR", 7, 16, 0.5319, 0.4449 },
	{ "7.5YR", 7, 18, 0.5417, 0.4492 },
	{ "10YR", 7, 2, 0.3443, 0.3454 },
	{ "10YR", 7, 4, 0.3778, 0.3719 },
	{ "10YR", 7, 6, 0.4102, 0.396 },
	{ "10YR", 7, 8, 0.4399, 0.4164 },
	{ "10YR", 7, 10, 0.4667, 0.4335 },
	{ "10YR", 7, 12, 0.49, 0.448 },
	{ "10YR", 7, 14, 0.5074, 0.4581 },
	{ "10YR", 7, 16, 0.5188, 0.465 },
	{ "10YR", 7, 18, 0.5276, 0.47 },
	{ "2.5Y", 7, 2, 0.3436, 0.3507 },
	{ "2.5Y", 7, 4, 0.3761, 0.38 },
	{ "2.5Y", 7, 6, 0.4073, 0.4073 },
	{ "2.5Y", 7, 8, 0.4353, 0.4312 },
	{ "2.5Y", 7, 10, 0.4606, 0.4516 },
	{ "2.5Y", 7, 12, 0.4806, 0.4666 },
	{ "2.5Y", 7, 14, 0.495, 0.4773 },
	{ "2.5Y", 7, 16, 0.5049, 0.4843 },
	{ "5Y", 7, 2, 0.3419, 0.354 },
	{ "5Y", 7, 4, 0.3718, 0.3885 },
	{ "5Y", 7, 6, 0.4009, 0.4198 },
	{ "5Y", 7, 8, 0.4271, 0.4462 },
	{ "5Y", 7, 10, 0.4509, 0.4696 },
	{ "5Y", 7, 12, 0.4677, 0.4857 },
	{ "5Y", 7, 14, 0.4791, 0.4965 },
	{ "5Y", 7, 16, 0.4875, 0.5047 },
	{ "7.5Y", 7, 2, 0.3396, 0.3558 },
	{ "7.5Y", 7, 4, 0.3677, 0.3925 },
	{ "7.5Y", 7, 6, 0.3943, 0.4264 },
	{ "7.5Y", 7, 8, 0.4184, 0.4568 },
	{ "7.5Y", 7, 10, 0.44, 0.483 },
	{ "7.5Y", 7, 12, 0.4547, 0.5005 },
	{ "7.5Y", 7, 14, 0.4652, 0.5128 },
	{ "7.5Y", 7, 16, 0.4728, 0.5215 },
	{ "10Y", 7, 2, 0.3369, 0.3569 },
	{ "10Y", 7, 4, 0.3624, 0.3951 },
	{ "10Y", 7, 6, 0.3864, 0.4305 },
	{ "10Y", 7, 8, 0.409, 0.4641 },
	{ "10Y", 7, 10, 0.4289, 0.4937 },
	{ "10Y", 7, 12, 0.442, 0.5131 },
	{ "10Y", 7, 14, 0.4516, 0.5277 },
	{ "10Y", 7, 16, 0.4582, 0.5375 },
	{ "2.5GY", 7, 2, 0.3328, 0.3569 },
	{ "2.5GY", 7, 4, 0.3534, 0.3953 },
	{ "2.5GY", 7, 6, 0.3728, 0.4316 },
	{ "2.5GY", 7, 8, 0.3919, 0.4684 },
	{ "2.5GY", 7, 10, 0.4091, 0.503 },
	{ "2.5GY", 7, 12, 0.4213, 0.527 },
	{ "2.5GY", 7, 14, 0.4309, 0.5459 },
	{ "2.5GY", 7, 16, 0.4366, 0.5578 },
	{ "5GY", 7, 2, 0.3284, 0.3559 },
	{ "5GY", 7, 4, 0.3437, 0.3929 },
	{ "5GY", 7, 6, 0.3581, 0.4291 },
	{ "5GY", 7, 8, 0.3722, 0.4669 },
	{ "5GY", 7, 10, 0.3852, 0.5051 },
	{ "5GY", 7, 12, 0.3949, 0.5367 },
	{ "5GY", 7, 14, 0.4027, 0.5615 },
	{ "5GY", 7, 16, 0.4076, 0.5783 },
	{ "7.5GY", 7, 2, 0.319, 0.3516 },
	{ "7.5GY", 7, 4, 0.3267, 0.3848 },
	{ "7.5GY", 7, 6, 0.3341, 0.4191 },
	{ "7.5GY", 7, 8, 0.3406, 0.4558 },
	{ "7.5GY", 7, 10, 0.3461, 0.495 },
	{ "7.5GY", 7, 12, 0.3502, 0.5328 },
	{ "7.5GY", 7, 14, 0.3532, 0.57 },
	{ "7.5GY", 7, 16, 0.3549, 0.6 },
	{ "7.5GY", 7, 18, 0.3555, 0.6242 },
	{ "10GY", 7, 2, 0.3117, 0.3469 },
	{ "10GY", 7, 4, 0.3133, 0.3764 },
	{ "10GY", 7, 6, 0.3142, 0.4058 },
	{ "10GY", 7, 8, 0.314, 0.4387 },
	{ "10GY", 7, 10, 0.3123, 0.4732 },
	{ "10GY", 7, 12, 0.3092, 0.5095 },
	{ "10GY", 7, 14, 0.3047, 0.5458 },
	{ "10GY", 7, 16, 0.2981, 0.5835 },
	{ "10GY", 7, 18, 0.2905, 0.6186 },
	{ "10GY", 7, 20, 0.2816, 0.6563 },
	{ "10GY", 7, 22, 0.2728, 0.6893 },
	{ "2.5G", 7, 2, 0.3047, 0.3413 },
	{ "2.5G", 7, 4, 0.2992, 0.3644 },
	{ "2.5G", 7, 6, 0.2933, 0.3873 },
	{ "2.5G", 7, 8, 0.2861, 0.4129 },
	{ "2.5G", 7, 10, 0.2775, 0.4395 },
	{ "2.5G", 7, 12, 0.2672, 0.4667 },
	{ "2.5G", 7, 14, 0.2568, 0.4931 },
	{ "2.5G", 7, 16, 0.2448, 0.5203 },
	{ "2.5G", 7, 18, 0.2328, 0.5467 },
	{ "2.5G", 7, 20, 0.2181, 0.5744 },
	{ "2.5G", 7, 22, 0.2029, 0.6017 },
	{ "2.5G", 7, 24, 0.1875, 0.6265 },
	{ "2.5G", 7, 26, 0.1689, 0.6549 },
	{ "5G", 7, 2, 0.3001, 0.3366 },
	{ "5G", 7, 4, 0.2902, 0.3548 },
	{ "5G", 7, 6, 0.2801, 0.3721 },
	{ "5G", 7, 8, 0.2687, 0.3901 },
	{ "5G", 7, 10, 0.2554, 0.4087 },
	{ "5G", 7, 12, 0.2416, 0.4267 },
	{ "5G", 7, 14, 0.2262, 0.445 },
	{ "5G", 7, 16, 0.2111, 0.4616 },
	{ "5G", 7, 18, 0.1967, 0.4771 },
	{ "5G", 7, 20, 0.1805, 0.4933 },
	{ "5G", 7, 22, 0.1659, 0.5074 },
	{ "5G", 7, 24, 0.1521, 0.52 },
	{ "5G", 7, 26, 0.1397, 0.5312 },
	{ "7.5G", 7, 2, 0.2972, 0.3333 },
	{ "7.5G", 7, 4, 0.285, 0.3482 },
	{ "7.5G", 7, 6, 0.2728, 0.3622 },
	{ "7.5G", 7, 8, 0.2595, 0.3764 },
	{ "7.5G", 7, 10, 0.2445, 0.3914 },
	{ "7.5G", 7, 12, 0.2295, 0.4058 },
	{ "7.5G", 7, 14, 0.2139, 0.4199 },
	{ "7.5G", 7, 16, 0.1982, 0.433 },
	{ "7.5G", 7, 18, 0.1841, 0.4448 },
	{ "7.5G", 7, 20, 0.1688, 0.457 },
	{ "7.5G", 7, 22, 0.1539, 0.4683 },
	{ "7.5G", 7, 24, 0.1415, 0.4778 },
	{ "7.5G", 7, 26, 0.1303, 0.4858 },
	{ "10G", 7, 2, 0.2945, 0.3297 },
	{ "10G", 7, 4, 0.2803, 0.3415 },
	{ "10G", 7, 6, 0.2662, 0.3526 },
	{ "10G", 7, 8, 0.2513, 0.3635 },
	{ "10G", 7, 10, 0.2352, 0.3748 },
	{ "10G", 7, 12, 0.2195, 0.3854 },
	{ "10G", 7, 14, 0.2033, 0.3956 },
	{ "10G", 7, 16, 0.1881, 0.4049 },
	{ "10G", 7, 18, 0.1734, 0.4135 },
	{ "10G", 7, 20, 0.1589, 0.422 },
	{ "10G", 7, 22, 0.1434, 0.4306 },
	{ "10G", 7, 24, 0.131, 0.4377 },
	{ "2.5BG", 7, 2, 0.2927, 0.3269 },
	{ "2.5BG", 7, 4, 0.2764, 0.3354 },
	{ "2.5BG", 7, 6, 0.2608, 0.343 },
	{ "2.5BG", 7, 8, 0.2439, 0.3508 },
	{ "2.5BG", 7, 10, 0.2264, 0.3576 },
	{ "2.5BG", 7, 12, 0.2102, 0.3636 },
	{ "2.5BG", 7, 14, 0.1932, 0.3694 },
	{ "2.5BG", 7, 16, 0.1788, 0.3739 },
	{ "2.5BG", 7, 18, 0.1626, 0.3788 },
	{ "2.5BG", 7, 20, 0.149, 0.3827 },
	{ "2.5BG", 7, 22, 0.1334, 0.387 },
	{ "5BG", 7, 2, 0.2898, 0.3225 },
	{ "5BG", 7, 4, 0.2712, 0.3269 },
	{ "5BG", 7, 6, 0.2543, 0.3302 },
	{ "5BG", 7, 8, 0.2354, 0.3335 },
	{ "5BG", 7, 10, 0.2163, 0.3361 },
	{ "5BG", 7, 12, 0.1997, 0.3379 },
	{ "5BG", 7, 14, 0.1838, 0.339 },
	{ "5BG", 7, 16, 0.1675, 0.3401 },
	{ "5BG", 7, 18, 0.1515, 0.341 },
	{ "5BG", 7, 20, 0.138, 0.3412 },
	{ "7.5BG", 7, 2, 0.2878, 0.3182 },
	{ "7.5BG", 7, 4, 0.2671, 0.3189 },
	{ "7.5BG", 7, 6, 0.249, 0.3186 },
	{ "7.5BG", 7, 8, 0.2292, 0.3178 },
	{ "7.5BG", 7, 10, 0.2094, 0.3165 },
	{ "7.5BG", 7, 12, 0.1914, 0.3148 },
	{ "7.5BG", 7, 14, 0.1751, 0.3129 },
	{ "7.5BG", 7, 16, 0.1584, 0.3101 },
	{ "7.5BG", 7, 18, 0.1427, 0.3076 },
	{ "10BG", 7, 2, 0.2869, 0.3143 },
	{ "10BG", 7, 4, 0.2642, 0.3109 },
	{ "10BG", 7, 6, 0.2448, 0.3069 },
	{ "10BG", 7, 8, 0.2235, 0.3014 },
	{ "10BG", 7, 10, 0.2035, 0.2956 },
	{ "10BG", 7, 12, 0.1841, 0.2892 },
	{ "10BG", 7, 14, 0.1671, 0.2832 },
	{ "10BG", 7, 16, 0.1489, 0.2768 },
	{ "2.5B", 7, 2, 0.2867, 0.311 },
	{ "2.5B", 7, 4, 0.2629, 0.3038 },
	{ "2.5B", 7, 6, 0.2418, 0.296 },
	{ "2.5B", 7, 8, 0.2208, 0.2871 },
	{ "2.5B", 7, 10, 0.1994, 0.2775 },
	{ "2.5B", 7, 12, 0.1797, 0.2672 },
	{ "2.5B", 7, 14, 0.1624, 0.2581 },
	{ "2.5B", 7, 16, 0.1435, 0.2472 },
	{ "5B", 7, 2, 0.2875, 0.3078 },
	{ "5B", 7, 4, 0.2633, 0.2972 },
	{ "5B", 7, 6, 0.241, 0.2854 },
	{ "5B", 7, 8, 0.2204, 0.2729 },
	{ "5B", 7, 10, 0.1986, 0.2579 },
	{ "5B", 7, 12, 0.1778, 0.243 },
	{ "5B", 7, 14, 0.1615, 0.2307 },
	{ "7.5B", 7, 2, 0.2888, 0.3058 },
	{ "7.5B", 7, 4, 0.2651, 0.2927 },
	{ "7.5B", 7, 6, 0.2436, 0.2787 },
	{ "7.5B", 7, 8, 0.2225, 0.2631 },
	{ "7.5B", 7, 10, 0.2016, 0.2466 },
	{ "7.5B", 7, 12, 0.1818, 0.2303 },
	{ "10B", 7, 2, 0.2908, 0.3039 },
	{ "10B", 7, 4, 0.2685, 0.2886 },
	{ "10B", 7, 6, 0.2478, 0.2728 },
	{ "10B", 7, 8, 0.2277, 0.2559 },
	{ "10B", 7, 10, 0.2078, 0.2382 },
	{ "10B", 7, 12, 0.1883, 0.2203 },
	{ "2.5PB", 7, 2, 0.2932, 0.3025 },
	{ "2.5PB", 7, 4, 0.2729, 0.2848 },
	{ "2.5PB", 7, 6, 0.2538, 0.2677 },
	{ "2.5PB", 7, 8, 0.2352, 0.2498 },
	{ "2.5PB", 7, 10, 0.2162, 0.2309 },
	{ "5PB", 7, 2, 0.2952, 0.3011 },
	{ "5PB", 7, 4, 0.2773, 0.2828 },
	{ "5PB", 7, 6, 0.2596, 0.2643 },
	{ "5PB", 7, 8, 0.2427, 0.2458 },
	{ "5PB", 7, 10, 0.2254, 0.2267 },
	{ "7.5PB", 7, 2, 0.2982, 0.3003 },
	{ "7.5PB", 7, 4, 0.2833, 0.2809 },
	{ "7.5PB", 7, 6, 0.2687, 0.2612 },
	{ "7.5PB", 7, 8, 0.2546, 0.2418 },
	{ "7.5PB", 7, 10, 0.241, 0.2224 },
	{ "10PB", 7, 2, 0.3005, 0.3 },
	{ "10PB", 7, 4, 0.2886, 0.2801 },
	{ "10PB", 7, 6, 0.2776, 0.2612 },
	{ "10PB", 7, 8, 0.267, 0.2425 },
	{ "10PB", 7, 10, 0.2563, 0.224 },
	{ "10PB", 7, 12, 0.2465, 0.2058 },
	{ "2.5P", 7, 2, 0.3031, 0.3 },
	{ "2.5P", 7, 4, 0.295, 0.281 },
	{ "2.5P", 7, 6, 0.2873, 0.2633 },
	{ "2.5P", 7, 8, 0.2799, 0.2459 },
	{ "2.5P", 7, 10, 0.2729, 0.2289 },
	{ "2.5P", 7, 12, 0.2664, 0.2127 },
	{ "5P", 7, 2, 0.3059, 0.301 },
	{ "5P", 7, 4, 0.3009, 0.2831 },
	{ "5P", 7, 6, 0.2961, 0.2663 },
	{ "5P", 7, 8, 0.2918, 0.2504 },
	{ "5P", 7, 10, 0.2872, 0.2343 },
	{ "5P", 7, 12, 0.2833, 0.2197 },
	{ "5P", 7, 14, 0.2801, 0.2068 },
	{ "7.5P", 7, 2, 0.3109, 0.3037 },
	{ "7.5P", 7, 4, 0.3111, 0.288 },
	{ "7.5P", 7, 6, 0.3111, 0.273 },
	{ "7.5P", 7, 8, 0.3109, 0.2584 },
	{ "7.5P", 7, 10, 0.3108, 0.2442 },
	{ "7.5P", 7, 12, 0.3104, 0.232 },
	{ "7.5P", 7, 14, 0.3101, 0.2192 },
	{ "7.5P", 7, 16, 0.3099, 0.2074 },
	{ "7.5P", 7, 18, 0.3093, 0.1962 },
	{ "10P", 7, 2, 0.3138, 0.3054 },
	{ "10P", 7, 4, 0.3181, 0.292 },
	{ "10P", 7, 6, 0.3221, 0.2786 },
	{ "10P", 7, 8, 0.3256, 0.2654 },
	{ "10P", 7, 10, 0.3288, 0.2531 },
	{ "10P", 7, 12, 0.3314, 0.2423 },
	{ "10P", 7, 14, 0.3341, 0.2308 },
	{ "10P", 7, 16, 0.3368, 0.2192 },
	{ "10P", 7, 18, 0.3391, 0.2088 },
	{ "10P", 7, 20, 0.341, 0.1988 },
	{ "10P", 7, 22, 0.343, 0.1883 },
	{ "2.5RP", 7, 2, 0.317, 0.3076 },
	{ "2.5RP", 7, 4, 0.3254, 0.2971 },
	{ "2.5RP", 7, 6, 0.3338, 0.2854 },
	{ "2.5RP", 7, 8, 0.3417, 0.2745 },
	{ "2.5RP", 7, 10, 0.3487, 0.2648 },
	{ "2.5RP", 7, 12, 0.3555, 0.2545 },
	{ "2.5RP", 7, 14, 0.362, 0.2448 },
	{ "2.5RP", 7, 16, 0.3688, 0.2342 },
	{ "2.5RP", 7, 18, 0.3751, 0.2241 },
	{ "2.5RP", 7, 20, 0.3811, 0.2143 },
	{ "5RP", 7, 2, 0.3206, 0.3104 },
	{ "5RP", 7, 4, 0.3332, 0.3032 },
	{ "5RP", 7, 6, 0.347, 0.2949 },
	{ "5RP", 7, 8, 0.3603, 0.2869 },
	{ "5RP", 7, 10, 0.3713, 0.2798 },
	{ "5RP", 7, 12, 0.3841, 0.271 },
	{ "5RP", 7, 14, 0.3958, 0.2628 },
	{ "5RP", 7, 16, 0.4076, 0.254 },
	{ "5RP", 7, 18, 0.4186, 0.2459 },
	{ "7.5RP", 7, 2, 0.3232, 0.3125 },
	{ "7.5RP", 7, 4, 0.3389, 0.3079 },
	{ "7.5RP", 7, 6, 0.3562, 0.3022 },
	{ "7.5RP", 7, 8, 0.3722, 0.2963 },
	{ "7.5RP", 7, 10, 0.3871, 0.2906 },
	{ "7.5RP", 7, 12, 0.404, 0.2834 },
	{ "7.5RP", 7, 14, 0.4195, 0.2762 },
	{ "7.5RP", 7, 16, 0.4346, 0.2689 },
	{ "10RP", 8, 2, 0.3218, 0.3152 },
	{ "10RP", 8, 4, 0.3412, 0.3135 },
	{ "10RP", 8, 6, 0.36, 0.3112 },
	{ "10RP", 8, 8, 0.38, 0.3082 },
	{ "10RP", 8, 10, 0.3983, 0.3049 },
	{ "2.5R", 8, 2, 0.3236, 0.3169 },
	{ "2.5R", 8, 4, 0.346, 0.3177 },
	{ "2.5R", 8, 6, 0.3671, 0.3175 },
	{ "2.5R", 8, 8, 0.39, 0.3171 },
	{ "2.5R", 8, 10, 0.4125, 0.316 },
	{ "5R", 8, 2, 0.3254, 0.3186 },
	{ "5R", 8, 4, 0.351, 0.3224 },
	{ "5R", 8, 6, 0.3743, 0.3248 },
	{ "5R", 8, 8, 0.4001, 0.3263 },
	{ "5R", 8, 10, 0.4249, 0.327 },
	{ "7.5R", 8, 2, 0.3277, 0.3211 },
	{ "7.5R", 8, 4, 0.3564, 0.3279 },
	{ "7.5R", 8, 6, 0.383, 0.3335 },
	{ "7.5R", 8, 8, 0.4118, 0.3385 },
	{ "7.5R", 8, 10, 0.4388, 0.3419 },
	{ "10R", 8, 2, 0.3301, 0.3237 },
	{ "10R", 8, 4, 0.3621, 0.3349 },
	{ "10R", 8, 6, 0.391, 0.3442 },
	{ "10R", 8, 8, 0.4212, 0.3526 },
	{ "10R", 8, 10, 0.449, 0.3589 },
	{ "2.5YR", 8, 2, 0.3334, 0.3276 },
	{ "2.5YR", 8, 4, 0.3667, 0.3429 },
	{ "2.5YR", 8, 6, 0.396, 0.3547 },
	{ "2.5YR", 8, 8, 0.4275, 0.3662 },
	{ "2.5YR", 8, 10, 0.4552, 0.3761 },
	{ "2.5YR", 8, 12, 0.4852, 0.3847 },
	{ "5YR", 8, 2, 0.3373, 0.333 },
	{ "5YR", 8, 4, 0.369, 0.351 },
	{ "5YR", 8, 6, 0.3988, 0.3663 },
	{ "5YR", 8, 8, 0.431, 0.382 },
	{ "5YR", 8, 10, 0.4576, 0.3938 },
	{ "5YR", 8, 12, 0.4849, 0.405 },
	{ "5YR", 8, 14, 0.5088, 0.4145 },
	{ "7.5YR", 8, 2, 0.3395, 0.3379 },
	{ "7.5YR", 8, 4, 0.3699, 0.3586 },
	{ "7.5YR", 8, 6, 0.4, 0.377 },
	{ "7.5YR", 8, 8, 0.4306, 0.3952 },
	{ "7.5YR", 8, 10, 0.4568, 0.41 },
	{ "7.5YR", 8, 12, 0.4816, 0.4232 },
	{ "7.5YR", 8, 14, 0.5025, 0.4338 },
	{ "7.5YR", 8, 16, 0.5195, 0.4424 },
	{ "7.5YR", 8, 18, 0.5316, 0.448 },
	{ "7.5YR", 8, 20, 0.5391, 0.4518 },
	{ "10YR", 8, 2, 0.3407, 0.3434 },
	{ "10YR", 8, 4, 0.3701, 0.3674 },
	{ "10YR", 8, 6, 0.3994, 0.3896 },
	{ "10YR", 8, 8, 0.428, 0.4102 },
	{ "10YR", 8, 10, 0.4527, 0.4268 },
	{ "10YR", 8, 12, 0.4753, 0.4414 },
	{ "10YR", 8, 14, 0.494, 0.453 },
	{ "10YR", 8, 16, 0.5079, 0.4613 },
	{ "10YR", 8, 18, 0.5179, 0.467 },
	{ "10YR", 8, 20, 0.5245, 0.4709 },
	{ "2.5Y", 8, 2, 0.3406, 0.3484 },
	{ "2.5Y", 8, 4, 0.3684, 0.3751 },
	{ "2.5Y", 8, 6, 0.3969, 0.4009 },
	{ "2.5Y", 8, 8, 0.4231, 0.4231 },
	{ "2.5Y", 8, 10, 0.4469, 0.4423 },
	{ "2.5Y", 8, 12, 0.4678, 0.4589 },
	{ "2.5Y", 8, 14, 0.4842, 0.4712 },
	{ "2.5Y", 8, 16, 0.4957, 0.48 },
	{ "2.5Y", 8, 18, 0.5033, 0.4855 },
	{ "2.5Y", 8, 20, 0.5091, 0.49 },
	{ "5Y", 8, 2, 0.3394, 0.3518 },
	{ "5Y", 8, 4, 0.365, 0.3826 },
	{ "5Y", 8, 6, 0.3913, 0.4117 },
	{ "5Y", 8, 8, 0.4158, 0.4378 },
	{ "5Y", 8, 10, 0.4376, 0.4601 },
	{ "5Y", 8, 12, 0.4562, 0.4788 },
	{ "5Y", 8, 14, 0.4699, 0.492 },
	{ "5Y", 8, 16, 0.4791, 0.5012 },
	{ "5Y", 8, 18, 0.4847, 0.5069 },
	{ "7.5Y", 8, 2, 0.3379, 0.354 },
	{ "7.5Y", 8, 4, 0.3622, 0.3861 },
	{ "7.5Y", 8, 6, 0.3862, 0.4175 },
	{ "7.5Y", 8, 8, 0.4088, 0.4466 },
	{ "7.5Y", 8, 10, 0.4283, 0.4712 },
	{ "7.5Y", 8, 12, 0.4455, 0.4917 },
	{ "7.5Y", 8, 14, 0.4574, 0.5062 },
	{ "7.5Y", 8, 16, 0.4658, 0.5158 },
	{ "7.5Y", 8, 18, 0.4709, 0.522 },
	{ "10Y", 8, 2, 0.3359, 0.3552 },
	{ "10Y", 8, 4, 0.3581, 0.3883 },
	{ "10Y", 8, 6, 0.3803, 0.4216 },
	{ "10Y", 8, 8, 0.4008, 0.452 },
	{ "10Y", 8, 10, 0.419, 0.4791 },
	{ "10Y", 8, 12, 0.4341, 0.502 },
	{ "10Y", 8, 14, 0.445, 0.5181 },
	{ "10Y", 8, 16, 0.4525, 0.5295 },
	{ "10Y", 8, 18, 0.457, 0.5366 },
	{ "2.5GY", 8, 2, 0.3327, 0.3555 },
	{ "2.5GY", 8, 4, 0.3504, 0.3887 },
	{ "2.5GY", 8, 6, 0.369, 0.423 },
	{ "2.5GY", 8, 8, 0.3858, 0.455 },
	{ "2.5GY", 8, 10, 0.4021, 0.4869 },
	{ "2.5GY", 8, 12, 0.4154, 0.5133 },
	{ "2.5GY", 8, 14, 0.4261, 0.5344 },
	{ "2.5GY", 8, 16, 0.4327, 0.5475 },
	{ "2.5GY", 8, 18, 0.4371, 0.5557 },
	{ "5GY", 8, 2, 0.3284, 0.3542 },
	{ "5GY", 8, 4, 0.3433, 0.3872 },
	{ "5GY", 8, 6, 0.3573, 0.4214 },
	{ "5GY", 8, 8, 0.3696, 0.4542 },
	{ "5GY", 8, 10, 0.3816, 0.4879 },
	{ "5GY", 8, 12, 0.3924, 0.5199 },
	{ "5GY", 8, 14, 0.4011, 0.5468 },
	{ "5GY", 8, 16, 0.4061, 0.5641 },
	{ "5GY", 8, 18, 0.4104, 0.5785 },
	{ "5GY", 8, 20, 0.4127, 0.5855 },
	{ "7.5GY", 8, 2, 0.3194, 0.3502 },
	{ "7.5GY", 8, 4, 0.3266, 0.3809 },
	{ "7.5GY", 8, 6, 0.3339, 0.4129 },
	{ "7.5GY", 8, 8, 0.3408, 0.4452 },
	{ "7.5GY", 8, 10, 0.3463, 0.4791 },
	{ "7.5GY", 8, 12, 0.3511, 0.5144 },
	{ "7.5GY", 8, 14, 0.3546, 0.549 },
	{ "7.5GY", 8, 16, 0.3569, 0.5798 },
	{ "7.5GY", 8, 18, 0.3585, 0.6063 },
	{ "7.5GY", 8, 20, 0.3592, 0.6235 },
	{ "10GY", 8, 2, 0.3121, 0.3459 },
	{ "10GY", 8, 4, 0.314, 0.3727 },
	{ "10GY", 8, 6, 0.315, 0.4014 },
	{ "10GY", 8, 8, 0.3149, 0.4284 },
	{ "10GY", 8, 10, 0.314, 0.4601 },
	{ "10GY", 8, 12, 0.3124, 0.4926 },
	{ "10GY", 8, 14, 0.3091, 0.5247 },
	{ "10GY", 8, 16, 0.3043, 0.5578 },
	{ "10GY", 8, 18, 0.2987, 0.5919 },
	{ "10GY", 8, 20, 0.2918, 0.6255 },
	{ "10GY", 8, 22, 0.2846, 0.6564 },
	{ "10GY", 8, 24, 0.2781, 0.684 },
	{ "2.5G", 8, 2, 0.3053, 0.3404 },
	{ "2.5G", 8, 4, 0.3009, 0.3614 },
	{ "2.5G", 8, 6, 0.2952, 0.3851 },
	{ "2.5G", 8, 8, 0.2896, 0.4065 },
	{ "2.5G", 8, 10, 0.2829, 0.4301 },
	{ "2.5G", 8, 12, 0.2743, 0.4554 },
	{ "2.5G", 8, 14, 0.2661, 0.478 },
	{ "2.5G", 8, 16, 0.2563, 0.5045 },
	{ "2.5G", 8, 18, 0.2451, 0.5309 },
	{ "2.5G", 8, 20, 0.2339, 0.5561 },
	{ "2.5G", 8, 22, 0.2221, 0.5799 },
	{ "2.5G", 8, 24, 0.2091, 0.6033 },
	{ "5G", 8, 2, 0.3009, 0.3359 },
	{ "5G", 8, 4, 0.2924, 0.3523 },
	{ "5G", 8, 6, 0.2822, 0.3702 },
	{ "5G", 8, 8, 0.2723, 0.3865 },
	{ "5G", 8, 10, 0.2613, 0.4026 },
	{ "5G", 8, 12, 0.2489, 0.4191 },
	{ "5G", 8, 14, 0.2368, 0.4348 },
	{ "5G", 8, 16, 0.224, 0.45 },
	{ "5G", 8, 18, 0.2103, 0.4652 },
	{ "5G", 8, 20, 0.1956, 0.4806 },
	{ "5G", 8, 22, 0.1821, 0.494 },
	{ "7.5G", 8, 2, 0.2981, 0.3326 },
	{ "7.5G", 8, 4, 0.2874, 0.3464 },
	{ "7.5G", 8, 6, 0.2754, 0.3608 },
	{ "7.5G", 8, 8, 0.2639, 0.3733 },
	{ "7.5G", 8, 10, 0.2515, 0.3867 },
	{ "7.5G", 8, 12, 0.238, 0.4002 },
	{ "7.5G", 8, 14, 0.2254, 0.4125 },
	{ "7.5G", 8, 16, 0.212, 0.4252 },
	{ "7.5G", 8, 18, 0.198, 0.4372 },
	{ "7.5G", 8, 20, 0.1845, 0.4492 },
	{ "10G", 8, 2, 0.2957, 0.3293 },
	{ "10G", 8, 4, 0.2828, 0.3403 },
	{ "10G", 8, 6, 0.2693, 0.3512 },
	{ "10G", 8, 8, 0.2564, 0.3611 },
	{ "10G", 8, 10, 0.243, 0.371 },
	{ "10G", 8, 12, 0.2282, 0.3811 },
	{ "10G", 8, 14, 0.2148, 0.3903 },
	{ "10G", 8, 16, 0.2012, 0.3992 },
	{ "10G", 8, 18, 0.1866, 0.4086 },
	{ "10G", 8, 20, 0.1734, 0.4164 },
	{ "2.5BG", 8, 2, 0.294, 0.3268 },
	{ "2.5BG", 8, 4, 0.2791, 0.3351 },
	{ "2.5BG", 8, 6, 0.2647, 0.3429 },
	{ "2.5BG", 8, 8, 0.25, 0.35 },
	{ "2.5BG", 8, 10, 0.2352, 0.3566 },
	{ "2.5BG", 8, 12, 0.2196, 0.363 },
	{ "2.5BG", 8, 14, 0.2057, 0.3681 },
	{ "2.5BG", 8, 16, 0.1915, 0.3732 },
	{ "2.5BG", 8, 18, 0.1759, 0.3782 },
	{ "5BG", 8, 2, 0.2919, 0.3228 },
	{ "5BG", 8, 4, 0.2752, 0.3278 },
	{ "5BG", 8, 6, 0.2588, 0.3318 },
	{ "5BG", 8, 8, 0.2419, 0.3352 },
	{ "5BG", 8, 10, 0.2264, 0.3383 },
	{ "5BG", 8, 12, 0.2101, 0.3412 },
	{ "5BG", 8, 14, 0.1958, 0.3432 },
	{ "5BG", 8, 16, 0.1814, 0.345 },
	{ "7.5BG", 8, 2, 0.29, 0.3183 },
	{ "7.5BG", 8, 4, 0.2718, 0.32 },
	{ "7.5BG", 8, 6, 0.2525, 0.3198 },
	{ "7.5BG", 8, 8, 0.2352, 0.3198 },
	{ "7.5BG", 8, 10, 0.2184, 0.3196 },
	{ "7.5BG", 8, 12, 0.201, 0.3188 },
	{ "7.5BG", 8, 14, 0.1868, 0.3179 },
	{ "7.5BG", 8, 16, 0.1721, 0.3168 },
	{ "10BG", 8, 2, 0.2894, 0.3152 },
	{ "10BG", 8, 4, 0.2686, 0.313 },
	{ "10BG", 8, 6, 0.2489, 0.3099 },
	{ "10BG", 8, 8, 0.2302, 0.3063 },
	{ "10BG", 8, 10, 0.212, 0.3025 },
	{ "10BG", 8, 12, 0.1937, 0.2978 },
	{ "10BG", 8, 14, 0.1788, 0.2936 },
	{ "2.5B", 8, 2, 0.2897, 0.3124 },
	{ "2.5B", 8, 4, 0.2668, 0.3067 },
	{ "2.5B", 8, 6, 0.2462, 0.3 },
	{ "2.5B", 8, 8, 0.2264, 0.2923 },
	{ "2.5B", 8, 10, 0.2066, 0.2839 },
	{ "2.5B", 8, 12, 0.1877, 0.2752 },
	{ "5B", 8, 2, 0.2908, 0.3096 },
	{ "5B", 8, 4, 0.2671, 0.2998 },
	{ "5B", 8, 6, 0.2457, 0.2888 },
	{ "5B", 8, 8, 0.2237, 0.2761 },
	{ "7.5B", 8, 2, 0.2922, 0.3077 },
	{ "7.5B", 8, 4, 0.2688, 0.2956 },
	{ "7.5B", 8, 6, 0.2472, 0.2821 },
	{ "7.5B", 8, 8, 0.2252, 0.2668 },
	{ "10B", 8, 2, 0.2935, 0.3062 },
	{ "10B", 8, 4, 0.2718, 0.2911 },
	{ "10B", 8, 6, 0.2512, 0.276 },
	{ "10B", 8, 8, 0.2294, 0.2587 },
	{ "2.5PB", 8, 2, 0.2957, 0.3047 },
	{ "2.5PB", 8, 4, 0.2758, 0.2879 },
	{ "2.5PB", 8, 6, 0.2562, 0.2709 },
	{ "5PB", 8, 2, 0.2974, 0.3039 },
	{ "5PB", 8, 4, 0.2798, 0.2861 },
	{ "5PB", 8, 6, 0.2614, 0.267 },
	{ "7.5PB", 8, 2, 0.3003, 0.3034 },
	{ "7.5PB", 8, 4, 0.2856, 0.2846 },
	{ "7.5PB", 8, 6, 0.2702, 0.2648 },
	{ "10PB", 8, 2, 0.3027, 0.3035 },
	{ "10PB", 8, 4, 0.2911, 0.2848 },
	{ "10PB", 8, 6, 0.2792, 0.2649 },
	{ "10PB", 8, 8, 0.2677, 0.2443 },
	{ "2.5P", 8, 2, 0.3048, 0.304 },
	{ "2.5P", 8, 4, 0.2962, 0.285 },
	{ "2.5P", 8, 6, 0.2881, 0.2671 },
	{ "2.5P", 8, 8, 0.28, 0.2488 },
	{ "5P", 8, 2, 0.3065, 0.3047 },
	{ "5P", 8, 4, 0.3012, 0.2868 },
	{ "5P", 8, 6, 0.2963, 0.2704 },
	{ "5P", 8, 8, 0.2914, 0.2534 },
	{ "5P", 8, 10, 0.287, 0.238 },
	{ "7.5P", 8, 2, 0.3107, 0.307 },
	{ "7.5P", 8, 4, 0.3114, 0.2915 },
	{ "7.5P", 8, 6, 0.3114, 0.2785 },
	{ "7.5P", 8, 8, 0.3116, 0.2626 },
	{ "7.5P", 8, 10, 0.3116, 0.2497 },
	{ "7.5P", 8, 12, 0.3117, 0.237 },
	{ "10P", 8, 2, 0.3131, 0.3084 },
	{ "10P", 8, 4, 0.3175, 0.2955 },
	{ "10P", 8, 6, 0.3213, 0.2829 },
	{ "10P", 8, 8, 0.325, 0.27 },
	{ "10P", 8, 10, 0.3282, 0.2582 },
	{ "10P", 8, 12, 0.3312, 0.247 },
	{ "10P", 8, 14, 0.3342, 0.2349 },
	{ "2.5RP", 8, 2, 0.3154, 0.31 },
	{ "2.5RP", 8, 4, 0.3239, 0.3 },
	{ "2.5RP", 8, 6, 0.3327, 0.2898 },
	{ "2.5RP", 8, 8, 0.3406, 0.2793 },
	{ "2.5RP", 8, 10, 0.3479, 0.2699 },
	{ "2.5RP", 8, 12, 0.3552, 0.2594 },
	{ "2.5RP", 8, 14, 0.3621, 0.2496 },
	{ "5RP", 8, 2, 0.318, 0.312 },
	{ "5RP", 8, 4, 0.3308, 0.3052 },
	{ "5RP", 8, 6, 0.344, 0.2978 },
	{ "5RP", 8, 8, 0.357, 0.29 },
	{ "5RP", 8, 10, 0.3685, 0.2828 },
	{ "5RP", 8, 12, 0.3818, 0.2742 },
	{ "7.5RP", 8, 2, 0.32, 0.3136 },
	{ "7.5RP", 8, 4, 0.336, 0.3092 },
	{ "7.5RP", 8, 6, 0.3521, 0.3042 },
	{ "7.5RP", 8, 8, 0.3682, 0.2983 },
	{ "7.5RP", 8, 10, 0.383, 0.293 },
	{ "7.5RP", 8, 12, 0.4002, 0.2859 },
	{ "10RP", 9, 2, 0.3205, 0.3155 },
	{ "10RP", 9, 4, 0.34, 0.314 },
	{ "10RP", 9, 6, 0.359, 0.3118 },
	{ "2.5R", 9, 2, 0.321, 0.3168 },
	{ "2.5R", 9, 4, 0.3445, 0.3179 },
	{ "2.5R", 9, 6, 0.3665, 0.3183 },
	{ "5R", 9, 2, 0.324, 0.3188 },
	{ "5R", 9, 4, 0.3495, 0.3226 },
	{ "5R", 9, 6, 0.3734, 0.3256 },
	{ "7.5R", 9, 2, 0.3263, 0.321 },
	{ "7.5R", 9, 4, 0.3551, 0.3283 },
	{ "7.5R", 9, 6, 0.3812, 0.3348 },
	{ "10R", 9, 2, 0.3284, 0.3233 },
	{ "10R", 9, 4, 0.36, 0.3348 },
	{ "10R", 9, 6, 0.388, 0.3439 },
	{ "2.5YR", 9, 2, 0.332, 0.3273 },
	{ "2.5YR", 9, 4, 0.3641, 0.3422 },
	{ "2.5YR", 9, 6, 0.3927, 0.355 },
	{ "5YR", 9, 2, 0.3353, 0.3325 },
	{ "5YR", 9, 4, 0.3668, 0.3509 },
	{ "5YR", 9, 6, 0.3948, 0.3659 },
	{ "7.5YR", 9, 2, 0.338, 0.3377 },
	{ "7.5YR", 9, 4, 0.3679, 0.3585 },
	{ "7.5YR", 9, 6, 0.395, 0.3763 },
	{ "7.5YR", 9, 8, 0.422, 0.393 },
	{ "10YR", 9, 2, 0.3392, 0.343 },
	{ "10YR", 9, 4, 0.3677, 0.3668 },
	{ "10YR", 9, 6, 0.3941, 0.3877 },
	{ "10YR", 9, 8, 0.4199, 0.4069 },
	{ "2.5Y", 9, 2, 0.339, 0.3472 },
	{ "2.5Y", 9, 4, 0.3655, 0.3738 },
	{ "2.5Y", 9, 6, 0.391, 0.3972 },
	{ "2.5Y", 9, 8, 0.4154, 0.4186 },
	{ "2.5Y", 9, 10, 0.437, 0.4369 },
	{ "2.5Y", 9, 12, 0.4569, 0.4527 },
	{ "5Y", 9, 2, 0.3378, 0.3504 },
	{ "5Y", 9, 4, 0.3621, 0.3799 },
	{ "5Y", 9, 6, 0.3858, 0.4071 },
	{ "5Y", 9, 8, 0.408, 0.4319 },
	{ "5Y", 9, 10, 0.4275, 0.4529 },
	{ "5Y", 9, 12, 0.4455, 0.4719 },
	{ "5Y", 9, 14, 0.4602, 0.4869 },
	{ "5Y", 9, 16, 0.4711, 0.4977 },
	{ "5Y", 9, 18, 0.4782, 0.5049 },
	{ "5Y", 9, 20, 0.483, 0.5092 },
	{ "7.5Y", 9, 2, 0.3365, 0.3527 },
	{ "7.5Y", 9, 4, 0.3591, 0.3832 },
	{ "7.5Y", 9, 6, 0.3811, 0.4123 },
	{ "7.5Y", 9, 8, 0.4019, 0.4392 },
	{ "7.5Y", 9, 10, 0.4201, 0.4622 },
	{ "7.5Y", 9, 12, 0.4369, 0.4829 },
	{ "7.5Y", 9, 14, 0.4503, 0.4993 },
	{ "7.5Y", 9, 16, 0.4595, 0.5104 },
	{ "7.5Y", 9, 18, 0.4663, 0.5188 },
	{ "10Y", 9, 2, 0.3349, 0.3537 },
	{ "10Y", 9, 4, 0.3558, 0.3852 },
	{ "10Y", 9, 6, 0.3761, 0.4155 },
	{ "10Y", 9, 8, 0.3957, 0.445 },
	{ "10Y", 9, 10, 0.412, 0.4694 },
	{ "10Y", 9, 12, 0.4271, 0.492 },
	{ "10Y", 9, 14, 0.4393, 0.5101 },
	{ "10Y", 9, 16, 0.4477, 0.5225 },
	{ "10Y", 9, 18, 0.454, 0.532 },
	{ "2.5GY", 9, 2, 0.3321, 0.3539 },
	{ "2.5GY", 9, 4, 0.3499, 0.3866 },
	{ "2.5GY", 9, 6, 0.367, 0.4178 },
	{ "2.5GY", 9, 8, 0.3834, 0.449 },
	{ "2.5GY", 9, 10, 0.3973, 0.4761 },
	{ "2.5GY", 9, 12, 0.4108, 0.5028 },
	{ "2.5GY", 9, 14, 0.4212, 0.5237 },
	{ "2.5GY", 9, 16, 0.4288, 0.5383 },
	{ "2.5GY", 9, 18, 0.4354, 0.5508 },
	{ "5GY", 9, 2, 0.3284, 0.3534 },
	{ "5GY", 9, 4, 0.3437, 0.3861 },
	{ "5GY", 9, 6, 0.3572, 0.4179 },
	{ "5GY", 9, 8, 0.3698, 0.4497 },
	{ "5GY", 9, 10, 0.381, 0.4791 },
	{ "5GY", 9, 12, 0.3911, 0.5082 },
	{ "5GY", 9, 14, 0.3993, 0.5329 },
	{ "5GY", 9, 16, 0.4058, 0.5541 },
	{ "5GY", 9, 18, 0.4108, 0.5699 },
	{ "7.5GY", 9, 2, 0.3198, 0.35 },
	{ "7.5GY", 9, 4, 0.3274, 0.3793 },
	{ "7.5GY", 9, 6, 0.3351, 0.4111 },
	{ "7.5GY", 9, 8, 0.3414, 0.4415 },
	{ "7.5GY", 9, 10, 0.3471, 0.4735 },
	{ "7.5GY", 9, 12, 0.3518, 0.5042 },
	{ "7.5GY", 9, 14, 0.3551, 0.5339 },
	{ "7.5GY", 9, 16, 0.3581, 0.5654 },
	{ "7.5GY", 9, 18, 0.3602, 0.592 },
	{ "10GY", 9, 2, 0.3124, 0.3454 },
	{ "10GY", 9, 4, 0.3144, 0.3711 },
	{ "10GY", 9, 6, 0.3153, 0.4008 },
	{ "10GY", 9, 8, 0.3157, 0.4259 },
	{ "10GY", 9, 10, 0.3155, 0.4558 },
	{ "10GY", 9, 12, 0.3139, 0.4829 },
	{ "10GY", 9, 14, 0.3115, 0.5129 },
	{ "10GY", 9, 16, 0.3079, 0.544 },
	{ "10GY", 9, 18, 0.3032, 0.5748 },
	{ "2.5G", 9, 2, 0.3058, 0.34 },
	{ "2.5G", 9, 4, 0.3018, 0.3606 },
	{ "2.5G", 9, 6, 0.2966, 0.3846 },
	{ "2.5G", 9, 8, 0.2912, 0.4054 },
	{ "2.5G", 9, 10, 0.2851, 0.4275 },
	{ "2.5G", 9, 12, 0.2786, 0.4491 },
	{ "2.5G", 9, 14, 0.2711, 0.4726 },
	{ "2.5G", 9, 16, 0.263, 0.4966 },
	{ "5G", 9, 2, 0.3017, 0.3357 },
	{ "5G", 9, 4, 0.2933, 0.3519 },
	{ "5G", 9, 6, 0.2832, 0.3697 },
	{ "5G", 9, 8, 0.2735, 0.3854 },
	{ "5G", 9, 10, 0.2639, 0.4001 },
	{ "5G", 9, 12, 0.2528, 0.416 },
	{ "7.5G", 9, 2, 0.2987, 0.3323 },
	{ "7.5G", 9, 4, 0.2882, 0.3461 },
	{ "7.5G", 9, 6, 0.2763, 0.3607 },
	{ "7.5G", 9, 8, 0.2652, 0.3738 },
	{ "7.5G", 9, 10, 0.2545, 0.3855 },
	{ "7.5G", 9, 12, 0.2419, 0.3985 },
	{ "10G", 9, 2, 0.2965, 0.3293 },
	{ "10G", 9, 4, 0.284, 0.3402 },
	{ "10G", 9, 6, 0.2703, 0.3513 },
	{ "10G", 9, 8, 0.2574, 0.3618 },
	{ "10G", 9, 10, 0.2457, 0.3702 },
	{ "10G", 9, 12, 0.2325, 0.3796 },
	{ "2.5BG", 9, 2, 0.2947, 0.3267 },
	{ "2.5BG", 9, 4, 0.2805, 0.3349 },
	{ "2.5BG", 9, 6, 0.2652, 0.3433 },
	{ "2.5BG", 9, 8, 0.2509, 0.3507 },
	{ "2.5BG", 9, 10, 0.2382, 0.3568 },
	{ "5BG", 9, 2, 0.293, 0.3232 },
	{ "5BG", 9, 4, 0.2768, 0.3287 },
	{ "5BG", 9, 6, 0.2599, 0.3338 },
	{ "5BG", 9, 8, 0.2437, 0.3378 },
	{ "5BG", 9, 10, 0.2301, 0.3405 },
	{ "7.5BG", 9, 2, 0.2911, 0.3188 },
	{ "7.5BG", 9, 4, 0.2728, 0.3208 },
	{ "7.5BG", 9, 6, 0.2543, 0.322 },
	{ "7.5BG", 9, 8, 0.2361, 0.3225 },
	{ "7.5BG", 9, 10, 0.2215, 0.3226 },
	{ "10BG", 9, 2, 0.2907, 0.3159 },
	{ "10BG", 9, 4, 0.27, 0.314 },
	{ "10BG", 9, 6, 0.2501, 0.3118 },
	{ "2.5B", 9, 2, 0.2909, 0.3125 },
	{ "2.5B", 9, 4, 0.268, 0.3073 },
	{ "5B", 9, 2, 0.2919, 0.3102 },
	{ "5B", 9, 4, 0.2675, 0.3005 },
	{ "7.5B", 9, 2, 0.2937, 0.3087 },
	{ "7.5B", 9, 4, 0.2688, 0.2961 },
	{ "10B", 9, 2, 0.2949, 0.3076 },
	{ "10B", 9, 4, 0.2712, 0.2924 },
	{ "2.5PB", 9, 2, 0.2975, 0.3063 },
	{ "5PB", 9, 2, 0.2991, 0.3057 },
	{ "7.5PB", 9, 2, 0.3015, 0.3052 },
	{ "10PB", 9, 2, 0.3038, 0.3054 },
	{ "10PB", 9, 4, 0.291, 0.285 },
	{ "2.5P", 9, 2, 0.305, 0.3051 },
	{ "2.5P", 9, 4, 0.2963, 0.2865 },
	{ "5P", 9, 2, 0.3067, 0.306 },
	{ "5P", 9, 4, 0.3003, 0.287 },
	{ "7.5P", 9, 2, 0.3107, 0.3081 },
	{ "7.5P", 9, 4, 0.3117, 0.2928 },
	{ "7.5P", 9, 6, 0.312, 0.2788 },
	{ "10P", 9, 2, 0.3128, 0.3094 },
	{ "10P", 9, 4, 0.3176, 0.2966 },
	{ "10P", 9, 6, 0.3218, 0.2845 },
	{ "2.5RP", 9, 2, 0.3149, 0.3108 },
	{ "2.5RP", 9, 4, 0.3234, 0.301 },
	{ "2.5RP", 9, 6, 0.3322, 0.291 },
	{ "5RP", 9, 2, 0.3172, 0.3126 },
	{ "5RP", 9, 4, 0.3301, 0.306 },
	{ "5RP", 9, 6, 0.3431, 0.2988 },
	{ "7.5RP", 9, 2, 0.319, 0.3141 },
	{ "7.5RP", 9, 4, 0.335, 0.3099 },
	{ "7.5RP", 9, 6, 0.3512, 0.3052 },
	{ 0 }
};
#if 0
double muncell_V_to_Y[] = { // 0 to 9
	0, 1.21, 3.126, 6.555, 12, 19.77, 30.05, 43.06, 59.1, 78.66
};
#else
double muncell_V_to_Y(double V) {
	// https://www.jcri.jp/JCRI/hiroba/COLOR/buhou/166/166-4.htm
	// JIS Z 8721 (1993) ̎gp
	double V2 = V * V;
	double V3 = V2 * V;
	double V4 = V2 * V2;
	double V5 = V3 * V2;
	return 1.1913*V - 0.22532*V2 + 0.23351*V3 - 0.020483*V4 + 0.00081936*V5;
}
double Y_to_muncell_V(double Y) {
	return ONGEO_FindRootByBrentMethod(0, 10, [Y](double V) {return muncell_V_to_Y(V) - Y; }, 1e-8);
}
#endif

bool query_xyY_from_muncell_illumi_C(const char *hue, int V, int C, double &x, double &y, double &Y) {
	if (V < 0 || V > 9) return false;
	for (auto *p = muncell_to_xy_illumi_C; p->hue; ++p) {
		if (std::strcmp(p->hue, hue) != 0) continue;
		if (p->V != V || p->C != C) continue;
		x = p->x;
		y = p->y;
		Y = muncell_V_to_Y(p->V);
		return true;
	}
	return false;
}

/// _, lKY, [JÐM: "}ZF[̕˗z̐," {Fʊw, Vol.13, No.2, pp.52 - 54, 1989
struct spectral_reflectance_eigen_vector_item {
	int lambda;
	double r[4];
}
spectral_reflectance_eigen_vectors_R[] = {
	{400, { 0.1661, 0.0823, 0.0897, 0.1546}},
	{410, { 0.2136, 0.1344, 0.1616, 0.2168}},
	{420, { 0.2237, 0.1499, 0.1862, 0.2266}},
	{430, { 0.2236, 0.1517, 0.1904, 0.2204}},
	{440, { 0.2228, 0.1521, 0.1918, 0.2104}},
	{450, { 0.2219, 0.1523, 0.1930, 0.1991}},
	{460, { 0.2199, 0.1521, 0.1939, 0.1821}},
	{470, { 0.2172, 0.1519, 0.1951, 0.1562}},
	{480, { 0.2141, 0.1515, 0.1958, 0.1232}},
	{490, { 0.2115, 0.1511, 0.1960, 0.0824}},
	{500, { 0.2105, 0.1511, 0.1936, 0.0305}},
	{510, { 0.2111, 0.1520, 0.1865,-0.0350}},
	{520, { 0.2120, 0.1532, 0.1767,-0.1023}},
	{530, { 0.2126, 0.1538, 0.1710,-0.1432}},
	{540, { 0.2139, 0.1544, 0.1667,-0.1724}},
	{550, { 0.2194, 0.1567, 0.1579,-0.2165}},
	{560, { 0.2337, 0.1624, 0.1405,-0.2893}},
	{570, { 0.2655, 0.1747, 0.1093,-0.3664}},
	{580, { 0.3134, 0.1904, 0.0555,-0.3712}},
	{590, { 0.3593, 0.2026,-0.0218,-0.2917}},
	{600, { 0.3914, 0.2093,-0.0953,-0.1795}},
	{610, { 0.4032, 0.2128,-0.1439,-0.0860}},
	{620, { 0.4162, 0.2154,-0.1807,-0.0304}},
	{630, { 0.4199, 0.2168,-0.1975, 0.0020}},
	{640, { 0.4231, 0.2178,-0.2076, 0.0319}},
	{650, { 0.4259, 0.2182,-0.2144, 0.0603}},
	{660, { 0.4286, 0.2185,-0.2199, 0.0862}},
	{670, { 0.4297, 0.2179,-0.2233, 0.1060}},
	{680, { 0.4307, 0.2179,-0.2263, 0.1200}},
	{690, { 0.4317, 0.2183,-0.2291, 0.1313}},
	{700, { 0.4325, 0.2187,-0.2319, 0.1405}},
	{-1, {0}}
},
spectral_reflectance_eigen_vectors_Y[] = {
	{400, { 0.1294, 0.0682, 0.1235,-0.1311}},
	{410, { 0.1602, 0.1011, 0.1900,-0.2054}},
	{420, { 0.1678, 0.1100, 0.2095,-0.2195}},
	{430, { 0.1712, 0.1128, 0.2154,-0.2127}},
	{440, { 0.1752, 0.1156, 0.2204,-0.2022}},
	{450, { 0.1803, 0.1188, 0.2259,-0.1884}},
	{460, { 0.1863, 0.1223, 0.2315,-0.1687}},
	{470, { 0.1936, 0.1266, 0.2379,-0.1445}},
	{480, { 0.2021, 0.1313, 0.2432,-0.1159}},
	{490, { 0.2145, 0.1374, 0.2473,-0.0804}},
	{500, { 0.2350, 0.1471, 0.2479,-0.0185}},
	{510, { 0.2701, 0.1609, 0.2327, 0.0903}},
	{520, { 0.3073, 0.1755, 0.1903, 0.2362}},
	{530, { 0.3288, 0.1847, 0.1490, 0.3366}},
	{540, { 0.3390, 0.1893, 0.1202, 0.3730}},
	{550, { 0.3476, 0.1936, 0.0919, 0.3598}},
	{560, { 0.3598, 0.1979, 0.0512, 0.3066}},
	{570, { 0.3769, 0.2035,-0.0054, 0.2212}},
	{580, { 0.3902, 0.2079,-0.0551, 0.1273}},
	{590, { 0.3962, 0.2107,-0.1119, 0.0431}},
	{600, { 0.3956, 0.2119,-0.1415,-0.0248}},
	{610, { 0.3923, 0.2124,-0.1579,-0.0727}},
	{620, { 0.3901, 0.2132,-0.1669,-0.1000}},
	{630, { 0.3889, 0.2140,-0.1715,-0.1124}},
	{640, { 0.3880, 0.2149,-0.1741,-0.1190}},
	{650, { 0.3870, 0.2153,-0.1757,-0.1218}},
	{660, { 0.3877, 0.2163,-0.1757,-0.1153}},
	{670, { 0.3888, 0.2169,-0.1737,-0.0981}},
	{680, { 0.3906, 0.2179,-0.1718,-0.0310}},
	{690, { 0.3923, 0.2191,-0.1703,-0.0558}},
	{700, { 0.3933, 0.2201,-0.1698,-0.0557}},
	{-1, {0}}
},
spectral_reflectance_eigen_vectors_G[] = {
	{400, { 0.1418, 0.0368, 0.1008, 0.1219}},
	{410, { 0.1808, 0.1318, 0.1530, 0.2202}},
	{420, { 0.1945, 0.1463, 0.1751, 0.2436}},
	{430, { 0.2029, 0.1517, 0.1875, 0.2356}},
	{440, { 0.2122, 0.1567, 0.1992, 0.2198}},
	{450, { 0.2236, 0.1624, 0.2132, 0.1960}},
	{460, { 0.2378, 0.1685, 0.2327, 0.1590}},
	{470, { 0.2549, 0.1749, 0.2571, 0.1076}},
	{480, { 0.2708, 0.1807, 0.2722, 0.0495}},
	{490, { 0.2867, 0.1865, 0.2715,-0.0123}},
	{500, { 0.3057, 0.1938, 0.2427,-0.0958}},
	{510, { 0.3281, 0.2019, 0.1843,-0.2148}},
	{520, { 0.3440, 0.2085, 0.1099,-0.3275}},
	{530, { 0.3455, 0.2119, 0.0527,-0.3638}},
	{540, { 0.3375, 0.2128, 0.0101,-0.3402}},
	{550, { 0.3238, 0.2118,-0.0299,-0.2837}},
	{560, { 0.3073, 0.2090,-0.0656,-0.2166}},
	{570, { 0.2901, 0.2052,-0.1002,-0.1461}},
	{580, { 0.2717, 0.2000,-0.1286,-0.0754}},
	{590, { 0.2503, 0.1927,-0.1534,-0.0051}},
	{600, { 0.2286, 0.1835,-0.1736, 0.0573}},
	{610, { 0.2108, 0.1752,-0.1852, 0.0978}},
	{620, { 0.2005, 0.1703,-0.1905, 0.1181}},
	{630, { 0.1958, 0.1682,-0.1923, 0.1268}},
	{640, { 0.1933, 0.1673,-0.1930, 0.1318}},
	{650, { 0.1917, 0.1668,-0.1932, 0.1337}},
	{660, { 0.1944, 0.1638,-0.1926, 0.1289}},
	{670, { 0.2003, 0.1727,-0.1895, 0.1157}},
	{680, { 0.2082, 0.1770,-0.1851, 0.0995}},
	{690, { 0.2145, 0.1809,-0.1816, 0.0338}},
	{700, { 0.2190, 0.1838,-0.1778, 0.0737}},
	{-1, {0}}
},
spectral_reflectance_eigen_vectors_B[] = {
	{400, { 0.1933, 0.0925,-0.0366,-0.1440}},
	{410, { 0.2662, 0.1610,-0.0318,-0.2399}},
	{420, { 0.2911, 0.1864,-0.0370,-0.2661}},
	{430, { 0.3005, 0.1911,-0.0659,-0.2676}},
	{440, { 0.3086, 0.1933,-0.1007,-0.2628}},
	{450, { 0.3177, 0.1951,-0.1454,-0.2512}},
	{460, { 0.3259, 0.1964,-0.1919,-0.2079}},
	{470, { 0.3340, 0.1973,-0.2409,-0.1403}},
	{480, { 0.3378, 0.1977,-0.2731,-0.0637}},
	{490, { 0.3363, 0.1930,-0.2819, 0.0242}},
	{500, { 0.3304, 0.1981,-0.2686, 0.1030}},
	{510, { 0.3216, 0.1980,-0.2394, 0.1686}},
	{520, { 0.3083, 0.1969,-0.1941, 0.2296}},
	{530, { 0.2936, 0.1951,-0.1393, 0.2665}},
	{540, { 0.2786, 0.1925,-0.0785, 0.2748}},
	{550, { 0.2612, 0.1884,-0.0130, 0.2721}},
	{560, { 0.2419, 0.1823, 0.0455, 0.2710}},
	{570, { 0.2259, 0.1765, 0.0924, 0.2533}},
	{580, { 0.2154, 0.1729, 0.1285, 0.2092}},
	{590, { 0.2070, 0.1697, 0.1605, 0.1476}},
	{600, { 0.1981, 0.1661, 0.1897, 0.0855}},
	{610, { 0.1907, 0.1629, 0.2090, 0.0398}},
	{620, { 0.1876, 0.1618, 0.2168, 0.0092}},
	{630, { 0.1892, 0.1632, 0.2171,-0.0213}},
	{640, { 0.1935, 0.1658, 0.2162, 0.0625}},
	{650, { 0.1979, 0.1681, 0.2152,-0.1032}},
	{660, { 0.2024, 0.1704, 0.2117,-0.2135}},
	{670, { 0.2056, 0.1720, 0.2044,-0.1130}},
	{680, { 0.2063, 0.1727, 0.1993,-0.0818}},
	{690, { 0.2070, 0.1737, 0.1946,-0.0535}},
	{700, { 0.2102, 0.1757, 0.1870,-0.0498}},
	{-1, {0}}
},
spectral_reflectance_eigen_vectors_P[] = {
	{400, { 0.2179, 0.0847, 0.0377,-0.1405}},
	{410, { 0.2974, 0.1530, 0.1000,-0.1893}},
	{420, { 0.3194, 0.1771, 0.1331,-0.1996}},
	{430, { 0.3228, 0.1801, 0.1481,-0.2129}},
	{440, { 0.3234, 0.1807, 0.1606,-0.2198}},
	{450, { 0.3225, 0.1809, 0.1730,-0.2195}},
	{460, { 0.3180, 0.1805, 0.1827,-0.1998}},
	{470, { 0.3106, 0.1800, 0.1929,-0.1654}},
	{480, { 0.3002, 0.1789, 0.2004,-0.1151}},
	{490, { 0.2861, 0.1772, 0.1996,-0.0450}},
	{500, { 0.2717, 0.1748, 0.1948, 0.0201}},
	{510, { 0.2582, 0.1720, 0.1888, 0.0734}},
	{520, { 0.2437, 0.1685, 0.1776, 0.1319}},
	{530, { 0.2334, 0.1662, 0.1656, 0.1750}},
	{540, { 0.2278, 0.1649, 0.1570, 0.1948}},
	{550, { 0.2229, 0.1637, 0.1465, 0.2092}},
	{560, { 0.2176, 0.1622, 0.1270, 0.2377}},
	{570, { 0.2228, 0.1653, 0.0913, 0.2677}},
	{580, { 0.2436, 0.1742, 0.0240, 0.2756}},
	{590, { 0.2680, 0.1831,-0.0615, 0.2418}},
	{600, { 0.2848, 0.1883,-0.1345, 0.1895}},
	{610, { 0.2908, 0.1906,-0.1796, 0.1603}},
	{620, { 0.2900, 0.1915,-0.1978, 0.1595}},
	{630, { 0.2920, 0.1929,-0.2026, 0.1438}},
	{640, { 0.3013, 0.1957,-0.2058, 0.0955}},
	{650, { 0.3142, 0.1984,-0.2114, 0.0227}},
	{660, { 0.3269, 0.2005,-0.2221,-0.0582}},
	{670, { 0.3358, 0.2007,-0.2366,-0.1295}},
	{680, { 0.3409, 0.2003,-0.2541,-0.1786}},
	{690, { 0.3447, 0.2001,-0.2690,-0.2174}},
	{700, { 0.3490, 0.2004,-0.2746,-0.2559}},
	{-1, {0}}
};

int spectrum_item_count(spectral_item *item) {
	for (int i = 0;; ++i) {
		if (item[i].lambda < 0) return i;
	}
	return 0;
}

bool interpolate_binlinear_spectral_item(spectral_item *points, int cnt, int lambda_first, int lambda_last, spectral_item *interpolated) {
	// ͒l`FbN
	// lambda_first  lambda_last ̕A܂ points lambda ɂȂĂȂꍇNG
	if (lambda_last < lambda_first) return false;
	if (cnt <= 0) return false;
	for (int i = 0; i < cnt - 1; ++i) {
		if (points[i].lambda >= points[i + 1].lambda) return false;
	}

	for (int l = lambda_first; l < points[0].lambda; ++l) {
		auto &itm = interpolated[l - lambda_first];
		itm.lambda = l, itm.v = 0;
	}
	for (int l = points[cnt-1].lambda + 1; l <= lambda_last; ++l) {
		auto &itm = interpolated[l - lambda_first];
		itm.lambda = l, itm.v = 0;
	}
	for (int j = 0; j < cnt - 1; ++j) {
		int l_sec_first = points[j].lambda, l_sec_last = points[j + 1].lambda;
		double inv_l_sec_len = 1.0 / static_cast<double>(l_sec_last - l_sec_first);
		double v_first = points[j].v, v_last = points[j + 1].v;
		for (int l = l_sec_first; l < l_sec_last && l <= lambda_last; ++l) {
			if (l_sec_first < lambda_first) continue;
			double t = static_cast<double>(l - l_sec_first) * inv_l_sec_len;
			auto &itm = interpolated[l - lambda_first];
			itm.lambda = l, itm.v = (1 - t) * v_first + t * v_last;
		}
	}
	int pt_lambda_last = points[cnt - 1].lambda;
	if (pt_lambda_last <= lambda_last) {
		interpolated[pt_lambda_last - lambda_first] = points[cnt - 1];
	}
	return true;
}
bool interpolate_binlinear_spectral_item(spectral_item *points, int cnt, int lambda_first, int lambda_last, std::vector<spectral_item> &interpolated) {
	if (lambda_last < lambda_first) return false;
	interpolated.resize(lambda_last - lambda_first + 1);
	return interpolate_binlinear_spectral_item(points, cnt, lambda_first, lambda_last, interpolated.data());
}

int spectral_reflectance_eigen_vectors_item_count(spectral_reflectance_eigen_vector_item *srev) {
	for (int i = 0;; ++i) {
		if (srev[i].lambda < 0) return i;
	}
	return 0;
}

// si ͌ĂяoŕKvȗ̈mۂĂ
void extract_spectral_from_eigen_vectors(spectral_reflectance_eigen_vector_item *srev, int index, spectral_item *si) {
	for (int i = 0; srev[i].lambda > 0; ++i) {
		si[i].lambda = srev[i].lambda;
		si[i].v = srev[i].r[index];
	}
}

bool xyY_to_spectral_reflectance(double x, double y, double Y, double t, const char hue_char[2], int lambda_first, int lambda_last, spectral_item *interpolated) {
	double rt = 1 - t;

	double Yc = Y;
	double Xc = x * Y / y;
	double Zc = (1 - x - y) * Y / y;

	spectral_reflectance_eigen_vector_item *target_srevs[2] = { 0, 0 };
	for (int i = 0; i < 2; ++i) {
		if (hue_char[i] == 'R') {
			target_srevs[i] = spectral_reflectance_eigen_vectors_R;
		} else if (hue_char[i] == 'Y') {
			target_srevs[i] = spectral_reflectance_eigen_vectors_Y;
		} else if (hue_char[i] == 'G') {
			target_srevs[i] = spectral_reflectance_eigen_vectors_G;
		} else if (hue_char[i] == 'B') {
			target_srevs[i] = spectral_reflectance_eigen_vectors_B;
		} else if (hue_char[i] == 'P') {
			target_srevs[i] = spectral_reflectance_eigen_vectors_P;
		}
	}

	spectral_item *target_illuminant = std_illuminant_C;
	std::vector<spectral_item> illuminant_interp;
	interpolate_binlinear_spectral_item(target_illuminant, spectrum_item_count(target_illuminant), lambda_first, lambda_last, illuminant_interp);

	double illumi_y_conv = cmf_convolution_y(illuminant_interp.data());
	double inv_illumi_y_conv = 100.0 / illumi_y_conv;
	mist::matrix<double> xyz123(3, 3);

	{
		std::vector<spectral_item> target_eigen_work;
		std::vector<spectral_item> eigen_interp_work[4];
		for (int j = 0; j < 2; ++j) {
			if (!target_srevs[j]) break;
			target_eigen_work.resize(spectral_reflectance_eigen_vectors_item_count(target_srevs[j]));
			double X0, Y0, Z0;
			for (int i = 0; i < 4; ++i) {
				extract_spectral_from_eigen_vectors(target_srevs[j], i, target_eigen_work.data());
				interpolate_binlinear_spectral_item(target_eigen_work.data(), static_cast<int>(target_eigen_work.size()), lambda_first, lambda_last, eigen_interp_work[i]);

				double X, Y, Z;
				cmf_convolution_xyz(illuminant_interp.data(), eigen_interp_work[i].data(), X, Y, Z);
				X *= inv_illumi_y_conv, Y *= inv_illumi_y_conv, Z *= inv_illumi_y_conv;
				if (i >= 1) {
					xyz123(0, i - 1) = X, xyz123(1, i - 1) = Y, xyz123(2, i - 1) = Z;
				} else {
					X0 = X, Y0 = Y, Z0 = Z;
				}
			}
			mist::matrix<double> xyz_c0(3, 1);
			xyz_c0[0] = Xc - X0, xyz_c0[1] = Yc - Y0, xyz_c0[2] = Zc - Z0;
			inverse_234(xyz123);
			auto k = xyz123 * xyz_c0;

			double t_c;
			if (j == 0) {
				for (size_t h = 0; h < eigen_interp_work[0].size(); ++h) {
					interpolated[h].v = t * eigen_interp_work[0][h].v;
				}
				t_c = t;
			} else {
				for (size_t h = 0; h < eigen_interp_work[0].size(); ++h) {
					interpolated[h].v += rt * eigen_interp_work[0][h].v;
				}
				t_c = rt;
			}
			for (int i = 1; i < 4; ++i) {
				for (size_t h = 0; h < eigen_interp_work[0].size(); ++h) {
					interpolated[h].v += t_c * k[i - 1] * eigen_interp_work[i][h].v;
				}
			}
		}
		for (size_t h = 0; h < eigen_interp_work[0].size(); ++h) {
			interpolated[h].lambda = illuminant_interp[h].lambda;
		}
	}
	return true;
}

bool xyY_to_spectral_reflectance(double x, double y, double Y, double t, const char hue_char[2], int lambda_first, int lambda_last, std::vector<spectral_item> &interpolated) {
	if (lambda_last < lambda_first) return false;
	interpolated.resize(lambda_last - lambda_first + 1);
	return xyY_to_spectral_reflectance(x, y, Y, t, hue_char, lambda_first, lambda_last, interpolated.data());
}

bool muncell_to_spectral_reflectance(const char *hue, int V, int C, int lambda_first, int lambda_last, char hue_char[2], double &x, double &y, double &Y, spectral_item *interpolated) {

	double t;
	size_t hue_str_len = std::strlen(hue);
	// w肳ꂽFAgp郊XgI
	if (std::strstr(hue, "10") == hue) {
		hue_char[0] = hue[2];
		hue_char[1] = '\0';
		t = 1;
	} else if (std::isalpha(hue[hue_str_len - 2])){
		hue_char[0] = hue[hue_str_len - 2];
		hue_char[1] = hue[hue_str_len - 1];
		t = std::strtod(hue, 0);
	} else {
		hue_char[0] = hue[hue_str_len - 1];
		hue_char[1] = '\0';
		t = 1;
	}

	if (!query_xyY_from_muncell_illumi_C(hue, V, C, x, y, Y)) return false;
	return xyY_to_spectral_reflectance(x, y, Y, t, hue_char, lambda_first, lambda_last, interpolated);
}

bool muncell_to_spectral_reflectance(const char *hue, int V, int C, int lambda_first, int lambda_last, char hue_char[2], double &x, double &y, double &Y, std::vector<spectral_item> &interpolated) {
	if (lambda_last < lambda_first) return false;
	interpolated.resize(lambda_last - lambda_first + 1);
	return muncell_to_spectral_reflectance(hue, V, C, lambda_first, lambda_last, hue_char, x, y, Y, interpolated.data());
}

struct spectral_shape_fitting {
	int lambda_first, lambda_last;
	spectral_item *reflectance_interp, *reflectance_shape_work, *reflectance_interp_work;

	// m - number of data points : lambda_last - lambda_first + 1
	// n - number of parameters (3) (Ԕg3_)
	// p - array of fit parameters
	//     p[0] = lambda_1
	//     p[2] = lambda_2
	//     p[3] = lambda_3
	// dy - array of residuals to be returned
	// vars - private data(struct vars_struct *)
	static int func(int m, int n, double *p, double *dy, double **dvec, void *vars) {
		spectral_shape_fitting *vars_ = static_cast<spectral_shape_fitting *>(vars);
		for (int i = 0; i < n; ++i) {
			int lambda = static_cast<int>(p[i]);
			vars_->reflectance_shape_work[i+1].lambda = lambda;
			vars_->reflectance_shape_work[i+1].v = vars_->reflectance_interp[lambda - vars_->lambda_first].v;
		}

		interpolate_binlinear_spectral_item(vars_->reflectance_shape_work, n + 2, vars_->lambda_first, vars_->lambda_last, vars_->reflectance_interp_work);

		for (int i = 0; i < m; ++i) {
			dy[i] = vars_->reflectance_interp_work[i].v - vars_->reflectance_interp[i].v;
		}
		return 0;
	}
};

struct spectral_to_chromaticity_fitting {
	int lambda_first, lambda_last;
	spectral_item * illuminant_interp;
	double illumi_y_conv;

	double target_x, target_y;

	double *lambda_points;
	int reflectance_points_count;
	spectral_item *reflectance_work, *reflectance_interp_work;
	double X, Y, Z, x, y;

	// m - number of data points (2)
	// n - number of parameters (5) == reflectance_points_count
	// p - array of fit parameters (i: 0 to n-1)
	//     p[i] = value in lambda_points[i]
	// dy - array of residuals to be returned
	// vars - private data(struct vars_struct *)
	static int func(int m, int n, double *p, double *dy, double **dvec, void *vars) {
		spectral_to_chromaticity_fitting *vars_ = static_cast<spectral_to_chromaticity_fitting *>(vars);
		for (int i = 0; i < n; ++i) {
			vars_->reflectance_work[i].lambda = vars_->lambda_points[i];
			vars_->reflectance_work[i].v = p[i];
		}

		interpolate_binlinear_spectral_item(vars_->reflectance_work, vars_->reflectance_points_count, vars_->lambda_first, vars_->lambda_last, vars_->reflectance_interp_work);

		double X, Y, Z;
		double S = cmf_convolution_xyz(vars_->illuminant_interp, vars_->reflectance_interp_work, X, Y, Z);
		vars_->X = X;
		vars_->Y = Y;
		vars_->Z = Z;
		vars_->x = X / S;
		vars_->y = Y / S;
		dy[0] = (vars_->x - vars_->target_x);
		dy[1] = (vars_->y - vars_->target_y);
		for (int i = 2; i < m; ++i) dy[i] = 0;
		return 0;
	}
};


int main(int argc, char *argv[]) {
	int lambda_first, lambda_last;
	cmf_get_range(lambda_first, lambda_last);

	spectral_item *target_illuminant = std_illuminant_C;
	std::vector<spectral_item> illuminant_interp_C;
	interpolate_binlinear_spectral_item(target_illuminant, spectrum_item_count(target_illuminant), lambda_first, lambda_last, illuminant_interp_C);
	double illumi_y_conv = cmf_convolution_y(illuminant_interp_C.data());

	char hue[10];
	int V, C;
	if (argc != 6) {
		std::printf("input hue:");
		std::scanf("%s", hue);
		std::printf("input V, C:");
		std::scanf("%d, %d", &V, &C);
	}

	// }Zl番˗𐄒肷B
	std::printf("<estimate spectral reflectance from muncell value>\n");
	char hue_char[3] = { 0 };
	double muncell_x, muncell_y, muncell_Y;
	double sum_spectral_estimated_v = 0;
	std::vector<spectral_item> spectral_reflectance_estimated_interp;
	{
		if (argc == 6) {
			muncell_x = std::strtod(argv[1], 0);
			muncell_y = std::strtod(argv[2], 0);
			muncell_Y = std::strtod(argv[3], 0);
			double t = std::strtod(argv[4], 0);
			std::strncpy(hue_char, argv[5], 2);
			xyY_to_spectral_reflectance(muncell_x, muncell_y, muncell_Y, t, hue_char, lambda_first, lambda_last, spectral_reflectance_estimated_interp);
		} else {
			muncell_to_spectral_reflectance(hue, V, C, lambda_first, lambda_last, hue_char, muncell_x, muncell_y, muncell_Y, spectral_reflectance_estimated_interp);
		}
		for (size_t i = 0; i < spectral_reflectance_estimated_interp.size(); ++i) sum_spectral_estimated_v += spectral_reflectance_estimated_interp[i].v;

		double X, Y, Z;
		double S = cmf_convolution_xyz(illuminant_interp_C.data(), spectral_reflectance_estimated_interp.data(), X, Y, Z);
		std::printf("(X, Y, Z) = (%f, %f, %f)\n", X / illumi_y_conv, Y / illumi_y_conv, Z / illumi_y_conv);
		std::printf("(x, y) = (%f, %f)\n", X / S, Y / S);
	}

	// 肵˗AIȔg3_IB
	std::printf("<select lambdas>\n");
	double lambda[5];
	{
		std::vector<spectral_item> reflectance_shape(5), spectral_reflectance_work_interp(spectral_reflectance_estimated_interp.size());
		spectral_shape_fitting fit;
		fit.lambda_first = lambda_first, fit.lambda_last = lambda_last;
		fit.reflectance_interp = spectral_reflectance_estimated_interp.data();
		fit.reflectance_shape_work = reflectance_shape.data();
		fit.reflectance_interp_work = spectral_reflectance_work_interp.data();

		double *p = lambda;
		if (std::strcmp(hue_char, "R") == 0) {
			p[0] = 400, p[1] = 410, p[2] = 550, p[3] = 600, p[4] = 700;
		} else if (std::strcmp(hue_char, "YR") == 0) {
			p[0] = 400, p[1] = 410, p[2] = 530, p[3] = 600, p[4] = 700;
		} else if (std::strcmp(hue_char, "Y") == 0) {
			p[0] = 400, p[1] = 500, p[2] = 560, p[3] = 620, p[4] = 700;
		} else if (std::strcmp(hue_char, "GY") == 0) {
			p[0] = 400, p[1] = 450, p[2] = 510, p[3] = 610, p[4] = 700;
		} else if (std::strcmp(hue_char, "G") == 0) {
			p[0] = 400, p[1] = 410, p[2] = 530, p[3] = 630, p[4] = 700;
		} else if (std::strcmp(hue_char, "BG") == 0) {
			p[0] = 400, p[1] = 410, p[2] = 510, p[3] = 630, p[4] = 700;
		} else if (std::strcmp(hue_char, "B") == 0) {
			p[0] = 400, p[1] = 410, p[2] = 490, p[3] = 630, p[4] = 700;
		} else if (std::strcmp(hue_char, "PB") == 0) {
			p[0] = 400, p[1] = 410, p[2] = 460, p[3] = 560, p[4] = 700;
		} else if (std::strcmp(hue_char, "P") == 0) {
			p[0] = 400, p[1] = 420, p[2] = 560, p[3] = 610, p[4] = 700;
		} else if (std::strcmp(hue_char, "RP") == 0) {
			p[0] = 400, p[1] = 440, p[2] = 560, p[3] = 620, p[4] = 700;
		}

		reflectance_shape[0].lambda = p[0];
		reflectance_shape[0].v = spectral_reflectance_estimated_interp[reflectance_shape[0].lambda - lambda_first].v;
		reflectance_shape[4].lambda = p[4];
		reflectance_shape[4].v = spectral_reflectance_estimated_interp[reflectance_shape[4].lambda - lambda_first].v;

		mp_par_struct pars[3];
		for (int i = 0; i < 3; ++i) {
			std::memset(&pars[i], 0, sizeof(mp_par_struct));
			pars[i].fixed = 0;
			pars[i].limited[0] = pars[i].limited[1] = 1;
			pars[i].step = 1;
			int dif = (p[i] < 430) ? 5 : 25;
			pars[i].limits[0] = lambda[i+1] - dif;
			pars[i].limits[1] = lambda[i+1] + dif;
		}
		mp_result result = { 0 };
		std::vector<double> perror(spectral_reflectance_work_interp.size());
		result.xerror = perror.data();
		int status = mpfit(spectral_shape_fitting::func, static_cast<int>(spectral_reflectance_work_interp.size()), 3, p+1, pars, 0, &fit, &result);
		std::printf("status:%d\n", status);

		for (int i = 0; i < 5; ++i) {
			std::printf("%d,%f\n", reflectance_shape[i].lambda, reflectance_shape[i].v);
		}
		double X, Y, Z;
		double S = cmf_convolution_xyz(illuminant_interp_C.data(), spectral_reflectance_work_interp.data(), X, Y, Z);
		std::printf("(X, Y, Z) = (%f, %f, %f)\n", X / illumi_y_conv, Y / illumi_y_conv, Z / illumi_y_conv);
		std::printf("(x, y) = (%f, %f)\n", X / S, Y / S);

	}

	std::printf("<adjust values in selected lambdas>\n");
	std::vector<spectral_item> spectral_reflectance_adjusted_interp(spectral_reflectance_estimated_interp.size());
	{
		spectral_to_chromaticity_fitting fit;
		fit.lambda_first = lambda_first, fit.lambda_last = lambda_last;
		fit.illumi_y_conv = illumi_y_conv;
		fit.illuminant_interp = illuminant_interp_C.data();
		fit.lambda_points = lambda;

		std::vector<spectral_item> refl_fit(5);
		fit.reflectance_work = refl_fit.data();
		fit.reflectance_points_count = static_cast<int>(refl_fit.size());
		fit.reflectance_interp_work = spectral_reflectance_adjusted_interp.data();
		fit.target_x = muncell_x, fit.target_y = muncell_y;

		double p[5];
		for (int i = 0; i < 5; ++i){
			p[i] = spectral_reflectance_estimated_interp[static_cast<int>(lambda[i]) - lambda_first].v;
		};

		mp_par_struct pars[5];
		for (int i = 0; i < fit.reflectance_points_count; ++i) {
			std::memset(&pars[i], 0, sizeof(mp_par_struct));
			pars[i].fixed = (i != fit.reflectance_points_count - 1 && lambda[i] > 420) ? 0 : 1;
			pars[i].limited[0] = 1;
			pars[i].limited[1] = 0;
			pars[i].limits[0] = 1e-5;
			pars[i].limits[1] = 0;
		}

		double perror[5] = {0};
		mp_result result = {0};
		result.xerror = perror;
		int status = mpfit(spectral_to_chromaticity_fitting::func, fit.reflectance_points_count, fit.reflectance_points_count, p, pars, 0, &fit, &result);
		std::printf("status:%d\n", status);

#if 0
		double X, Y, Z;
		double S = cmf_convolution_xyz(illuminant_interp_C.data(), spectral_reflectance_adjusted_interp.data(), X, Y, Z);
		double sum_spectral_adjusted_v = 0;
		for (size_t i = 0; i < spectral_reflectance_adjusted_interp.size(); ++i) {
			sum_spectral_adjusted_v += spectral_reflectance_adjusted_interp[i].v;
		}
		double v_adjusted = sum_spectral_estimated_v / sum_spectral_adjusted_v;
		for (size_t i = 0; i < spectral_reflectance_adjusted_interp.size(); ++i) {
			spectral_reflectance_adjusted_interp[i].v *= v_adjusted;
		}
#else
		double X, Y, Z;
		double S = cmf_convolution_xyz(illuminant_interp_C.data(), spectral_reflectance_adjusted_interp.data(), X, Y, Z);
		double v_adjusted = muncell_Y * 0.01 / Y * illumi_y_conv;

		for (size_t i = 0; i < spectral_reflectance_adjusted_interp.size(); ++i) {
			spectral_reflectance_adjusted_interp[i].v *= v_adjusted;
		}
		S = cmf_convolution_xyz(illuminant_interp_C.data(), spectral_reflectance_adjusted_interp.data(), X, Y, Z);
#endif
		for (size_t i = 0; i < fit.reflectance_points_count; ++i) {
			std::printf("%d,%f\n", refl_fit[i].lambda, refl_fit[i].v * v_adjusted);
		}

		std::printf("(X, Y, Z) = (%f, %f, %f)\n", X, Y, Z);
		std::printf("(x, y) = (%f, %f)\n", X / S, Y / S);
	}

	std::printf("lambda, estimated, simplified\n");
	for (size_t i = 0; i < spectral_reflectance_estimated_interp.size(); ++i) {
		auto &itm_e = spectral_reflectance_estimated_interp[i];
		auto &itm_a = spectral_reflectance_adjusted_interp[i];
		std::printf("%d, %f, %f\n", itm_e.lambda, itm_e.v, itm_a.v);
	}

	std::printf("<test by all standard illuminances(first:estimated, second:adjusted)>\n");
	{
		std::printf("illumi_type,x,y,Y,x,y,Y,dx,dy,dY\n");

		std::vector<spectral_item> illuminant_interp_test;

		for (int i = 0; std_illuminants[i].name; ++i) {
			std::printf("%s", std_illuminants[i].name);
			interpolate_binlinear_spectral_item(std_illuminants[i].sp, spectrum_item_count(std_illuminants[i].sp), lambda_first, lambda_last, illuminant_interp_test);
			double illumi_y_conv = cmf_convolution_y(illuminant_interp_test.data());
			double Xe, Ye, Ze;
			double Se = cmf_convolution_xyz(illuminant_interp_test.data(), spectral_reflectance_estimated_interp.data(), Xe, Ye, Ze);
			double xe = Xe / Se, ye = Ye / Se;
			std::printf(",%f,%f,%f", xe, ye, Ye / illumi_y_conv);
			double Xa, Ya, Za;
			double Sa = cmf_convolution_xyz(illuminant_interp_test.data(), spectral_reflectance_adjusted_interp.data(), Xa, Ya, Za);
			double xa = Xa / Sa, ya = Ya / Sa;
			std::printf(",%f,%f,%f", xa, ya, Ya / illumi_y_conv);
			std::printf(",%f,%f,%f", xe - xa, ye - ya, (Ye - Ya) / illumi_y_conv);
			std::printf("\n");
		}
	}
	// Y to muncell V test
	{
		std::printf("V,Y,V,err\n");
		for (double V = 0; V <= 10.0; V += 0.125){
			double Y = muncell_V_to_Y(V);
			double Vr = Y_to_muncell_V(Y);
			std::printf("%f,%f,%f,%f\n", V, Y, Vr, V - Vr);
		}
	}
	return 0;
}
