/***************************************************************************
                          simple.cpp  -  description
                             -------------------
    begin                : Thu Oct 17 21:59:18 CEST 2002
    copyright            : (C) 2002 by Pier Philipsen
    email                : pier@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "QPPlotDemo.h"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qtextedit.h>
#include <qmenubar.h>
#include<qpainter.h>
#include<qcombobox.h>
#include<qmessagebox.h>

#include "QPPlot.h"
#include "../generic/RubyPPlotInterface.h"
#include "../generic/PythonPPlotInterface.h"
#include "QP3DPlot.h"

const bool kPainterTester = false;// set to "true" to make the painter tester plot

QPPlotDemo::QPPlotDemo(QWidget *parent, const char *name) : 
  QWidget(parent, name)
{
  if (kPainterTester) {
    setGeometry (0,0,300,300);
    QGridLayout *theLayout = new QGridLayout (this, 1, 1);
    QPPlot *thePlot = new QPPlot (this);
    MakePainterTester (thePlot->mPPlot);
    theLayout->addWidget (thePlot, 0, 0);
    return;
  }

  setGeometry (0,0,900,700);

  QGridLayout *theLayout = new QGridLayout (this, 2, 4);

  QPPlot *thePlotA = new QPPlot (this);
  MakeExamplePlot (1, thePlotA->mPPlot);

  QPPlot *thePlotB = new QPPlot (this, "bbb");
  MakeExamplePlot (2, thePlotB->mPPlot);

  QPPlot *thePlotC = new QPPlot (this, "ccc");
  MakeExamplePlot (3, thePlotC->mPPlot);

  QPPlot *thePlotD = new QPPlot (this, "ddd");
  MakeExamplePlot (4, thePlotD->mPPlot);

  QPPlot *thePlotE = new QPPlot (this, "eee");
  MakeExamplePlot (5, thePlotE->mPPlot);

  QPPlot *thePlotF= new QPPlot (this, "fff");
  MakeExamplePlot (6, thePlotF->mPPlot);

  QPPlot *thePlotG = new QPPlot (this, "ggg");
  MakeExamplePlot (7, thePlotG->mPPlot);

  QPPlot *thePlotH= new QPPlot (this, "hhh");
  MakeExamplePlot (8, thePlotH->mPPlot);

  theLayout->addWidget (thePlotA, 0, 0);
  theLayout->addWidget (thePlotB, 0, 1);
  theLayout->addWidget (thePlotC, 1, 0);
  theLayout->addWidget (thePlotD, 1, 1);
  theLayout->addWidget (thePlotE, 0, 2);
  theLayout->addWidget (thePlotF, 1, 2);
  theLayout->addWidget (thePlotG, 0, 3);
  theLayout->addWidget (thePlotH, 1, 3);
}


QSinglePPlotDemo::QSinglePPlotDemo(int inIndex, QWidget *parent, const char *name) : 
  QWidget(parent, name)
{
  setGeometry (0,0,300,300);
  QGridLayout *theLayout = new QGridLayout (this, 1, 1);
  QPPlot *thePlot = new QPPlot (this);
  if (inIndex<1) {
    MakePainterTester (thePlot->mPPlot);
  }
  else {
    MakeExamplePlot (inIndex, thePlot->mPPlot);
  }
  theLayout->addWidget (thePlot, 0, 0);

}

QPPlotRubyDemo::QPPlotRubyDemo(QWidget *parent, const char *name) : 
  QWidget(parent, name),
  mTextEdit (0),
  mPPlot (0),
  mScriptType (0)
{
  setGeometry (0,0,900,700);

  QBoxLayout *theMainLayout = new QVBoxLayout (this);
  QMenuBar *theMenubar = new QMenuBar( this, "menubar" );
  theMenubar->setMaximumHeight (30);

  QPopupMenu *theFileMenu = new QPopupMenu( this ); 
  theMenubar->insertItem( tr( "&File" ), theFileMenu);
  theFileMenu->insertItem( tr( "&Load script" ), this, SLOT (LoadScript ()) );


  QPushButton *theButton = new QPushButton ("apply script", this);
  //theButton->setMinimumHeight (20);
  QComboBox *theComboBox = new QComboBox (this);
  theComboBox->insertItem ("ruby", 0);
  theComboBox->insertItem ("python", 1);

  mTextEdit = new QTextEdit (this);
  mTextEdit->setMaximumHeight (300);
  QPPlot *thePlotA = new QPPlot (this);
  //  MakeExamplePlot (1, thePlotA->mPPlot);

  connect (theComboBox, SIGNAL (activated(int)), this, SLOT (SetScriptType (int)));
  connect (theButton, SIGNAL (clicked()), this, SLOT (ApplyScript ()));
  connect (theButton, SIGNAL (clicked()), thePlotA, SLOT (update ()));
  mPPlot = &(thePlotA->mPPlot);

  SetCurrentPPlot (mPPlot);

  theMainLayout->addWidget (theMenubar);
  QBoxLayout *theSubLayout = new QHBoxLayout (theMainLayout);
  theSubLayout->addWidget (theButton);
  theSubLayout->addWidget (theComboBox);
  theMainLayout->addWidget (mTextEdit);
  theMainLayout->addWidget (thePlotA);
}

void QPPlotRubyDemo::ApplyScript () {
  QString theQScript = mTextEdit->text ();
  string theScript = (const char *)theQScript;
  string theErrorString;
  if (mScriptType == 0) {
    RubyPPlotInterface theRubyInterface;
    theRubyInterface.ApplyScript (*mPPlot, theScript, theErrorString);
  }
  else {
    PythonPPlotInterface thePythonInterface;
    thePythonInterface.ApplyScript (*mPPlot, theScript);
  }
}

void QPPlotRubyDemo::LoadScript ()
{
  string theDir = "../ruby";
  string thePattern = "Ruby (*.rb)";
  if (mScriptType == 1) {
    theDir = "../python";
    thePattern = "Python (*.py)";
  }
 QString s = QFileDialog::getOpenFileName(
                    theDir.c_str (),
                    thePattern.c_str (),
                    this,
                    "open file dialog"
                    "Choose a file" );
 QFile file( s );
 QString lines;
 if ( file.open( IO_ReadOnly ) ) {
   QTextStream stream( &file );
   QString line;
   int i = 1;
   while ( !stream.atEnd() ) {
     line = stream.readLine(); // line of text excluding '\n'
     lines += (line + "\n");
   }
   file.close();
 }
 mTextEdit->setText (lines);
}


QP3DPlotDemo::QP3DPlotDemo(QWidget *parent, const char *name) : 
  QWidget(parent, name)
{
  setGeometry (0,0,900,700);

  QMenuBar *theMenubar = new QMenuBar( this, "menubar" );
  theMenubar->setMaximumHeight (20);

  QPopupMenu *theFileMenu = new QPopupMenu( this ); 
  theMenubar->insertItem( tr( "&File" ), theFileMenu);
  QVBoxLayout * theMainLayout = new QVBoxLayout (this);
  theMainLayout->addWidget (theMenubar);

  QComboBox *theComboBox = new QComboBox (this);
  theComboBox->insertItem ("example 1", 0);
  theComboBox->insertItem ("example 2", 1);
  theMainLayout->addWidget (theComboBox);

  QGridLayout *theLayout = new QGridLayout (theMainLayout, 1,1);

  QP3DPlot *thePlot = new QP3DPlot (this);
  connect (theComboBox, SIGNAL (activated(int)), thePlot, SLOT (MakeDemoPlot (int)));
  theFileMenu->insertItem( tr( "&Rotate" ), thePlot, SLOT (ToggleAutoRotate ()) );
  MakeExamplePlot1 (thePlot->mPPlot);


  theLayout->addWidget (thePlot, 0, 0);
}
