/***************************************************************************
                          QPPlot.h  - qt widget for (p)plotting  
                             -------------------
    begin                : Thu Oct 17 21:59:18 CEST 2002
    copyright            : (C) 2002 by Pier Philipsen
    email                : pier@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __QPPPLOT_H__
#define __QPPPLOT_H__

#include <qwidget.h>
#include <qpixmap.h>
#include "../generic/PPlot.h"

class InteractionContainer;
class DefaultInteractionContainer;

class QPPlotBase: public QWidget, public Painter {
  Q_OBJECT 
  public:
    /** construtor */
    QPPlotBase(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~QPPlotBase();

    virtual void paintEvent (QPaintEvent *inEvent);


    virtual void DrawLine (float inX1, float inY1, float inX2, float inY2);
    virtual void FillRect (int inX, int inY, int inW, int inH);
    virtual void InvertRect (int inX, int inY, int inW, int inH);
    virtual void SetClipRect (int inX, int inY, int inW, int inH);
    virtual void SetLineColor (int, int, int);
    virtual void SetFillColor (int, int, int);
    virtual long GetWidth () const {return width ();};
    virtual long GetHeight () const {return height ();};
    virtual long GetFontHeight () const {return 12;};
    virtual long CalculateTextDrawSize (const char *inString);
    virtual void DrawText (int inX, int inY, const char *inString);
    virtual void DrawRotatedText (int inX, int inY, float inDegrees, const char *inString);
    virtual void SetStyle (const PStyle &inStyle);

    void SetPDrawer (PDrawer *inPDrawer) {mPDrawer = inPDrawer;};

    virtual PPlot & GetPPlot ()=0;
    virtual InteractionContainer & GetInteractionContainer ()=0;
 protected:
    QPainter *mPainter;
    QPen *mPen;
    QFont *mFont;

    PDrawer *mPDrawer;
signals:
    void StartDraw ();
    void EndDraw ();
    void QPPlotDeleted ();
    void QPPlotPressed (QPPlotBase *inQPPlot);
protected:
   void        keyPressEvent( QKeyEvent * );
   void        mouseDoubleClickEvent( QMouseEvent * );
    void mousePressEvent ( QMouseEvent * e ) ;
    void mouseReleaseEvent ( QMouseEvent * e ) ;
    void mouseMoveEvent ( QMouseEvent * e ) ;

};


class QPPlot : public QPPlotBase {
  Q_OBJECT 
  public:
    /** construtor */
    QPPlot(QWidget* parent=0, const char *name=0);
    ~QPPlot ();

    virtual PPlot & GetPPlot () {return mPPlot;};
    virtual DefaultInteractionContainer & GetDefaultInteractionContainer () {return *mDefaultInteractionContainer;};
    virtual InteractionContainer & GetInteractionContainer () {return *mInteractionContainer;};
    PPlot mPPlot;
    DefaultInteractionContainer *mDefaultInteractionContainer;
    InteractionContainer *mInteractionContainer;
};

#endif
