#!/bin/sh

TARGETDIR=../generic

echo "$0: installing make files for pplot library"

PPLOTCFLAGS=
PPLOTLDFLAGS=
QTPPLOTLIBS=

# define this envirnonment varialbe to get ruby support!
# (should say: where is ruby.h located?)
if [ -f $RUBYINCL/ruby.h ]
then
    echo "ruby detected"
    PPLOTCFLAGS="-I $RUBYINCL -DRUBY"
    PPLOTLDFLAGS="-lruby"
    QTPPLOTLIBS="../ruby/pplot_wrap.o -lutil -lruby"
fi
if  [ -f $PYTHONINCL/Python.h ]
then
    echo "python detected"
    PPLOTCFLAGS="$PPLOTCFLAGS -I $PYTHONINCL -DPYTHON"
    PPLOTLDFLAGS="$PPLOTLDFLAGS -lpython"
# this is not really cool yet
    QTPPLOTLIBS="$QTPPLOTLIBS ../python/build/temp.freebsd-4.8-RELEASE-i386-2.3/pplot_wrap.o -L/usr/local/lib/python2.3/config -lpython2.3 -Wl,--export-dynamic"
fi
echo "cflags $PPLOTCFLAGS"
echo "ldflags $PPLOTLDFLAGS"
echo "qtlibs $QTPPLOTLIBS"

if ! m4 -D_PPLOTLDFLAGS_="$PPLOTLDFLAGS" -D_PPLOTCFLAGS_="$PPLOTCFLAGS" Makefile.pplotlib > $TARGETDIR/Makefile
then
    exit 1
fi


if ! cp Makefile.generic $TARGETDIR/
then
  exit 1
fi

if ! m4 -D_QTPPLOTLIBS_="$QTPPLOTLIBS" qpplotdemo.pro.template > ../qt/qpplotdemo.pro
then
    exit 1
fi


echo "$0: configuring qt example"
if ! cd ../qt
then
  exit 1
fi

echo "$0: using qmake to generate makefile"
if ! qmake -o Makefile qpplotdemo.pro
then
    exit 1
fi
echo "$0: OK"
