#import "MainController.h"
#import <PPlotPython/PPlotView.h>
#import <PPlotPython/CocoaPainter.h>
#import <PPlotPython/PythonPPlotInterface.h>

@implementation MainController


-(void)awakeFromNib {
    [scriptTextView setString:[NSString stringWithContentsOfFile:
        [[NSBundle mainBundle] pathForResource:@"example" ofType:@"py"]]];
}


-(IBAction)plot:(id)sender {
    PythonPPlotInterface interface;
    id pplotPath = [[NSBundle mainBundle] pathForResource:@"pplot" ofType:@"py"];
    pplotPath = [pplotPath stringByDeletingLastPathComponent];
    id importPPlot = [NSString stringWithFormat:@"import sys\nsys.path.append('%@')\n", pplotPath];
    id script = [scriptTextView string];
    id fullString = [importPPlot stringByAppendingString:script];
    interface.ApplyScript( [pplotView cocoaPainter]->mPPlot, [fullString cString] );
    [pplotView setNeedsDisplay:YES];
}


@end
