#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# ﾏﾙﾁｽﾚｯﾄﾞｻｰﾊﾞｰ用 module組み込みｻﾝﾌﾟﾙ(bottle/flask共通)

#############################################################################################
class ModuleTest :
	#############################################################################################
	# ｵﾌﾞｼﾞｪｸﾄﾃｽﾄ用の設定
	def __init__(self,debug=False):
		self.debug	= debug					# ﾃﾞﾊﾞｯｸﾞﾌﾗｸﾞ
		self.empData = {}

		self.empData['C00000'] = 'ああああ'
		self.empData['C11111'] = 'いいいい'
		self.empData['C22222'] = 'うううう'

	#############################################################################################
	def getName(self,empNo=None):
		return self.empData.get(empNo,'不明')

	#############################################################################################
	# 終了時に呼ばれるﾒｿｯﾄﾞ(無くてもよい)
	def close(self):
		''' 内部変数を初期化します｡ '''
		pass

#############################################################################################
# ogServer.py で、bottle/flask に組み込むためのﾌｯｸ
def new_obj(debug=False):
	'''
		filter/module/subapp処理を行うｸﾗｽのｲﾝｽﾀﾝｽを生成します｡

		:return	:	(filterｲﾝｽﾀﾝｽ,moduleｲﾝｽﾀﾝｽ,subappｲﾝｽﾀﾝｽ)の辞書
	'''
	module = ModuleTest(debug)

	# ﾓｼﾞｭｰﾙのIDは、xxxx_module の xxxx部分('_'でsplitした先頭)が自動で設定されます。
	# それを強制的に変更する場合は、MOD_NAME 属性を追加します。(こちらが優先されます)
	module.MOD_NAME = 'modname'

	return {'module':module}

################################################
# 動作確認用のテストプログラムです。
def main(argDic):

	module = ModuleTest()

	empno = argDic.get('empno')
	name  = module.getName(empno)

	print( 'empno={} Name={}'.format(empno,name) )

	print( '========' )
	for k,v in module.empData.items() :
		print( 'empno={} Name={}'.format(k,v) )

################################################
# main関数を呼び出します
################################################
if __name__=='__main__':
	print( 'python test_module.py [empno]' )

	argDic = {'empno':None}

	import sys								# 引数の読み込み用
	args = sys.argv
	argDic['fname'] = args[0]
	if len(args) > 1 : argDic['empno'] = args[1]

	main(argDic)
