#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# ﾏﾙﾁｽﾚｯﾄﾞｻｰﾊﾞｰ用 module組み込みｻﾝﾌﾟﾙ(bottle/flask共通)

import time								# sleep用
import threading						# ｽﾚｯﾄﾞ生成
from datetime	import datetime			# 現在時刻 の取得用

#############################################################################################
class CallbackTest :
	#############################################################################################
	# ｵﾌﾞｼﾞｪｸﾄﾃｽﾄ用の設定
	def __init__(self,debug=False):
		self.debug	= debug					# ﾃﾞﾊﾞｯｸﾞﾌﾗｸﾞ
		self.callback = None				# 検出したｺｰﾄﾞに変化が発生した場合のｺｰﾙﾊﾞｯｸ

	#############################################################################################
	# callback ｵﾌﾞｼﾞｪｸﾄとしては必須ﾒｿｯﾄﾞ
	def setCallback(self,callback):
		self.callback = callback

	#############################################################################################
	def start(self):
		cnt = 0
		while True :
			now = datetime.today()
			ymd = now.strftime( '%Y/%m/%d %H:%M:%S' )	# 年/月/日 時:分:秒

			if self.callback :
				msgJson = {'count':cnt , 'ymd':ymd}
				self.callback( msgJson )				# json形式でﾒｯｾｰｼﾞを渡す。

				cnt += 1

			time.sleep( 5 )

#############################################################################################
# ogServer.py で、bottle/flask に組み込むためのﾌｯｸ
def new_obj(debug=False):
	'''
		filter/module/subapp処理を行うｸﾗｽのｲﾝｽﾀﾝｽを生成します｡

		:return	:	(filterｲﾝｽﾀﾝｽ,moduleｲﾝｽﾀﾝｽ,subappｲﾝｽﾀﾝｽ)の辞書
	'''
	callTest = CallbackTest(debug)
	thread = threading.Thread(target=callTest.start)
	thread.setDaemon(True)			# Trueで、メインスレッドが終了した瞬間にプログラム全体が終了(サブスレッドも終了)
	thread.start()

	return {'callback':callTest}

################################################
def callback( data ) :
	if data :
		cnt = data.get('count')
		ymd = data.get('ymd')

		print( '{:5d} {}'.format(cnt,ymd) )

#############################################################################################
def sysExit(signo, frame):
	print( "Ctl+C 終了" )
	import sys
	sys.exit(0)

################################################
# 動作確認用のテストプログラムです。
def main():

	callTest = CallbackTest(True)

	thread = threading.Thread(target=callTest.start)
	thread.setDaemon(False)			# Falseで、メインスレッドが終了しても残り続ける。
	thread.start()

	callTest.setCallback( callback )					# callback関数を設定する

################################################
# main関数を呼び出します
################################################
if __name__=='__main__':
	print( 'python test_callback.py' )

	main()
