/*
 * mark.js
 *
 * マウスダウンで始点を、マウスアップで終点を指定した座標値を
 * ajaxで非同期ﾘｸｴｽﾄで送信します。
 * 要素の座標位置は、ｸﾘｯｸ位置(画面全体に対する座標)から、
 * 要素の位置を引いた値になります。
 * 画像など、ｵﾘｼﾞﾅﾙのｻｲｽﾞとﾌﾞﾗｳｻﾞ上のｻｲｽﾞが異なるｹｰｽもあるため、
 * 要素の幅(width)と高さ(height)、ｸﾘｯｸ座標(始点のX,Y、終点のX,Y)
 * をjson文字列に変換して、/filter にPOST しています。
 */

$(function(){
	$('#img_C').mousedown( function(event)		{ mark('0',event); });
	$('#img_C').mouseup(   function(event)		{ mark('1',event); });
	$('#img_C').mousewheel(function(event,mov)	{ mark('2',event,mov); });
	$('#writebtn' ).click( function() { write();  });
	$('#changebtn').click( function() { change(); });
});

// マウスダウンで始点を記録
var stX = 0;
var stY = 0;

function mark( flag,event,mov ) {
	// 要素の位置を取得
	let clientRect = event.target.getBoundingClientRect() ;
	let positionX = clientRect.left + window.pageXOffset ;
	let positionY = clientRect.top  + window.pageYOffset ;

	// 要素内におけるクリック位置を計算
	let x = event.pageX - positionX ;
	let y = event.pageY - positionY ;

	// 要素の大きさを取得(ｸﾗｲｱﾝﾄ側で拡大・縮小されている可能性あり)
	let width  = clientRect.width ;
	let height = clientRect.height ;

	// flag は、ダウン=0 , アップ=1
	if( flag == '0' ) {				// マウスダウン時の位置が、開始XY
		stX = x ;
		stY = y ;
	}
	else {
		let data ;
		if( flag == '1' ) {			// マウスアップ時の位置が、終了XY
			// jsonﾃﾞｰﾀの作成
			data = JSON.stringify({
				width : width  ,
				height: height ,
				stX   : stX ,
				stY   : stY ,
				edX   : x ,
				edY   : y ,
			});
		}
		else if( flag == '2' ) {	// マウスホイール操作時
			// jsonﾃﾞｰﾀの作成
			data = JSON.stringify({
				wheel : mov ,
				width : width  ,
				height: height ,
				whX   : x ,
				whY   : y ,
			});
		}

		// ajax で bottle の/markにPOST する
		$.ajax({
			method: 'POST',
			url: '/mark',
			data: data,
			contentType: 'application/json',
		}).then(
			error => console.log(error)
		);
	}
};

function write() {
	$.ajax({
		method: 'GET',
		url: '/write',
	}).then(
		error => console.log(error)
	);
};

function change() {
	$.ajax({
		method: 'GET',
		url: '/change',
	}).then(
		error => console.log(error)
	);
};
