#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# bottle と waitress を使用した､ﾏﾙﾁｽﾚｯﾄﾞAPｻｰﾊﾞｰです｡
#
# --filter ｵﾌﾟｼｮﾝにより、ｽﾄﾘｰﾐﾝｸﾞされた画像にﾌｨﾙﾀﾘﾝｸﾞ処理が行えます。
#          filterﾓｼﾞｭｰﾙにも、bottleのﾙｰﾃｨﾝｸﾞをﾏｰｼﾞ処理することが可能です。
# --module ｵﾌﾟｼｮﾝにより、bottleのﾙｰﾃｨﾝｸﾞをﾏｰｼﾞ処理することが可能です。
#
# 画像のﾌｨﾙﾀｰ処理は､mjpg-streamer の input_opencv.so の 互換を意識した作りです｡
#

from datetime import datetime				# filter ｻﾝﾌﾟﾙで日時表示用

import argparse								# 引数の取り込み
from importlib import import_module			# 動的 import(ﾓｼﾞｭｰﾙを動的読み込み)

# import flask
import bottle								# ｱﾌﾟﾘｹｰｼｮﾝｻｰﾊﾞｰ
from waitress import serve					# ﾏﾙﾁｽﾚｯﾄﾞｻｰﾊﾞｰ

from camera import Camera					# openCVｶﾒﾗ読取ﾏﾙﾁｽﾚｯﾄﾞｸﾗｽ

################################################
def enc( key ) :
	return bottle.request.params.getunicode(key, encoding='utf-8') or ""

################################################
def gen(camera,skip=0):
	"""Video streaming generator function."""
	cnt = 0
	btimg = None

	yield b'--frame\r\n'
	while True:
		if cnt < skip and btimg is not None :			# 120ﾌﾚｰﾑ返すまで画面表示されない対策
			cnt += 1									# 無限に数字が加算されるのを避けるため
			yield btimg									# 意味不明だが、openCVのFPSが遅いので
			continue									# 表示されるまでに数秒～数十秒かかるため

		frame = camera.get_frame()
		btimg = b'Content-Type: image/jpeg\r\n\r\n' + frame + b'\r\n\r\n--frame\r\n'

		yield btimg

################################################
def main(argp):
	'''
		main関数

		:param argp		: ArgumentParserでﾊﾟｰｽ処理された引数
	'''

	TITLE = 'openCV ｲﾒｰｼﾞｽﾄﾘｰﾐﾝｸﾞ'

	# ﾓｼﾞｭｰﾙは、辞書にして、action時に引数のｷｰでｵﾌﾞｼﾞｪｸﾄを渡す。後で close() ﾒｿｯﾄﾞを行う。
	modules = {}

	###### 変数の定義(ｴﾗｰ発生時に finallyで変数未定義を防ぐため) #####
	cam = None
	debug = argp.debug
	try :
		app = bottle.Bottle()						# bottle ｱﾌﾟﾘｹｰｼｮﾝｻｰﾊﾞｰ
	#	テンプレートフォルダを viewsから変えたい場合(例えば、Flaskに合わせる…とか)
	#	bottle.TEMPLATE_PATH += ['./templates']

#		app = flask.Flask(__name__)						# Flask  ｱﾌﾟﾘｹｰｼｮﾝｻｰﾊﾞｰ
#		# ﾃﾝﾌﾟﾚｰﾄﾌｫﾙﾀﾞを templatesから変えたい場合(例えば､bottleに合わせる…とか)
#		app = flask.Flask(__name__, template_folder="views")

		cam = Camera(devno=argp.devno,width=argp.width,height=argp.height)
		cam.info()

		###### module 処理(plug in) #####
		print( '  module={}'.format(argp.module) )
		for fin in argp.module :
			module = import_module(fin)				# filter名でﾓｼﾞｭｰﾙを動的読み込み
			modDic = module.new_obj()				# ﾓｼﾞｭｰﾙ生成を行う new_obj() は必須とする｡

			filter = modDic.get( 'filter' )			# filterｵﾌﾞｼﾞｪｸﾄを取得(無ければ､None)
			if filter : cam.add_filter( filter )

			subapp = modDic.get( 'subapp' )
			if subapp : app.merge(subapp)				# bottle ｵﾌﾞｼﾞｪｸﾄをﾏｰｼﾞします
#			if subapp : app.register_blueprint(subapp)	# Flask ｵﾌﾞｼﾞｪｸﾄをﾏｰｼﾞします

			modobj = modDic.get( 'module' )
			if modobj :
				modkey = 'dummy'					# 仮の名前(template内でmoduleにｱｸｾｽできるｷｰ)
				if hasattr(modobj,'MOD_NAME') :
					modkey = modobj.MOD_NAME		# MOD_NAME が規程されていれば、その値を使う
				else :
					lst = fin.split('_')			# xxxx_module などの、xxx をｷｰにする。
					modkey = lst[0]
				modules[modkey] = modobj			# modkeyの値が、template 内で使用できる。

		###### action ﾙｰﾃｨﾝｸﾞ処理 #####
		@app.route('/')
		@app.route('/<name>')			# nameは / を含まない。階層まで考慮するなら、<name:path> とします。
		def index(name='index.html'):	# nameの初期値設定が無いと、'/' でｴﾗｰになる。
			'''
				URLﾄｯﾌﾟと、?action=XXXX による画面振り分けﾙｰﾃｨﾝｸﾞを行います。
				actionのﾊﾟﾗﾒｰﾀが存在しないときは､初期値に､"index" を設定します｡

				:return : templateの適用
			'''
			# /?action=XXXX で､振り分け画面を指定します｡
			url = bottle.request.params.get( "action",name )	# action 優先
#			url = flask.request.args.get( "action",name )

			if url is None or len(url)==0 :
				url = 'index.html'								# index の拡張子は､'tpl', 'html', 'thtml', 'stpl' の何れか
			elif url == 'stream' :								# /?action=stream でも､/stream でもｱｸｾｽ可
				return stream()
			elif url == 'snapshot' :							# /?action=snapshot でも､/snapshot でもｱｸｾｽ可
				return snapshot()
			elif url == 'favicon.ico' :							# Edge の先読み機能？
				return ''										# ｱﾄﾞﾚｽ入力だけでﾘｸｴｽﾄされるが、存在しないｴﾗｰになる

			prmDic = {}
			for k in bottle.request.params.keys() :
				prmDic[k] = enc(k)

			params = dict( { "title":TITLE ,"enc":enc } , **modules, **prmDic )		# title,enc,ﾓｼﾞｭｰﾙ,ﾊﾟﾗﾒｰﾀ を設定
#			params = dict( { "title":TITLE } , **flask.request.args , **prmDic )	# title,enc,ﾊﾟﾗﾒｰﾀ を設定

			return bottle.template(url,params)							# ﾃﾝﾌﾟﾚｰﾄの初期ﾌｫﾙﾀﾞは､views
#			return flask.render_template(url,params=params,**modules)	# ﾃﾝﾌﾟﾚｰﾄの初期ﾌｫﾙﾀﾞは､templates

		###### static ﾙｰﾃｨﾝｸﾞ処理 #####
		# bottle の場合､static ﾙｰﾃｨﾝｸﾞ は､記述が必要｡Flask では不要
		@app.route('/static/<file:path>')
		def static( file ):
			'''
				static 以下は､静的ﾌｧｲﾙをそのまま返します。

				:return : static/以下の静的ﾌｧｲﾙ
			'''
			return bottle.static_file( file, root="./static" )

		###### stream ﾙｰﾃｨﾝｸﾞ処理 #####
		@app.route('/stream')
		def stream():
			'''
				Cameraｵﾌﾞｼﾞｪｸﾄの movie関数を呼び出します。

				:return : mjpeg 動画生成のｼﾞｪﾈﾚｰﾀ
			'''

	#		resp = bottle.HTTPResponse(status=200)
	#		resp.content_type = 'multipart/x-mixed-replace;boundary=frame'
	#		resp.body = gen(cam)
	#		return resp

			bottle.response.content_type = 'multipart/x-mixed-replace;boundary=frame'
			return gen(cam,argp.skip)

#			return flask.Response(gen(cam,argp.skip),
#						mimetype='multipart/x-mixed-replace; boundary=frame')

		###### snapshot ﾙｰﾃｨﾝｸﾞ処理 #####
		@app.route('/snapshot')
		def snapshot():
			'''
				Cameraｵﾌﾞｼﾞｪｸﾄの snap関数を呼び出します。

				:return : jpeg 静止画
			'''
			bottle.response.content_type = 'image/jpeg'
			return cam.get_frame()

#			return flask.Response(cam.get_frame() , mimetype='image/jpeg')

		###### ｻｰﾊﾞｰ起動(bottle を引数に､waitress を起動) #####
		# ※ ﾏﾙﾁｽﾚｯﾄﾞでないと、ajaxが処理されない？のか、動かなくなる。
		# app.run(host='localhost', port=8080, reloader=True, debug=True)
		# app.run(host='0.0.0.0'  , port=8088, reloader=True, debug=True)
		# waitress では、debug は、logging を使うみたい。
		#          , host=制限なし , port=8088     ,threads=20
		serve( app , host='0.0.0.0', port=argp.port,threads=argp.threads )	# waitressのthreadsの初期値は 4

	###### Ctl+C,Exception,finallyでclose処理 #####
	except KeyboardInterrupt  : 				# Ctl+Cが押されたらﾙｰﾌﾟを終了
		print( "\nCtl+C Stop" )
	except Exception as ex:
		print( datetime.today().strftime( '%Y/%m/%d %H:%M:%S' ) )
		print( ex )								# 例外処理の内容をｺﾝｿｰﾙに表示
		import traceback
		traceback.print_exc()					# Exception のﾄﾚｰｽ
	finally :
		if cam : cam.close()					# filter の close() は、cam で実行

		for modobj in modules.values() :
			# close 属性を持ち、実行可能な場合のみ、close 処理を行います。
			if hasattr(modobj,'close') and callable(modobj.close) :
				modobj.close()

		print( "main 終了" )

################################################
# main関数を呼び出します
################################################
if __name__=='__main__':
	# add_argument_group とか、parents=[parser1,parser2,parser3] とか、
	# 色々がんばりましたが、動的組み込みﾓｼﾞｭｰﾙのﾊﾟﾗﾒｰﾀ設定が
	# うまくできませんでした。

	parser = argparse.ArgumentParser(description='ﾏﾙﾁｽﾚｯﾄﾞ AP Server')
	group = parser.add_mutually_exclusive_group()			# 排他ｸﾞﾙｰﾌﾟ
	group.add_argument('--devno'	, type=int, default=0   ,help='ｶﾒﾗのﾃﾞﾊﾞｲｽﾎﾟｰﾄ番号')
	group.add_argument('--skip'		, type=int, default=120 ,help='ｶﾒﾗ表示遅延対策(120)')

	parser.add_argument('--port'	, type=int, default=8088 , help='Web Server http port(8088)')
	parser.add_argument('--threads'	, type=int, default=20   , help='waitress Server threads(20)')

	parser.add_argument('--width' , type=int, help='openCV FRAME WIDTH')
	parser.add_argument('--height', type=int, help='openCV FRAME HEIGHT')
	parser.add_argument('-m','--module',nargs='+', default=[],help='filter,module,subapp')
	parser.add_argument('--debug' , action='store_true', help='Debug mode')
	argp = parser.parse_args()

	if argp.debug :
		print( '  {}'.format( parser.format_usage() ) )		# コマンドラインの短い説明
		print( '  {}'.format( argp ) )						# 設定された値(Namespace) vars(argp) で辞書に出来る
	#	print( '  {}'.format( vals(argp) ) )				# vars(argp) で辞書に出来る

	main(argp)
