#!/usr/bin/env python
# -*- coding: utf-8 -*-

# https://el.jibun.atmarkit.co.jp/pythonlove/2022/06/2618_videocapture.html#c7
# 7.YouTubeからの読取

import cv2									# openCV のimport
import pafy

################################################
# 動作確認用のﾃｽﾄﾌﾟﾛｸﾞﾗﾑです｡
def main():
	# キャプチャするYouTube動画のURLを設定します
	url = "https://youtu.be/PaCyCcWseO4"

	video = pafy.new(url)
	best = video.getbest(preftype="mp4")
	cap = cv2.VideoCapture(best.url)

	try:
		while True :
			ret,frame=cap.read()			# 戻り値は､読取成否と画像

			cv2.imshow('testCamera',frame)	# 画面に画像を表示

			k = cv2.waitKey(10)				# ｷｰﾎﾞｰﾄﾞ入力待ち(10ms)
											# これがないと､画像が表示されない
			if k == ord('q') or k == 27:	# q または､ESC で終了
				break

	except KeyboardInterrupt  :				# Ctl+Cが押されたらﾙｰﾌﾟを終了
		print( "\nCtl+C Stop" )
	except Exception as ex:
		print( ex )							# 例外処理の内容をｺﾝｿｰﾙに表示
		import traceback
		traceback.print_exc()				# Exception のﾄﾚｰｽ
	finally :
		if cap is not None : cap.release()	# 動画やｶﾒﾗﾃﾞﾊﾞｲｽを閉じる
		cv2.destroyAllWindows()				# すべてのｳｨﾝﾄﾞｳを閉じる
		print( "終了" )

################################################
if __name__ == '__main__':
	main()
