#!/usr/bin/env python
# -*- coding: utf-8 -*-

# https://el.jibun.atmarkit.co.jp/pythonlove/2022/06/2618_videocapture.html#c5
# 5.動画ファイルの書込み

import cv2									# openCV のimport

################################################
# 動作確認用のﾃｽﾄﾌﾟﾛｸﾞﾗﾑです｡
def main():
	cap = cv2.VideoCapture(0)			   # ﾃﾞﾊﾞｲｽ 0 からの画像読取

	# 幅と高さとフレームレートを取得
	w = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
	h = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
	fps = int(cap.get(cv2.CAP_PROP_FPS))

	fourcc = cv2.VideoWriter_fourcc(*'XVID')
	writer = cv2.VideoWriter('output.avi',fourcc, fps, (w,h))

#	# 'M','P','4','V' または、*'MP4V' を指定します。
#   fourcc = cv2.VideoWriter_fourcc('M','P','4','V')
#   writer = cv2.VideoWriter('output.mp4',fourcc, fps, (w,h))

	try:
		while True :
			ret,frame=cap.read()			# 戻り値は､読取成否と画像

			writer.write(frame)				# イメージを書き込む

			cv2.imshow('testCamera',frame)	# 画面に画像を表示

			k = cv2.waitKey(10)				# ｷｰﾎﾞｰﾄﾞ入力待ち(10ms)
											# これがないと､画像が表示されない
			if k == ord('q') or k == 27:	# q または､ESC で終了
				break

	# VideoCapture が未使用なので、cap.release() 不要
	except KeyboardInterrupt  :				# Ctl+Cが押されたらﾙｰﾌﾟを終了
		print( "\nCtl+C Stop" )
	except Exception as ex:
		print( ex )							# 例外処理の内容をｺﾝｿｰﾙに表示
		import traceback
		traceback.print_exc()				# Exception のﾄﾚｰｽ
	finally :
		if writer is not None : writer.release()  # 動画やｶﾒﾗﾃﾞﾊﾞｲｽを閉じる
		if cap is not None : cap.release()	# 動画やｶﾒﾗﾃﾞﾊﾞｲｽを閉じる
		cv2.destroyAllWindows()				# すべてのｳｨﾝﾄﾞｳを閉じる
		print( "終了" )

################################################
if __name__ == '__main__':
	main()
