#!/usr/bin/env python
# -*- coding: utf-8 -*-

# https://el.jibun.atmarkit.co.jp/pythonlove/2022/06/2618_videocapture.html#c4
# 4.静止画ファイルの読取

import cv2									# openCV のimport

################################################
# 動作確認用のﾃｽﾄﾌﾟﾛｸﾞﾗﾑです｡
def main():
	try:
		img = cv2.imread('Lenna.png')		# 静止画ファイルの読取

		height, width, ch = img.shape		# 画像の幅、高さ、ﾁｬﾈﾙ
		size = width * height				# img.size の画素数(ｶﾗｰの場合 3倍)

		# 情報表示
		print("幅：", width)
		print("高さ：", height)
		print("チャンネル数:", ch)
		print("画素数:", size)
		print("データ型：", img.dtype)

		cv2.imshow('testCamera',img)		# 画面に画像を表示

		k = cv2.waitKey(0)					# 0 で無制限に待つ
		if k == ord('q') or k == 27:		# q または、ESC で終了
			return

		cv2.imwrite('Lenna.jpeg', img)		# 画像の書き出し

	# VideoCapture が未使用なので、cap.release() 不要
	except KeyboardInterrupt  :				# Ctl+Cが押されたらﾙｰﾌﾟを終了
		print( "\nCtl+C Stop" )
	except Exception as ex:
		print( ex )							# 例外処理の内容をｺﾝｿｰﾙに表示
		import traceback
		traceback.print_exc()				# Exception のﾄﾚｰｽ
	finally :
		cv2.destroyAllWindows()				# すべてのｳｨﾝﾄﾞｳを閉じる
		print( "終了" )

################################################
if __name__ == '__main__':
	main()
