/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.dnj.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static boolean exists(File file, boolean exception) {
        if (file == null) {
            if (exception) {
                throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u304c[null]\u3067\u3059\u3002");
            }
            return false;
        }
        if (!file.exists()) {
            if (exception) {
                throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb[" + file.getAbsolutePath() + "]\u304c\u3042\u308a\u307e\u305b\u3093");
            }
            return false;
        }
        return true;
    }

    public static String[] readFile(File file) {
        return FileUtils.readFile(file, null);
    }

    public static String[] readFile(File file, String charsetName) {
        if (!FileUtils.exists(file, false)) {
            return new String[0];
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        List lines = new ArrayList();
        try {
            fis = new FileInputStream(file);
            isr = charsetName == null ? new InputStreamReader(new BufferedInputStream(fis)) : new InputStreamReader((InputStream)new BufferedInputStream(fis), charsetName);
            lines = FileUtils._loadLines(isr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (isr != null) {
                isr.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines.toArray(new String[0]);
    }

    private static List _loadLines(InputStreamReader isr) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(100);
        try {
            int c;
            boolean is0d = false;
            do {
                if ((c = isr.read()) == 10 || c == -1 && sb.length() > 0 || is0d) {
                    lines.add(sb.toString());
                    if (sb.length() > 0) {
                        sb = new StringBuffer();
                        if (is0d && c != 10 && c != -1) {
                            sb.append((char)c);
                        }
                    }
                    is0d = false;
                    continue;
                }
                if (c == 13) {
                    is0d = true;
                    continue;
                }
                sb.append((char)c);
            } while (c != -1);
        }
        catch (IOException is0d) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static byte[] readBytes(File file) {
        if (!FileUtils.exists(file, false)) {
            return new byte[0];
        }
        BufferedInputStream in = null;
        byte[] by = new byte[(int)file.length()];
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            int n = in.read(by);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return by;
    }

    public static void writeFile(File file, String[] lines) {
        FileUtils.writeFile(file, lines, null, false);
    }

    public static void writeFile(File file, String[] lines, String charsetName) {
        FileUtils.writeFile(file, lines, charsetName, false);
    }

    public static void writeFile(File file, String[] lines, String charsetName, boolean append) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file, append);
            osw = charsetName == null ? new OutputStreamWriter(new BufferedOutputStream(fos)) : new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), charsetName);
            int i = 0;
            while (i < lines.length) {
                osw.write(lines[i]);
                if (!lines[i].endsWith("\n")) {
                    if (isWindows) {
                        osw.write("\r\n");
                    } else {
                        osw.write("\n");
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (osw != null) {
                osw.flush();
                osw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeBytes(File file, byte[] by) {
        FileUtils.writeBytes(file, by, by.length);
    }

    public static void writeBytes(File file, byte[] by, int len) {
        if (!FileUtils.exists(file, false)) {
            try {
                file.createNewFile();
            }
            catch (Throwable th) {
                th.printStackTrace();
                return;
            }
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            out.write(by, 0, len);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] lists = file.listFiles();
            int i = 0;
            while (i < lists.length) {
                FileUtils.delete(lists[i]);
                ++i;
            }
        }
        file.delete();
    }
}

