/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.dnj;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jp.nanah.dnj.DokonanFrame;
import jp.nanah.dnj.DokonanJar;
import jp.nanah.dnj.util.FileUtils;
import jp.nanah.dnj.util.JarUtils;

public class DokonanJarMain {
    public static final String CONFIG_FILE = "dokonan.conf";
    private Properties prop = new Properties();
    private File outputDir = new File("./libs");
    private List<File> resultFile;
    private DokonanFrame dokoFrame = new DokonanFrame();
    private DokonanJar dokoJar = null;

    public void initProp() {
        FileInputStream fis = null;
        try {
            try {
                String fontname;
                File file = new File(CONFIG_FILE);
                if (!file.exists()) {
                    file.createNewFile();
                }
                fis = new FileInputStream(file);
                this.prop.load(fis);
                String path = this.prop.getProperty("output.dir");
                if (path != null && path.length() > 0) {
                    this.outputDir = new File(path);
                    if (!this.outputDir.exists()) {
                        this.outputDir.mkdirs();
                    }
                }
                if ((fontname = this.prop.getProperty("fontname")) != null && fontname.length() > 0) {
                    this.dokoFrame.fontName = fontname;
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    public void initFrame() {
        this.dokoFrame.initComponent();
        final JButton button = this.dokoFrame.getCopyButton();
        button.addActionListener(new CopyButtonActionListener());
        Thread thread = new Thread(){

            @Override
            public void run() {
                button.setEnabled(false);
                DokonanJarMain.this.dokoJar = new DokonanJar(DokonanJarMain.this.prop);
                int[] counts = DokonanJarMain.this.dokoJar.initSearch();
                button.setEnabled(true);
                DokonanJarMain.this.dokoFrame.getResultArea().setText(String.format("Gradle: %d\u30d5\u30a1\u30a4\u30eb, Maven: %d\u30d5\u30a1\u30a4\u30eb", counts[0], counts[1]));
            }
        };
        thread.start();
        this.dokoFrame.setChangeListener(new TextChangeListener());
        this.dokoFrame.getResultArea().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        String path = e.getURL().getPath().replaceAll("/", "\\\\");
                        Runtime.getRuntime().exec("explorer.exe /select," + path);
                    }
                    catch (Throwable th) {
                        System.out.println("\u30d5\u30a9\u30eb\u30c0\u8868\u793a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    }
                }
            }
        });
        this.dokoFrame.getFrame().setVisible(true);
    }

    public void searchFiles(String path) {
        List<File> tempList;
        String[] texts = this.getSearchTexts(path);
        ArrayList<File> allList = new ArrayList<File>();
        if (this.dokoFrame.getGradleCheckBox().isSelected() && (tempList = this.dokoJar.searchJarForGradle(texts)) != null) {
            allList.addAll(tempList);
        }
        if (this.dokoFrame.getMavenCheckBox().isSelected() && (tempList = this.dokoJar.searchJarForMaven(texts)) != null) {
            allList.addAll(tempList);
        }
        StringBuilder sb = new StringBuilder();
        for (File f : allList) {
            if (sb.length() > 0) {
                sb.append("<br/>");
            }
            sb.append(this.toPathText(f, texts));
        }
        this.dokoFrame.getResultArea().setText(sb.toString());
        this.resultFile = allList;
    }

    private String toPathText(File file, String[] texts) {
        boolean hasClass;
        String fullpath = file.getAbsolutePath();
        int filenameIndex = fullpath.lastIndexOf(File.separator) + 1;
        String beforeLastFolder = fullpath.substring(0, filenameIndex);
        String filename = fullpath.substring(filenameIndex);
        String dispname = filename.substring(0, filename.length() - 4);
        int i = 0;
        while (i < texts.length) {
            dispname = dispname.replaceAll(texts[i], "<b>" + texts[i] + "</b>");
            ++i;
        }
        String html_line = String.valueOf(beforeLastFolder) + "<a href='file:" + fullpath + "'>" + dispname + ".jar</a>";
        if (file.length() < 10000L && !(hasClass = JarUtils.hasDotClass(file))) {
            html_line = "<font color='silver'>" + html_line + "(\u203bno-class)</font>";
        }
        return html_line;
    }

    private String[] getSearchTexts(String path) {
        String[] texts = path.split(" ");
        int i = 0;
        while (i < texts.length) {
            texts[i] = texts[i].trim();
            if (texts[i].endsWith(".jar")) {
                texts[i] = texts[i].substring(0, texts[i].length() - 4);
            }
            ++i;
        }
        return texts;
    }

    public static void main(String[] args) {
        DokonanJarMain app = new DokonanJarMain();
        app.initProp();
        app.initFrame();
    }

    private class CopyButtonActionListener
    implements ActionListener {
        private CopyButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DokonanJarMain.this.resultFile == null) {
                return;
            }
            TreeMap<String, JarInfo> doneJarInfoMap = new TreeMap<String, JarInfo>();
            StringBuilder sb = new StringBuilder();
            for (File f : DokonanJarMain.this.resultFile) {
                try {
                    String fname = f.getName();
                    byte[] by = FileUtils.readBytes(f);
                    JarInfo ji = new JarInfo();
                    ji.file = f;
                    ji.data = by;
                    JarInfo doneJi = (JarInfo)doneJarInfoMap.get(fname);
                    if (doneJi != null) {
                        if (Arrays.equals(doneJi.data, ji.data)) continue;
                        String fileinfo = String.valueOf(ji.file.getAbsolutePath()) + "," + ji.data.length;
                        boolean isOverwrite = ji.data.length > doneJi.data.length;
                        String warningMessage = isOverwrite ? "overwrited" : "skipped";
                        sb.append("<br/><font color='red'>## file size is different and " + warningMessage + " by " + fileinfo + "</font>");
                        if (!isOverwrite) continue;
                    }
                    File dstFile = new File(DokonanJarMain.this.outputDir, fname);
                    FileUtils.writeBytes(dstFile, by);
                    dstFile.setLastModified(f.lastModified());
                    doneJarInfoMap.put(fname, ji);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            String orgText = DokonanJarMain.this.dokoFrame.getResultArea().getText();
            int bodyEnd = orgText.lastIndexOf("</body>");
            DokonanJarMain.this.dokoFrame.getResultArea().setText(String.valueOf(orgText.substring(0, bodyEnd)) + sb.toString() + orgText.substring(bodyEnd));
        }
    }

    private class JarInfo {
        public File file;
        public byte[] data;

        private JarInfo() {
        }
    }

    private class TextChangeListener
    implements ChangeListener {
        private TextChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            String text = (String)e.getSource();
            DokonanJarMain.this.searchFiles(text);
        }
    }
}

