package jp.nanah.bastub.service;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import jp.nanah.bastub.controller.AnyRestController;
import nanah.oslib.ResUtils;

@Service
public class PathService {

	private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);

	@Value("${pagedata.root:pagedata}")
	private String pagedataPath;

	public static File pageDir;

	@PostConstruct
    public void setupDir() throws Exception {
		pageDir = getPageDir();
    }

    public File getPageDir(){
    	if (pageDir != null){
    		return pageDir;
    	}
		File dir = new File(pagedataPath);
		if (dir.isAbsolute() == false){
			File appRoot = ResUtils.getRootDirAs(this.getClass());
			dir = new File(appRoot, pagedataPath);
		}
		try {
			pageDir = dir.getCanonicalFile();
		} catch (IOException e){
			pageDir = dir.getAbsoluteFile();
		}
		return pageDir;
	}

	public File getPageDataFile(File dir, HttpServletRequest req){
		File file = new File(dir, req.getRequestURI());
		logger.debug("Path=[{}]", file.getAbsolutePath());
		return file;
	}

	@Value("${path_last_slash_valid:1}")
	private int pathLastSlashValid;

	public List<String> getPathList(HttpServletRequest req){
		String reqPath = req.getRequestURI();
		String[] pathArray = reqPath.substring(1).split("/");
		List<String> pathList = Arrays.asList(pathArray); //BastubUtils.toValidList(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);

		if (pathLastSlashValid == 1){
			//URLがスラッシュ終わりなら、ファイル名が""の要求が来たものとする
			logger.info("URL={}, URI={}", req.getRequestURL().toString(), reqPath );
			if (reqPath.endsWith("/")){
				pathList.add("");
			}
		}

		return pathList;
	}


}
