package jp.nanah.bastub.filter;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import jp.nanah.bastub.BastubConsts;
import jp.nanah.bastub.service.PathService;
import jp.nanah.bastub.util.BastubUtils;

@Component
public class ReplaceFilter implements Filter {

	/** 動作ログ */
	private static final Logger logger = LoggerFactory.getLogger(BastubHttpRequest.class);

	@Override
    public void init(FilterConfig filterConfig) throws ServletException {
        System.out.println("init!!");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException{

        System.out.println("doFilter...");

        BastubHttpRequest req = new BastubHttpRequest((HttpServletRequest)request);
		String orgurl = req.getRequestURL().toString();
		String url = orgurl;

		//■差し替え＃１
		//replace.propertiesに定義があればパスをそのまま差し替える
		List<String[]> pathList = getReplacePathList();
		String repurl = replacePath(pathList, orgurl);
		if (repurl != null) {
			logger.debug("replace1: [{}]-->[{}]", url, repurl);
			url = repurl;
		}

		//■差し替え＃２
		//リクエストのURI＋".html"に該当する.htmlファイルがあるとき、
		//そのリクエストはJSON応答ではなくHTMLを返す。
		//今のところThymeleaf対応のみ対応とする。

		String uri = BastubUtils.getUriPath(url);
 		File file = new File(PathService.pageDir, uri + ".html");
		if (file.exists()){

			// Viewに遷移するために拡張子を付加する。AnyViewControllerはこの拡張子のものを処理する
			url = url + BastubConsts.VIEW_TRANS_EXT;
			logger.debug("replace2: -->[{}]", url);
		}

        //Viewファイル
		req.setUrl(url);

		chain.doFilter(req, response);
    }

//    @Override
//    public void destroy() {
//    }


	/**
	 * パスを置き換える。
	 * 置き換えられなかった場合はnullを返す。
	 * @return
	 */
	public String replacePath(List<String[]> pathList, String src){
		logger.debug("置き換え定義数: [{}]", pathList.size());
		for (String[] path : pathList){
			logger.debug("src=[{}]: path=[{}][{}]", src, path[0],path[1]);
			int n = src.indexOf(path[0]);
			if (n >=0){
				return src.replace(path[0], path[1]);
			}
		}
		return  null;
	}

    /**
     * 置き換えファイル。
     */
	private File replaceFile = null;

	/**
     * 初回または更新されたときだけ読み直すために更新時刻を保持。
	 */
	private long lastUpdated = 0;

	/**
	 * 置き換えファイルの中身。
	 * [0]=置き換え前、[1]=置き換え後
	 */
	private List<String[]> replaceList;

	/**
	 * 置き換えパス情報を取得する。
	 * @return
	 */
	public List<String[]> getReplacePathList(){

		if (replaceFile == null){
			URL replaceFileUrl = getClass().getResource("/replace.properties");
			replaceFile = new File(replaceFileUrl.getFile());
		}
		if (replaceList != null){
			if (lastUpdated == replaceFile.lastModified()){
				return replaceList;
			}
		}

		try {
			List<String> lines = FileUtils.readLines(replaceFile); //UTF-8 only
			Map<String, String> sdMap = new TreeMap<String, String>();
			for (String s : lines){
				if (s.startsWith("#")){
					continue;
				}
				s = StringUtils.normalizeSpace(s);
				int n = s.indexOf(" ");
				if (n >= 0){
					String src = s.substring(0, n);
					String dst = s.substring(n).trim();
					sdMap.put(src, dst);
				}
			}


			//長い順に並べる
			replaceList = new ArrayList<String[]>();
			Iterator<String> it = sdMap.keySet().iterator();
			while (it.hasNext()){
				String srcPath = it.next();
				String dstPath = sdMap.get(srcPath);
				replaceList.add(0, new String[]{srcPath, dstPath});
				logger.info("[{}] src=[{}] dst=[{}]", replaceList.size(), srcPath, dstPath);
			}
		} catch (IOException e){
			logger.warn("read_error:{}", replaceFile.getAbsolutePath());
		}

		return replaceList;
	}

}
