package jp.nanah.bastub.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 全体で共通する（一意の）サービスを提供する。
 */
@Component
public class AppInfo {

	/** 動作ログ */
	private static final Logger logger = LoggerFactory.getLogger(AppInfo.class);

	/**
	 * アプリケーション識別値。ログを区別するため。
	 */
	private static String APP_SNO = Long.toString(System.currentTimeMillis()/1000, 36).toUpperCase();

	/**
	 * リクエスト通番。起動するたびに0から始まる。
	 */
	private static long reqNo = 0;

	public long setCurrentThreadName(){
		synchronized (APP_SNO){
			Thread.currentThread().setName(APP_SNO + "_" + reqNo);
			reqNo++;
			return reqNo;
		}
	}

}
