package jp.nanah.bastub.config;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.linkbuilder.AbstractLinkBuilder;
import org.thymeleaf.linkbuilder.StandardLinkBuilder;

@Component
public class BastubLinkBuilder extends AbstractLinkBuilder{

	protected static final Logger logger = LoggerFactory.getLogger(BastubLinkBuilder.class);

    private final StandardLinkBuilder standardLinkBuilder = new StandardLinkBuilder();

	@Override
    public String buildLink(final IExpressionContext context, final String base, final Map<String, Object> parameters) {
		String repbase = base;
		if (base.startsWith("/")){
			if (context instanceof WebEngineContext){
				WebEngineContext webcon = (WebEngineContext)context;
				repbase = getContextRootBase(base, webcon.getRequest().getRequestURI());
	        }
		}

		String link = this.standardLinkBuilder.buildLink(context, repbase, parameters);
		return link;
    }

	/**
	 * パスの先頭にコンテキストルートを追加する
	 * 通常、絶対パス指定の場合、Thymeleafは
	 *     "@{/foo/bar}"→"http://hostname:port/コンテキストルート/foo/bar"
	 * のようなパスを生成するので、何もしなければ
	 *     "@{/foo/bar}"→"http://hostname:port/foo/bar"
	 * または
	 *     "@{/foo/bar}"→"http://hostname:port/bastub/foo/bar"
	 * のようなパスが生成される。
	 * Stubとして動かしたい場合は、元のコンテキストルート(例:example)がパスの中に
	 * 含まれていてほしいので、
	 *     "@{/foo/bar}"→"http://hostname:port/<b>example</b>/foo/bar"
	 *     "@{/foo/bar}"→"http://hostname:port/bastub/<b>example</b>/foo/bar"
	 * というパスが吐き出されるようにする。
	 * @param base
	 * @param uri
	 * @return
	 */
	private String getContextRootBase(String base, String uri){
		int n = uri.indexOf("/", 1);
		if (n > 0){
			base = uri.substring(0, n) + base;
		}
		return base;
	}

}
