/*
 [df:title]
 プルダウン用メッセージタイトル取得
 
 [df:description]
 メッセージ種別ごとに一意な雛形メッセージタイトルを取得する。
 メッセージ種別条件の「すべて」用のタイトルは返すが、タイトル条件の「すべて」は含まれない。
 表示フィルター値は固定（埋め込み）のため、変更時はここを修正すること。
*/

-- #df:entity#

-- !df:pmb!
-- !!AutoDetect!!

-- 「すべて」用
select
	distinct '' as message_kind, '' as disp_filter, coalesce(message_title,'') as message_title
from t_distribution_template
/*BEGIN*/
	/*IF pmb.groupId != null*/
	where group_id = /*pmb.groupId*/'GRP00000000001'
	/*END*/
/*END*/

-- 本来の「種別」と「タイトル」の組み合わせ
union all
select 
	distinct coalesce(message_kind,'') as message_kind, 
	coalesce(message_kind,'----') as disp_filter, 
	coalesce(message_title,'') as message_title
from t_distribution_template
	where 
	(length(message_kind) <> 0 and length(message_kind) <> 0)
	/*IF pmb.groupId != null*/
	and group_id = /*pmb.groupId*/'GRP00000000001'
	/*END*/
order by message_kind, disp_filter, message_title
;