/*
 [df:title]
 最終送信状態取得
 
 [df:description]
 配信ID１つに対応する、各送信宛先ごとの最終送信結果を取得する。
 ※メッセンジャーAPI異常のとき、message_reply_viewから送信ステータスが取れないことをカバーするためのSQL
*/

-- #df:entity#

-- !df:pmb!
-- !!AutoDetect!!

SELECT
	A.group_id
	, A.distribution_id
	, A.distribution_no
	, (SELECT send_sts 
	   FROM t_distribution_message X
	   WHERE X.group_id = A.group_id
	   AND X.distribution_id = A.distribution_id
	   AND X.distribution_no = A.distribution_no) as send_sts
	, A.user_id
FROM
	t_distribution_user A
WHERE
	A.group_id = /*pmb.groupId*/'GRP000000000001'
	AND A.distribution_id = /*pmb.distributionId*/'M000000029'
	AND A.distribution_no = (
		select max(distribution_no)
		from t_distribution_user B
		where A.group_id = B.group_id
		AND A.distribution_id = B.distribution_id
		AND A.user_id = B.user_id
	)
ORDER BY A.group_id, distribution_id, A.distribution_no, A.user_id
;
