//文字コード：UTF-8

//検索条件を取得する
var saveCond;
function getConditionJson(pagemv, sortcol){

	// 検索条件
	var condition = saveCond;
	if (pagemv == 0 && sortcol == "") {
		condition = {
			"ymd_start": $("#jk_ymdStart").val(),
			"ymd_end": $("#jk_ymdEnd").val(),
			"user_id": $("#jk_user_name").val(),
			"patient_id": $("#jk_patient_id").val(),
			"message_kind": $("#jk_message_kind").val(),
			"distribution_source": $("#jk_source").val()
		}
		saveCond = condition;
	}

	//ソート条件取得
	var sort_param = getSortParams(".lmc_th_table table", sortcol);

	//ページ情報取得
	var pno = parseInt($("#page_no").text()) + pagemv;
	pno = (pno < 1) ? 1 : pno;
	var page_info = {
		"page_no": pno,
		"rows_per_page": 20
	};

	//JSON作成
	var jsonData = {
		"condition": condition,
		"sort_params": sort_param,
		"page_info": page_info
	};

	return jsonData;
}

//雛形登録に登録するパラメータを取得する。【MDIF225】
function getTemplateRegistParam(elm){

	var row = getRowNumberFromId(elm);

	// 検索条件
	var jsonData = {
		"template_id": "",
		"message_kind": $("#message_kind_"+row).text(),
		"message_title": $("#message_title_"+row).val(),
		"message_body": $("#message_body_"+row).val(),
		"reply_text1": $("#reply_text1_"+row).val(),
		"reply_text2": $("#reply_text2_"+row).val(),
		"reply_text3": $("#reply_text3_"+row).val(),
		"reply_text4": $("#reply_text4_"+row).val(),
		"reply_text5": $("#reply_text5_"+row).val(),
		"create_user_id": $("#jk_source").val(),
		"update_user_id": $("#jk_source").val(),
		"update_at": null
	};

	return jsonData;
}

//返ってきたJSONに表示に使うデータを追加する
function addDispData(list_data) {
	for (var i=0; i<list_data.length; i++){
		var row_data = list_data[i];

		//総宛先数が2箇所あるので2つ作る
		var rowval = row_data['summary_send'];
		row_data['summary_send1'] = rowval;
		row_data['summary_send2'] = rowval;
	}
}

//表示値ではなくスタイルの個別変更はここで行う
function updateStyle(list_data){
	for (var i=0; i<list_data.length; i++){
		var row_data = list_data[i];

		//【行背景色】
		//未送信＞失敗＞正常の順。
		//送信エラーがある場合は薄青、配信待ちがある場合は薄ピンク（配信待ち優先）
		//メッセージIDが無ければ送信ステータスをそのまま使う
		//メッセージIDがあるときは、複数宛先を考慮する必要があるため
		//    送信ステータス＜10なら未送信
		//    送信ステータス≧10なら送信エラー数>0で薄ピンク
		var className = "lmc_tr";  //通常色クラス
		var msg_onoff = "none";
		var send_status = row_data['send_status'];
		if (row_data['message_id'] != null && row_data['message_id'].length > 0){
			if (send_status < 10){
				//未送信状態を優先
			} else if (row_data['summary_error'] > 0){
				send_status = 11;  //送信エラー
			} else {
				send_status = 10;
			}
		}
		
		if (send_status < 10){
			className = className + " dist_wait_exist";   //送信待ち  ：薄青色
		} else if (send_status > 10){
			className = className + " dist_error_exist";  //エラーあり：薄桃色
			msg_onoff = "inline";
		}
		$("#rowa"+ i).attr('class', className);
		$("#warning_message_"+ i).css('display', msg_onoff);  //エラーメッセージON
		
		//【返信個数】
		$("#reply1_count_"+ i).css('color', row_data['reply1_count'] > 0 ? '#86BA4B' : '#6D6D6D'); //lime : gray
		$("#reply2_count_"+ i).css('color', row_data['reply2_count'] > 0 ? '#86BA4B' : '#6D6D6D');
		$("#reply3_count_"+ i).css('color', row_data['reply3_count'] > 0 ? '#86BA4B' : '#6D6D6D');
		$("#reply4_count_"+ i).css('color', row_data['reply4_count'] > 0 ? '#86BA4B' : '#6D6D6D');
		$("#reply5_count_"+ i).css('color', row_data['reply5_count'] > 0 ? '#86BA4B' : '#6D6D6D');

		//【編集・削除ボタン】
		//※未配信のみ編集可だが、未配信は再送の場合も含むためつまりは送信待ちがあれば編集可とする
		var isWaiting = row_data['summary_wait'] > 0;
		$("#msgedt_"+ i).prop('disabled', isWaiting == false);
		$("#msgdel_"+ i).prop('disabled', isWaiting == false);
	}
}
function updateCondition(condition){
	setValueIfNotSame(saveCond, condition, 'ymd_start' , "#jk_ymdStart");
	setValueIfNotSame(saveCond, condition, 'ymd_end'   , "#jk_ymdEnd");
	setValueIfNotSame(saveCond, condition, 'patient_id', "#jk_patient_id");
	saveCond = condition;
}
