//文字コード：UTF-8

//============================================================

//============================================================
// キー値が指定値を持つ配列のインデックスを返す
//============================================================
function indexOfKey(ary, key, val){
	for (var i=0; i<ary.length; i++){
		if (ary[i] != null){
			if (ary[i][key] == val){
				return i;
			}
		}
	}
	return -1;
}

//■最後のdelimより後ろにある数値を返す
function getTailNumber(txt, delim){
	var idx = txt.lastIndexOf(delim);
	var num = parseInt(txt.substring(idx+1));
	return num;
}

//■要素のIDから行番号を返す
function getRowNumberFromId(elm){
	var idval = elm.prop("id");
	return getTailNumber(idval, "_");
}

//============================================================
// ボタンが押されたときに対象データが識別しやすいように
// 属性値をセットする。一覧表示とセットで呼び出す。
// idkey     : trタグのID共通部。#は含めない。"ID値＋数値"がIDになる。"row"、"rowa"など。
// list_data : 受信したjsonそのまま。→配列で渡すように改訂する★TODO
// dispcnt   : 最大表示行数。ループ数
// tagparam  : 設定するタグのID情報。IDと設定するJSON側のデータキー名を
//			   { "edtbtn": "template_id", "edtbtn": "template_id" }
//			   { "delbtn": "distribution_id" }
// attr      : セットする属性値。"tid"、"did"など。
//
// 例：
// 	setTargetAttr("rowb", json['dist_messages'], 20, {"distribution_id": "distribution_no"}, "dno");
// HTML側で"distribution_id_NN"となっているタグに、JSONのキー名="distribution_no"の値を
// dno="(distribution_noの値)"となるように設定する。
//============================================================
function setTargetAttr(idkey, list_data, dispcnt, tagparam, attrnam) {

	for (var i=0; i<dispcnt; i++){
		var rowid = "#" + idkey + i;

		var val = "";
		for(key in tagparam){
			if (i < list_data.length){
				val = list_data[i][tagparam[key]];
			}
			var tagid = "#" + key + "_" + i;
			var obj = $(tagid);
			if (obj.length > 0){
				obj.attr(attrnam, val);
			}
		}
	}
}

//■アコーディオン用。行の並びを、AAAABBBB→ABABABABにする。
function insertAccordion(oyaid, koid){
	for (var i=0; i<20; i++){
		var oya = $(oyaid + i);
		var ko = $(koid + i);
		oya.after(ko);
	}
}
function toggleAccordion(idval){
	var rowb = "#rowb" + getTailNumber(idval, "_");

	var disp_val = $(rowb).css("display");
	if (disp_val == "none"){
		$(rowb).css("display", "");
		$(idval).text("▲");
	} else {
		$(rowb).css("display", "none");
		$(idval).text("▼");
	}
}

//===========================================================
// 検索用関数
//===========================================================

//■ソート条件を取得する。
//sort_prio、sort_key、sort_typeを属性値として持っていること前提で
function getSortParams( selector, sortcol ){
	var sort_param = [];
	$(selector).each(function(i, elem) {
		var sort_prio= parseInt($(this).attr("sort_prio"));
		var sort_key = $(this).attr("sort_key");
		var sort_type= $(this).attr("sort_type");  //デフォルトのソート順
		if (sort_type.length == 0){
			sort_type = "1";
		}

		if (sort_key == sortcol){
		
			var imgelm = $("img", this);
		
			sort_prio = 0;
			var path = imgelm.attr("src");
			var abc = path.substring(path.length - 5).substring(0,1);
			//上向きか下向きなら逆にする。そうじゃないなら初期ソート値を変更しない
			if (abc == "A"){
				sort_type = 2;
			} else if (abc == "B"){
				sort_type = 1;
			}
		} else {
			if (sortcol == ""){
				var imgelm = $("img", this);
				var path = imgelm.attr("src");
				var abc = path.substring(path.length - 5).substring(0,1);
				if (abc != "C"){
					sortcol = sort_key;
					sort_prio = 0;
					sort_type = (abc == "A") ? 1 : 2;
				}
			}
		}
		var arg = {"sort_prio": sort_prio
		          ,"sort_key": sort_key
		          ,"sort_type": sort_type};
		sort_param.push(arg);
	});
	sort_param.sort(column_comparator);
	return sort_param;
}

//■表示のソート条件を優先度順に並び替え
function column_comparator(a, b) { 
	return(a["sort_prio"] - b["sort_prio"]); 
}

//■前回ソートの状態を復元する
function setResumeSortParam(selector, sortcol, sorttyp){
	var sort_param = [];
	$(selector).each(function(i, elem) {
		var sort_key = $(this).attr("sort_key");
		if (sort_key != sortcol){
			return true;	//continue;
		}
		var imgelm = $("img", this);
		var imgext = (sorttyp == "1") ? "A.png" : "B.png";
		replacePathExt(imgelm, imgext);
		return false;  //break;
	});
}

//■２つの値が違っているときだけv2側の値を設定する。elmkeyは"#id"形式で指定する。
function setValueIfNotSame(json1, json2, jsonkey, elmkey) { 
	if (json1[jsonkey] != json2[jsonkey]){
		$(elmkey).val(json2[jsonkey]);
	}
}

//【Ajax汎用呼び出し(post用)】
//
function doAjax( apikey, json_req, post_url, okfunc, ngfunc){
	doAjaxM("post", apikey, json_req, post_url, okfunc, ngfunc);
}

//【Ajax汎用呼び出し】
//・一時的に暗くする
//・失敗のときはエラーを出す(popup_message)
//・成功のとき、okfuncを呼び出す。関数がnullなら何もしない。
//・失敗のとき、メッセージボックスを表示する。ngfuncがnullならメッセージボックスを閉じて終了する。
//  ngfuncがあるときはその関数を呼び出す。メッセージボックスは自分で閉じる必要あり。
//・実行確認のダイアログ表示などはこの関数の外で行うこと。
function doAjaxM( method, apikey, json_req, post_url, okfunc, ngfunc){
	//ポップアップはひとまず非表示
	hidePopup();
	
	//apikeyは受け側で未使用だが共通I/Fに合わせて渡すこととする
	if (apikey == ""){
		var ak = $("#apikey").text();
		if (ak != undefined){
			apikey = ak;
		}
	}

    // 通信実行
    $.ajax({
        type : method,  
        url  : post_url,
        data : JSON.stringify(json_req),
		headers: {
        	'Content-Type': 'application/json',
    		'X-Humanbridge-PHR-APIKey': apikey,
			'X-Humanbridge-PHR-DeviceId': 0
  		},
        dataType: "json",

        // 送信前
        beforeSend: function(xhr, settings) {
            showLoading();
        },
        // 応答後
        complete: function() {
            //successやerrorが呼び出されたあとに呼び出される
        },

        // 通信成功時の処理
        success: function(json_res, status, xhr) {   // 200 OK時
			if ( xhr.status != 200 ){
	            hideLoadingNow(0);
				//背景を暗くしてメッセージを子画面に出す
				if (ngfunc == undefined){
					showPopup(json_res['popup_message'], ['OK']);
				} else {
					showPopup(json_res['popup_message'], ['OK', ngfunc]);
				}
				removeLoadingBack();
				return;
        	} else {
	            if (isBackContinue == false){
	            	hideLoading(100);
        		}
        		//成功時
    			hidePopup();
				if (okfunc != null){
					if (okfunc.length == 3){
						okfunc(json_res, status, xhr);
        			} else {
        				okfunc();
        			}
        		}
        	}

        },
		// エラー時
        error: function(xhr, textsts, errorThrown) {
            hideLoadingNow();
		    var errmsg = "";
		    try {
		        var json = $.parseJSON(xhr.responseText);
		        errmsg = json["popup_message"];
		        if (errmsg === undefined){
		        	errmsg = "";
		        }
		    } catch (e) {
			    errmsg = "ネットワークに接続できません。";
		    }
		    try {
		    	if (errmsg == ""){
				    errmsg = "システムエラー[" + textsts + "]";
		    	}
				//セッションタイムアウトのときの特別処理
				if ( xhr.status == 408 ){
		        	showPopup(errmsg, ['OK', exitByError]);  //exitByError()はHTML側で実装すること
				} else {
					if (ngfunc == undefined){
			        	showPopup(errmsg, ['OK']);
		        	} else {
			        	showPopup(errmsg, ['OK', ngfunc]);
		        	}
				}
		    } catch (e) {
		    	//例外は無視
		    }
			removeLoadingBack();
        }

    });
}

//===========================================================
// 検索後の表示更新関数
//===========================================================

//■全行に同じデータを追加する。
function addAllRows(ary, key, val){
	for (var i=0; i<ary.length; i++){
		ary[i][key] = val;
	}
}

//■指定した行番号以降を削除する。
//rownumは、１始まり。
function removeRowAfter(elm, rownum){
	$("tr", elm).each(function(i, elem) {
		if ((i+1) >= rownum){
			$(elem).remove();
		}
	});
}

//■テーブル要素の先頭１行目を元にして２行目以降を生成する。
//１行目はコピー元として使用。
//これは保守性を考えてコピーして使うべき。
function replaceTable(tbodyelm, list_data, setfunc){
	//先頭行を取得
	var copy_base = $("tr", tbodyelm).eq(0);
	for(var i=0; i<list_data.length; i++){
		var new_trrow = copy_base.clone();
		setfunc(list_data[i], new_trrow); 
		new_trrow.css("display","");
		tbodyelm.append(new_trrow);
	}

}

//============================================================
// 【検索結果一覧設定】
// 検索結果を一覧に設定する。ソートボタンのON/OFFも行う。
// 
// idkey : trタグのID共通部。#は含めない。"ID値＋数値"がIDになる
// json_data : 受信したjsonそのまま。→配列で渡すように改訂する★TODO
// listkey : 一覧データを格納しているJSONのキー名
// dispcnt : 最大表示行数。ループ数
// dispval : 初回表示値。一覧行は""(=表示)、展開行は"none"(非表示)
//------------------------------------------------------------
//・検索結果が０件のときは「データがありません」を表示
//・検索結果が１件以上のときは表形式で表示
//・ヘッダー部分のソートイメージもON/OFFする
//・渡されるJSONは配列であること
//・テーブル側のタグのIDが "JSONのキー名" + "_" + 数字になっていること
//============================================================
function applyJsonDataToTable(idkey, json_data, list_key, dispcnt, dispval) {
	var list_data = json_data[list_key];

	//一覧に展開
	for (var i=0; i<dispcnt; i++){
		var rowid = "#" + idkey + i;

		if (i >= list_data.length){
			$(rowid).css( "display", "none");
			continue;
		}

		var row_data = list_data[i];
		for(key in row_data){
			var rowval = row_data[key];
			if ($.isArray(rowval)){
				for (var j=0; j<rowval.length; j++){
					setDispValue(key + j, i, rowval[j]);
				}
			} else {
				setDispValue(key, i, rowval);
			}
		}
		$(rowid).css( "display", dispval);
	}
}

function updateInitList() {
	$("#header_tr").attr( "class", "lmc_th_nodata");
}

//データの有り無しで変わる部分を更新する。タグIDは固定とする。
function updateListExists(list_data) {
	if (list_data.length == 0){
		//データなし：「データがありません」＆ソートボタンOFF
		$("#td_nodata").css( "display", "");
		$("#header_tr").attr( "class", "lmc_th_nodata");
	} else {
		//データあり：一覧表示＆ソートボタンON
		$("#td_nodata").css( "display", "none");
		$("#header_tr").attr( "class", "lmc_th_somedata");
	}
}

//ID指定で、要素に表示値を設定する。
function setDispValue(key, n, dat){
	var id = "#" + key + "_" + n;
	var elm = $(id);
	if(!elm[0]){
		//タグが無い
		return;
	}
	var tag = elm.prop("tagName");
	if (tag == "INPUT"){
		elm.val(dat);
	} else if (tag == "IMG"){
		replacePathExt(elm, dat);
	} else {
		elm.text(dat);
	}
}

//■ソートボタンの向きを設定する。ON/OFFは別で行う。
function updateSortImage(json_data){
	var sort_param = json_data['sort_params'];

	//tableタグにソート情報を設定
	$("table", $(".lmc_th_table")).each(function(i, elem) {
		var sort_key = $(this).attr("sort_key");
		if (sort_key == null){
			return true; //continue
		}
		var n = indexOfKey(sort_param, "sort_key", sort_key);
		var image_name = "C.png";
		if (n == 0){
			var sort_type= sort_param[n]['sort_type'];	//$(this).attr("sort_type");
			if(sort_type == 1){
				image_name= "A.png";
			} else {
				image_name= "B.png";
			}
		}
		var imgelm = $("img", this);
		replacePathExt(imgelm, image_name);
	});
}

//■イメージ要素のパスの最後の文字を置き換える。イメージ差し替え用。
function replacePathExt(imgelm, ext){
	var org_path = imgelm.attr("src");
	var new_path = org_path.substring(0, org_path.length - ext.length) + ext;
	imgelm.attr("src", new_path);
}

//■ページ情報設定。ページは１始まり。
function updatePageInfo(json_data){
	var page_info = json_data['page_info'];
	var total_count = page_info['total_count'];
	var pageno = page_info['page_no'];
	var pagemax = page_info['page_count'];
	if ( total_count == undefined ){
		total_count = 0;
	}
	if ( pageno == undefined ){
		pageno = 0;
	}
	if ( pagemax == undefined ){
		pagemax = 0;
	}
	
	$("#total_count").text(total_count + "件");
	$("#page_no").text(pageno);
	$("#page_count").text(pagemax);
	//前後ボタンも設定
	$("button#prev").attr('disabled', pageno <= 1);
	$("button#next").attr('disabled', pageno >= pagemax);
}


//===========================================================
// 各種ダイアログ
//===========================================================

//ID="popupMessage"を持つタグを作っておく。
//好きなタイミングでshowPopup(msg)を呼び出す。
//改行は、改行コード\nではなく改行タグ<br/>
//
// showPopup("ABC", ["OK"] );
// showPopup("ABC", ["はい", returnOK], ["いいえ"] );


//■TODO
//・ウインドウサイズが変わったときにも中央になること
//・表示位置固定
//============================================================
function showPopup( msg ){
	var popobj = $("#popupMessage");
	popobj.html(msg);
	button = [];
	for (var i=1; i<arguments.length; i++){
		var mesg = arguments[i][0];
		var func = (arguments[i].length < 2) ? hidePopup : arguments[i][1];
		var argv = (arguments[i].length < 3) ? null      : arguments[i][2];
		var obj = {text: mesg, click: func, arg: argv};
		button.push( obj );
	}

	$( function() {
		popobj.dialog({
			title: 'システム情報',
			modal: true,
			dialogClass:"lmc_common",
	        buttons: button,
			autoOpen: true,
			modal: true,
			resizable: false,
			   height: 'auto',
			   width: 400

		});
	});
	
}

function hidePopup(){
	var popobj = $("#popupMessage");
	if (popobj.parent().prop("tagName") != "BODY"){
		popobj.dialog( "close" );
	}
}

//============================================================
// Loading中
//============================================================
function writeLoading(){
	document.write("<div id='nowloading_area' class='modal-content'>");
	document.write("<div id='nowloading' class='sk-fading-circle lmc_loading'>");
	document.write("<div class='sk-circle1 sk-circle'></div>");
	document.write("<div class='sk-circle2 sk-circle'></div>");
	document.write("<div class='sk-circle3 sk-circle'></div>");
	document.write("<div class='sk-circle4 sk-circle'></div>");
	document.write("<div class='sk-circle5 sk-circle'></div>");
	document.write("<div class='sk-circle6 sk-circle'></div>");
	document.write("<div class='sk-circle7 sk-circle'></div>");
	document.write("<div class='sk-circle8 sk-circle'></div>");
	document.write("<div class='sk-circle9 sk-circle'></div>");
	document.write("<div class='sk-circle10 sk-circle'></div>");
	document.write("<div class='sk-circle11 sk-circle'></div>");
	document.write("<div class='sk-circle12 sk-circle'></div>");
	document.write("</div>");
	document.write("</div>");
}
function showLoading(){
	//画面全体に黒バック
	$('body').append('<div id="loading_layer" class="modal-overlay"></div>');
	$('.modal-overlay').fadeIn();

	//「くるくる」の表示位置を計算
	var nowld_area = $('#nowloading_area');
	modalResize();
	nowld_area.fadeIn();

	$('.modal-overlay, .modal-close').off().click(function(){
		nowld_area.fadeOut();
		$('.modal-overlay').fadeOut('fast',function(){
			$('.modal-overlay').remove();
		});
	});
	
	$(window).on('resize', function(){
		modalResize();
	});
	
	function modalResize(){
		var w = $(window).width();
		var h = $(window).height();
		var ldw = nowld_area.outerWidth(true);
		var ldh = nowld_area.outerHeight(true);
		var x = (w - ldw) / 2;
		var y = (h - ldh) / 2;
		nowld_area.css({'left': x + 'px','top': y + 'px'});
	}

}
//自動的に消えるようにする場合
function hideLoading(speed){
	$('#nowloading_area').fadeOut(speed);
	removeLoadingBack();
}
//ポップアップメッセージを出す前に処理中表示を消す場合は
//すぐに消したい＆後ろの黒バックは残す方が都合がよい。
function hideLoadingNow(){
	$('#nowloading_area').css( "display", "none");
}
//処理中の黒バックを消す
function removeLoadingBack(){
	$('.modal-overlay').remove();
}

//Ajax成功時に黒バックとくるくるを消さないためのフラグ
var isBackContinue = false;
function setLoadingContinue(){
	isBackContinue = true;
}

//============================================================
// キー入力
//============================================================

//■日付選択の表示設定(※要jquery-ui)
//
function setDatepicker(elm){
    elm.datepicker({
        dateFormat:"yy/mm/dd",
        dayNamesMin:["日","月","火","水","木","金","土"],
        monthNames:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],
        nextText:"次>",
        prevText:"<前",
        showMonthAfterYear: true,  //年月で表示
        yearSuffix: '年',
    });
	$(".ui-datepicker").css("font-size","20px");  //0.9emなので大き目にする。
}

//■時刻選択の表示設定(※要timepicker.js)
function setTimepicker(elm){
    elm.timepicker({
        showPeriodLabels: false,
        minutes: {
            manual: [0,30] 
        }
    });
    $("#ui-timepicker-div").css("font-size","18px");
}

//■入力制限：数値のみ
function only_num(event){
	return (event.char.match(/[0-9]/gi) != null);
}

//============================================================
// 画面遷移
//============================================================

//■ログアウト
function callLogout( logoutUrl, loginUrl ){
    setLoadingContinue();
    var callLogin = function (){
		location.href= loginUrl;
    };
	doAjax( "", {}, logoutUrl, callLogin );
}

//■POSTで画面遷移
var postForm = function(url, json) {
    var $form = $('<form/>', {'action': url, 'method': 'post'});
    for(var key in json) {
        $form.append($('<input/>', {'type': 'hidden', 'name': key, 'value': json[key]}));
    }
    $form.appendTo(document.body);
    $form.submit();
};

//============================================================
// CSSスタイル汎用
//============================================================

function setAttr(allelm, attr, dstval){
	allelm.each(function(i, elem) {
		var elm = $(this);
		var srcval = elm.css(attr);
		if (srcval != dstval){
			elm.css(attr, dstval);
		}
	});
}

//イメージチェックボックスのチェックON判定
function isCheckOn(elm){
	var org_path = elm.attr("src");
	var isChecked = org_path.charAt(org_path.length - 5) == "A";
	return isChecked;
}

