#! /usr/bin/env ruby
# coding: utf-8

require "open3"


# ==============================================================================
# Check the latest mozc version
# ==============================================================================

Open3.capture3("wget -N https://raw.githubusercontent.com/google/mozc/master/src/data/version/mozc_version_template.bzl")

file = File.new("mozc_version_template.bzl", "r")
	lines = file.read.split("\n")
file.close

version = ""

lines.length.times do |i|
	if lines[i].index("MAJOR = ") == 0
			version = lines[i].split("MAJOR = ")[1] + "."
			next
	end

	if lines[i].index("MINOR = ") == 0
			version = version + lines[i].split("MINOR = ")[1] + "."
			next
	end

	if lines[i].index("BUILD = ") == 0
			version = version + lines[i].split("BUILD = ")[1]
			break
	end
end

mozcdir = "mozc-" + version + ".102"


# ==============================================================================
# Get the latest mozc
# ==============================================================================

if FileTest.exist?(mozcdir + ".zip") == false
	Open3.capture3("rm -f mozc-*.zip")
	Open3.capture3("wget https://github.com/google/mozc/archive/refs/heads/master.zip -O " + mozcdir + ".zip")
else
	puts mozcdir + ".zip already exists."
end

Open3.capture3("rm -rf mozc-master")
Open3.capture3("unzip " + mozcdir + ".zip")
Open3.capture3("cp mozc-master/src/data/dictionary_oss/id.def .")
Open3.capture3("cat mozc-master/src/data/dictionary_oss/dictionary*.txt > mozcdic.txt")

puts "Compress " + mozcdir + "..."
Open3.capture3("rm -f mozc-*.tar.bz2")
Open3.capture3("rm -rf mozc-master/src/third_party/")
Open3.capture3("mv mozc-master " + mozcdir)
Open3.capture3("tar -cjf " + mozcdir + ".tar.bz2 " + mozcdir)
Open3.capture3("rm -rf " + mozcdir)
