#! /usr/bin/env ruby
# coding: utf-8

require 'nkf'


# ==============================================================================
# organize_jinmei_ut
# ==============================================================================

def organize_jinmei_ut
	file = File.new($filename, "r")
		lines = file.read.split("\n")
	file.close

	l2 = []
	p = 0

	lines.length.times do |i|
		# 全角英数を半角に変換
		lines[i] = NKF.nkf("-m0Z1 -W -w", lines[i])

		s = lines[i].split("	")
		yomi = s[0]
		hyouki = s[-1]

		# 表記の最初が空白の場合は取る
		if hyouki[0] == " "
			hyouki = hyouki[1..-1]
		end

		# 表記の最後が空白の場合は取る
		if hyouki[-1] == " "
			hyouki = hyouki[0..-2]
		end

		# 読みにならない文字を削除したhyouki2を作る
		hyouki2 = hyouki.tr(' !?=:・。★☆', '')

		# hyouki2がひらがなとカタカナだけの場合は、読みをhyouki2から作る
		# さいたまスーパーアリーナ
		if hyouki2 == hyouki2.scan(/[ぁ-ゔァ-ヴー]/).join
			yomi = NKF.nkf("--hiragana -w -W", hyouki2)
			yomi = yomi.tr("ゐゑ", "いえ")
		end

		# 読みが2文字以下の場合はスキップ
		if yomi[2] == nil ||
		# hyouki2が1文字の場合はスキップ
		hyouki2[1] == nil ||
		# hyoukiが26文字以上の場合はスキップ
		hyouki[25] != nil ||
		# 読みの文字数がhyouki2の4倍を超える場合はスキップ
		# けやきざかふぉーてぃーしっくす（15文字） 欅坂46（4文字）
		yomi.length > hyouki2.length * 4 ||
		# hyouki2の文字数が読みの文字数より多い場合はスキップ
		# 英数字表記が削除されるのを防ぐため、hyouki2の文字数は (bytesize / 3) とする。
		# みすたーちるどれんりふれくしょん（16文字） Mr.Children REFLECTION（22bytes / 3）
		# あいしす（16文字） アイシス（48bytes / 3）
		yomi.length < hyouki2.bytesize / 3 ||
		# 読みがひらがな以外を含む場合はスキップ
		yomi != yomi.scan(/[ぁ-ゔー]/).join
			next
		end

		l2[p] =  yomi + "	0	0	6000	" + hyouki
		p = p + 1
	end

	lines = l2
	l2 = []

	# 重複行を削除
	lines = lines.uniq.sort

	dicfile = File.new($dicname, "w")
		dicfile.puts lines
	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".organized"

	organize_jinmei_ut
end
