/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jp.nanah.bastub.data.KvData;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BastubUtils {
    private static final Logger logger = LoggerFactory.getLogger(BastubUtils.class);

    @SafeVarargs
    public static <T> List<T> toValidList(Optional<T> ... vals) {
        ArrayList<T> list = new ArrayList<T>();
        Optional<T>[] optionalArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Optional<T> v = optionalArray[n2];
            if (v.isPresent()) {
                list.add(v.get());
            }
            ++n2;
        }
        return list;
    }

    public static File getPagedataPath(File dir, String filename, String method, String exttext) {
        String[] extarray = exttext.split(",", -1);
        File nofile = null;
        String[] stringArray = extarray;
        int n = extarray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            File fileByMethod = new File(dir, String.valueOf(filename) + "_" + method + ext);
            if (fileByMethod.exists()) {
                return fileByMethod;
            }
            File fileAll = new File(dir, String.valueOf(filename) + ext);
            if (fileAll.exists()) {
                return fileAll;
            }
            if (nofile == null) {
                nofile = fileAll;
            }
            ++n2;
        }
        return nofile;
    }

    public static void replacePathValue(List<String> valueList, List<String> pathList) {
        int i = 0;
        while (i < valueList.size()) {
            int index;
            String val = valueList.get(i);
            if (val.startsWith("$") && (index = Integer.parseInt(val.substring(1)) - 1) < pathList.size()) {
                valueList.set(i, pathList.get(index));
            }
            ++i;
        }
    }

    public static KvData toKvData(List<String> valueList) {
        int n = valueList.size();
        List<String> k = valueList.subList(0, n - 1);
        String v = valueList.get(n - 1);
        KvData kv = new KvData(k, v);
        return kv;
    }

    public static boolean equalsKey(List<String> v1, List<String> v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        int i = 0;
        while (i < v1.size()) {
            if (!v1.get(i).equals(v2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getExtText(String s) {
        int n = s.lastIndexOf(".");
        if (n >= 0) {
            return s.substring(n).toLowerCase();
        }
        return "";
    }

    public static String getUrlDomain(String url) {
        int m;
        int n = url.lastIndexOf("//");
        if (n >= 0 && (m = url.indexOf("/", n + 2)) >= 0) {
            return url.substring(0, m);
        }
        return url;
    }

    public static List<String> getRowValueList(Row row, boolean blankOk) {
        ArrayList<String> keyList = new ArrayList<String>();
        int coltop = row.getFirstCellNum();
        short colend = row.getLastCellNum();
        int i = coltop;
        while (i < colend) {
            Cell cell = row.getCell(i);
            String s = BastubUtils.getCellText(cell);
            if (i == coltop && StringUtils.startsWith((CharSequence)s, (CharSequence)"#")) break;
            if (!StringUtils.isBlank((CharSequence)s) || blankOk) {
                keyList.add(s);
            }
            ++i;
        }
        return keyList;
    }

    public static String getCellText(Cell cell) {
        if (cell == null) {
            return null;
        }
        try {
            if (cell.getCellType() == CellType.STRING) {
                return cell.getStringCellValue();
            }
            if (cell.getCellType() == CellType.NUMERIC) {
                return String.valueOf((int)cell.getNumericCellValue());
            }
            if (cell.getCellType() == CellType.FORMULA) {
                CellType formulaType = cell.getCachedFormulaResultType();
                if (formulaType == CellType.NUMERIC) {
                    return String.valueOf(cell.getNumericCellValue());
                }
                return String.valueOf(cell.getStringCellValue());
            }
            if (cell.getCellType() == CellType._NONE) {
                return cell.getStringCellValue();
            }
        }
        catch (Exception e) {
            logger.warn("\u5909\u63db\u7570\u5e38", (Throwable)e);
        }
        return null;
    }

    public static boolean isBlankRow(Row row) {
        int coltop = row.getFirstCellNum();
        short colend = row.getLastCellNum();
        int i = coltop;
        while (i <= colend) {
            Cell cell = row.getCell(i);
            String s = BastubUtils.getCellText(cell);
            if (StringUtils.isNotBlank((CharSequence)s)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void printJsonTree(String path, JSONObject json) throws JSONException {
        Iterator it = json.keys();
        while (it.hasNext()) {
            String here;
            String key = (String)it.next();
            JSONObject val = json.optJSONObject(key);
            String string = here = StringUtils.isEmpty((CharSequence)path) ? key : String.valueOf(path) + "." + key;
            if (json.optJSONArray(key) != null) {
                JSONArray jsarray = json.getJSONArray(key);
                int i = 0;
                while (i < jsarray.length()) {
                    if (jsarray.optJSONObject(i) != null) {
                        BastubUtils.printJsonTree(String.valueOf(here) + "[" + i + "]", jsarray.getJSONObject(i));
                    }
                    ++i;
                }
                continue;
            }
            if (json.optJSONObject(key) == null) continue;
            BastubUtils.printJsonTree(here, json.getJSONObject(key));
        }
    }

    public static int getColumnNoForReplace(String v, List<Row> rowList, String defaultColumnName) {
        boolean isToNumber = v.endsWith("#N");
        if (isToNumber) {
            v = v.substring(0, v.length() - 2);
        }
        if (v.startsWith("${") && v.endsWith("}")) {
            if (rowList.size() <= 1) {
                return -1;
            }
            String matchName = v.substring(2, v.length() - 1);
            if (matchName.equals("") && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{defaultColumnName})) {
                matchName = defaultColumnName;
            }
            Row row = rowList.get(0);
            int coltop = row.getFirstCellNum();
            short colend = row.getLastCellNum();
            int i = coltop;
            while (i <= colend) {
                String cellv = BastubUtils.getCellText(row.getCell(i));
                if (cellv != null && cellv.equals(matchName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        return -2;
    }

    public static int getNumberLast(String s, int n) {
        int last = s.indexOf("}", n);
        if (last < 0) {
            return -1;
        }
        int i = n - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (c != ':') break;
                return last + 1;
            }
            --i;
        }
        return -1;
    }

    public static boolean isArrayExists(JSONObject json) throws JSONException {
        Iterator it = json.keys();
        while (it.hasNext()) {
            boolean b;
            String key = (String)it.next();
            if (json.optJSONArray(key) != null) {
                return true;
            }
            if (json.optJSONObject(key) == null || !(b = BastubUtils.isArrayExists(json.getJSONObject(key)))) continue;
            return true;
        }
        return false;
    }

    public static boolean isJsonEntry(Map.Entry<String, String[]> ent) {
        String key = ent.getKey().trim();
        String[] val = ent.getValue();
        if (val == null || val.length == 0 || val[0].trim().length() == 0) {
            if (key.startsWith("[") && key.endsWith("]")) {
                return true;
            }
            if (key.startsWith("{") && key.endsWith("}")) {
                return true;
            }
        }
        return false;
    }

    public static boolean equals(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            if (!StringUtils.equals((CharSequence)list1.get(i), (CharSequence)list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsTail(List<String> list1, List<String> list2) {
        int size2;
        int size1 = list1.size();
        if (size1 < (size2 = list2.size())) {
            list2 = list2.subList(size2 - size1, size2);
        } else if (size1 > size2) {
            list1 = list1.subList(size1 - size2, size1);
        }
        return BastubUtils.equals(list1, list2);
    }

    public static List<String> sortIterator(Iterator<String> it) {
        ArrayList<String> keyList = new ArrayList<String>();
        while (it.hasNext()) {
            keyList.add(it.next());
        }
        Collections.sort(keyList);
        return keyList;
    }
}

