/*
 * Decompiled with CFR 0.152.
 */
package jp.nanah.bastub.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nanah.bastub.data.FilterParam;
import jp.nanah.bastub.data.JsonInfo;
import jp.nanah.bastub.data.KvData;
import jp.nanah.bastub.service.JsonService;
import jp.nanah.bastub.service.UsingInfo;
import jp.nanah.bastub.util.BastubUtils;
import nanah.oslib.ResUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AnyRestController {
    private static final Logger logger = LoggerFactory.getLogger(AnyRestController.class);
    private static final Logger reqlog = LoggerFactory.getLogger((String)"REQLOG");
    @Autowired
    private JsonService jsonService;
    private static String APP_SNO = Long.toString(System.currentTimeMillis() / 1000L, 36).toUpperCase();
    private static long reqNo = 0L;
    @Value(value="${path_last_slash_valid:1}")
    private int pathLastSlashValid;
    @Value(value="${pagedata.root:pagedata}")
    private String pagedataPath;
    private static String STATIC_RESOURCE_EXT = ".html.htm.css.js.png.jpg.jpeg";
    private Map<String, Object[]> workbookCache = new TreeMap<String, Object[]>();

    @RequestMapping(path={"/{p1}", "{p1}/{p2}", "{p1}/{p2}/{p3}", "{p1}/{p2}/{p3}/{p4}", "{p1}/{p2}/{p3}/{p4}/{p5}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}/{p10}"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    public String path1(@PathVariable(value="p1") Optional<String> p1, @PathVariable(value="p2") Optional<String> p2, @PathVariable(value="p3") Optional<String> p3, @PathVariable(value="p4") Optional<String> p4, @PathVariable(value="p5") Optional<String> p5, @PathVariable(value="p6") Optional<String> p6, @PathVariable(value="p7") Optional<String> p7, @PathVariable(value="p8") Optional<String> p8, @PathVariable(value="p9") Optional<String> p9, @PathVariable(value="p10") Optional<String> p10, @RequestBody(required=false) ModelMap body, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        return this.path_common(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, (Map)body, model, req, res);
    }

    @RequestMapping(path={"/{p1}", "{p1}/{p2}", "{p1}/{p2}/{p3}", "{p1}/{p2}/{p3}/{p4}", "{p1}/{p2}/{p3}/{p4}/{p5}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}", "{p1}/{p2}/{p3}/{p4}/{p5}/{p6}/{p7}/{p8}/{p9}/{p10}"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE}, consumes={"application/x-www-form-urlencoded"})
    public String path1_multipart(@PathVariable(value="p1") Optional<String> p1, @PathVariable(value="p2") Optional<String> p2, @PathVariable(value="p3") Optional<String> p3, @PathVariable(value="p4") Optional<String> p4, @PathVariable(value="p5") Optional<String> p5, @PathVariable(value="p6") Optional<String> p6, @PathVariable(value="p7") Optional<String> p7, @PathVariable(value="p8") Optional<String> p8, @PathVariable(value="p9") Optional<String> p9, @PathVariable(value="p10") Optional<String> p10, @RequestParam(required=false) Map<String, String> paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        return this.path_common(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, paramMap, model, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String path_common(Optional<String> p1, Optional<String> p2, Optional<String> p3, Optional<String> p4, Optional<String> p5, Optional<String> p6, Optional<String> p7, Optional<String> p8, Optional<String> p9, Optional<String> p10, Map paramMap, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        String string = APP_SNO;
        synchronized (string) {
            Thread.currentThread().setName(String.valueOf(APP_SNO) + "_" + reqNo);
            ++reqNo;
        }
        String method = req.getMethod();
        String reqPath = req.getRequestURL().toString();
        String queryStr = req.getQueryString() == null ? "" : req.getQueryString();
        Object bodyData = paramMap == null ? "" : paramMap;
        reqlog.info("[{}] {}{} {}", new Object[]{method, reqPath, queryStr, bodyData});
        logger.info("== \u25bc == [{}] {}", (Object)method, (Object)reqPath);
        res.setContentType("application/json;charset=UTF-8");
        List<String> pathList = BastubUtils.toValidList(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);
        if (this.pathLastSlashValid == 1 && reqPath.endsWith("/")) {
            pathList.add("");
        }
        String result = this.getAny(pathList, paramMap, model, req, res);
        logger.info("== \u25b3 ==");
        return result;
    }

    public String getAny(List<String> pathList, Map body, ModelMap model, HttpServletRequest req, HttpServletResponse res) {
        try {
            File pageDir = new File(this.pagedataPath);
            if (!pageDir.isAbsolute()) {
                File appRoot = ResUtils.getRootDirAs(this.getClass());
                pageDir = new File(appRoot, this.pagedataPath);
            }
            if (!(pageDir = pageDir.getCanonicalFile()).exists()) {
                String errormsg = "Bastub\u306e\u8a2d\u5b9a\u30d5\u30a9\u30eb\u30c0[" + pageDir.getAbsolutePath() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002application.properties\u306epagedata.root\u3092\u898b\u76f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                logger.info(errormsg);
                return errormsg;
            }
            UsingInfo ui = UsingInfo.getInitInstance(pathList, req);
            String ext = BastubUtils.getExtText(req.getRequestURI());
            if (ext.length() > 0 && STATIC_RESOURCE_EXT.indexOf(ext) >= 0) {
                File htmlFile = BastubUtils.getPagedataPath(pageDir, req.getRequestURI(), req.getMethod(), "");
                res.setContentType("text/html; charset=" + res.getCharacterEncoding());
                String text = FileUtils.readFileToString((File)htmlFile, (String)res.getCharacterEncoding());
                return ui.replaceSring(text);
            }
            String path = StringUtils.join(pathList, (String)"/");
            File dataFile = BastubUtils.getPagedataPath(pageDir, path, req.getMethod(), ".xlsx,.xls");
            File jsonFile = BastubUtils.getPagedataPath(pageDir, path, req.getMethod(), ".json");
            Sheet paramSheet = null;
            Sheet dataSheet = null;
            Workbook wb = this.readWorkbook(dataFile);
            if (wb == null) {
                logger.warn("Excel\u30d5\u30a1\u30a4\u30eb\u7121\u3057\u306e\u305f\u3081JSON\u3092\u56fa\u5b9a\u3067\u5fdc\u7b54 (ExcelFile=[{}])", (Object)dataFile.getAbsolutePath());
            } else {
                paramSheet = wb.getSheet("filter");
                dataSheet = wb.getSheet("data");
                wb.close();
                if (paramSheet == null) {
                    logger.debug("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb[{}]\u306b[filter]\u30b7\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (Object)dataFile.getAbsolutePath());
                }
                if (dataSheet == null) {
                    logger.debug("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb[{}]\u306b[data]\u30b7\u30fc\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", (Object)dataFile.getAbsolutePath());
                }
            }
            this.trimDataSheet(dataSheet);
            List<KvData> requestData = this.getRequestData(req.getParameterMap(), body);
            List<FilterParam> allFilter = this.getFilterParamList(paramSheet);
            List<FilterParam> validFilter = null;
            if (allFilter != null) {
                validFilter = this.getValidFilter(allFilter, requestData, pathList);
            }
            List<Row> resultTarget = this.pickupSheetData(dataSheet, validFilter);
            JsonInfo jsonInfo = this.jsonService.readJsonFile(jsonFile);
            if (jsonInfo.getJsonObject() == null) {
                res.setStatus(404);
                String jsonPath = jsonFile.getAbsolutePath();
                logger.warn("## \u25c6 \u5fdc\u7b54JSON\u7570\u5e38: \u7406\u7531=[{}] \u30d1\u30b9=[{}]", (Object)jsonInfo.getErrorMessage(), (Object)jsonPath);
                String errorJson = "no_file - " + jsonPath.replaceAll("\\\\", "/") + "]";
                return errorJson;
            }
            this.jsonService.setDataToJsonObject(null, jsonInfo.getJsonObject(), resultTarget, ui);
            String jsonText = jsonInfo.getJsonObject().toString(4);
            if (jsonInfo.isTopArray()) {
                int n1 = jsonText.indexOf(":");
                int n2 = jsonText.lastIndexOf("}");
                jsonText = jsonText.substring(n1 + 1, n2);
            }
            res.addHeader("Access-Control-Allow-Origin", "*");
            return jsonText;
        }
        catch (Throwable th) {
            logger.info("\u51e6\u7406\u7570\u5e38: {}", (Object)th.toString());
            return th.toString();
        }
    }

    protected synchronized Workbook readWorkbook(File file) throws IOException {
        Long filetime;
        if (!file.exists()) {
            return null;
        }
        String key = file.getAbsolutePath();
        Object[] cache = this.workbookCache.get(key);
        if (cache != null && (filetime = (Long)cache[0]).longValue() == file.lastModified()) {
            return (Workbook)cache[1];
        }
        Workbook wb = WorkbookFactory.create((File)file, null, (boolean)true);
        this.workbookCache.put(key, new Object[]{file.lastModified(), wb});
        return wb;
    }

    protected void trimDataSheet(Sheet sheet) {
        if (sheet == null || sheet.getLastRowNum() == 0) {
            return;
        }
        Row topRow = sheet.getRow(0);
        int lastColNum = topRow.getLastCellNum() - 1;
        while (lastColNum >= 0) {
            Cell cell = topRow.getCell(lastColNum);
            String s = BastubUtils.getCellText(cell);
            if (StringUtils.isNotBlank((CharSequence)s)) break;
            --lastColNum;
        }
        int rowNum = sheet.getLastRowNum();
        while (rowNum >= 0) {
            Row row = sheet.getRow(rowNum);
            if (row != null) {
                if (BastubUtils.isBlankRow(row)) {
                    sheet.removeRow(row);
                } else {
                    int i = row.getLastCellNum() - 1;
                    while (i > lastColNum) {
                        Cell cell = row.getCell(i);
                        if (cell != null) {
                            row.removeCell(cell);
                        }
                        --i;
                    }
                }
            }
            --rowNum;
        }
    }

    public List<KvData> getRequestData(Map<String, String[]> paramMap, Map body) {
        ArrayList<KvData> paramList = new ArrayList<KvData>();
        if (paramMap != null) {
            int cnt = 0;
            for (Map.Entry<String, String[]> ent : paramMap.entrySet()) {
                if (BastubUtils.isJsonEntry(ent)) continue;
                List<String> key = Arrays.asList(ent.getKey());
                String[] stringArray = ent.getValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    KvData kv = this.appendKvParam(new KvData(key, val), paramList);
                    ++cnt;
                    ++n2;
                }
            }
        }
        if (body != null) {
            int startSize = paramList.size();
            this.appendEntryToParamList(body.entrySet(), null, paramList);
            int i = startSize;
            while (i < paramList.size()) {
                KvData kvData = (KvData)paramList.get(i);
                ++i;
            }
        }
        return paramList;
    }

    private KvData appendKvParam(KvData src, List<KvData> dstList) {
        KvData nowval = null;
        int i = 0;
        while (i < dstList.size()) {
            if (BastubUtils.equals(dstList.get(i).getKey(), src.getKey())) {
                nowval = dstList.get(i);
                break;
            }
            ++i;
        }
        if (nowval == null) {
            dstList.add(src);
            nowval = src;
        } else {
            nowval.addValue(src.getValueAsOne());
        }
        return nowval;
    }

    private void appendEntryToParamList(Set<Map.Entry<String, Object>> set, List<String> parentKeys, List<KvData> paramList) {
        int count = 0;
        for (Map.Entry<String, Object> ent : set) {
            String key = ent.getKey();
            Object val = ent.getValue() == null ? "" : ent.getValue();
            ArrayList<String> thisKeys = new ArrayList<String>();
            if (parentKeys != null) {
                thisKeys.addAll(parentKeys);
            }
            thisKeys.add(key);
            if (val instanceof Map) {
                Map vmap = (Map)val;
                this.appendEntryToParamList(vmap.entrySet(), thisKeys, paramList);
            } else if (val instanceof List) {
                List vlist = (List)val;
                this.appendListToParamList(vlist, thisKeys, paramList);
            } else {
                this.appendToParamList(val, thisKeys, paramList);
            }
            ++count;
        }
    }

    private void appendListToParamList(List<Object> list, List<String> parentKeys, List<KvData> paramList) {
        for (Object o : list) {
            if (o instanceof Map) {
                Map map = (Map)o;
                this.appendEntryToParamList(map.entrySet(), parentKeys, paramList);
                continue;
            }
            if (o instanceof List) {
                List vlist = (List)o;
                this.appendListToParamList(vlist, parentKeys, paramList);
                continue;
            }
            this.appendToParamList(o, parentKeys, paramList);
        }
    }

    private void appendToParamList(Object obj, List<String> parentKeys, List<KvData> paramList) {
        String valstr = obj.toString();
        KvData kv = new KvData(parentKeys, valstr);
        this.appendKvParam(kv, paramList);
    }

    private List<FilterParam> getFilterParamList(Sheet sheet) {
        ArrayList<FilterParam> filterList = null;
        if (sheet == null) {
            return filterList;
        }
        int i = 0;
        while (i <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i);
            List<String> cellList = BastubUtils.getRowValueList(row, false);
            if (cellList.size() >= 3) {
                if (filterList == null) {
                    filterList = new ArrayList<FilterParam>();
                }
                String cellName = cellList.get(0);
                String compType = cellList.get(1);
                List<String> paramKey = cellList.subList(2, cellList.size());
                FilterParam fp = new FilterParam(cellName, compType, paramKey);
                filterList.add(fp);
            }
            ++i;
        }
        return filterList;
    }

    public List<FilterParam> getValidFilter(List<FilterParam> filterParamList, List<KvData> requestData, List<String> pathList) {
        ArrayList<FilterParam> validList = new ArrayList<FilterParam>();
        for (FilterParam fp : filterParamList) {
            int pathNumber;
            String key0;
            if (fp.getRequestKeys().size() > 0 && (key0 = fp.getRequestKeys().get(0)).startsWith("$") && (pathNumber = NumberUtils.toInt((String)key0.substring(1))) > 0 && pathNumber <= pathList.size()) {
                fp.setOneValue(pathList.get(pathNumber - 1));
                validList.add(fp);
                continue;
            }
            List<String> reqKey = fp.getRequestKeys();
            boolean isFound = false;
            String delimText = this.getDelimText(fp.getCompareType());
            for (KvData kv : requestData) {
                if (!BastubUtils.equalsTail(kv.getKey(), reqKey)) continue;
                List<String> fpValues = this.toFilterValue(delimText, kv.getValues());
                fp.setValues(fpValues);
                validList.add(fp);
                isFound = true;
            }
            if (!isFound) {
                logger.warn("HTTP\u30ea\u30af\u30a8\u30b9\u30c8\u5185\u306b\u3001\u9805\u76ee\u5024[{}]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", reqKey);
            }
            if (delimText == null) continue;
            fp.setCompareType("=");
        }
        return validList;
    }

    private String getDelimText(String compareType) {
        int n1 = compareType.indexOf("[");
        int n2 = compareType.indexOf("]");
        if (n1 < 0 || n2 < 0) {
            return null;
        }
        String delim = compareType.substring(n1 + 1, n2);
        return delim;
    }

    private List<String> toFilterValue(String delimText, List<String> org) {
        if (delimText == null) {
            return org;
        }
        ArrayList<String> dst = new ArrayList<String>();
        for (String s : org) {
            dst.addAll(Arrays.asList(s.split(delimText, 0)));
        }
        return dst;
    }

    public List<Row> pickupSheetData(Sheet sheet, List<FilterParam> validFilter) {
        int i;
        ArrayList<Row> noDatasheet = new ArrayList<Row>();
        if (sheet == null) {
            return noDatasheet;
        }
        ArrayList<Row> sheetData = new ArrayList<Row>();
        int i2 = sheet.getFirstRowNum();
        while (i2 <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(i2);
            if (row != null) {
                sheetData.add(sheet.getRow(i2));
            }
            ++i2;
        }
        if (validFilter == null || validFilter.isEmpty()) {
            return sheetData;
        }
        Object[] columnNames = this.getColumnNames(sheet);
        for (FilterParam fp : validFilter) {
            int columnIndex = ArrayUtils.indexOf((Object[])columnNames, (Object)fp.getColumnName());
            if (columnIndex < 0) {
                logger.warn("***** data\u30b7\u30fc\u30c8\u306b\u3001\u5217\u540d[{}]\u304c\u3042\u308a\u307e\u305b\u3093\u3002", (Object)fp.getColumnName());
                continue;
            }
            i = 1;
            while (i < sheetData.size()) {
                Cell cell;
                String v;
                Row row = (Row)sheetData.get(i);
                if (row != null && (v = BastubUtils.getCellText(cell = row.getCell(columnIndex))) != null) {
                    boolean isMatch = false;
                    String ct = fp.getCompareType();
                    for (String fv : fp.getValues()) {
                        int n;
                        if (StringUtils.isNumericSpace((CharSequence)v) && StringUtils.isNumericSpace((CharSequence)fv)) {
                            Integer v1 = Integer.parseInt(v);
                            Integer v2 = Integer.parseInt(fv);
                            n = v1.compareTo(v2);
                        } else {
                            n = v.compareTo(fv);
                        }
                        if (ct.equals("=")) {
                            isMatch = n == 0;
                        } else if (ct.equals("<")) {
                            isMatch = n < 0;
                        } else if (ct.equals("<=")) {
                            isMatch = n <= 0;
                        } else if (ct.equals(">")) {
                            isMatch = n > 0;
                        } else if (ct.equals(">=")) {
                            isMatch = n >= 0;
                        } else if (ct.equals("!=") || ct.equals("<>")) {
                            boolean bl = isMatch = n != 0;
                        }
                        if (isMatch) break;
                    }
                    if (!isMatch) {
                        sheetData.set(i, null);
                    }
                }
                ++i;
            }
        }
        sheetData.removeAll(Collections.singleton(null));
        for (Row row : sheetData) {
            StringBuilder sb = new StringBuilder();
            i = row.getFirstCellNum();
            while (i < row.getLastCellNum()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(BastubUtils.getCellText(row.getCell(i)));
                ++i;
            }
        }
        return sheetData;
    }

    private String[] getColumnNames(Sheet sheet) {
        Row row = sheet.getRow(sheet.getFirstRowNum());
        String[] columns = new String[row.getLastCellNum()];
        int i = row.getFirstCellNum();
        while (i < row.getLastCellNum()) {
            columns[i] = BastubUtils.getCellText(row.getCell(i));
            ++i;
        }
        return columns;
    }
}

