/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.nio.file.Path;
import rdj.Validate;

public class FCPath {
    public static int MAC_SIZE;
    public static int KEY_SIZE_MIN_DEFAULT;
    public static int KEY_SIZE_MIN;
    public static final int INVALID = 0;
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    public static final int SYMLINK = 3;
    public static final int DEVICE = 4;
    public static final int PARTITION = 5;
    public static final int DEVICE_INVALID = 6;
    public static final int DEVICE_PROTECTED = 7;
    public static final String[] TYPE_DESCRIPTION_ARRAY;
    public Path path;
    public boolean exist = false;
    public int type = 0;
    public long size = 0L;
    public boolean isReadable = false;
    public boolean isWritable = false;
    public boolean isHidden = false;
    public boolean matchKey = false;
    public boolean isValidPath = false;
    public boolean isValidFile = false;
    public boolean isValidDeviceProtected = false;
    public boolean isValidDevice = false;
    public boolean isValidPartition = false;
    public boolean isKey = false;
    public boolean isValidKey = false;
    public boolean isValidKeyDir = false;
    public boolean isDecrypted = false;
    public boolean isEncryptable = false;
    public boolean needsWriteAutoKey = false;
    public long needsWriteAutoKeySize = 0L;
    public boolean matchedReadAutoKey = false;
    public long matchedReadAutoKeySize = 0L;
    public boolean unmatchedReadAutoKey = false;
    public long unmatchedReadAutoKeySize = 0L;
    public boolean isNewEncrypted = false;
    public boolean isUnEncryptable = false;
    public boolean isEncrypted = false;
    public static int defaultMACVersion;
    public int macVersion = defaultMACVersion;
    public boolean isDecryptable = false;
    public boolean isNewDecrypted = false;
    public boolean isUnDecryptable = false;
    public String errorDescription = "";

    public FCPath(Path path) {
        this.path = path;
    }

    public FCPath(Path path, boolean exist, int type, long size, boolean readable, boolean writable, boolean isHidden, boolean matchKey, boolean isValidPath, boolean isValidFile, boolean isValidDeviceProtected, boolean isValidDevice, boolean isValidPartition, boolean isKey, boolean isValidKey, boolean isValidKeyDir, boolean isDecrypted, boolean isEncryptable, boolean needsWriteAutoKey, long needsWriteAutoKeySize, boolean matchedReadAutoKey, long matchedReadAutoKeySize, boolean unmatchedReadAutoKey, long unmatchedReadAutoKeySize, boolean isNewEncrypted, boolean isUnEncryptable, boolean isEncrypted, int macVersion, boolean isDecryptable, boolean isNewDecrypted, boolean isUnDecryptable, String errorDesc) {
        this.path = path;
        this.exist = exist;
        this.type = type;
        this.size = size;
        this.isReadable = readable;
        this.isWritable = writable;
        this.isHidden = isHidden;
        this.matchKey = matchKey;
        this.isValidPath = isValidPath;
        this.isValidFile = isValidFile;
        this.isValidDeviceProtected = isValidDeviceProtected;
        this.isValidDevice = isValidDevice;
        this.isValidPartition = isValidPartition;
        this.isKey = isKey;
        this.isValidKey = isValidKey;
        this.isValidKeyDir = isValidKeyDir;
        this.isDecrypted = isDecrypted;
        this.isEncryptable = isEncryptable;
        this.needsWriteAutoKey = needsWriteAutoKey;
        this.needsWriteAutoKeySize = needsWriteAutoKeySize;
        this.matchedReadAutoKey = matchedReadAutoKey;
        this.matchedReadAutoKeySize = matchedReadAutoKeySize;
        this.unmatchedReadAutoKey = unmatchedReadAutoKey;
        this.unmatchedReadAutoKeySize = unmatchedReadAutoKeySize;
        this.isNewEncrypted = isNewEncrypted;
        this.isUnEncryptable = isUnEncryptable;
        this.isEncrypted = isEncrypted;
        this.macVersion = macVersion;
        this.isDecryptable = isDecryptable;
        this.isNewDecrypted = isNewDecrypted;
        this.isUnDecryptable = isUnDecryptable;
        this.errorDescription = errorDesc;
    }

    public FCPath clone(FCPath fcPath) {
        FCPath newFCPath = new FCPath(fcPath.path);
        newFCPath.path = fcPath.path;
        newFCPath.exist = fcPath.exist;
        newFCPath.type = fcPath.type;
        newFCPath.size = fcPath.size;
        newFCPath.isReadable = fcPath.isReadable;
        newFCPath.isWritable = fcPath.isWritable;
        newFCPath.isHidden = fcPath.isHidden;
        newFCPath.matchKey = fcPath.matchKey;
        newFCPath.isValidPath = fcPath.isValidPath;
        newFCPath.isValidFile = fcPath.isValidFile;
        newFCPath.isValidDeviceProtected = fcPath.isValidDeviceProtected;
        newFCPath.isValidDevice = fcPath.isValidDevice;
        newFCPath.isValidPartition = fcPath.isValidPartition;
        newFCPath.isKey = fcPath.isKey;
        newFCPath.isValidKey = fcPath.isValidKey;
        newFCPath.isValidKeyDir = fcPath.isValidKeyDir;
        newFCPath.isDecrypted = fcPath.isDecrypted;
        newFCPath.isEncryptable = fcPath.isEncryptable;
        newFCPath.needsWriteAutoKey = fcPath.needsWriteAutoKey;
        newFCPath.needsWriteAutoKeySize = fcPath.needsWriteAutoKeySize;
        newFCPath.matchedReadAutoKey = fcPath.matchedReadAutoKey;
        newFCPath.matchedReadAutoKeySize = fcPath.matchedReadAutoKeySize;
        newFCPath.unmatchedReadAutoKey = fcPath.unmatchedReadAutoKey;
        newFCPath.unmatchedReadAutoKeySize = fcPath.unmatchedReadAutoKeySize;
        newFCPath.isNewEncrypted = fcPath.isNewEncrypted;
        newFCPath.isUnEncryptable = fcPath.isUnEncryptable;
        newFCPath.isEncrypted = fcPath.isEncrypted;
        newFCPath.macVersion = fcPath.macVersion;
        newFCPath.isDecryptable = fcPath.isDecryptable;
        newFCPath.isNewDecrypted = fcPath.isNewDecrypted;
        newFCPath.isUnDecryptable = fcPath.isUnDecryptable;
        newFCPath.errorDescription = fcPath.errorDescription;
        return newFCPath;
    }

    public static String getTypeString(int type) {
        return TYPE_DESCRIPTION_ARRAY[type];
    }

    public String getString() {
        String returnString = "";
        returnString = returnString + "FCPath:\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Path:                  " + this.path.toAbsolutePath().toString() + "\r\n";
        returnString = returnString + "Exist:                 " + this.exist + "\r\n";
        returnString = returnString + "Type:                  " + FCPath.getTypeString(this.type) + "\r\n";
        returnString = returnString + "Size:                  " + Validate.getHumanSize(this.size, 1, "Bytes") + "\r\n";
        returnString = returnString + "Readable:              " + this.isReadable + "\r\n";
        returnString = returnString + "Writable:              " + this.isWritable + "\r\n";
        returnString = returnString + "Hidden:                " + this.isHidden + "\r\n";
        returnString = returnString + "Match Key:             " + this.matchKey + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Valid Path:            " + this.isValidPath + "\r\n";
        returnString = returnString + "Valid File:            " + this.isValidFile + "\r\n";
        returnString = returnString + "Valid Device:          " + this.isValidDevice + "\r\n";
        returnString = returnString + "Valid Partition:       " + this.isValidPartition + "\r\n";
        returnString = returnString + "Is Key:                " + this.isKey + "\r\n";
        returnString = returnString + "Valid Key:             " + this.isValidKey + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Unencrypted:           " + this.isDecrypted + "\r\n";
        returnString = returnString + "Encryptable:           " + this.isEncryptable + "\r\n";
        returnString = returnString + "Unencryptable:         " + this.isUnEncryptable + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Encrypted:             " + this.isEncrypted + "\r\n";
        returnString = returnString + "MAC Version:           " + this.macVersion + "\r\n";
        returnString = returnString + "Decryptable:           " + this.isDecryptable + "\r\n";
        returnString = returnString + "Undecryptable:         " + this.isUnDecryptable + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Create Key:            " + this.needsWriteAutoKey + "\r\n";
        returnString = returnString + "Match Key:             " + this.matchedReadAutoKey + "\r\n";
        returnString = returnString + "Missing Key:           " + this.unmatchedReadAutoKey + "\r\n";
        returnString = returnString + "\r\n";
        return returnString;
    }

    static {
        KEY_SIZE_MIN = KEY_SIZE_MIN_DEFAULT = (MAC_SIZE = "FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length() * 2);
        TYPE_DESCRIPTION_ARRAY = new String[]{"Invalid", "File", "Directory", "Symlink", "Device", "Partition", "Device Invalid", "Device Protected"};
        defaultMACVersion = 3;
    }
}

