#!/bin/bash

UTDICDATE="20210421"
REVISION="1"

#altcannadic="true"
#edict="true"
#jawikiarticles="true"
#jinmeiut="true"
neologd="true"
#nicoime="true"
#skk="true"
#sudachidict="true"


# ==============================================================================
# Make each dictionary
# ==============================================================================

rm -f mozcdic-ut.txt
rm -f ../mozcdic-ut-*.txt
rm ../*/*.zip
rm ../*/*.gz
#rm ../*/*.bz2

cd ../mozc/
sh get-official-mozc.sh

cd ../neologd/
ruby convert-neologd-to-mozc.rb
ruby ../src/filter-entries.rb mozcdic-neologd.txt
cat mozcdic-neologd.txt >> ../src/mozcdic-ut.txt

cd ../src/


# ==============================================================================
# Extract new entries and apply jawiki costs
# ==============================================================================

ruby extract-new-entries.rb mozcdic-ut.txt
ruby apply-jawiki-costs.rb mozcdic-ut.txt.extracted

rm -f ../mozcdic*-ut-*.txt
mv mozcdic-ut.txt.extracted ../mozcdic-ut-$UTDICDATE.$REVISION.txt


# ==============================================================================
# Make a mozcdic-ut package
# ==============================================================================

cd ../../
rm -rf mozcdic-ut-$UTDICDATE.$REVISION
rsync -av mozcdic-ut-dev/* mozcdic-ut-$UTDICDATE.$REVISION --exclude=id.def \
--exclude=jawiki-latest* --exclude=jawiki-ut.txt --exclude=KEN_ALL.* --exclude=*.csv \
--exclude=*.xml --exclude=*.gz --exclude=*.bz2 --exclude=*.xz --exclude=*.zip
rm -f mozcdic-ut-$UTDICDATE.$REVISION/*/mozcdic*.txt*

