package com.xxxxxxx.drvpp.fw.web.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;

public class SessionInfo extends HashMap<String, Map<String, Object>> {
	public static final String SCOPE_AP = "SCOPE_AP";
	public static final String SCOPE_SESSION = "SCOPE_SESSION";
	
	private WebRequest request;
	
	public SessionInfo(){
		this.put(SCOPE_AP, new HashMap<String, Object>());
		this.put(SCOPE_SESSION, new HashMap<String, Object>());
	}
	
	public void init(WebRequest request){
		this.request = request;
		
		String[] names = request.getAttributeNames(RequestAttributes.SCOPE_SESSION);
		Map<String, Object> sessionMap = new HashMap<String, Object>();
		for (int i = 0; i < names.length; i++){
			sessionMap.put(names[i], request.getAttribute(names[i], RequestAttributes.SCOPE_SESSION));
		}
		this.put(SCOPE_SESSION, sessionMap);
	}
	
	public void commin(){
		Map<String, Object> map = this.get(SCOPE_SESSION);
		Set<java.util.Map.Entry<String, Object>> entrySet = map.entrySet();
		Iterator<java.util.Map.Entry<String, Object>> it = entrySet.iterator();
		while (it.hasNext()){
			java.util.Map.Entry<String, Object> entry = it.next();
			String key = entry.getKey();
			Object value = entry.getValue();
			request.setAttribute(key, value, RequestAttributes.SCOPE_SESSION);
		}
	}
	
}
