/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Message
extends Packet {
    private Type type = Type.normal;
    private String thread = null;
    private String language;
    private final Set<Subject> subjects = new HashSet<Subject>();
    private final Set<Body> bodies = new HashSet<Body>();

    public Message() {
    }

    public Message(String to) {
        this.setTo(to);
    }

    public Message(String to, Type type) {
        this.setTo(to);
        if (type != null) {
            this.type = type;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    public String getSubject() {
        return this.getSubject(null);
    }

    public String getSubject(String language) {
        Subject subject = this.getMessageSubject(language);
        return subject == null ? null : subject.subject;
    }

    private Subject getMessageSubject(String language) {
        language = this.determineLanguage(language);
        for (Subject subject : this.subjects) {
            if (!language.equals(subject.language)) continue;
            return subject;
        }
        return null;
    }

    public Collection<Subject> getSubjects() {
        return Collections.unmodifiableCollection(this.subjects);
    }

    public void setSubject(String subject) {
        if (subject == null) {
            this.removeSubject("");
            return;
        }
        this.addSubject(null, subject);
    }

    public Subject addSubject(String language, String subject) {
        language = this.determineLanguage(language);
        Subject messageSubject = new Subject(language, subject);
        this.subjects.add(messageSubject);
        return messageSubject;
    }

    public boolean removeSubject(String language) {
        language = this.determineLanguage(language);
        for (Subject subject : this.subjects) {
            if (!language.equals(subject.language)) continue;
            return this.subjects.remove(subject);
        }
        return false;
    }

    public boolean removeSubject(Subject subject) {
        return this.subjects.remove(subject);
    }

    public Collection<String> getSubjectLanguages() {
        Subject defaultSubject = this.getMessageSubject(null);
        ArrayList<String> languages = new ArrayList<String>();
        for (Subject subject : this.subjects) {
            if (subject.equals(defaultSubject)) continue;
            languages.add(subject.language);
        }
        return Collections.unmodifiableCollection(languages);
    }

    public String getBody() {
        return this.getBody(null);
    }

    public String getBody(String language) {
        Body body = this.getMessageBody(language);
        return body == null ? null : body.message;
    }

    private Body getMessageBody(String language) {
        language = this.determineLanguage(language);
        for (Body body : this.bodies) {
            if (!language.equals(body.language)) continue;
            return body;
        }
        return null;
    }

    public Collection<Body> getBodies() {
        return Collections.unmodifiableCollection(this.bodies);
    }

    public void setBody(String body) {
        if (body == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, body);
    }

    public Body addBody(String language, String body) {
        language = this.determineLanguage(language);
        Body messageBody = new Body(language, body);
        this.bodies.add(messageBody);
        return messageBody;
    }

    public boolean removeBody(String language) {
        language = this.determineLanguage(language);
        for (Body body : this.bodies) {
            if (!language.equals(body.language)) continue;
            return this.bodies.remove(body);
        }
        return false;
    }

    public boolean removeBody(Body body) {
        return this.bodies.remove(body);
    }

    public Collection<String> getBodyLanguages() {
        Body defaultBody = this.getMessageBody(null);
        ArrayList<String> languages = new ArrayList<String>();
        for (Body body : this.bodies) {
            if (body.equals(defaultBody)) continue;
            languages.add(body.language);
        }
        return Collections.unmodifiableCollection(languages);
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    private String determineLanguage(String language) {
        String string = language = "".equals(language) ? null : language;
        if (language == null && this.language != null) {
            return this.language;
        }
        if (language == null) {
            return Message.getDefaultLanguage();
        }
        return language;
    }

    @Override
    public String toXML() {
        XMPPError error;
        StringBuilder buf = new StringBuilder();
        buf.append("<message");
        if (this.getXmlns() != null) {
            buf.append(" xmlns=\"").append(this.getXmlns()).append("\"");
        }
        if (this.language != null) {
            buf.append(" xml:lang=\"").append(this.getLanguage()).append("\"");
        }
        if (this.getPacketID() != null) {
            buf.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            buf.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            buf.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.normal) {
            buf.append(" type=\"").append((Object)this.type).append("\"");
        }
        buf.append(">");
        Subject defaultSubject = this.getMessageSubject(null);
        if (defaultSubject != null) {
            buf.append("<subject>").append(StringUtils.escapeForXML(defaultSubject.subject)).append("</subject>");
        }
        for (Subject subject : this.getSubjects()) {
            if (subject.equals(defaultSubject)) continue;
            buf.append("<subject xml:lang=\"").append(subject.language).append("\">");
            buf.append(StringUtils.escapeForXML(subject.subject));
            buf.append("</subject>");
        }
        Body defaultBody = this.getMessageBody(null);
        if (defaultBody != null) {
            buf.append("<body>").append(StringUtils.escapeForXML(defaultBody.message)).append("</body>");
        }
        for (Body body : this.getBodies()) {
            if (body.equals(defaultBody)) continue;
            buf.append("<body xml:lang=\"").append(body.getLanguage()).append("\">");
            buf.append(StringUtils.escapeForXML(body.getMessage()));
            buf.append("</body>");
        }
        if (this.thread != null) {
            buf.append("<thread>").append(this.thread).append("</thread>");
        }
        if (this.type == Type.error && (error = this.getError()) != null) {
            buf.append(error.toXML());
        }
        buf.append(this.getExtensionsXML());
        buf.append("</message>");
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (!super.equals(message)) {
            return false;
        }
        if (this.bodies.size() != message.bodies.size() || !this.bodies.containsAll(message.bodies)) {
            return false;
        }
        if (this.language != null ? !this.language.equals(message.language) : message.language != null) {
            return false;
        }
        if (this.subjects.size() != message.subjects.size() || !this.subjects.containsAll(message.subjects)) {
            return false;
        }
        if (this.thread != null ? !this.thread.equals(message.thread) : message.thread != null) {
            return false;
        }
        return this.type == message.type;
    }

    @Override
    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.subjects.hashCode();
        result = 31 * result + (this.thread != null ? this.thread.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + this.bodies.hashCode();
        return result;
    }

    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String name) {
            try {
                return Type.valueOf(name);
            }
            catch (Exception e) {
                return normal;
            }
        }
    }

    public static class Body {
        private String message;
        private String language;

        private Body(String language, String message) {
            if (language == null) {
                throw new NullPointerException("Language cannot be null.");
            }
            if (message == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.language = language;
            this.message = message;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.language.hashCode();
            result = 31 * result + this.message.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Body other = (Body)obj;
            return this.language.equals(other.language) && this.message.equals(other.message);
        }
    }

    public static class Subject {
        private String subject;
        private String language;

        private Subject(String language, String subject) {
            if (language == null) {
                throw new NullPointerException("Language cannot be null.");
            }
            if (subject == null) {
                throw new NullPointerException("Subject cannot be null.");
            }
            this.language = language;
            this.subject = subject;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSubject() {
            return this.subject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.language.hashCode();
            result = 31 * result + this.subject.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subject other = (Subject)obj;
            return this.language.equals(other.language) && this.subject.equals(other.subject);
        }
    }
}

