package com.xxxxxxx.drvpp.fw.batch.controller;

import java.util.ArrayList;
import java.util.List;

import mockit.Mocked;
import mockit.NonStrictExpectations;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.Assert;

import com.xxxxxxx.drvpp.fw.batch.util.BatchParameter;
import com.xxxxxxx.drvpp.fw.batch.util.Business;
import com.xxxxxxx.drvpp.fw.common.log.LoggerFactoryImpl;
import com.xxxxxxx.drvpp.fw.common.mybatis.MyBatisSessionFactory;
import com.xxxxxxx.drvpp.fw.common.util.BeanFactoryBuilder;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:testApplicationContext.xml")
public class ApplicationControllerImplTest {
	@BeforeClass
	public static void setUpBeforeClass(){
		BeanFactoryBuilder.setApplicationContextName("testApplicationContext.xml");
		MyBatisSessionFactory.setResourceName("testMybatis.xml");		
	}
	
	@AfterClass
	public static void tearDownAfterClass(){
		
	}

	@Before
	public void setUp() throws Exception {

	}

	@After
	public void tearDown() throws Exception {

	}	
	
	@Test
	public void testDoExecute001() {
		new NonStrictExpectations() {
			@Mocked(methods="getBean")
			ClassPathXmlApplicationContext applicationContext;
			{
				applicationContext.getBean("loggerFactory");
				result = LoggerFactoryImpl.getInstance();
				
				List<Business<BatchParameter>> flow = new ArrayList<Business<BatchParameter>>();
				flow.add(new Business<BatchParameter>(){
					@Override
					public int doExecute(BatchParameter parameter) {
						return 0;
					}});
				
				applicationContext.getBean("businessList");
				result = flow;
			}
		};		

		ApplicationControllerImpl controller = new ApplicationControllerImpl();
		String[] args = new String[0];
		int result = controller.doExecute(args);		
		
		Assert.isTrue(result == 0);
	}

	@Test
	public void testDoExecute002() {
		final TestSqlSession sqlSession = new TestSqlSession();
		
		new NonStrictExpectations() {
			@Mocked(methods="getBean")
			ClassPathXmlApplicationContext applicationContext;
			@Mocked(methods="openSession")
			MyBatisSessionFactory sessionFactory;
			{
				applicationContext.getBean("loggerFactory");
				result = LoggerFactoryImpl.getInstance();
				
				sessionFactory.openSession();
				result = sqlSession;
				
				List<Business<BatchParameter>> flow = new ArrayList<Business<BatchParameter>>();
				flow.add(new Business<BatchParameter>(){
					@Override
					public int doExecute(BatchParameter parameter) {
						return 0;
					}});
				flow.add(new Business<BatchParameter>(){
					@Override
					public int doExecute(BatchParameter parameter) {
						return 1;
					}});
				
				applicationContext.getBean("businessList");
				result = flow;
			}
		};		

		ApplicationControllerImpl controller = new ApplicationControllerImpl();
		String[] args = new String[0];
		int result = controller.doExecute(args);		
		
		Assert.isTrue(result != 0);
		
		int i = 0;
		List<String> list = sqlSession.getList();
		Assert.isTrue(list.size() == 2);
		Assert.isTrue(list.get(i++).equals(TestSqlSession.COMMIT));
		Assert.isTrue(list.get(i++).equals(TestSqlSession.ROLLBACK));
	}

	@Test
	public void testDoExecute003() {
		final String key = "KEY";
		
		new NonStrictExpectations() {
			@Mocked(methods="getBean")
			ClassPathXmlApplicationContext applicationContext;
			{
				applicationContext.getBean("loggerFactory");
				result = LoggerFactoryImpl.getInstance();
				
				List<Business<BatchParameter>> flow = new ArrayList<Business<BatchParameter>>();
				flow.add(new Business<BatchParameter>(){
					@Override
					public int doExecute(BatchParameter parameter) {
						//parameter.getOutput().put(key, 0);
						
						return 0;
					}});
				flow.add(new Business<BatchParameter>(){
					@Override
					public int doExecute(BatchParameter parameter) {
						//int value = (Integer)parameter.getInput().get(key);
						//value++;
						//parameter.getOutput().put(key, value);
						
						return 0;
					}});
				
				applicationContext.getBean("businessList");
				result = flow;
			}
		};		

		ApplicationControllerImpl controller = new ApplicationControllerImpl();
		String[] args = new String[0];
		int result = controller.doExecute(args);		
		
		Assert.isTrue(result == 0);
		
		//BatchParameter parameter = controller.getParameter();
		//int value = (int) parameter.getOutput().get(key);
		//Assert.isTrue(value == 1);
	}
}
