package com.xxxxxxx.drvpp.fw.common.util;

import java.util.Map;

import org.springframework.context.ApplicationContext;

import com.xxxxxxx.drvpp.fw.common.util.BeanFactoryBuilder;

/**
 * 設定ファクトリ.
 */
public class SettingFactory {
	/**
	 * 設定値取得キー
	 */
	private static final String SYSTEM_SETTING_MAP = "systemSettingMap";

	/**
	 * シングルトン保持
	 */
	private static class SettingHolder {
		/**
		 * インスタンス
		 */
		private static final SettingFactory instance = new SettingFactory();
	}

	/**
	 * インスタンス取得.
	 * @return インスタンス
	 */
	public static SettingFactory getInstance() {
		return SettingHolder.instance;
	}
	
	/**
	 * システム設定取得.
	 * @return システム設定
	 */
	public Setting getSystemSetting(){
		return getSystemSetting(SYSTEM_SETTING_MAP);
	}

	/**
	 * システム設定取得.
	 * @param key キー
	 * @return システム設定
	 */
	public Setting getSystemSetting(String key){
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();
		Map<String, Object> map = (Map<String, Object>)applicationContext.getBean(key);
		return new SettingImpl(map);
	}
}
