package com.xxxxxxx.drvpp.fw.common.util;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.xxxxxxx.drvpp.fw.common.exception.FwRuntimeException;

/**
 * Beanファクトリビルダ.
 */
public class BeanFactoryBuilder {
	/** アプリケーションコンテキスト名 */
	private static String applicationContextName = "applicationContext.xml";
	/** アプリケーションコンテキスト */
	private ApplicationContext applicationContext;
	
	/**
	 * シングルトン保持
	 */
	private static class BeanFactoryBuilderHolder {
		/**
		 * インスタンス
		 */
		private static final BeanFactoryBuilder instance = new BeanFactoryBuilder();
	}

	/**
	 * インスタンス取得.
	 * @return インスタンス
	 */
	public static BeanFactoryBuilder getInstance() {
		BeanFactoryBuilderHolder.instance.init();
		return BeanFactoryBuilderHolder.instance;
	}

	/**
	 * アプリケーションコンテキスト名設定.
	 * @param applicationContext アプリケーションコンテキスト名
	 */
	public static void setApplicationContextName(String applicationContextName){
		BeanFactoryBuilder.applicationContextName = applicationContextName;
	}
	
	/**
	 * 初期化.
	 */
	private void init() {
		applicationContext = new ClassPathXmlApplicationContext(
				applicationContextName);
		if (applicationContext == null){
			throw new FwRuntimeException(null);
		}
	}

	/**
	 * コンストラクタ.
	 */
	private BeanFactoryBuilder(){
		
	}
	
	/**
	 * アプリケーションコンテキスト取得.
	 * @return アプリケーションコンテキスト
	 */
	public ApplicationContext build(){
		return applicationContext;
	}

	/**
	 * アプリケーションコンテキスト取得.
	 * @return アプリケーションコンテキスト
	 */
	public ApplicationContext getApplicationContext() {
	    return applicationContext;
	}

	/**
	 * アプリケーションコンテキスト設定.
	 * @param applicationContext アプリケーションコンテキスト
	 */
	public void setApplicationContext(ApplicationContext applicationContext) {
	    this.applicationContext = applicationContext;
	}
}
