package com.sample.fw;

import static org.junit.Assert.*;

import java.io.File;

import mockit.Deencapsulation;
import mockit.Delegate;
import mockit.Expectations;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import mockit.NonStrictExpectations;
import mockit.Verifications;

import org.junit.Test;

// http://d.hatena.ne.jp/ryoasai/20110107/1294427245
// http://genesis-tdsg.blogspot.jp/2013/08/jmockit.html
// http://jmockit.googlecode.com/svn/trunk/www/tutorial/BehaviorBasedTesting.html
// http://qiita.com/opengl-8080/items/a49d4dae9067413ccdd6
// http://genesis-tdsg.blogspot.jp/2013/05/junit4-macher.html
public class FooTest {
	@Test
	public void testExit(){
		new NonStrictExpectations() {
			@Mocked("exit")
			System sys;
			{
				System.exit(anyInt); // static
			}
		};
		Foo foo = new Foo();
		int result;
		result = foo.exit();
		assertEquals(0, result);
	}
	
	
	/**
	 * 呼び出しごとに戻り値を変更
	 */
	@Test
	public void testExecute_001() {
		new NonStrictExpectations() {
			@Mocked
			Bar bar;
			{
				bar.calc(0); // or anyInt
				result = 1;
				result = 2;
				result = 3;
			}
		};

		Foo foo = new Foo();
		int result;
		result = foo.execute();
		result = foo.execute();
		result = foo.execute();

		assertEquals(3, result);
	}

	/**
	 * 呼び出しごとに戻り値を変更(呼び出し回数を厳密にチェック)
	 */
	@Test
	public void testExecute_002() {
		new Expectations() {
			@Mocked
			Bar bar;
			{
				new Bar();
				result = bar;
				bar.calc(0); // or anyInt
				result = 1;

				new Bar();
				result = bar;
				bar.calc(0); // or anyInt
				result = 2;

				new Bar();
				result = bar;
				bar.calc(0); // or anyInt
				result = 3;
			}
		};

		Foo foo = new Foo();
		int result;
		result = foo.execute();
		result = foo.execute();
		result = foo.execute();

		assertEquals(3, result);
	}

	/**
	 * 引数がオブジェクトの場合
	 */
	@Test
	public void testExecute_003() {
		new NonStrictExpectations() {
			@Mocked
			Bar bar;
			{
				bar.mesg2((Bar)any);
				result = "xxx";
			}
		};

		Foo foo = new Foo();
		String result;
		result = foo.mesg();

		assertEquals("xxx", result);
	}
	
	/**
	 * 特定のメソッドのみモック化(calc2)
	 * privateメソッドをモック化
	 */
	@Test
	public void testExecute_004() {
		new NonStrictExpectations() {
			@Mocked("calc2")
			// only calc2()
			Bar bar;
			{
				invoke(bar, "calc2", anyInt); // private
				result = 4;
			}
		};

		Foo foo = new Foo();
		int result;
		result = foo.execute2();

		assertEquals(12, result);
	}

	/**
	 * staticメソッドをモック化
	 */
	@Test
	public void testExecute_005() {
		new NonStrictExpectations() {
			@Mocked
			Bar bar;
			{
				Bar.mesg(anyString); // static
				result = "ABC";
			}
		};

		String result;
		result = Bar.mesg("abc");

		assertEquals("ABC", result);
	}

	/**
	 * 例外発生
	 */
	@Test
	public void testExecute_006() {
		new NonStrictExpectations() {
			@Mocked
			Bar bar;
			{
				bar.calc(anyInt);
				result = new RuntimeException();
			}
		};

		Foo foo = new Foo();
		int result;
		try {
			result = foo.execute();
			fail();
		} catch (RuntimeException e) {

		}
	}

	/**
	 * メソッドのロジックを書き換えてモック化
	 */
	@Test
	public void testExecute_007() {
		new MockUp<Bar>() {
			@Mock
			int calc(int value) {
				return 3;
			}
		};

		Foo foo = new Foo();
		int result;
		result = foo.execute();

		assertEquals(3, result);
	}

	/**
	 * コンストラクタのモック化
	 */
	@Test
	public void testExecute_008() {
		new MockUp<Bar>() {
			@Mock
			void $init() { // constructor
				System.out.println("constructor");
			}
		};

		new Bar();
	}

	/**
	 * メソッドの呼び出し回数、引数をチェック
	 */
	@Test
	public void testExecute_009() {
		new NonStrictExpectations() {
			@Mocked
			Bar bar;
			{
			}
		};
		
		Foo foo = new Foo();
		int result;
		result = foo.execute();
		
	    new Verifications(){
			@Mocked
			Bar bar;
	    	{
	    		bar.calc(0); times=1;
	    	}
	    };
	}
	
	/**
	 * メソッドの引数のチェック
	 * 戻り値にロジックを記述
	 */
	@Test
	public void testExecute_010() {
		new NonStrictExpectations() {
			@Mocked
			Bar bar;
			{
				bar.calc(anyInt);
				result = new Delegate() { 
					int calc(int value){
						assertEquals(0, value);
						
						return 3;
					}
				};
			}
		};

		Foo foo = new Foo();
		int result;
		result = foo.execute();

		assertEquals(3, result);
	}
	
	/**
	 * privateな変数、メソッドへのアクセス
	 */
	@Test
	public void testExecute_011() {
		Bar bar = new Bar();
		
		Object o;
		int result;
		
		o = Deencapsulation.invoke(bar, "calc2", 1); // private method
		result = (Integer)o;
		assertEquals(2, result);
		
		o = Deencapsulation.invoke(Bar.class, "mesg", "x"); // private static method
		assertEquals("xx", o);

		Deencapsulation.setField(bar, "n", 3); // private variable
		o = Deencapsulation.getField(bar, "n"); // private variable
		result = (Integer)o;
		assertEquals(3, result);

		Deencapsulation.setField(Bar.class, "N", 4); // private static variable
		o = Deencapsulation.getField(Bar.class, "N"); // private static variable
		result = (Integer)o;
		assertEquals(4, result);
	}
	
	@Test
	public void testM1(){
		new NonStrictExpectations() {
			@Mocked
			File f;
			{
				f.exists();
				result = true;
			}
		};
		Foo foo = new Foo();
		boolean b = foo.m1();
		
		assertTrue(b);
	}

	@Test
	public void testM2(){
		Foo foo = new Foo();
		boolean b = foo.m1();
		
		assertFalse(b);
	}

	@Test
	public void testM3(){
		new NonStrictExpectations() {
			@Mocked("getenv")
			System sys;
			{
				System.getenv(anyString);
				result = "xxx";
			}
		};
		
		String result = System.getenv("");
		assertEquals("xxx", result);
	}

	@Test
	public void testM4(){
		String result = System.getenv("");
		assertNull(result);
	}
}
