package com.xxxxxxx.drvpp.fw.web.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.ibatis.session.SqlSession;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

import com.xxxxxxx.drvpp.fw.common.log.Logger;
import com.xxxxxxx.drvpp.fw.common.log.LoggerFactory;
import com.xxxxxxx.drvpp.fw.common.log.LoggerFactoryBuilder;
import com.xxxxxxx.drvpp.fw.common.mybatis.FwSqlSession;
import com.xxxxxxx.drvpp.fw.common.mybatis.MyBatisSessionFactory;
import com.xxxxxxx.drvpp.fw.common.util.BeanFactoryBuilder;
import com.xxxxxxx.drvpp.fw.common.util.SettingFactory;
import com.xxxxxxx.drvpp.fw.web.util.DownloadParameter;
import com.xxxxxxx.drvpp.fw.web.util.EventParameter;
import com.xxxxxxx.drvpp.fw.web.util.SessionInfo;
import com.xxxxxxx.drvpp.fw.web.util.UploadParameter;
import com.xxxxxxx.drvpp.fw.web.util.WebParameter;

@Controller
public class FrontControllerImpl {
	@RequestMapping(value = "/web/**/", method = RequestMethod.GET)
	public String doGet(HttpServletRequest req, WebRequest request, Model model) {
		return doExecute(req, request, model);
	}

	@RequestMapping(value = "/web/**/", method = RequestMethod.POST)
	public String doPost(HttpServletRequest req, WebRequest request, Model model) {
		return doExecute(req, request, model);
	}

	public String doExecute(HttpServletRequest req, WebRequest request,
			Model model) {
		// ロガー取得
		LoggerFactoryBuilder loggerFactoryBuilder = LoggerFactoryBuilder
				.getInstance();
		LoggerFactory loggerFactory = loggerFactoryBuilder.getLoggerFactory();
		Logger logger = loggerFactory.getLogger(this.getClass());

		// 設定値取得
		SettingFactory settingFactory = SettingFactory.getInstance();

		// DBセッション取得
		MyBatisSessionFactory sessionFactory = MyBatisSessionFactory
				.getInstance();
		SqlSession sqlSession = sessionFactory.openSession();
		FwSqlSession fwSqlSession = new FwSqlSession(sqlSession);

		// アプリケーションコンテキスト取得(Beanの生成に使用)
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();

		// リクエストパラメータ
		Map<String, String> requestParameter = new HashMap<String, String>();
		Map<String, String[]> map = req.getParameterMap();
		setRequestParameter(requestParameter, map);

		SessionInfo sessionInfo = new SessionInfo();
		sessionInfo.init(request);

		String url = req.getRequestURI();
		url = url.substring(req.getContextPath().length());

		WebParameter parameter = new WebParameter();

		ApplicationControllerImpl applicationController = new ApplicationControllerImpl();
		int result = applicationController.doExecute(url, requestParameter,
				model, sessionInfo, fwSqlSession, settingFactory, parameter);

		return parameter.getViewName();
	}

	@RequestMapping(value = "/rest/**/", method = RequestMethod.POST)
	public void doExecute(HttpServletRequest req, HttpServletResponse res) {
		// ロガー取得
		LoggerFactoryBuilder loggerFactoryBuilder = LoggerFactoryBuilder
				.getInstance();
		LoggerFactory loggerFactory = loggerFactoryBuilder.getLoggerFactory();
		Logger logger = loggerFactory.getLogger(this.getClass());

		// 設定値取得
		SettingFactory settingFactory = SettingFactory.getInstance();

		// DBセッション取得
		MyBatisSessionFactory sessionFactory = MyBatisSessionFactory
				.getInstance();
		SqlSession sqlSession = sessionFactory.openSession();
		FwSqlSession fwSqlSession = new FwSqlSession(sqlSession);

		// アプリケーションコンテキスト取得(Beanの生成に使用)
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();

		// リクエストパラメータ
		Map<String, String> requestParameter = new HashMap<String, String>();
		Map<String, String[]> map = req.getParameterMap();
		setRequestParameter(requestParameter, map);

		/*
		 * // フローの決定 List<Business> flow = new ArrayList<Business>(); Business
		 * biz; biz = (Business) applicationContext.getBean("businessD");
		 * flow.add(biz); // biz = (Business)
		 * applicationContext.getBean("businessB"); // flow.add(biz); // biz =
		 * (Business) applicationContext.getBean("businessC"); // flow.add(biz);
		 */
		InputStream is = null;
		OutputStream os = null;
		try {
			is = req.getInputStream();
			os = res.getOutputStream();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		// 実行
		/*
		 * EventParameter parameter = null; for (Business b : flow) { // パラメータ設定
		 * parameter = new EventParameter();
		 * parameter.setSqlSession(sqlSession);
		 * parameter.setRequestParameter(requestParameter); //
		 * parameter.setRequest(request); // parameter.setModel(model); //
		 * parameter.setViewName("error");
		 * 
		 * parameter.setInputStream(is); parameter.setOutputStream(os);
		 * 
		 * int result = -1; try { // ビジネスロジック起動 result = b.doExecute(parameter);
		 * } catch (Exception e) { e.printStackTrace(); } finally { // 起動後処理 if
		 * (result != 0) { sqlSession.rollback(); break; } sqlSession.commit();
		 * } }
		 */
		String url = req.getRequestURI();
		url = url.substring(req.getContextPath().length());

		EventParameter parameter = new EventParameter();

		ApplicationControllerImpl applicationController = new ApplicationControllerImpl();
		int result = applicationController.doExecute(url, requestParameter,
				fwSqlSession, settingFactory, parameter, is, os);
		
		// TODO result

		// TODO
		res.setStatus(200);
	}

	@RequestMapping(value = "/upload/**/", method = RequestMethod.POST)
	public String doExecuteUpload(HttpServletRequest req, WebRequest request, @RequestParam("files") List<MultipartFile> files,
			Model model) {
		// ロガー取得
		LoggerFactoryBuilder loggerFactoryBuilder = LoggerFactoryBuilder
				.getInstance();
		LoggerFactory loggerFactory = loggerFactoryBuilder.getLoggerFactory();
		Logger logger = loggerFactory.getLogger(this.getClass());

		// 設定値取得
		SettingFactory settingFactory = SettingFactory.getInstance();

		// DBセッション取得
		MyBatisSessionFactory sessionFactory = MyBatisSessionFactory
				.getInstance();
		SqlSession sqlSession = sessionFactory.openSession();
		FwSqlSession fwSqlSession = new FwSqlSession(sqlSession);

		// アプリケーションコンテキスト取得(Beanの生成に使用)
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();

		// リクエストパラメータ
		Map<String, String> requestParameter = new HashMap<String, String>();
		Map<String, String[]> map = req.getParameterMap();
		setRequestParameter(requestParameter, map);

		SessionInfo sessionInfo = new SessionInfo();
		sessionInfo.init(request);

		String url = req.getRequestURI();
		url = url.substring(req.getContextPath().length());

		WebParameter parameter = new WebParameter();
		UploadParameter uploadParameter = new UploadParameter();
		parameter.setUploadParameter(uploadParameter);
		uploadParameter.setFiles(files);

//		for (MultipartFile file : files) {
//			//if (!file.isEmpty() && file.getSize() > 100000)
//			//	throw new RuntimeException("File too large");
//			try {
//				String name = file.getOriginalFilename();
//				byte[] b = file.getBytes();
//				String c = file.getContentType();
//			} catch (IOException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//		}
//		return "/controller";

		ApplicationControllerImpl applicationController = new ApplicationControllerImpl();
		int result = applicationController.doExecute(url, requestParameter,
				model, sessionInfo, fwSqlSession, settingFactory, parameter);

		return parameter.getViewName();
	}

	@RequestMapping(value = "/download/**/", method = RequestMethod.POST)
	public void doExecuteDownload(HttpServletRequest req, WebRequest request, HttpServletResponse res) {
		// ロガー取得
		LoggerFactoryBuilder loggerFactoryBuilder = LoggerFactoryBuilder
				.getInstance();
		LoggerFactory loggerFactory = loggerFactoryBuilder.getLoggerFactory();
		Logger logger = loggerFactory.getLogger(this.getClass());

		// 設定値取得
		SettingFactory settingFactory = SettingFactory.getInstance();

		// DBセッション取得
		MyBatisSessionFactory sessionFactory = MyBatisSessionFactory
				.getInstance();
		SqlSession sqlSession = sessionFactory.openSession();
		FwSqlSession fwSqlSession = new FwSqlSession(sqlSession);
		
		// アプリケーションコンテキスト取得(Beanの生成に使用)
		BeanFactoryBuilder builder = BeanFactoryBuilder.getInstance();
		ApplicationContext applicationContext = builder.build();

		// リクエストパラメータ
		Map<String, String> requestParameter = new HashMap<String, String>();
		Map<String, String[]> map = req.getParameterMap();
		setRequestParameter(requestParameter, map);

		SessionInfo sessionInfo = new SessionInfo();
		sessionInfo.init(request);

		String url = req.getRequestURI();
		url = url.substring(req.getContextPath().length());

		WebParameter parameter = new WebParameter();
		DownloadParameter downloadParameter = new DownloadParameter();
		parameter.setDownloadParameter(downloadParameter);
		downloadParameter.setOutputStream(new ByteArrayOutputStream());
//		try {
//			downloadParameter.setOutputStream(res.getOutputStream());
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}

//		String filename = url + ".txt";
//
//		res.setContentType("text/plain;charset=utf8");
//		res.setHeader("Content-Disposition", "attachment; filename=" + filename);
//
//		InputStream in = new ByteArrayInputStream("TEST".getBytes());
//		OutputStream os;
//		try {
//			os = res.getOutputStream();
//			byte[] b = new byte[1024];
//			int len;
//			while ((len = in.read(b)) != -1) {
//				os.write(b, 0, len);
//			}
//			in.close();
//			os.close();
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}

		ApplicationControllerImpl applicationController = new ApplicationControllerImpl();
		int result = applicationController.doExecute(url, requestParameter,
				null, sessionInfo, fwSqlSession, settingFactory, parameter);		
		
		res.setContentType(downloadParameter.getContentType());
		res.setHeader("Content-Disposition", "attachment; filename=" + downloadParameter.getFilename());
		ByteArrayOutputStream bos = (ByteArrayOutputStream)downloadParameter.getOutputStream();
		try {
			OutputStream os = res.getOutputStream();
			byte[] b = bos.toByteArray();
			os.write(b);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private void setRequestParameter(Map<String, String> requestParameter,
			Map<String, String[]> map) {
		Set<Entry<String, String[]>> set = map.entrySet();
		for (Iterator<Entry<String, String[]>> it = set.iterator(); it
				.hasNext();) {
			Entry<String, String[]> entry = it.next();
			String key = entry.getKey();
			String value = entry.getValue()[0];
			requestParameter.put(key, value);
		}
	}

}
