/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.omegat.core.Core;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

/**
 *
 * @author Yu-Tang
 */
public class MenuManager {

    private JMenu root;
    private JMenu currentProject;
    private JMenu userConfig;

    public MenuManager() {
        root = createLocalizedMenu(L10n.getFoldersMenuLabel());  // Folders menu
        root.addMenuKeyListener(MenuHelper.getMenuKeyListener()); // for opening folder with enter key
        root.addMenuListener(MenuHelper.getRootMenuListener());
        
        // ProjectRoot
        try {
            root.add(currentProject = new ShellLinkMenu(L10n.getProjectRootMenuLabel()).getMenu());
        } catch (IOException ex) {
            Log.log(ex);
            return;
        }

        // User Config
        try {
            File confDir = new File(StaticUtils.getConfigDir());
            root.add(userConfig = new ShellLinkMenu(confDir, L10n.getUserConfigMenuLabel()).getMenu());
        } catch (IOException ex) {
            Log.log(ex);
        }
        
        // insert Files menu before the last menu (Help menu.)
        JMenuBar mainMenuBar = (JMenuBar) Core.getMainWindow().getMainMenu().getOptionsMenu().getParent();
        mainMenuBar.add(root, mainMenuBar.getMenuCount() - 1);
    }

    public void createProjectItems() {
        File rootDir = new File(Core.getProject().getProjectProperties().getProjectRoot());
        try {
            new ShellLinkMenu(currentProject).link(rootDir);
        } catch (IOException ex) {
            Log.log(ex);
        }
    }

    public void removeAllProjectItems() {
        new ShellLinkMenu(currentProject).unlink();
    }
    
    private JMenu createLocalizedMenu(String labelString) {
        JMenu m = new JMenu();
        Mnemonics.setLocalizedText(m, labelString);
        return m;
    }
}