package org.dyndns.nuda.tools.util;

import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ReversibleConverter {
	public static String compress(final String source) {
		try {
			// Encode a String into bytes
			String inputString = source;
			byte[] input = inputString.getBytes("UTF-8");
			
			int length = input.length;
			
			// Compress the bytes
			byte[] output = new byte[length];
			Deflater compresser = new Deflater(Deflater.BEST_COMPRESSION);
			compresser.setInput(input);
			compresser.finish();
			compresser.deflate(output);
			
			String bin2Hex = bin2hex(output);
			
			return bin2Hex;
		} catch (java.io.UnsupportedEncodingException ex) {
			return "";
		}
	}
	
	public static String decompress(final String source) {
		try {
			// Encode a String into bytes
			byte[] hex2Bin = hex2bin(source);
			
			// Decompress the bytes
			Inflater decompresser = new Inflater();
			decompresser.setInput(hex2Bin, 0, hex2Bin.length);
			byte[] result = new byte[hex2Bin.length];
			int resultLength = decompresser.inflate(result);
			decompresser.end();
			
			// Decode the bytes into a String
			String outputString = new String(result, 0, resultLength, "UTF-8");
			return outputString;
		} catch (java.io.UnsupportedEncodingException ex) {
			return "";
		} catch (java.util.zip.DataFormatException ex) {
			return "";
		}
	}
	
	public static void main(final String[] args) {
		test000();
	}
	
	public static void test000() {
		String source =
			"cmm_seq 		VARCHAR(45)		COLLATE utf8_bin NOT NULL COMMENT 'ユニークキー',";
		
		String c = compress(source);
		String d = decompress(c);
		//Digest di = new Digest();
		System.out.println(source);
		
		System.out.println(c);
		System.out.println(c.length());
		
		System.out.println(d);
		
	}
	
	public static void test001() {
		String source = "16で割った余りを各桁の値として繰り返しを使って自作したプログラム。";
		
		String c = compress(source);
		String d = decompress(c);
		Digest di = new Digest();
		System.out.println(source);
		System.out.println(c);
		System.out.println(d);
		
		//System.out.println(di.outputDigest(c.getBytes()));
		System.out.println("===");
		
		System.out.println("===");
		System.out.println("source byte :" + bin2hex(source.getBytes()));
		
		String h = bin2hex(source.getBytes());
		
		String c2 = radix32Compress(source);
		String c3 = radix32Compressv2(source);
		
		String di2 = new String(radix32ToHex(c2));
		
		System.out.println("source rdx32:" + c2);
		System.out.println("source rdx32:" + c3);
		String di3 = new String(radix32ToHex(c3));
		System.out.println("trans       :" + di2);
		System.out.println("trans       :" + di3);
		
		System.out.println("===");
		//System.out.println(c3);
		//System.out.println(di2);
		
		//System.out.println(b);
		
		System.out.println(0x3f);
	}
	
	public static void test002() {
		byte[] b = { 0x0031, 0x6, 0x08 };
		b = new String("16で割った余りを各桁の値として繰り返しを使って自作したプログラム。").getBytes();
		String bStr = bin2hex(b);
		String r32 = radix32Compressv2("16で割った余りを各桁の値として繰り返しを使って自作したプログラム。");
		String out = radix32ToHex(r32);
		
		System.out.println(bStr);
		System.out.println(r32);
		System.out.println(out);
	}
	
	public static String radix32Compress(final String source) {
		String result = "";
		//System.out.println("start");
		
		byte checkByte = 32;
		
		//byte[] s0 = hex2bin(source);
		
		StringBuilder b = new StringBuilder();
		for (int i = 0; i < source.getBytes().length; i++) {
			String out =
				Integer.toString(
					(~(~source.getBytes()[i] | checkByte) & 0x3f),
					36);
			
			b.append(out);
		}
		
		result = b.toString();
		return result;
	}
	
	public static String radix32Compressv2(final String source) {
		String result = "";
		//System.out.println("start");
		
		//byte[] s0 = hex2bin(source);
		
		byte checkByte = 32;
		StringBuilder b = new StringBuilder();
		for (int i = 0; i < source.getBytes().length; i++) {
			byte tmp = source.getBytes()[i];
			String hex = bin2hex(new byte[] { tmp });
			String out = Integer.toString(tmp, 36);
			
			b.append(out);
		}
		
		result = b.toString();
		
		System.out.println("radix32Compressv2:" + result);
		
		return result;
	}
	
	public static String bin2hex(final byte[] data) {
		StringBuffer sb = new StringBuffer();
		for (byte b : data) {
			String s = Integer.toHexString(0xff & b);
			if (s.length() == 1) {
				sb.append("0");
			}
			sb.append(s);
		}
		return sb.toString();
	}
	
	public static String bin2hexv2(final byte[] data) {
		StringBuffer sb = new StringBuffer();
		for (byte b : data) {
			String s = Integer.toHexString(0xff & b);
			if (s.length() == 1) {
				sb.append("0");
			}
			sb.append(s).append("_");
		}
		return sb.toString();
	}
	
	public static byte[] hex2bin(final String hex) {
		byte[] bytes = new byte[hex.length() / 2];
		for (int index = 0; index < bytes.length; index++) {
			bytes[index] =
				(byte) Integer.parseInt(
					hex.substring(index * 2, (index + 1) * 2),
					16);
		}
		return bytes;
	}
	
	public static String radix32ToHex(final String hex) {
		
		StringBuilder b = new StringBuilder();
		for (int index = 0; index < hex.length(); index++) {
			char s = hex.charAt(index);
			
			b.append(radix32ToRadix16(s));
			
			if (((index + 1) % 1) == 0) {
				b.append("_");
			}
		}
		
		return b.toString();
	}
	
	public static String radix32ToRadix16(final char s) {
		String result = "";
		if ("0".charAt(0) == s) {
			result = "00";
		} else if ("1".charAt(0) == s) {
			result = "01";
		} else if ("2".charAt(0) == s) {
			result = "02";
		} else if ("3".charAt(0) == s) {
			result = "03";
		} else if ("4".charAt(0) == s) {
			result = "04";
		} else if ("5".charAt(0) == s) {
			result = "05";
		} else if ("6".charAt(0) == s) {
			result = "06";
		} else if ("7".charAt(0) == s) {
			result = "07";
		} else if ("8".charAt(0) == s) {
			result = "08";
		} else if ("9".charAt(0) == s) {
			result = "09";
		} else if ("a".charAt(0) == s) {
			result = "0a";
		} else if ("b".charAt(0) == s) {
			result = "0b";
		} else if ("c".charAt(0) == s) {
			result = "0c";
		} else if ("d".charAt(0) == s) {
			result = "0d";
		} else if ("e".charAt(0) == s) {
			result = "0e";
		} else if ("f".charAt(0) == s) {
			result = "0f";
		} else if ("g".charAt(0) == s) {
			result = "10";
		} else if ("h".charAt(0) == s) {
			result = "11";
		} else if ("i".charAt(0) == s) {
			result = "12";
		} else if ("j".charAt(0) == s) {
			result = "13";
		} else if ("k".charAt(0) == s) {
			result = "14";
		} else if ("l".charAt(0) == s) {
			result = "15";
		} else if ("m".charAt(0) == s) {
			result = "16";
		} else if ("n".charAt(0) == s) {
			result = "17";
		} else if ("o".charAt(0) == s) {
			result = "18";
		} else if ("p".charAt(0) == s) {
			result = "19";
		} else if ("q".charAt(0) == s) {
			result = "1a";
		} else if ("r".charAt(0) == s) {
			result = "1b";
		} else if ("s".charAt(0) == s) {
			result = "1c";
		} else if ("t".charAt(0) == s) {
			result = "1d";
		} else if ("u".charAt(0) == s) {
			result = "1e";
		} else if ("v".charAt(0) == s) {
			result = "1f";
		}
		
		return result;
	}
	
	public static String radix32ToRadix16(final byte s) {
		String result = "";
		int ss = s;
		if (0 == ss) {
			result = "0";
		} else if (1 == ss) {
			result = "1";
		} else if (2 == ss) {
			result = "2";
		} else if (3 == ss) {
			result = "3";
		} else if (4 == ss) {
			result = "4";
		} else if (5 == ss) {
			result = "5";
		} else if (6 == ss) {
			result = "6";
		} else if (7 == ss) {
			result = "7";
		} else if (8 == ss) {
			result = "8";
		} else if (9 == ss) {
			result = "9";
		} else if (10 == ss) {
			result = "a";
		} else if (11 == ss) {
			result = "b";
		} else if (12 == ss) {
			result = "c";
		} else if (13 == ss) {
			result = "d";
		} else if (14 == ss) {
			result = "e";
		} else if (15 == ss) {
			result = "f";
		} else if (16 == ss) {
			result = "g";
		} else if (17 == ss) {
			result = "h";
		} else if (18 == ss) {
			result = "i";
		} else if (19 == ss) {
			result = "j";
		} else if (20 == ss) {
			result = "k";
		} else if (21 == ss) {
			result = "l";
		} else if (22 == ss) {
			result = "m";
		} else if (23 == ss) {
			result = "n";
		} else if (24 == ss) {
			result = "o";
		} else if (25 == ss) {
			result = "p";
		} else if (26 == ss) {
			result = "q";
		} else if (27 == ss) {
			result = "r";
		} else if (28 == ss) {
			result = "s";
		} else if (29 == ss) {
			result = "t";
		} else if (30 == ss) {
			result = "u";
		} else if (31 == ss) {
			result = "v";
		}
		
		return result;
	}
}
