/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.stats2excel;

import java.util.Comparator;
import java.util.ResourceBundle;
import jp.sourceforge.users.yutang.omegat.plugin.stats2excel.L10n;
import jp.sourceforge.users.yutang.omegat.plugin.stats2excel.StatsController;
import org.apache.lucene.util.StringHelper;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class Stats2Excel {
    private static String __VERSION_KEY = "version";

    public static void loadPlugins() {
        try {
            String OMT_VERSION = ResourceBundle.getBundle("org/omegat/Version").getString(__VERSION_KEY);
            if (!Stats2Excel.isAvailableOmTVersion(OMT_VERSION)) {
                throw new RuntimeException(L10n.getLoadingErrorVersionTooOld());
            }
            if (!Stats2Excel.isWindows()) {
                throw new RuntimeException(L10n.getLoadingErrorWrongPlatform());
            }
            CoreEvents.registerApplicationEventListener(StatsController.getInstance());
        }
        catch (Throwable ex) {
            String msg = StaticUtils.format(L10n.getLoadingErrorFormat(), ex.getMessage());
            Log.logErrorRB(msg, new Object[0]);
            Core.pluginLoadingError(msg);
        }
    }

    public static void unloadPlugins() {
    }

    private static boolean isWindows() {
        switch (Platform.getOsType()) {
            case WIN64: 
            case WIN32: {
                return true;
            }
        }
        return false;
    }

    private static boolean isAvailableOmTVersion(String version) {
        Comparator<String> comp = StringHelper.getVersionComparator();
        return comp.compare(version, "3.0.7") >= 0;
    }
}

