set VCVERSION=VC9
set CONFIGURATION=Release

set TCLLIBNAME=tcl85t.lib tclstub85.lib
set TCLDIR=..\..\..\..\tcl8.5.11

set TKLIBNAME=tk85t.lib tkstub85.lib
set TKDIR=..\..\..\..\tk8.5.11

set EXTRA_LIBS=user32.lib gdi32.lib oldnames.lib advapi32.lib winspool.lib comdlg32.lib


set INCLUDEOPT=-I ..\..\..\generic\ -I %TCLDIR%\generic -I %TKDIR%\generic -I ..\..\..\win

set OPTS=-DWIN32 -DNDEBUG -MP

set PACKAGE_NAME=BLT
set PACKAGE_NAME_LETTER=blt
set PACKAGE_VERSION=2.5
set PACKAGE_VERSION3=2.5.3
set PACKAGE_VERSION_NUM=25

set INSTALLDIR=..\..\..\inst\

SET N_OBJS=	..\..\..\generic\bltTed.c
SET V3_OBJS=	..\..\..\generic\bltTri.c ^
	..\..\..\generic\bltGrMt.c
	
SET TK_OBJS=	..\..\..\generic\tkButton.c ^
	..\..\..\generic\tkFrame.c ^
	..\..\..\generic\tkScrollbar.c
	
SET GRAPH_OBJS=	..\..\..\generic\bltGrAxis.c ^
	..\..\..\generic\bltGrBar.c ^
	..\..\..\generic\bltGrElem.c ^
	..\..\..\generic\bltGrGrid.c ^
	..\..\..\generic\bltGrHairs.c ^
	..\..\..\generic\bltGrLegd.c ^
	..\..\..\generic\bltGrLine.c ^
	..\..\..\generic\bltGrMarker.c ^
	..\..\..\generic\bltGrMisc.c ^
	..\..\..\generic\bltGrPen.c ^
	..\..\..\generic\bltGrPs.c ^
	..\..\..\generic\bltGraph.c
	
SET TCL_ONLY_OBJS=	..\..\..\generic\bltAlloc.c ^
	..\..\..\generic\bltArrayObj.c ^
	..\..\..\generic\bltBgexec.c ^
	..\..\..\generic\bltChain.c ^
	..\..\..\generic\bltDebug.c ^
	..\..\..\generic\bltHash.c ^
	..\..\..\generic\bltList.c ^
	..\..\..\generic\bltNsUtil.c ^
	..\..\..\generic\bltParse.c ^
	..\..\..\generic\bltPool.c ^
	..\..\..\generic\bltSpline.c ^
	..\..\..\generic\bltSwitch.c ^
	..\..\..\generic\bltTree.c ^
	..\..\..\generic\bltTreeCmd.c ^
	..\..\..\generic\bltUtil.c ^
	..\..\..\generic\bltVecCmd.c ^
	..\..\..\generic\bltVecMath.c ^
	..\..\..\generic\bltVecObjCmd.c ^
	..\..\..\generic\bltVector.c ^
	..\..\..\generic\bltWatch.c  ^
	..\..\..\generic\bltWinPipe.c ^
	..\..\..\generic\bltWinUtil.c ^
	..\..\..\generic\bltWinDde.c
	
SET OBJS=%GRAPH_OBJS% ^
	%TCL_ONLY_OBJS% ^
	..\..\..\generic\bltBeep.c ^
	..\..\..\generic\bltBind.c ^
	..\..\..\generic\bltBitmap.c ^
	..\..\..\generic\bltBusy.c ^
	..\..\..\generic\bltCanvEps.c ^
	..\..\..\generic\bltConfig.c ^
	..\..\..\generic\bltContainer.c ^
	..\..\..\generic\bltDragdrop.c ^
	..\..\..\generic\bltHierbox.c ^
	..\..\..\generic\bltHtext.c ^
	..\..\..\generic\bltImage.c ^
	..\..\..\generic\bltWinImage.c ^
	..\..\..\generic\bltPs.c ^
	..\..\..\generic\bltTable.c ^
	..\..\..\generic\bltTabnotebook.c ^
	..\..\..\generic\bltTabset.c ^
	..\..\..\generic\bltText.c ^
	..\..\..\generic\bltTile.c ^
	..\..\..\generic\bltTreeView.c ^
	..\..\..\generic\bltTreeViewCmd.c ^
	..\..\..\generic\bltTreeViewEdit.c ^
	..\..\..\generic\bltTreeViewColumn.c ^
	..\..\..\generic\bltTreeViewStyle.c ^
	..\..\..\generic\bltWinDraw.c ^
	..\..\..\generic\bltWinPrnt.c ^
	..\..\..\generic\bltWindow.c ^
	..\..\..\generic\bltObjConfig.c ^
	..\..\..\generic\bltWinop.c ^
	%TK_OBJS% %N_OBJS% ^
	..\..\..\generic\bltInit.c


rem === BUILD FROM HERE ===

mkdir %CONFIGURATION%_%VCVERSION%
cd %CONFIGURATION%_%VCVERSION%

rem threads,static
mkdir %PACKAGE_NAME_LETTER%_ThreadedStatic
cd %PACKAGE_NAME_LETTER%_ThreadedStatic

cl -DPACKAGE_NAME="\"%PACKAGE_NAME%\"" -DPACKAGE_VERSION="\"%PACKAGE_VERSION%\"" %OPTS% -DSTATIC_BUILD -c %OBJS% %INCLUDEOPT%
lib -OUT:%PACKAGE_NAME%%PACKAGE_VERSION_NUM%ts.lib *.obj
copy *.lib ..
cd ..

rem threads
mkdir %PACKAGE_NAME_LETTER%_ThreadedDynamic
cd %PACKAGE_NAME_LETTER%_ThreadedDynamic
cl -LD -DPACKAGE_NAME="\"%PACKAGE_NAME%\"" -DPACKAGE_VERSION="\"%PACKAGE_VERSION%\"" -DEXTERN=__declspec(dllexport) %OPTS% %OBJS% %INCLUDEOPT% /link /OUT:%PACKAGE_NAME%%PACKAGE_VERSION_NUM%.dll %EXTRA_LIBS% /IMPLIB:%PACKAGE_NAME%%PACKAGE_VERSION_NUM%.lib /LIBPATH:%TCLDIR%\win\%CONFIGURATION%_%VCVERSION%\ %TCLLIBNAME% /LIBPATH:%TKDIR%\win\%CONFIGURATION%_%VCVERSION%\ %TKLIBNAME%
copy *.dll ..
copy *.lib ..
cd ..

rem === INSTALL FROM HERE ===

mkdir %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%

copy %PACKAGE_NAME_LETTER%_ThreadedStatic\*.lib %INSTALLDIR%\lib
copy %PACKAGE_NAME_LETTER%_ThreadedDynamic\*.lib %INSTALLDIR%\lib
copy %PACKAGE_NAME_LETTER%_ThreadedDynamic\%PACKAGE_NAME%%PACKAGE_VERSION_NUM%.dll %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%

echo package ifneeded %PACKAGE_NAME% %PACKAGE_VERSION3% [list load [file join $dir %PACKAGE_NAME%%PACKAGE_VERSION_NUM%.dll] %PACKAGE_NAME%]  > %INSTALLDIR%\lib\%PACKAGE_NAME%%PACKAGE_VERSION%\pkgIndex.tcl

SET SCRIPTS_DIR=..\..\library\

copy %SCRIPTS_DIR%treeview.cur	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%bltCanvEps.pro	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\

copy %SCRIPTS_DIR%bltGraph.pro	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%dnd.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%dragdrop.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%graph.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%hierbox.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%tabnotebook.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%tabset.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%treeview.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%init.tcl	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\
copy %SCRIPTS_DIR%tclIndex	%INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\

mkdir %INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\dd_protocols
copy %SCRIPTS_DIR%dd_protocols\*.* %INSTALLDIR%lib\%PACKAGE_NAME%%PACKAGE_VERSION%\dd_protocols

cd ..
