# options.sh
# -----------------------------------------------------------------------------
#
# Module defining the options which are to be recognised during a command
# line parse, and implementing their associated handlers.
#
# -----------------------------------------------------------------------------
#
# $Id: options.sh,v a57bbf0187da 2020/08/20 16:29:01 keith $
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2011, 2013, 2017-2020, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
  require module optdefn

  optdefine h help optional_argument
  opteval_help() { require module help $optarg; }

  optdefine V version
  opteval_version() { require module licence short; }

  optdefine licence
  optalias license=licence
  opteval_licence() { require module licence full; }

  optdefine v verbose
  opteval_verbose() { OPTION_VERBOSE=true; }

  optdefine c stdout
  opteval_stdout() { OUTPUT_STREAMING_OPTION=stdout; }

  optdefine option requires_argument
  opteval_option() { option $optarg; }

  optdefine arch requires_argument
  opteval_arch() { ARCH="$optarg"; }

  optdefine identity requires_argument
  opteval_identity() { PORTSPEC="$optarg"; }

  optdefine port
  opteval_port() { MINGW_PORT_DISTRIBUTION=true SRCTAG=port; }

  optdefine srcdir requires_argument
  opteval_srcdir() {
    mkdir -p .$cmd && echo "PACKAGE_SRCDIR=\"$optarg\"" > .$cmd/srcdir.sh
    PACKAGE_SRCDIR="$optarg"
  }

  optdefine pre-staged
  opteval_pre_staged() { is_pre_staged=true; }

  optdefine keep-staged-image
  opteval_keep_staged_image() { keep_staged_image=true; }

  optdefine ignore-untracked-files
  opteval_ignore_untracked_files() { ignore_untracked_files=true; }

  optdefine xtool
  opteval_xtool() { xtool_mode=true; }
#
# -----------------------------------------------------------------------------
# $RCSfile: options.sh,v $: end of file
