# mkspec.sh
# -----------------------------------------------------------------------------
#
# mingw-pkg module for generating an initial package specification template;
# required by the mkspec action, to emit a package specification which matches
# the package settings currently defined in the mingw-pkg environment.
#
# -----------------------------------------------------------------------------
#
# $Id: mkspec.sh,v a57bbf0187da 2020/08/20 16:29:01 keith $
#
# Written by Keith Marshall <keithmarshall@users.sourceforge.net>
# Copyright (C) 2011-2014, 2018, 2020, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
( test "${OUTPUT_STREAMING_OPTION+"set"}" = set || {
    mkdir -p ${PACKAGE_SRCDIR-"."}/arch/${ARCH-"mingw32"}
    SPECSFILE=$PACKAGE-$VERSION${RELEASE+"-$RELEASE"}${ARCH+"-$ARCH"}.pkgspec
    exec > ${PACKAGE_SRCDIR-"."}/arch/${ARCH-"mingw32"}/$SPECSFILE
  }

  test "${RELEASE+"set"}" = set && RELEASE_PREFIX="" || RELEASE_PREFIX="# "

  case $COMPRESS_CMD in
    gzip)  COMPRESSION_TYPE=.gz ;;
    bzip2) COMPRESSION_TYPE=.bz2 ;;
    lzma)  COMPRESSION_TYPE=.lzma ;;
    xz)    COMPRESSION_TYPE=.xz ;;
  esac

  test "${PACKAGE_HOME_URI+set}" = set && PKGHOME_SET="" || PKGHOME_SET="# "
  PACKAGE_TYPE_SUFFIX=${ARCHIVE_CMD-"tar"}${COMPRESSION_TYPE-".gz"}

  cat <<ETX
# $PACKAGE-$VERSION${RELEASE+"-$RELEASE"}${ARCH+"-$ARCH"}.pkgspec
#
# Package specification file -- automatically generated by mingw-pkg
#
# Package name and version must be explicitly specified; these appear
# as the initial part of the package name, as interpreted by mingw-get.
#
pkgname 	$PACKAGE
pkgversion	$VERSION

# Contributed by ${AUTHOR-"anonymous"}${AUTHOR_EMAIL+" <$AUTHOR_EMAIL>"}
# Copyright (C) ${COPYRIGHT-"`date +%Y`"}, ${OWNER-"MinGW.org Project"}
#
# -----------------------------------------------------------------------------
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
# Identify an internet URL for acquisition of the primary package soucres;
# (it will be composed by conflation of srcpath/srcname specifications).
#
${PKGHOME_SET}pkghome 	${PACKAGE_HOME_URI-"specify PACKAGE_HOME_URI here"}
${PKGHOME_SET}srcpath 	\$PACKAGE_HOME_URI # plus host directory path here
${PKGHOME_SET}srcname 	$PACKAGE-$VERSION.$PACKAGE_TYPE_SUFFIX

# A release identifier is optional; if specified, it will be appended
# to the package name and version, delimited by an intervening hyphen.
#
${RELEASE_PREFIX}pkgrelease 	${RELEASE-"1"}

# A system architecture identifier is required for any package which
# is to be delivered by mingw-get; it establishes the sub-system type
# identifier which will appear within the package name, following the
# package name, version and release identifiers.
#
arch		${ARCH-"mingw32"}

# The pkgtype specification determines the packaging method to be used
# for all distributable component packages, and the final extension to
# be appended to the component package names.  The default is tar.gz;
# alternatives supported by mingw-get are tar.bz2, tar.lzma and tar.xz
#
pkgtype 	$PACKAGE_TYPE_SUFFIX

# Optional alias, title, and description specifications may be provided;
# these are used by 'mingw-pkg mkxml', to specify the associated entries
# in mingw-get's xml catalogue specification for this package.
#
# Each of these should be specified only once; 'aliases' is permitted as
# a synonym for 'alias', where the associated value is a space separated
# list of multiple alias names.
#
alias		$PACKAGE
title		"Short description for mingw-get package list"
description	"
Long form description for package, as is to be emitted when
running 'mingw-get show ... $PACKAGE ...'; this is typically
specified as a multi-line quoted string.  A blank line causes
a paragraph break; thus ...

This will appear as a separate paragraph, in the description
emitted by mingw-get.

Take care that the final line of the specified description
ends with a quote character to match the opening quote used
to introduce the argument; (it is a double quote here)"

# An affiliate specification is also optional; it identifies a package
# category with which mingw-get will affiliate this package.  Unlike
# the alias, title, and description specifications, multiple affiliate
# specifications are permitted, allowing for affiliation of the package
# with multiple mingw-get categories.
#
affiliate	"MinGW Contributed Applications"

# The distributable package inventory is established by means of a
# collection of component specifications; each is of the form:
#
#   component  keyword  "content"
#
#   where:
#     keyword	specifies the component package class name, as it
#		will be included in the mingw-get compatible package
#		archive name, immediately preceding the pkgtype.
#     content	specifies a white-space separated list of directory
#		and/or file path names, relative to the top of the
#		staging directory tree in which the distribution is
#		prepared, which are to be passed as argument list
#		to the archiving program, so defining the content
#		for the associated component package.
#
# The following is a typical component package list, which may be
# adjusted to suit the requirements for each individual package;
# (do please note that the 'N' in 'dll-N' should be replaced by an
# appropriate ABI version serial number for the DLL component).
#
component	bin	"bin/*.exe"
component	dll-N	"bin/*.dll"
component	dev	"include lib share/\$PACKAGE"
component	lic	"share/doc/\$PACKAGE/\$VERSION/COPYRIGHT"
component	man	"share/man"

component	doc	"--exclude=share/doc/\$PACKAGE/\$VERSION/COPYRIGHT
			 share/doc/\$PACKAGE/\$VERSION"

# For some packages, it may be necessary to override mingw-pkg's
# default actions.  Each action is supported by a shell function
# called "action_\$ACTION_NAME", and any so-named function defined
# here will override the built-in default.
#
# This facility should be avoided, unless absolutely necessary.
# The following examples are taken from the mingw32-lua package;
# they will not be suitable for direct use in any other package
# specification, without appropriate modification.
#
# action_compile() {
#   make \${host+"host=\$host"} mingw
# }
#
# action_install() {
#   \${is_staged-"false"} && rm -rf \${INSTALLDIR="staged"} \\
#     || INSTALLDIR=\${INSTALLDIR-"\${prefix-"/mingw"}"}
#   test -f src/lua.exe || action_compile
#   mkdir -p \$INSTALLDIR/share/doc/\$PACKAGE/\$VERSION
#   make INSTALL_TOP=\`pwd\`/\$INSTALLDIR EXEEXT=.exe install
#   cp COPYRIGHT doc/*.[!1]* \$INSTALLDIR/share/doc/\$PACKAGE/\$VERSION
#   mv \$INSTALLDIR/man \$INSTALLDIR/share
# }
#
# action_clean() {
#   make EXEEXT=.exe clean
# }
#
# $PACKAGE-$VERSION${RELEASE+"-$RELEASE"}${ARCH+"-$ARCH"}.pkgspec: end of file
ETX
)
# $RCSfile: mkspec.sh,v $: end of file
